package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.workflow.WorkFlow;



/**
 * 工作流程业务处理类
 * @author lisu
 *  2013-11-18
 */

public class WorkFlowManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WorkFlowManagedBean.class.getName());   
    private BaseSo baseSo;
	private int rownum = 0;	
	
	public WorkFlowManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	
	/**
	 * 查询工作流程
	 * @return
	 */
	public String getQueryWorkFlowList(){
		logger.info("开始工作流程查询");
        this.authenticateRun();//验证运行权限
        WorkFlow flow = findBean(WorkFlow.class, "workflow");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(flow);
        pagedFliper.setRecordCount(count);
        List<WorkFlow> list = new ArrayList<WorkFlow>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(flow, page);
        }
        Sheet<WorkFlow> sheet = new Sheet<WorkFlow>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增工作流程
	 * @return
	 */
	public String add(){
		logger.info("开始工作流程添加");		
		 WorkFlow flow = findBean(WorkFlow.class, "workflow");
		try{
			if(flow==null){
				logger.info("工作流程信息为空");
				throw new XLRuntimeException("工作流程信息为空");
			}		
			WorkFlow mp = new WorkFlow();
			mp.setFlowNo(flow.getFlowNo());
			List<WorkFlow> mplist = baseSo.findObjects(mp, new Page());
			if(mplist != null&&mplist.size()>0){
				throw new XLRuntimeException("流程编号为："+flow.getFlowNo()+"的工作流程，已存在，请不要重复添加");
			}
			flow.setInputBy(this.currentUserLogo());
			flow.setInputTime(now());			
			baseSo.addObject(flow);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改工作流程
	 * @return
	 */
	public String edit(){
		logger.info("开始工作流程信息修改");
		this.authenticateEdit();//编辑权限
		WorkFlow flow = findBean(WorkFlow.class, "workflow");
		try{
			if(flow==null){
				logger.info("工作流程信息为空");
				throw new XLRuntimeException("工作流程信息为空");
			}					
			flow.setEditBy(this.currentUserLogo());
			flow.setEditTime(now());
			baseSo.updateObjectById(flow);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除工作流程
	 * @return
	 */
	public String delete(){	
		logger.info("开始工作流程信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(WorkFlow.class, id);	
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
