package com.xunlei.niux.manager.web.model;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.WholePeopleCountry;




/**
 * 世界杯参赛国家业务处理类
 * @author lisu
 * 2014-06-10
 */
public class WholePeopleCountryManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WholePeopleCountryManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static List<SelectItem> countryList;
    public  static Map<String,String> countryMap = new HashMap<String,String>();

    
	public WholePeopleCountryManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public List<SelectItem> getCountryList(){
		if(countryList == null){
			initCountryList();
		}		
		return countryList;
	}
	
	private void initCountryList(){		
		WholePeopleCountry query=new WholePeopleCountry();
		Page page = new Page();
		page.addOrder("simpleName", OrderType.ESC);
		List<WholePeopleCountry> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(WholePeopleCountry country:bplist){
			siList.add(new SelectItem(country.getCountryNo(),country.getSimpleName()+"-"+country.getCountryName()+"-"+country.getGroupName())); 	
			countryMap.put(country.getCountryNo(), country.getCountryName());
		}
		countryList = siList;
	}
	
	/**
	 * 查询世界杯参赛国家记录
	 * @return
	 */
	public String getQueryWholePeopleCountryList(){		
	    logger.info("开始世界杯参赛国家记录查询");
        this.authenticateRun();//验证运行权限
        WholePeopleCountry query = findBean(WholePeopleCountry.class, "wholepeoplecountry");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);    
        pagedFliper.setRecordCount(count);
        List<WholePeopleCountry> list = new ArrayList<WholePeopleCountry>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(query, page);
        } 
        Sheet<WholePeopleCountry> sheet = new Sheet<WholePeopleCountry>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	/**
	 * 新增世界杯参赛国家记录
	 * @return
	 */
	public String add(){
		logger.info("开始世界杯参赛国家添加");
		this.authenticateAdd();//添加权限
		WholePeopleCountry wpg = findBean(WholePeopleCountry.class, "wholepeoplecountry");		
		try{
			if(wpg==null){
				logger.info("世界杯参赛国家记录为空");
				throw new XLRuntimeException("世界杯参赛国家记录为空");
			}
			WholePeopleCountry  query = new WholePeopleCountry();
			query.setCountryNo(wpg.getCountryNo());
			List<WholePeopleCountry> qwpglist = baseSo.findObjects(query, new Page());
			if(qwpglist !=null&&qwpglist.size()>0){
				logger.info("该世界杯参赛国家已存在");
				throw new XLRuntimeException("该世界杯参赛国家已存在");
			}
	        baseSo.addObject(wpg);
	        initCountryList();

		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	
	/**
	 * 修改世界杯参赛国家记录
	 * @return
	 */
	public String edit(){
		logger.info("开始世界杯参赛国家记录修改");
		this.authenticateEdit();//编辑权限
		WholePeopleCountry wpg = findBean(WholePeopleCountry.class, "wholepeoplecountry");					
		try{
			if(wpg==null){
				logger.info("世界杯参赛国家记录为空");
				throw new XLRuntimeException("世界杯参赛国家记录为空");
			}
			baseSo.updateObjectById(wpg);	
			initCountryList();

		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除世界杯参赛国家记录
	 * @return
	 */
	public String delete(){
		logger.info("开始全民竞猜世界杯记录删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			  baseSo.deleteById(WholePeopleCountry.class, id);			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
 
}
