package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.WhiteListBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.WhiteList;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 白名单业务处理类
 * @author lisu
 *  2013-1-29
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_WHITELIST)
public class WhiteListManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(WhiteListManagedBean.class.getName());
	private WhiteListBo whiteListBo;
	private int rownum = 0;
	 //白名单所属部门
    private Map<String,String> deptCollectionMap;   
	
	public WhiteListManagedBean(){
		whiteListBo = FacadeFactory.INSTANCE.getWhiteListBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询白名单
	 * @return
	 */
	public String getQueryWhiteListList(){
		logger.info("开始公告查询");
        this.authenticateRun();//验证运行权限
        WhiteList wl = findBean(WhiteList.class, "whitelist");
        PagedFliper pagedFliper = this.getFliper();
        int count = whiteListBo.count(wl);
        pagedFliper.setRecordCount(count);
        List<WhiteList> list = new ArrayList<WhiteList>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = whiteListBo.find(wl,page.getPageNo(),page.getPageSize());
        }
        Sheet<WhiteList> sheet = new Sheet<WhiteList>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增白名单
	 * @return
	 */
	public String add(){
		logger.info("开始白名单添加");		
		WhiteList wl = this.findBean(WhiteList.class,"whitelist");	
		try{
			if(wl==null){
				logger.info("白名单为空");
				throw new XLRuntimeException("白名单为空");
			}		
			
			String account = wl.getAccount();
			WhiteList white = new WhiteList();
			white.setAccount(account);
			List<WhiteList> lists = whiteListBo.find(white, 0, 0);
			if(lists != null && lists.size()>=1){
				logger.info("白名单已存在该账户，请不要重复添加");
				throw new XLRuntimeException("白名单已存在该账户，请不要重复添加");
			}
			wl.setInputBy(this.currentUserLogo());
			wl.setInputTime(now());
			whiteListBo.insert(wl);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改白名单
	 * @return
	 */
	public String edit(){
		logger.info("开始白名单修改");
		this.authenticateEdit();//编辑权限
		WhiteList wl =this.findBean(WhiteList.class,"whitelist");
		try{
			if(wl==null){
				logger.info("白名单为空");
				throw new XLRuntimeException("白名单为空");
			}
			WhiteList white = new WhiteList();
			String account = wl.getAccount();
			white.setAccount(account);
			List<WhiteList> lists = whiteListBo.find(white, 0, 0);
			if(lists != null ){
				if(lists.size() == 1){
					WhiteList w = lists.get(0);
					if(wl.getSeqId() != w.getSeqId()){
						logger.info("白名单已存在该账户，请不要重复添加");
						throw new XLRuntimeException("白名单已存在该账户，请不要重复添加");
					}
				}else if(lists.size() > 1){
					logger.info("白名单已存在该账户，请不要重复添加");
					throw new XLRuntimeException("白名单已存在该账户，请不要重复添加");
				}

			}
			wl.setEditBy(this.currentUserLogo());
			wl.setEditTime(now());
			whiteListBo.update(wl);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除白名单
	 * @return
	 */
	public String delete(){	
		logger.info("开始白名单删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				whiteListBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}

	/**
	 * 重置白名单显示顺序
	 * @return
	 */
	public String resetOrder(){	
		logger.info("开始重置白名单显示顺序");
		this.authenticateDel();//删除权限
		String orderseqids = findParameter("orderseqids");		
		try{
			String ids[] = orderseqids.split(",");
			String sql = null;
			List list = new ArrayList(); 
			for(String id:ids){
				list.clear();
				sql = "update whitelist set displayOrder=100 where seqid=?";
				list.add(id);
				whiteListBo.execute(sql, list);
			}
							
		}catch(Exception e){
			logger.error("白名单显示顺序重置失败", e);
			mergeJsmessage("白名单显示顺序重置，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 设置白名单是否生效
	 * @return
	 */
	public String resetValidate(){	
		logger.info("开始设置白名单是否生效");
		this.authenticateDel();//删除权限
		String wid = findParameter("wid");		
		try{
           if(wid == null || "".equals(wid)){
        	   logger.info("要设置的白名单id为空");
				throw new XLRuntimeException("要设置的白名单id为空");
           }
           String sql = "UPDATE whitelist SET isvalidate = (isvalidate + 1)%2 WHERE seqid = ?";
           List list = new ArrayList();
           list.add(wid);
           whiteListBo.execute(sql, list);		
		}catch(Exception e){
			logger.error("白名单显示顺序重置失败", e);
			mergeJsmessage("白名单显示顺序重置，原因：" + e.getMessage());
		}
		return "";
	}
		
		 /**
		  * 获得基础数组中配置的游戏信息
		  * @return
		  */
		 public List getDeptCollection(){
		        List list = (List)getRequestAttribute("deptcollection");
		        if(list == null){
		            List datas = LibClassM.getLibClassDList("deptcollection");
		            list = new ArrayList(datas.size());
		            for(int i = 0; i < datas.size(); i++){
		            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
		            }	                
		            setRequestAttribute("deptcollection", list);
		        }
		        return list;
		 }
		 
		 /**
		     * 从基础数组数据中取得游戏集合
		     * @return
		     */
		    public Map<String, String> getDeptCollectionMap() {
		        if(deptCollectionMap==null){
		            Map<String, String> tempMap=new HashMap<String,String>();
		            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("deptcollection");
		            if(list!=null){           	
		                for(LibClassD libClassD:list){
		                    tempMap.put(libClassD.getItemno(), libClassD.getItemname());
		                }
		            }
		            deptCollectionMap=tempMap;
		        }
		        return deptCollectionMap;

		    }
		
		
}
