package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.InterfaceManBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.InterfaceMan;
import com.xunlei.niux.data.vipgame.vo.tips.TipsSkin;


/**
 * tips皮肤处理类
 * @author lisu
 * 2014-08-28
 */
public class TipsSkinManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(TipsSkinManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    
	public TipsSkinManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询tips皮肤
	 * @return
	 */
	public String getQueryTipsSkinList(){		
	    logger.info("开始tips皮肤查询");
        this.authenticateRun();//验证运行权限
        TipsSkin skin = findBean(TipsSkin.class, "tipsskin");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(skin);
        pagedFliper.setRecordCount(count);
        List<TipsSkin> list = new ArrayList<TipsSkin>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("skinNo", OrderType.DESC);
            list = baseSo.findObjects(skin, page);
        } 
        Sheet<TipsSkin> sheet = new Sheet<TipsSkin>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增tips皮肤
	 * @return
	 */
	public String add(){
		logger.info("开始tips皮肤信息添加");
		this.authenticateAdd();//添加权限
		TipsSkin skin = findBean(TipsSkin.class, "tipsskin");		
		try{
			if(skin==null){
				logger.info("tips皮肤信息为空");
				throw new XLRuntimeException("tips皮肤信息为空");
			}
			baseSo.addObject(skin);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改tips皮肤信息
	 * @return
	 */
	public String edit(){
		logger.info("开始tips皮肤信息修改");
		this.authenticateEdit();//编辑权限
		TipsSkin skin = findBean(TipsSkin.class, "tipsskin");	
		try{
			if(skin==null){
				logger.info("tips皮肤信息为空");
				throw new XLRuntimeException("tips皮肤信息为空");
			}
			baseSo.updateObjectById(skin);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除tips皮肤信息
	 * @return
	 */
	public String delete(){
		logger.info("开始tips皮肤信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
			    baseSo.deleteById(TipsSkin.class,new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
