package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tips.TipsClassify;
import com.xunlei.niux.data.vipgame.vo.tips.TipsGameConstraint;
import com.xunlei.niux.data.vipgame.vo.tips.TipsInfo;
import com.xunlei.niux.data.vipgame.vo.tips.TipsSkin;
import com.xunlei.niux.manager.web.util.PageUtil;

public class TipsInfoManagerBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(TipsInfoManagerBean.class.getName());
	private List<TipsGameConstraint> gameConstraintList;
	
	public List<TipsGameConstraint> getGameConstraintList(){
		String tipsNo=this.findParameter("tipsNo");
		if(tipsNo==null||"".equals(tipsNo.trim())){
			return new  ArrayList<TipsGameConstraint>();
		}
		TipsGameConstraint queryContrataint=new TipsGameConstraint();
		queryContrataint.setTipsNo(tipsNo);
		List<TipsGameConstraint> gcList=FacadeFactory.INSTANCE.getBaseSo().findObjects(queryContrataint, new Page());
		return gcList;
	}
	public String deleteGameConstraint(){
		long seqId=this.findParamLong("gameConstraintSeqId");
		FacadeFactory.INSTANCE.getBaseSo().deleteById(TipsGameConstraint.class, seqId);
		return "";
	}
	public String addGameConstraint(){
		String gameId=this.findParameter("gameConstraintGameId");
		int fenQuNum=this.findParamInt("gameConstraintFenQuNum");
		String tipsNo=this.findParameter("tipsNo");
		TipsGameConstraint gameConstraint=new TipsGameConstraint();
		gameConstraint.setGameId(gameId);
		gameConstraint.setFenQuNum(fenQuNum);
		gameConstraint.setTipsNo(tipsNo);
		FacadeFactory.INSTANCE.getBaseSo().addObject(gameConstraint);
		return "";
	}
	
	public String addTipsInfo(){
		TipsInfo tipsInfo=this.findBean(TipsInfo.class, "tipsinfo");
		FacadeFactory.INSTANCE.getBaseSo().addObject(tipsInfo);
		return "";
	}
	public String editTipsInfo(){
		TipsInfo tipsInfo=this.findBean(TipsInfo.class, "tipsinfo");
		FacadeFactory.INSTANCE.getBaseSo().updateObjectById(tipsInfo);
		return "";
	}
	public String deleteTips(){
		this.authenticateDel();
		 String paramseqids = findParameter("delseqids");
	       String[] params = paramseqids.split(",");
	       try{
	           for(String id : params) {
	        	   FacadeFactory.INSTANCE.getBaseSo().deleteById(TipsInfo.class, id);
	           }
	           alertJS("删除成功!");
	       } catch (Exception e) {
	           logger.error("删除失败", e);
	           alertJS("删除失败，原因：" + e);
	       }
		return "";
	}
	public String getQueryTipsInfo(){
		TipsInfo tipsinfo=this.findBean(TipsInfo.class, "tipsinfo");
		int count = FacadeFactory.INSTANCE.getBaseSo().countObject(tipsinfo);
		if(count==0){
			return this.mergePagedDataModel(0, new ArrayList<TipsInfo>());
		}
		Page page=PageUtil.formatPage(this.getFliper());
		List<TipsInfo> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(tipsinfo, page);  
		return this.mergePagedDataModel(count, list);
	}
	public Map<String,String> getSkinMap(){
		List<TipsSkin> skinList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new TipsSkin(), new Page());
		Map<String,String> skinMap=new HashMap<String,String>();
		for(TipsSkin skin:skinList){
			skinMap.put(skin.getSkinNo(), skin.getSkinName());
		}
		return skinMap;
	}
	public List<SelectItem> getClassifySiList(){
		String classifyType=this.findParameter("classifyType");
		TipsClassify querytipsclassify=new TipsClassify();
		querytipsclassify.setClassifyType(classifyType);
		List<TipsClassify> tclassifyList=FacadeFactory.INSTANCE.getBaseSo().findObjects(querytipsclassify, new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(TipsClassify classify:tclassifyList){
			SelectItem si=new SelectItem();
			si.setLabel(classify.getClassifyNo()+"-"+classify.getClassifyName());
			si.setValue(classify.getClassifyNo());
			siList.add(si);
		}
		return siList;
	}
	public List<SelectItem> getSkinSiList(){
		String classifyType=this.findParameter("classifyType");
		String businessNo=this.findParameter("businessNo");
		TipsSkin querySkin=new TipsSkin();
		querySkin.setBussinessNo(businessNo);
		querySkin.setClassifyType(classifyType);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		List<TipsSkin> skinList=FacadeFactory.INSTANCE.getBaseSo().findObjects(querySkin, new Page());
		for(TipsSkin skin:skinList){
			SelectItem si=new SelectItem();
			si.setLabel(skin.getSkinName());
			si.setValue(skin.getSkinNo());
			siList.add(si);
		}
		return siList;
	}
}
