package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.TimeTaskRecordBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TimeTaskRecord;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 定时任务监控业务逻辑类
 * @author lisu
 * 2013-04-08
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TIMETASKRECORD)
public class TimeTaskRecordManagedBean extends BaseManagedBean {	
	private static final Logger logger = Logger.getLogger(TimeTaskRecordManagedBean.class.getName());
	private int rownum = 0;
	
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public TimeTaskRecordManagedBean(){
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	/**
	 * 查询定时任务执行情况
	 * @return
	 */
	public String getQueryTimeTaskRecordList(){
		    logger.info("开始定时任务执行情况查询");
	        this.authenticateRun();//验证运行权限
	        TimeTaskRecord record = findBean(TimeTaskRecord.class, "timetaskrecord");
	        PagedFliper pagedFliper = this.getFliper();
	        TimeTaskRecordBo timeTaskRecordBo = FacadeFactory.INSTANCE.getTimeTaskRecordBo();
	        int count = timeTaskRecordBo.count(record);
	        pagedFliper.setRecordCount(count);
	        List<TimeTaskRecord> list = new ArrayList<TimeTaskRecord>();
	        if (count > 0) {
	        	rownum = 1;
	        	Page page=new Page();
	        	page.setPageNo(pagedFliper.getPageNo());
	        	page.setPageSize(pagedFliper.getPageSize());
	        	page.addOrder("starttime", OrderType.DESC);
	            list = timeTaskRecordBo.find(record,page);
	        }
	        Sheet<TimeTaskRecord> sheet = new Sheet<TimeTaskRecord>(count, list);
	        this.mergePagedDataModel(sheet, pagedFliper);
	        return "";
	}
	
}
