package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.TestAccountBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TestAccount;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PropertyUtil;

/**
 * 测试账号业务处理类
 * @author lisu
 *  2013-05-08
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TESTACCOUNT)
public class TestAccountManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(TestAccountManagedBean.class.getName());
	private TestAccountBo testAccountBo;
	private static String accountChangeUrl="http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?type=100";//gameid=000069&type=200&accounts=lijunfuangguang,wfgfcmwfg
    private static String accountFileUrl = "/usr/local/ly_gameservers/ly_authserver/testaccount/";
    private static String SYNCPICCOMMOND = "rsync_to_t23121_twin08a50_twin08a51.sh";//同步测试账号配置信息到认证服务器
	private int rownum = 0;
	
	
	public TestAccountManagedBean(){
		testAccountBo = FacadeFactory.INSTANCE.getTestAccountBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询测试账号
	 * @return
	 */
	public String getQueryTestAccountList(){
		logger.info("开始测试账号查询");
        this.authenticateRun();//验证运行权限
        TestAccount testAccount = findBean(TestAccount.class, "testaccount");
        PagedFliper pagedFliper = this.getFliper();
        int count = testAccountBo.count(testAccount);
        pagedFliper.setRecordCount(count);
        List<TestAccount> list = new ArrayList<TestAccount>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = testAccountBo.findTestAccount(testAccount, page);
        }
        Sheet<TestAccount> sheet = new Sheet<TestAccount>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增测试账号
	 * @return
	 */
	public String add(){
		logger.info("开始测试账号添加");		
		TestAccount testAccount = this.findBean(TestAccount.class,"testaccount");	
		try{
			if(testAccount==null){
				logger.info("测试账号为空");
				throw new XLRuntimeException("测试账号为空");
			}		
			TestAccount account = new TestAccount();
			account.setGameid(testAccount.getGameid()==null?"":testAccount.getGameid().trim());
			account.setGameAccount(testAccount.getGameAccount()==null?"":testAccount.getGameAccount().trim());
			String gameAccount = account.getGameAccount();
			if(gameAccount.indexOf("xlniuxtest")==-1||gameAccount.length() != 13){
				throw new XLRuntimeException("只允许：xlniuxtest000-xlniuxtest200之间的账号");
			}
			String number = gameAccount.substring(10);
			if(number.indexOf("0")==0){
				number = number.substring(1);
				if(number.indexOf("0")==0){
					number = number.substring(1);
				}
			}
			int num = Integer.parseInt(number);
			if(num<0 || num>200){
				throw new XLRuntimeException("只允许：xlniuxtest000-xlniuxtest200之间的账号");
			}
			List<TestAccount> talist = testAccountBo.findTestAccount(account, new Page());
			if(talist != null && talist.size()>0){
				throw new XLRuntimeException("编号为："+testAccount.getGameid()+"的游戏中账号："+testAccount.getGameAccount()+"已经存在，请不要重复添加");
			}
			account = new TestAccount();
			account.setGameid(testAccount.getGameid());
			talist = testAccountBo.findTestAccount(account, new Page());
			if(talist != null&& talist.size()>=1){
				throw new XLRuntimeException("编号为："+testAccount.getGameid()+"的游戏只允许一个测试账号");
			}
			testAccount.setInputBy(this.currentUserLogo());
			testAccount.setInputTime(now());
			
			testAccount.setCustomerid("");
			testAccountBo.insert(testAccount);
			
			//生成testaccount.properties文件
			makeFile(testAccount.getGameid(),testAccount.getGameAccount());
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 *  生成配置文件
	 * @throws Exception
	 */
	private void makeFile(String gameid,String value) throws Exception{
		 PropertyUtil.writeData("gameid_"+gameid,value,accountFileUrl+"testaccount.properties");
	}
	
	/**
	 * 同步配置文件到认证服务器
	 * @throws Exception
	 */
	public void synchFile() {
		try {
			 logger.info("开始同步新游接入的相关xml文件,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);	
			 logger.info("新游接入xml同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	/**
	 * 解析返回值，获得加密账号
	 * @param responseText
	 * @return
	 */
	private static String getCustomerId(String responseText){
		  if(responseText==null){
			  return null;
		  }
		  responseText = responseText.replaceAll("\"", "").replace("{","").replace("}", "");
		  String strs[] = responseText.split(",");
		  String substrings[] = strs[1].split(":");
		  if("0".equals(substrings[1])){  
			  return strs[0].split("=")[1];			  
		  }
		  return null;
	}
	
	/**
	 * 处理get请求
	 * @param url
	 * @return
	 */
	private static String getInfoForHttpGetMothed(String url) throws Exception {
			logger.info(" Get/URL :" + url);
			HttpGet httpget = new HttpGet(url);
			HttpClient client = new DefaultHttpClient();
			String backStr = "";
			ResponseHandler<String> responseHandler = new BasicResponseHandler();
			backStr = client.execute(httpget, responseHandler);
			return backStr;

	}
	
	/**
	 * 修改测试账号
	 * @return
	 */
	public String edit(){
		logger.info("开始测试账号修改");
		this.authenticateEdit();//编辑权限
		TestAccount testAccount = this.findBean(TestAccount.class,"testaccount");
		try{
			if(testAccount==null){
				logger.info("测试账号为空");
				throw new XLRuntimeException("测试账号为空");
			}	
			TestAccount account = new TestAccount();
			account.setGameid(testAccount.getGameid()==null?"":testAccount.getGameid().trim());
			account.setGameAccount(testAccount.getGameAccount()==null?"":testAccount.getGameAccount().trim());
			List<TestAccount> talist = testAccountBo.findTestAccount(account, new Page());
			if(talist != null&& talist.size()>0){
				if(talist.size() == 1){
					TestAccount ta = talist.get(0);
					if(ta.getSeqid().longValue() != testAccount.getSeqid().longValue()){
						throw new XLRuntimeException("编号为："+testAccount.getGameid()+"的游戏中账号："+testAccount.getGameAccount()+"已经存在，请不要重复添加");
					}
				}else{
					throw new XLRuntimeException("游戏："+testAccount.getGameid()+"的账号："+testAccount.getGameAccount()+"已经存在多个，请删除多余的");
				}
			}
			String gameAccount = account.getGameAccount();
			if(gameAccount.indexOf("xlniuxtest")==-1||gameAccount.length() != 13){
				throw new XLRuntimeException("只允许：xlniuxtest000-xlniuxtest200之间的账号");
			}
			String number = gameAccount.substring(10);
			if(number.indexOf("0")==0){
				number = number.substring(1);
				if(number.indexOf("0")==0){
					number = number.substring(1);
				}
			}
			int num = Integer.parseInt(number);
			if(num<0 || num>200){
				throw new XLRuntimeException("只允许：xlniuxtest000-xlniuxtest200之间的账号");
			}
			testAccount.setCustomerid("");
			testAccount.setEditBy(this.currentUserLogo());
			testAccount.setEditTime(now());
			testAccountBo.update(testAccount);		
			
			//生成testaccount.properties文件
			makeFile(testAccount.getGameid(),testAccount.getGameAccount());
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除测试账号
	 * @return
	 */
	public String delete(){	
		logger.info("开始测试账号删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				testAccountBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
