package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TempPassword;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;
import com.xunlei.proxy.socket.bin.resp.Resp_set;
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TEMPPASSWORD)
public class TempPasswordManagedBean extends BaseManagedBean{

	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public String getQueryTempPasswordList(){
		this.authenticateRun();
		TempPassword tempPassword=this.findBean(TempPassword.class,"temppassword");
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getTempPasswordBo().count(tempPassword);
		pagedFliper.setRecordCount(count);
		List<TempPassword> list=new ArrayList<TempPassword>();
		if(count>0){
			Page page=new Page();
			page.setPageNo(pagedFliper.getPageNo());
			page.setPageSize(pagedFliper.getPageSize());
			page.addOrder("inputtime", OrderType.DESC);
			list=FacadeFactory.INSTANCE.getTempPasswordBo().find(tempPassword, page);
		}
		Sheet<TempPassword> sheet=new Sheet<TempPassword>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String add(){
		this.authenticateAdd();
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		TempPassword tempPassword=this.findBean(TempPassword.class,"temppassword");
		//
		tempPassword.setInputby(user.getTrueName());
		tempPassword.setInputtime(sdf.format(now));
		tempPassword.setStatus("2");
		tempPassword.setTemppwd(to2Md5(tempPassword.getTemppwd()));
		tempPassword.setPwd(tempPassword.getTemppwd());
		//获取用户账号信息
		UserInfoProxy userInfoProxy=ProxyFactory.getInstance().getUserInfoProxy();
		Resp_getuserinfo_sec userinfosec=userInfoProxy.getuserinfo_sec(tempPassword.getUsername(), (byte) -1);
		
		if(userinfosec==null){
			alertJS("账号不存在");
			return "";
		}
		if(!userinfosec.isOk()){
			 String msg=getErrorMsg(userinfosec.getResult());
			 alertJS("更改失败，原因："+msg);
			 return "";
		}
		try{
			changePwd(String.valueOf(userinfosec.getUserno()), tempPassword.getTemppwd());
		}catch(Exception e){
			 alertJS(e.getMessage());
			 return "";
		}
		//插入到数据库
		FacadeFactory.INSTANCE.getTempPasswordBo().insert(tempPassword);
		return "";
	}
	public String edit(){
		this.authenticateEdit();
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		TempPassword tempPassword=this.findBean(TempPassword.class,"temppassword");
		TempPassword tp=FacadeFactory.INSTANCE.getTempPasswordBo().find(tempPassword.getSeqid());
		//还原密码
		UserInfoProxy userInfoProxy=ProxyFactory.getInstance().getUserInfoProxy();
		String rtn=changePwd(userInfoProxy, tp.getUsername(), tp.getTemppwd(), tp.getPwd());
		if(!"200".equals(rtn)){
			alertJS("还原失败，原因："+rtn);
			return "";
		}
		tp.setStatus("2");
		tp.setEditby(user.getTrueName());
		tp.setEdittime(sdf.format(now));
		FacadeFactory.INSTANCE.getTempPasswordBo().update(tp);
		return "";
	}
	public String changePwd(UserInfoProxy userInfoProxy,String userid,String oldPwd,String newPwd){
		//设置临时密码
		 Resp_set result=userInfoProxy.changepass(userid, (byte)-1,oldPwd, newPwd);
		 if(result.isOk()){
			 return "200";
		 }
		 String msg=getErrorMsg(result.getResult());
		
		 return msg;
	}
	public static  void changePwd(String userId,String newPwd){
		String url="http://10.1.1.57:9527/temppsw?request=retaketemppwd&userid="+userId+"&password="+newPwd;
		String resp=HttpClientUtil.get(url);
		logger.info("set tmeppassword url:"+url+";resp:"+resp);
		if(!resp.equals("result=200")){
			throw new RuntimeException("设置临时密码失败");
		}
	}

	private String getErrorMsg(int errorCode){
		 int rtn=errorCode;
		 String msg="";
		 switch (rtn) {
			case 505:
				msg="没有更改密码权限";
				break;
			case 501:
				msg="数据库错误";
				break;	
			case 500:
				msg="内部错误（缓存异常等）";
				break;
			case 413:
				msg="不支持的用户类型";
				break;
			case 412:
				msg="旧密码错误";
				break;	
			case 411:
				msg="密码格式不对";
				break;
			case 410:
				msg="帐号与帐号类型不匹配";
				break;
			case 404:
				msg="帐号不存在";
				break;	
			case 403:
				msg="请求参数非法";
				break;
			case 401:
				msg="协议解析失败";
				break;
			default:
				msg=String.valueOf(rtn);
				break;
		 }
		 return msg;
	}
	public static String to2Md5(String value){
		String v= Md5Encrypt.md5(value).toLowerCase();
		v=Md5Encrypt.md5(v).toLowerCase();
		return v;
	}
}
