package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.SpreadInfoTimeBo;
import com.xunlei.niux.data.vipgame.bo.SpreadinfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Flatno;
import com.xunlei.niux.data.vipgame.vo.SpreadInfoTime;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.ShortUrlCreater;
import com.xunlei.niux.manager.web.util.SpreadInfoUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 专题活动业务控制
 *
 * @author haibo
 * @date 2012-8-7
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_SPREADINFO)
public class SpreadInfoManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger
            .getLogger("SpreadInfo");
    private boolean enableAdd = true;
    private boolean enableDelete = true;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    //正式地址
    private static final String DOMAIN = "http://jump.niu.xunlei.com:8080/";


    //测试地址
//    private static final String DOMAIN = "http://10.10.10.203:8088/";

    /**
     * 查询专题活动
     *
     * @return
     */
    public String getQueryActivityList() {
//        logger.info("开始专题活动查询");
        this.authenticateRun();// 验证运行权限
        // 获取查询条件
        Spreadinfo spreadInfo = this.findBean(Spreadinfo.class, "spreadinfo");

        if (spreadInfo.getLikeSpreadTab() != null) {
            spreadInfo.setLikeSpreadTab("%" + spreadInfo.getLikeSpreadTab() + "%");
        }
        spreadInfo.setStatus(true);

        // 获取条件
        PagedFliper fliper = this.getFliper();//

        List<Spreadinfo> list = FacadeFactory.INSTANCE.getSpreadinfoBo()
                .findSpreadInfoInlist(spreadInfo, fliper);
        Sheet<Spreadinfo> sheet = new Sheet<Spreadinfo>();
        sheet.setDatas(list);
        sheet.setRowcount(FacadeFactory.INSTANCE.getSpreadinfoBo().count(spreadInfo));
        this.mergePagedDataModel(sheet, fliper);
//        logger.info("完成专题活动查询");
        return "";
    }

    public String edit() {
        UserInfo userInfo = currentUserInfo();
        logger.info(userInfo.getTrueName()+"开始专题活动编辑");
        this.authenticateEdit();// 编辑权限
        Spreadinfo spreadInfo = this.findBean(Spreadinfo.class, "spreadinfo");

        if (spreadInfo == null) {
            logger.info("信息为空");
            alertJS("编辑失败，原因：信息为空");
            return "";
        }

        Spreadinfo info = FacadeFactory.INSTANCE.getSpreadinfoBo()
                .findSpreadInfo(spreadInfo.getSeqId());
        if (info == null) {
            logger.info(info + "不存在");
            alertJS("编辑失败，原因：活动" + info + "不存在");
            return "";
        }
        logger.info(userInfo.getTrueName()+"编辑前SpreadInfo信息为："+info);

        if(spreadInfo.getJumpurl().contains(spreadInfo.getShorturl())){
            logger.info("跳转链接不能设置与短链接相同");
            alertJS("编辑失败，原因：跳转链接不能设置与短链接相同");
            return "";
        }

//		info.setAdvNo(spreadInfo.getAdvNo());
        info.setJumpurl(spreadInfo.getJumpurl());
        info.setChooseWeight(spreadInfo.getChooseWeight());
		info.setShorturl(spreadInfo.getShorturl());
        info.setRemark(spreadInfo.getRemark());
        info.setEditBy(userInfo.getTrueName());
        info.setEditTime(format.format(new Date()));
//        info.setFlatno(spreadInfo.getFlatno());
        info.setSpreadTab(spreadInfo.getSpreadTab());
//		info.setInputBy(spreadInfo.getInputBy());
//		info.setInputTime(spreadInfo.getInputTime());

        FacadeFactory.INSTANCE.getSpreadinfoBo().updateSpreadinfo(info);
        logger.info(userInfo.getTrueName()+"编辑完成后SpreadInfo信息为："+info);

        logger.info(userInfo.getTrueName()+"完成推广信息更新 ");
        alertJS("编辑成功");
        return "";
    }

    public String add() {
        UserInfo userInfo = currentUserInfo();
        logger.info(userInfo.getTrueName()+"开始添加推广活动");
        this.authenticateAdd();// 添加权限
        Spreadinfo spreadinfo = this.findBean(Spreadinfo.class, "spreadinfo");

        if (spreadinfo == null) {
            logger.info("推广为空");
            alertJS("添加失败，原因：活动为空");
            return "";
        }

        //不做这个验证
//        Spreadinfo dbSpreadinfo = new Spreadinfo();
//
//        dbSpreadinfo.setFlatno(spreadinfo.getFlatno());
//        dbSpreadinfo.setSpreadTab(spreadinfo.getSpreadTab());
//
//        Spreadinfo spreadinfo2 = FacadeFactory.INSTANCE.getSpreadinfoBo().findSpreadInfo(dbSpreadinfo);
//        logger.info("==========================" + spreadinfo2);
//        if (spreadinfo2 != null) {
//            alertJS("添加失败,已存在推广平台推广位");
//            return "";
//        }

        try {
            if(StringUtils.isEmpty(spreadinfo.getAdvNo())){
                spreadinfo.setAdvNo(ShortUrlCreater.createAdvNo());
            }
        } catch (Exception e1) {
            alertJS("添加失败，原因：生成编号出错，请重试");
            e1.printStackTrace();
        }
//        UserInfo info = currentUserInfo();

        spreadinfo.setStatus(true);
        spreadinfo.setInputBy(userInfo.getTrueName());
        spreadinfo.setInputTime(format.format(new Date()));
        if(StringUtils.isEmpty(spreadinfo.getShorturl())){
            spreadinfo.setShorturl(DOMAIN
                    + ShortUrlCreater.createShortUrl(spreadinfo.getAdvNo()));
        }
        logger.info("getAdvNo:" + spreadinfo.getAdvNo() + "=======shortUrl:"
                + spreadinfo.getShorturl());

        logger.info(userInfo.getTrueName()+"添加推广活动的SpreadInfo信息为："+spreadinfo);

        try {
            FacadeFactory.INSTANCE.getSpreadinfoBo().insertSpreadInfo(
                    spreadinfo);

            logger.info(userInfo.getTrueName()+"完成添加推广活动");
            alertJS("添加成功");
            return "";
        } catch (Exception e) {
            logger.info("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
            return "";
        }
    }


    public String batedit() {
        UserInfo userInfo = currentUserInfo();
        logger.info(userInfo.getTrueName()+"begin batedit...");

        String advurl = this.findParameter("advurl");
        String paramseqids = this.findParameter("bateditids");
        if (isEmpty(paramseqids)) {
            return "";
        }
        String[] params = paramseqids.split(",");
        long[] ids = new long[params.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Long.parseLong(params[i]);
        }
        logger.info(userInfo.getTrueName()+"批量修改的数据信息为："+paramseqids+"的Jumpurl设置为"+advurl);
        for (long id : ids) {

            Spreadinfo data = FacadeFactory.INSTANCE.getSpreadinfoBo().findSpreadInfo(id);

            logger.info(data.getShorturl()+"的Jumpurl修改信息：");
            logger.info("修改前为:"+data.getJumpurl());
            logger.info("修改后为:"+advurl);

            data.setJumpurl(advurl);
            FacadeFactory.INSTANCE.getSpreadinfoBo().updateSpreadinfo(data);
        }
        /* reloadAdvMap(RELOADURL44);
        reloadAdvMap(RELOADURL45);*/
        return "";
    }


    public void delete() {
        UserInfo userInfo = currentUserInfo();
        logger.info(userInfo.getTrueName()+"开始删除推广活动");
        this.authenticateAdd();// 添加权限
        // Spreadinfo spreadinfo = this.findBean(Spreadinfo.class,
        // "spreadinfo");
        long seqids[] = this.findParamSeqids();
        // logger.debug("=========="+spreadinfo);
        // if (spreadinfo == null) {
        // logger.info("推广为空");
        // alertJS("添加失败，原因：活动为空");
        // return ;
        // }
        // logger.info("getAdvNo:" + spreadinfo.getSeqId());
        logger.info(userInfo.getTrueName()+"删除的推广信息Id为"+seqids+",具体信息如下：");

        try {

            SpreadinfoBo spreadinfoBo = FacadeFactory.INSTANCE.getSpreadinfoBo();
            for (long seqId : seqids) {
                logger.debug("=======seqId" + seqId);
                Spreadinfo info = spreadinfoBo.findSpreadInfo(seqId);
                logger.info("seqid="+seqId+",shorturl="+info.getShorturl()+",jumpurl="+info.getJumpurl()+",advno="+info.getAdvNo());
                info.setStatus(false);
                spreadinfoBo.updateSpreadinfo(info);

                deleteTimeTask(seqId);

            }
            /*  reloadAdvMap(RELOADURL44);
            reloadAdvMap(RELOADURL45);*/
            logger.info(userInfo.getTrueName()+"完成删除推广活动");
            alertJS("删除成功");
            return;
        } catch (Exception e) {
            logger.info("删除失败", e);
            alertJS("删除失败，原因：" + e.getMessage());
            return;
        }
    }

    /**
     * 删除定时任务
     * @param seqId  推广信息ID
     */
    private void deleteTimeTask(long seqId) {

        SpreadInfoTime spreadInfoTime = new SpreadInfoTime();
        spreadInfoTime.setSpreadid(Long.valueOf(seqId).intValue());

        SpreadInfoTimeBo spreadInfoTimeBo = FacadeFactory.INSTANCE.getSpreadInfoTimeBo();
        int spreadInfoTimeCount = spreadInfoTimeBo.count(spreadInfoTime);
        if(spreadInfoTimeCount > 0) {
            List<SpreadInfoTime> list = spreadInfoTimeBo.find(spreadInfoTime, 1, spreadInfoTimeCount);

            for(SpreadInfoTime deleteTime : list) {
                spreadInfoTimeBo.delete(deleteTime.getSeqid());
            }
        }
    }

    protected long[] findParamSeqids() {
        String paramseqids = findParameter("param_seqid");
        if (isEmpty(paramseqids))
            paramseqids = findParameter("delseqids");
        if (isEmpty(paramseqids))
            paramseqids = findParameter("delbtn");
        String[] params = paramseqids.split(",");
        long[] seqids = new long[params.length];
        for (int i = 0; i < seqids.length; ++i) {
            logger.info("===========" + params[i] + "===========");
            seqids[i] = Long.parseLong(params[i]);
        }
        return seqids;
    }

    public boolean getEnableAdd() {
        return enableAdd;
    }

    public void setEnableAdd(boolean enableAdd) {
        this.enableAdd = enableAdd;
    }

    public boolean isEnableDelete() {
        return enableDelete;
    }

    public void setEnableDelete(boolean enableDelete) {
        this.enableDelete = enableDelete;
    }


    public List<SelectItem> getFlatnoList() {

        List<SelectItem> tempList = new ArrayList<SelectItem>();
        SelectItem sm = new SelectItem();
        sm.setLabel("全部");
        tempList.add(sm);

        tempList.addAll(getAddFlatnoList());


        return tempList;
    }

    public List<SelectItem> getAddFlatnoList() {
        List<Flatno> list = FacadeFactory.INSTANCE.getSpreadinfoBo().findFlatnoList();

        List<SelectItem> tempList = new ArrayList<SelectItem>();

        for (Flatno flat : list) {
            SelectItem si = new SelectItem();
            si.setValue(flat.getFlatno());
            si.setLabel(flat.getFlatno());
            tempList.add(si);
        }


        return tempList;
    }

    /**
     * 同步外网
     */
    public void publish() {

        SpreadInfoUtil.reloadInfo();

        alertJS("发布成功！");
    }


    /**
     * 同步预发布
     */
    public void prePublish() {
        SpreadInfoUtil.preReloadInfo();

        alertJS("预发布成功");
    }

    /**
     * 批量定时
     *
     * @return
     */
    public String battime() {
        this.authenticateRun();

        SpreadInfoTime spreadInfoTime = findBean(SpreadInfoTime.class, "spreadinfotime");
        if (spreadInfoTime == null) {
            logger.debug("添加内容为空");
            alertJS("添加失败，原因：添加内容为空");
            return "";
        }
        try {

            String paramseqids = this.findParameter("bateditids");
            String[] params = paramseqids.split(",");
            long[] ids = new long[params.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = Long.parseLong(params[i]);
            }
            for (Long id : ids) {
                spreadInfoTime.setSpreadid(id.intValue());

                FacadeFactory.INSTANCE.getSpreadInfoTimeBo().insert(spreadInfoTime);
            }

            alertJS("批量定时成功!");
        } catch (Exception e) {
            logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
        }

        return "";
    }
}

