package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.SmsReceiver;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SmsReceiverManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(SmsReceiverManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public SmsReceiverManagedBean()
    {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum()
    {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQuerySmsReceiverList()
    {
        logger.info("开始短信收信人查询");
        authenticateRun();
        SmsReceiver query = (SmsReceiver)findBean(SmsReceiver.class, "smsreceiver");
        if ((query != null) &&
                (query.getSid() != null) && (query.getSid().longValue() == 0L)) {
            query.setSid(null);
        }

        PagedFliper pagedFliper = getFliper();
        int count = this.baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("sid", OrderType.DESC);
            page.addOrder("sendTime", OrderType.DESC);
            list = this.baseSo.findObjects(query, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }
}