package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyInfo;
import com.xunlei.newplayercard.vo.KeyRule;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.SmsActivationCode;
import com.xunlei.niux.data.vipgame.vo.SmsReceiver;
import com.xunlei.niux.manager.web.exception.NiuxException;
import com.xunlei.niux.manager.web.proxy.SmsProxy;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.util.StringTools;

public class SmsActivationCodeManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger
			.getLogger(SmsActivationCodeManagedBean.class.getName());
	private static final String FILEPATH = IFacadeCommon.INSTANCE
			.getLibconfigValueByConfigNo("fileStorePath") + "/";
	private static final String checkers = IFacadeCommon.INSTANCE
			.getLibconfigValueByConfigNo("smscheckers");
	private static com.xunlei.newplayercard.facade.IFacade facade = com.xunlei.newplayercard.facade.IFacade.INSTANCE;
	
//	//TODO:to be change
//	private static String FILEPATH = "d:/logs" + "/";
	
	private BaseSo baseSo;
	private int rownum = 0;
	private UploadedFile upfile;
	private String text = "";

	public UploadedFile getUpfile() {
		return this.upfile;
	}

	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}

	public String getText() {
		return this.text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public SmsActivationCodeManagedBean() {
		this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

		int pageNo = getFliper().getPageNo();
		int pageSize = getFliper().getPageSize();
		this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
	}

	public int getRownum() {
		return this.rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}

	private boolean checkLimit() {
		String checker = currentUserLogo();
		if (StringTools.isEmpty(checkers))
			return true;
		if (checkers.indexOf(",") == -1) {
			if (checker.trim().equals(checkers.trim()))
				return true;
		} else {
			String[] mycheckers = checkers.split(",");
			for (String mychecker : mycheckers) {
				if (mychecker.trim().equals(checker.trim()))
					return true;
			}
		}
		return false;
	}

	public String doPass() {
		logger.info("开始发送短信激活码申请审核");
		try {
			String seqId = findParameter("seqId");
			SmsActivationCode apply = (SmsActivationCode) this.baseSo.findById(SmsActivationCode.class,
					seqId);
			if (apply == null) {
				throw new XLRuntimeException("该申请已经不存在");
			}
			
			int batCount = SmsProxy.getInstance().getUserInfoCount(FILEPATH + apply.getFileName());
			String batId = apply.getBatId();
			String ruleId = facade.queryRuleIdByBatId(batId);
			boolean isEnough = facade.isBatchEnoughToSend(ruleId, batId, batCount);
			if(!isEnough){
				//如果激活码数量不足，则审核自动失败，并把状态设置为不通过
				apply.setReason("该批次的激活码数量不足");
				apply.setAllCount(Long.valueOf(0));
				apply.setCheckerTime(now());
				apply.setChecker(currentUserLogo());
				apply.setCheckStatus(Integer.valueOf(2));
				this.baseSo.updateObjectById(apply);
				throw new XLRuntimeException("该批次的激活码数量不足");
			}
			
			List<String> activationCodeList = facade.getActivationCodes(ruleId, batId, batCount);
			
			Map<String, String> succMap = SmsProxy.getInstance().sendSmsActivationCode(apply.getContent(),
					FILEPATH + apply.getFileName(), activationCodeList);
			
			facade.updateKeyInfoState(ruleId, batId, succMap);
			
			int count = succMap.size();
			apply.setAllCount(Long.valueOf(count));
			apply.setCheckerTime(now());
			apply.setChecker(currentUserLogo());
			apply.setCheckStatus(Integer.valueOf(1));
			this.baseSo.updateObjectById(apply);
		} catch (Exception e) {
			e.printStackTrace();
			mergeJsmessage("审核失败，原因：" + e.getMessage());
		}
		return "";
	}

	public String doFail() {
		logger.info("开始发送短信激活码申请审核");
		try {
			if (!checkLimit()) {
				throw new XLRuntimeException("您没有该功能的审核权限");
			}
			String seqId = findParameter("seqId2");
			SmsActivationCode apply = (SmsActivationCode) this.baseSo.findById(SmsActivationCode.class,
					seqId);
			if (apply == null) {
				throw new XLRuntimeException("该申请已经不存在");
			}
			String reason = findParameter("reason");
			apply.setCheckerTime(now());
			apply.setChecker(currentUserLogo());
			apply.setCheckStatus(Integer.valueOf(2));
			apply.setReason(reason);
			this.baseSo.updateObjectById(apply);
		} catch (Exception e) {
			e.printStackTrace();
			mergeJsmessage("审核失败，原因：" + e.getMessage());
		}
		return "";
	}

	public String testSms() {
		logger.info("开始发送测试短信");
		try {
			SmsActivationCode apply = (SmsActivationCode) findBean(SmsActivationCode.class, "smsactivationcode");
			SmsProxy.getInstance().testSms(apply.getTestPhone(),
					apply.getContent());
		} catch (NiuxException ee) {
			ee.printStackTrace();
			mergeJsmessage("发送失败，原因：" + ee.errorMsg);
		} catch (Exception e) {
			e.printStackTrace();
			mergeJsmessage("发送失败，原因：" + e.getMessage());
		}
		return "";
	}

	public String getQuerySmsApplyList() {
		logger.info("开始发送短信激活码申请查询");
		authenticateRun();
		SmsActivationCode apply = (SmsActivationCode) findBean(SmsActivationCode.class, "smsactivationcode");
		if ((apply != null) && (apply.getCheckStatus() != null)
				&& (apply.getCheckStatus().intValue() == -2)) {
			apply.setCheckStatus(null);
		}

		PagedFliper pagedFliper = getFliper();
		int count = this.baseSo.countObject(apply);
		pagedFliper.setRecordCount(count);
		List list = new ArrayList();
		if (count > 0) {
			this.rownum = 1;
			Page page = new Page();
			page.setPageNo(pagedFliper.getPageNo());
			page.setPageSize(pagedFliper.getPageSize());
			page.addOrder("applyTime", OrderType.DESC);
			list = this.baseSo.findObjects(apply, page);
		}
		Sheet sheet = new Sheet(count, list);
		mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
		return "";
	}

	public String uploadFile() throws Exception {
		logger.info("开始收件者文件上传");
		if (this.upfile != null) {
			try {
				String seqId = findParameter("sseqId");
				SmsActivationCode apply = (SmsActivationCode) this.baseSo.findById(
						SmsActivationCode.class, seqId);
				if (apply == null) {
					throw new XLRuntimeException("该申请已经不存在");
				}
				
				this.text = FileUploadUtil.upLoadFile(this.upfile, FILEPATH);
				apply.setCheckStatus(Integer.valueOf(0));
				apply.setFileName(this.text);
				this.baseSo.updateObjectById(apply);
				System.out.println("filename:" + this.text);
			} catch (Exception e) {
				e.printStackTrace();
				throw e;
			}
		}
		return this.text;
	}

	public String addPhoneSms() {
		logger.info("开始录入手机号");
		try {
			String seqId = findParameter("seqId3");
			String one_phone = findParameter("one_phone");
			SmsActivationCode apply = (SmsActivationCode) this.baseSo.findById(SmsActivationCode.class,
					seqId);
			if (apply == null) {
				throw new XLRuntimeException("该申请已经不存在");
			}
			if (StringTools.isEmpty(one_phone)) {
				throw new XLRuntimeException("手机号不能为空");
			}
			checkPhone(one_phone);
			int i = sendSms(one_phone, apply);
			apply.setCheckStatus(Integer.valueOf(1));
			apply.setAllCount(new Long(i));
			apply.setCheckerTime(now());
			apply.setChecker(currentUserLogo());
			this.baseSo.updateObjectById(apply);
		} catch (Exception e) {
			logger.error("录入手机号", e);
			mergeJsmessage("录入手机号，原因：" + e.getMessage());
		}
		return "";
	}

	private int sendSms(String one_phone, SmsActivationCode apply) {
		int i = 0;
		if (one_phone.indexOf(",") == -1) {
			if (sms(one_phone, apply))
				i++;
		} else {
			String[] phones = one_phone.split(",");
			for (String phone : phones) {
				if ((StringTools.isEmpty(phone)) || (!sms(phone, apply)))
					continue;
				i++;
			}
		}

		return i;
	}

	private void checkPhone(String one_phone) throws XLRuntimeException {
		StringBuilder sql = new StringBuilder(
				"select * from smsreceiver where sendTime>='" + getMinDay()
						+ "' and phone in ");
		List params = new ArrayList();
		String where = "('";
		if (one_phone.indexOf(",") == -1) {
			where = where + one_phone.trim();
		} else {
			String[] phones = one_phone.split(",");
			for (String phone : phones) {
				if (!StringTools.isEmpty(phone))
					where = where + phone.trim() + "','";
			}
		}
		where = where + "')";
		sql.append(where);
		System.out.println("sql:" + sql);
		List<SmsReceiver> list = this.baseSo.executeQuery(SmsReceiver.class,
				sql.toString(), params);
		if (CollectionUtils.isNotEmpty(list)) {
			String phones = "";
			for (SmsReceiver sr : list) {
				phones = phones + sr.getPhone() + ",";
			}
			throw new XLRuntimeException("手机号：" + phones + "，3天之内不能重复发送短信");
		}
	}

	private String getMinDay() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar cal = Calendar.getInstance();
		cal.add(5, -3);
		return sdf.format(cal.getTime()) + " 00:00:00";
	}

	private boolean sms(String phone, SmsActivationCode apply) {
		try {
			SmsProxy.getInstance().testSms(phone, apply.getContent());
			addSmsReceiver(phone, apply);
			return true;
		} catch (Exception e) {
			logger.error("sendsms error", e);
		}
		return false;
	}

	private void addSmsReceiver(String phone, SmsActivationCode apply) {
		SmsReceiver receiver = new SmsReceiver();
		receiver.setContent(apply.getContent());
		receiver.setPhone(phone);
		receiver.setSendBy(apply.getApplyPerson());
		receiver.setSendTime(now());
		receiver.setSid(apply.getSeqId());
		this.baseSo.addObject(receiver);
	}

	public String add() {
		logger.info("开始发送短信申请信息添加");
		SmsActivationCode apply = (SmsActivationCode) findBean(SmsActivationCode.class, "smsactivationcode");
		try {
			if (apply == null) {
				logger.info("发送短信申请信息为空");
				throw new XLRuntimeException("发送短信申请信息为空");
			}
			
			String batId = apply.getBatId();
			if (batId == null || batId.equals("")) {
				throw new XLRuntimeException("批次号必须填写");
			}
			
			String ruleId = facade.queryRuleIdByBatId(batId);
			if (ruleId == null || ruleId.equals("")) {
				throw new XLRuntimeException("批次号不存在");
			}
			
			apply.setApplyPerson(currentUserLogo());
			apply.setApplyTime(now());
			apply.setCheckStatus(Integer.valueOf(-1));
			this.baseSo.addObject(apply);
		} catch (Exception e) {
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

	public String edit() {
		logger.info("开始发送短信申请信息修改");
		authenticateEdit();
		SmsActivationCode apply = (SmsActivationCode) findBean(SmsActivationCode.class, "smsactivationcode");
		try {
			if (apply == null) {
				logger.info("发送短信申请信息为空");
				throw new XLRuntimeException("发送短信申请信息为空");
			}
			this.baseSo.updateObjectById(apply);
		} catch (Exception e) {
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}

	public String delete() {
		logger.info("开始自动发放奖品信息删除");
		authenticateDel();
		String delseqids = findParameter("delseqids");
		try {
			String[] ids = delseqids.split(",");
			for (String id : ids)
				this.baseSo.deleteById(SmsActivationCode.class, id);
		} catch (Exception e) {
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}