package com.xunlei.niux.manager.web.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import com.xunlei.common.util.FunRef;
import com.xunlei.niux.data.vipgame.bo.SignStatisticsBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

/**
 * 签到统计业务处理类
 * @author lisu
 * 2013-04-02
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_SIGNSTATISTICS)
public class SignStatisticsManagedBean extends BaseManagedBean{

	private static final Logger logger = Logger.getLogger(SignStatisticsManagedBean.class.getName());
	
	/**
	 * 查询统计数据
	 * @return
	 */
	public Map<String,Object> getSignStatisticsMap(){
		logger.info("开始签到统计查询");
		String starttime = this.findParameter("signrecord_signStartDate");
		String endtime = this.findParameter("signrecord_signEndDate");	
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar calc = Calendar.getInstance(); 
		String nowtime = sdf.format(calc.getTime());//当前日期
		String firstDayOfThisWeek = null;//本周第一天
		String firstDateOfWeek = null;
		String lastDateOfWeek = null;
        if(starttime == null && endtime == null){//第一次打开界面时，默认查询上一周的统计数据
      	    int dayOfWeek = calc.get(Calendar.DAY_OF_WEEK);
    		calc.add(Calendar.WEEK_OF_YEAR, -1); //当前时间的前一周
    		calc.add(Calendar.DAY_OF_WEEK, -(dayOfWeek - 2));//前一周的第一天
    		firstDateOfWeek = sdf.format(calc.getTime());
    		calc.add(Calendar.DAY_OF_WEEK, 6);//前一周的最后一天
    		lastDateOfWeek = sdf.format(calc.getTime());  
    		calc.add(Calendar.DAY_OF_WEEK, 1);//本周的第一天
    		firstDayOfThisWeek = sdf.format(calc.getTime());
    		starttime = firstDateOfWeek;
    		endtime = lastDateOfWeek;
    		firstDayOfThisWeek = firstDateOfWeek;
    		nowtime = lastDateOfWeek;
    		calc.add(Calendar.WEEK_OF_YEAR, -2);//第一天
    		firstDateOfWeek = sdf.format(calc.getTime());
    		calc.add(Calendar.DAY_OF_WEEK, 6);//最后一天
    		lastDateOfWeek = sdf.format(calc.getTime());  
        }else{
        	try {
				Date date = sdf.parse(endtime);
				calc.setTime(date);//回到指定的日期
				nowtime = endtime;
				int dayOfWeek = calc.get(Calendar.DAY_OF_WEEK);
	    		calc.add(Calendar.WEEK_OF_YEAR, -1); //当前时间的前一周
System.out.println("time=================>"+sdf.format(calc.getTime()));	    		
	    		calc.add(Calendar.DAY_OF_WEEK, -(dayOfWeek - 2)==1?-6:-(dayOfWeek - 2));//前一周的第一天
	    		firstDateOfWeek = sdf.format(calc.getTime());
System.out.println("firstDateOfWeek==============>"+firstDateOfWeek);	    		
	    		calc.add(Calendar.DAY_OF_WEEK, 6);//前一周的最后一天
	    		lastDateOfWeek = sdf.format(calc.getTime());  
System.out.println("lastDateOfWeek==============>"+lastDateOfWeek);
	    		calc.add(Calendar.DAY_OF_WEEK, 1);//本周的第一天
	    		firstDayOfThisWeek = sdf.format(calc.getTime());
			} catch (ParseException e) {
				e.printStackTrace();
			}  
        }
        /**
         * 获得签到页面的总签到数
         */
		String sql = " SELECT COUNT(*) FROM `signrecord` WHERE 1 = 1";
		      if(starttime != null && !"".equals(starttime)){
		    	  sql += " and signDate>='"+starttime+"'";
		      }
		      if(endtime != null && !"".equals(endtime)){
		    	  sql += " and signDate<='"+endtime+"'";
		      }
System.out.println("sql1===================>"+sql);		      
		SignStatisticsBo csbo = FacadeFactory.INSTANCE.getSignStatisticsBo();
		int allcount = csbo.count(sql, null);//签到页面的总签到数
		
		/**
		 * 获得新增签到数
		 */
		sql = "SELECT COUNT(*) FROM `signrecord` WHERE signTotalBonusNum = 1 ";
			  if(starttime != null && !"".equals(starttime)){
		    	  sql += " and signDate>='"+starttime+"'";
		      }
		      if(endtime != null && !"".equals(endtime)){
		    	  sql += " and signDate<='"+endtime+"'";
		      }
System.out.println("sql2===================>"+sql);			      
		int newcount = csbo.count(sql, null);//新增签到数
		
		/**
		 * 获得签到用户周留存数
		 */
		StringBuffer sqlsb = new StringBuffer();
		           sqlsb.append("SELECT  COUNT(*) FROM ")
                   .append(" (SELECT userId  FROM signrecord WHERE signDate>= '1?' AND signDate<= '2?') s1  ")
                   .append(" INNER JOIN (SELECT userId  FROM signrecord WHERE signDate>= '3?' AND signDate<= '4?') s2  ")
                   .append(" ON s1.userId = s2.userId");
		sql = sqlsb.toString();
		sql = sql.replace("1?", firstDateOfWeek);
		sql = sql.replace("2?", lastDateOfWeek);
		sql = sql.replace("3?", firstDayOfThisWeek);
		sql = sql.replace("4?", nowtime);
		int persistcount = csbo.count(sql, null);
System.out.println("sql3===================>"+sql);			
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("allcount", allcount);
		map.put("newcount", newcount);
		map.put("persistcount", persistcount);
		return map;
	}
}
