package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.SeoGame;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.template.builder.ITemplateBuilder;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.DateUtil;


/**
 * 客户系统角色业务处理类
 * @author lisu
 *  2013-09-12
 */
public class SeoGameManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(SeoGameManagedBean.class.getName());
	private BaseSo baseBo;
	private int rownum = 0;
	private static final String templateid = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("seoTemplateid");//;
	
	public SeoGameManagedBean(){
		baseBo = FacadeFactory.INSTANCE.getBaseSo();

		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询Seo推荐游戏
	 * @return
	 */
	public String getQuerySeoGameList(){
		logger.info("开始Seo推荐游戏查询");
        this.authenticateRun();//验证运行权限
        SeoGame advice = findBean(SeoGame.class, "seogame");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseBo.countObject(advice);
        pagedFliper.setRecordCount(count);
        List<SeoGame> list = new ArrayList<SeoGame>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseBo.findObjects(advice, page);
        }
        Sheet<SeoGame> sheet = new Sheet<SeoGame>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增Seo推荐游戏
	 * @return
	 */
	public String add(){
		logger.info("开始Seo推荐游戏添加");		
		SeoGame game = this.findBean(SeoGame.class,"seogame");	
		try{
			if(game==null){
				logger.info("Seo推荐游戏为空");
				throw new XLRuntimeException("Seo推荐游戏为空");
			}		
			game.setInputBy(this.currentUserLogo());
			game.setInputTime(now());
			baseBo.addObject(game);
			
			//生成模版
			build(templateid);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改Seo推荐游戏
	 * @return
	 */
	public String edit(){
		logger.info("开始Seo推荐游戏修改");
		this.authenticateEdit();//编辑权限
		SeoGame game = this.findBean(SeoGame.class,"seogame");	
		try{
			if(game==null){
				logger.info("Seo推荐游戏为空");
				throw new XLRuntimeException("Seo推荐游戏为空");
			}	
			game.setEditBy(this.currentUserLogo());
			game.setEditTime(now());
			baseBo.updateObjectById(game);
			
			//生成模版
			build(templateid);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除Seo推荐游戏
	 * @return
	 */
	public String delete(){	
		logger.info("开始Seo推荐游戏删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseBo.deleteById(SeoGame.class, id);		
			
			//生成模版
			build(templateid);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 生成模版
	 * @param gameid
	 * @param templdateid
	 * @throws Exception
	 */
	public void build(String templateid) throws Exception{
        TemplateSchema templateSchema = new TemplateSchema();
        templateSchema.setTemplateid(templateid);
        templateSchema.setExt1(Constant.BASEGAMEID);
        templateSchema.setIspreview(false);
        final String now = DateUtil.formatNowByDefault();
        templateSchema.setSchematime(now);
        UserInfo user=this.currentUserInfo();
        templateSchema.setInputby(user.getTrueName());
        templateSchema.setInputtime(now);
        templateSchema.setIsexecuted(false);
        HtmlTemplate ht=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(templateid);
        Class<?> clazz = Class.forName(ht.getExecclass());
        ITemplateBuilder builder = (ITemplateBuilder)clazz.newInstance();
        builder.manualAddTemplateSchema(ht, templateSchema);
	}
}
