package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.QuestionBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.Question;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;


/**
 * 客服问题设置业务处理类
 * @author lisu
 *  2012-12-12
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_QUESTION)
public class QuestionManagedBean extends BaseManagedBean {

	private static final Logger logger = Logger.getLogger(QuestionManagedBean.class.getName());
	private QuestionBo questionBo = null;	
	private int rownum = 0;
	//消息状态
    private Map<Integer,String> messageStatus;
    
	public  QuestionManagedBean(){
		questionBo = FacadeFactory.INSTANCE.getQuestionBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 获得基础数组中配置的游戏信息
	 * @return
	 */
	 public List<SelectItem> getGameList() {
        List<SelectItem> tempList = new ArrayList<SelectItem>();
        SelectItem sm = new SelectItem();
        sm.setLabel("全部");
        sm.setValue(0);
        tempList.add(sm);
        tempList.addAll(getGameCollection());
        return tempList;
	 }
	 
	 /**
	  * 获得消息状态
	  * @return
	  */
	 public Map<Integer, String> getMessageStatus() {
		    if(messageStatus==null){
		       Map<Integer, String> tempMap=new HashMap<Integer,String>();                       
		       tempMap.put(0, "已处理");
		       tempMap.put(1, "新消息");
		       messageStatus=tempMap;
		    }
		    return messageStatus;

	  }
	 
	 /**
	  * 强制关闭
	  * @return
	  */
	 public String forceClose(){
		 String questionid = findParameter("forcecloseid");	 
		 this.authenticateDel();//验证运行权限
		 try{
			 if(questionid == null||"".equals(questionid)){
				 logger.info("问题编号为空");
				 alertJS("问题编号为空");
				 return "";
			 } 
			 //如果用户评分之后，就不能强制关闭了
			 int count = questionBo.count("select count(*) from question where  estimate > 0 and questionid=?",new Object[]{questionid});
			 if(count > 0){
				 logger.info("该问题已经评分，不能强制关闭");
				 alertJS("该问题已经评分，不能强制关闭");
				 return "";
			 }
			 String sql = "update question set isnew=0, questionstatus=4,lastdealtime='"+now()+"' where questionid = '"+questionid+"'";		 
			 questionBo.execute(sql, new ArrayList());			 
			 //更新客服人员
	         updateCustomerName(Long.parseLong(questionid),this.currentUserInfo().getTrueName());
			 alertJS("强制关闭成功");
		 }catch(Exception e){
			 alertJS("强制关闭失败，原因：" + e.getMessage());
		 }
		 
		 return "";
	 }
	 
	 
	 /**
		 * 更新客服人员名称
		 * @param questionid
		 * @param name
		 */
		public void updateCustomerName(long questionid,String name) throws Exception{
			logger.info("开始更新客服人员");
			Question question = questionBo.findById(questionid);
			String customername = question.getCustomername();
			if(customername != null&&!"".equals(customername)){
				if(customername.indexOf(name) == -1)
				   customername = customername+"、"+name;
			}else{
				customername = name;
			}
			question.setCustomername(customername);
			questionBo.update(question);
		}
	 
	 /**
	  * 获得基础数组中配置的游戏信息
	  * @return
	  */
	 public List<SelectItem> getGameCollection(){
		 List<SelectItem> list = (List<SelectItem>)getRequestAttribute("gameCollection");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("GameCollection");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("gameCollection", list);
	        }
	        return list;
	 }
	 
	    /**
		 * 获得基础数组中配置的用户评分
		 * @return
		 */
		 public List<SelectItem> getEstimateList() {
	        List<SelectItem> tempList = new ArrayList<SelectItem>();
	        SelectItem sm = new SelectItem();
	        sm.setLabel("全部");
	        sm.setValue(0);
	        tempList.add(sm);
	        tempList.addAll(getEstimateCollection());
	        return tempList;
		 }
		 
		  
		 /**
		  * 获得基础数组中配置的用户评分集合
		  * @return
		  */
		 public List getEstimateCollection(){
		        List list = (List)getRequestAttribute("estimate");
		        if(list == null)
		        {
		            List datas = LibClassM.getLibClassDList("estimate");
		            list = new ArrayList(datas.size());
		            for(int i = 0; i < datas.size(); i++){
		            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
		            }	                
		            setRequestAttribute("estimate", list);
		        }
		        return list;
		 }
		 
		 /**
		  * 获得基础数组中配置的用户评分集合
		  * @return
		  */
		 public List getEstimate(){
		     
            List datas = LibClassM.getLibClassDList("estimate");
            List list = new ArrayList(datas.size());
            for(int i = 0; i < datas.size(); i++){
            	Map map = new HashMap();
            	map.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname());            	
            	list.add(map); 	
            }	                
		 
		        return list;
		 }
		 /**
			 * 获得基础数组中配置的工单进度
			 * @return
			 */
			 public List<SelectItem> getQuestionStatusList() {
		        List<SelectItem> tempList = new ArrayList<SelectItem>();
		        SelectItem sm = new SelectItem();
		        sm.setLabel("全部");
		        sm.setValue(0);
		        tempList.add(sm);
		        tempList.addAll(getQuestionStatusCollection());
		        return tempList;
			 }
			 
			  
			 /**
			  * 获得基础数组中配置的工单进度集合
			  * @return
			  */
			 public List getQuestionStatusCollection(){
			        List list = (List)getRequestAttribute("questionstatus");
			        if(list == null)
			        {
			            List datas = LibClassM.getLibClassDList("questionstatus");
			            list = new ArrayList(datas.size());
			            for(int i = 0; i < datas.size(); i++){
			            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
			            }	                
			            setRequestAttribute("questionstatus", list);
			        }
			        return list;
			 }
			 /**
			  * 获得基础数组中配置的处理方式
			  * @return
			  */
			 public List getDealType(){
		            List datas = LibClassM.getLibClassDList("dealtype");
		            List list = new ArrayList(datas.size());
		            for(int i = 0; i < datas.size(); i++){
		            	Map map = new HashMap();
		            	map.put(Integer.parseInt(((LibClassD)datas.get(i)).getItemno()), ((LibClassD)datas.get(i)).getItemname());           	
		            	list.add(map); 				            	
		            }	                
			           			       
			        return list;
			 }
	 
			 /**
			  * 获得基础数组中配置的工单进度
			  * @return
			  */
			 public List getQuestionStatus(){
		            List datas = LibClassM.getLibClassDList("questionstatus");
		            List list = new ArrayList(datas.size());
		            for(int i = 0; i < datas.size(); i++){
		            	Map map = new HashMap();
		            	map.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname());           	
		            	list.add(map); 				            	
		            }	                
			           			       
			        return list;
			 }
			 
			 public List getQuestionType() {
				 List datas = LibClassM.getLibClassDList("QuestionType");
		            List list = new ArrayList(datas.size());
		            for(int i = 0; i < datas.size(); i++){
		            	Map map = new HashMap();
		            	map.put(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname());           	
		            	list.add(map); 				            	
		            }	                
			           			       
			        return list;

			    }
			 
			
	/**
	 * 客服问题查询
	 * @return
	 */
	public String getQueryQuestionList(){
		logger.info("开始客服问题查询");
        this.authenticateRun();//验证运行权限
        Question question = findBean(Question.class, "question");
        String flag = findParameter("flag");
        PagedFliper pagedFliper = this.getFliper();  

        if("1".equals(flag)){
            /**
             * 精准查询
             */
            String questionid = findParameter("questionid");
            String username = findParameter("username");
            String userid = findParameter("userid");
            String customername = findParameter("customername");
            //用于返回时保存查询状态
            String usernamea = findParameter("usernamea");          
            String userida = findParameter("userida");
            String customernamea = null;
            String questionids = findParameter("questionids");
            HttpServletRequest request = getHttpServletRequest();
            try {
            	customernamea = request.getParameter("customernamea");
            	if(customernamea != null)
				   customernamea = new String(customernamea.getBytes("iso-8859-1"),"utf8");
			} catch (UnsupportedEncodingException e1) {
				e1.printStackTrace();
			}
            StringBuffer sb = new StringBuffer();
            if(questionid != null && !"".equals(questionid)){
            	if(questionid.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and questionid = '"+questionid+"'");
            	}else{
            		String ids[] = questionid.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and questionid in (").append(sbid).append("'0')");
            	}
            }
           
            if(questionids != null && !"".equals(questionids)){
            	if(questionids.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and questionid = '"+questionids+"'");
            	}else{
            		String ids[] = questionids.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and questionid in (").append(sbid).append("'0')");
            	}
            }
            if(usernamea != null && !"".equals(usernamea)){
            	if(usernamea.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and username = '"+usernamea+"'");
            	}else{
            		String ids[] = usernamea.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and username in (").append(sbid).append("'0')");
            	}
            }
            if(username != null && !"".equals(username)){
            	if(username.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and username = '"+username+"'");
            	}else{
            		String ids[] = username.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and username in (").append(sbid).append("'0')");
            	}
            }
            if(customernamea != null && !"".equals(customernamea)){
            	if(customernamea.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and customername = '"+customernamea+"'");
            	}else{
            		String ids[] = customernamea.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and customername in (").append(sbid).append("'0')");
            	}
            }
            if(customername != null && !"".equals(customername)){
            	if(customername.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and customername = '"+customername+"'");
            	}else{
            		String ids[] = customername.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and customername in (").append(sbid).append("'0')");
            	}
            }
            if(userida != null && !"".equals(userida)){
            	if(userida.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and userid = '"+userida+"'");
            	}else{
            		String ids[] = userida.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and userid in (").append(sbid).append("'0')");
            	}
            }
            
            if(userid != null && !"".equals(userid)){
            	if(userid.indexOf(",")==-1){//如果只有一个值
            		sb.append(" and userid = '"+userid+"'");
            	}else{
            		String ids[] = userid.split(",");
            		StringBuffer sbid = new StringBuffer();
            		for(String id:ids){
            			sbid.append("'").append(id).append("',");
            		}            		
            		sb.append(" and userid in (").append(sbid).append("'0')");
            	}
            }
            Object[] objs = new Object[]{};
logger.info("sql================>"+"select * from question where 1=1 "+sb.toString());
            int count = questionBo.count("select count(*) from question where 1=1 "+ sb.toString(), objs);
            question.setGameid(null);
            question.setQuestionstatus(null);
            question.setQuestiontype(null);
            question.setEstimate(null);
            question.setIsnew(null);
            question.setUpgradestatus(null);
            pagedFliper.setRecordCount(count);    
            List<Question> list = new ArrayList<Question>();
            if (count > 0) {
            	rownum = 1;
            	Page page=new Page();
            	page.setPageNo(pagedFliper.getPageNo());
            	page.setPageSize(pagedFliper.getPageSize());
            	
                list = questionBo.findBySql(question,"select * from question where 1=1 "+sb.toString(),page.getPageNo(),page.getPageSize());
            }
            Sheet<Question> sheet = new Sheet<Question>(count, list);
            this.mergePagedDataModel(sheet, pagedFliper);
        }else{       	
            /**
             * 组合查询
             */
           if(question.getGameid()==null||"0".equals(question.getGameid())||"".equals(question.getGameid())){
            	question.setGameid(null);
           }
           String gameid = findParameter("gameida");
           if(gameid != null && !"".equals(gameid)){
        	   question.setGameid(gameid);
           }
          
           if(question.getQuestionstatus() == null||"".equals(question.getQuestionstatus())||question.getQuestionstatus().intValue()==0){
            	question.setQuestionstatus(null);
           }
           String questionstatus = findParameter("questionstatusa");
           if(questionstatus != null && !"".equals(questionstatus)){
        	   question.setQuestionstatus(Integer.parseInt(questionstatus)==0?null:Integer.parseInt(questionstatus));
           }
           if(question.getQuestiontype() == null||"".equals(question.getQuestiontype())||question.getQuestiontype().intValue()==0){
            	question.setQuestiontype(null);
           }
           String questiontype = findParameter("questiontypea");
           if(questiontype != null && !"".equals(questiontype)){
        	   question.setQuestiontype(Integer.parseInt(questiontype)==0?null:Integer.parseInt(questiontype));
           }
           if(question.getEstimate() == null||"".equals(question.getEstimate())||question.getEstimate().intValue()==0){
             	question.setEstimate(null);
           }
           String estimate = findParameter("estimatea");
           if(estimate != null && !"".equals(estimate)){
        	   question.setEstimate(Integer.parseInt(estimate)==0?null:Integer.parseInt(estimate));
           }
           if(question.getIsnew() == null ||"".equals(question.getIsnew())||question.getIsnew().intValue()==-1){
        	   question.setIsnew(null);
           }
           String isnew = findParameter("isnewa");
           if(isnew != null && !"".equals(isnew)){
        	   question.setIsnew(Integer.parseInt(isnew)==-1?null:Integer.parseInt(isnew));
           }
           if(question.getUpgradestatus() == null ||"".equals(question.getUpgradestatus())||question.getUpgradestatus().intValue()==-1){
        	   question.setUpgradestatus(null);
           }
           String upgradestatus = findParameter("upgradestatusa");
           if(upgradestatus != null && !"".equals(upgradestatus)){
        	   question.setUpgradestatus(Integer.parseInt(upgradestatus)==-1?null:Integer.parseInt(upgradestatus));
           }
           String beginday = findParameter("begindaya");
           if(beginday != null && !"".equals(beginday)){
        	   question.setFromcommittime(beginday);
           }
           String endday = findParameter("enddaya");
           if(endday != null && !"".equals(endday)){
        	   question.setTocommittime(endday);
           }
           int count = questionBo.count(question);        
           pagedFliper.setRecordCount(count);    
           List<Question> list = new ArrayList<Question>();
           if (count > 0) {
           	rownum = 1;
           	Page page=new Page();
           	page.setPageNo(pagedFliper.getPageNo());
           	page.setPageSize(pagedFliper.getPageSize());
               list = questionBo.find(question,page.getPageNo(),page.getPageSize());
           }
           Sheet<Question> sheet = new Sheet<Question>(count, list);
           this.mergePagedDataModel(sheet, pagedFliper);
        }             
        return "";
	}
	
	
	public Map getQuestion(){
		logger.info("开始客服问题回复查询");
		String questionid = findParameter("questionid");	
		String qid = findParameter("qid");		
		if(qid != null&&!"".equals(qid))questionid = qid;
		this.authenticateRun();//添加权限
		Map map = (Map)getRequestAttribute("questiondetail");
		if(map == null){
			map = new HashMap();
			Question question =  questionBo.findById(new Long(questionid));
			map.put("questionid", question.getQuestionid());
			map.put("userid", question.getUserid());
			map.put("username", question.getUsername());
			map.put("gameid", question.getGameid());
			map.put("questionstatus",question.getQuestionstatus());
			map.put("committime", question.getCommittime());
			map.put("lastdealtime", question.getLastdealtime());
			map.put("questiontype", question.getQuestiontype());
			map.put("gamerole", question.getGamerole());
			map.put("customername", question.getCustomername());
			map.put("estimate", question.getEstimate());
			map.put("title", question.getTitle());
			map.put("questioncontent", question.getQuestioncontent());
			map.put("lastdealtype", question.getLastdealtype());
			map.put("isnew", question.getIsnew());
			map.put("phone", question.getPhone());
			map.put("qcgrade", question.getQcgrade()==0?"":question.getQcgrade());
			map.put("vipGrade", question.getVipGrade());
			map.put("qccomment", question.getQccomment());
			map.put("upgradestatus", question.getUpgradestatus()==1?"已升级":"");
			setRequestAttribute("questiondetail", map);
		}
		
		return map;
	}

	
	/**
	 * 删除客服工单
	 * @return
	 */
	public String delete(){
		logger.info("开始客服问题删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");			
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				questionBo.deleteById(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 将查询的数据导出到excel中
	 */
	public void export(){
		    logger.info("开始大客户详情导出到excel文件");
		    String flag = findParameter("flag");	                	        
		    List list = null;
	        if("1".equals(flag)){
	            /**
	             * 精准查询
	             */
	            String questionid = findParameter("questionid");
	            String username = findParameter("username");
	            String userid = findParameter("userid");	           
	            String customername = findParameter("customername");
	            //用于返回时保存查询状态
	            String usernamea = findParameter("usernamea");          
	            String userida = findParameter("userida");
	            String customernamea = null;
	            String questionids = findParameter("questionids");
	            HttpServletRequest request = getHttpServletRequest();
	            try {
	            	customernamea = request.getParameter("customernamea");	            	
	            	if(customernamea != null)
					   customernamea = new String(customernamea.getBytes("iso-8859-1"),"utf8");
				} catch (UnsupportedEncodingException e1) {
					e1.printStackTrace();
				}
	            StringBuffer sb = new StringBuffer("select * from question where 1=1");

	            if(questionid != null && !"".equals(questionid)){
	            	if(questionid.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and questionid = '"+questionid+"'");
	            	}else{
	            		String ids[] = questionid.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and questionid in (").append(sbid).append("'0')");
	            	}
	            }
	           
	            if(questionids != null && !"".equals(questionids)){
	            	if(questionids.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and questionid = '"+questionids+"'");
	            	}else{
	            		String ids[] = questionids.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and questionid in (").append(sbid).append("'0')");
	            	}
	            }
	            if(usernamea != null && !"".equals(usernamea)){
	            	if(usernamea.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and username = '"+usernamea+"'");
	            	}else{
	            		String ids[] = usernamea.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and username in (").append(sbid).append("'0')");
	            	}
	            }
	            if(username != null && !"".equals(username)){
	            	if(username.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and username = '"+username+"'");
	            	}else{
	            		String ids[] = username.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and username in (").append(sbid).append("'0')");
	            	}
	            }
	            if(customernamea != null && !"".equals(customernamea)){
	            	if(customernamea.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and customername = '"+customernamea+"'");
	            	}else{
	            		String ids[] = customernamea.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and customername in (").append(sbid).append("'0')");
	            	}
	            }
	            if(customername != null && !"".equals(customername)){
	            	if(customername.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and customername = '"+customername+"'");
	            	}else{
	            		String ids[] = customername.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and customername in (").append(sbid).append("'0')");
	            	}
	            }
	            if(userida != null && !"".equals(userida)){
	            	if(userida.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and userid = '"+userida+"'");
	            	}else{
	            		String ids[] = userida.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and userid in (").append(sbid).append("'0')");
	            	}
	            }
	            
	            if(userid != null && !"".equals(userid)){
	            	if(userid.indexOf(",")==-1){//如果只有一个值
	            		sb.append(" and userid = '"+userid+"'");
	            	}else{
	            		String ids[] = userid.split(",");
	            		StringBuffer sbid = new StringBuffer();
	            		for(String id:ids){
	            			sbid.append("'").append(id).append("',");
	            		}            		
	            		sb.append(" and userid in (").append(sbid).append("'0')");
	            	}
	            }
	           list = questionBo.findBySql(Question.class, sb.toString(), new ArrayList());
	        }else{
	        	Question question = findBean(Question.class, "question");
	        	 /**
	             * 组合查询
	             */
	        	 if(question.getGameid()==null||"0".equals(question.getGameid())||"".equals(question.getGameid())){
	             	question.setGameid(null);
	            }
	            String gameid = findParameter("gameida");
	            if(gameid != null && !"".equals(gameid)){
	         	   question.setGameid(gameid);
	            }
	           
	            if(question.getQuestionstatus() == null||"".equals(question.getQuestionstatus())||question.getQuestionstatus().intValue()==0){
	             	question.setQuestionstatus(null);
	            }
	            String questionstatus = findParameter("questionstatusa");
	            if(questionstatus != null && !"".equals(questionstatus)){
	         	   question.setQuestionstatus(Integer.parseInt(questionstatus)==0?null:Integer.parseInt(questionstatus));
	            }
	            if(question.getQuestiontype() == null||"".equals(question.getQuestiontype())||question.getQuestiontype().intValue()==0){
	             	question.setQuestiontype(null);
	            }
	            String questiontype = findParameter("questiontypea");
	            if(questiontype != null && !"".equals(questiontype)){
	         	   question.setQuestiontype(Integer.parseInt(questiontype)==0?null:Integer.parseInt(questiontype));
	            }
	            if(question.getEstimate() == null||"".equals(question.getEstimate())||question.getEstimate().intValue()==0){
	              	question.setEstimate(null);
	            }
	            String estimate = findParameter("estimatea");
	            if(estimate != null && !"".equals(estimate)){
	         	   question.setEstimate(Integer.parseInt(estimate)==0?null:Integer.parseInt(estimate));
	            }
	            if(question.getIsnew() == null ||"".equals(question.getIsnew())||question.getIsnew().intValue()==-1){
	         	   question.setIsnew(null);
	            }
	            String isnew = findParameter("isnewa");
	            if(isnew != null && !"".equals(isnew)){
	         	   question.setIsnew(Integer.parseInt(isnew)==-1?null:Integer.parseInt(isnew));
	            }
	            if(question.getUpgradestatus() == null ||"".equals(question.getUpgradestatus())||question.getUpgradestatus().intValue()==-1){
	         	   question.setUpgradestatus(null);
	            }
	            String upgradestatus = findParameter("upgradestatusa");
	            if(upgradestatus != null && !"".equals(upgradestatus)){
	         	   question.setUpgradestatus(Integer.parseInt(upgradestatus)==-1?null:Integer.parseInt(upgradestatus));
	            }
	            String beginday = findParameter("begindaya");
	            if(beginday != null && !"".equals(beginday)){
	         	   question.setFromcommittime(beginday);
	            }
	            String endday = findParameter("enddaya");
	            if(endday != null && !"".equals(endday)){
	         	   question.setTocommittime(endday);
	            }
	           StringBuffer sb = new StringBuffer("select * from question where 1=1");
	           if(question.getGameid() != null){
	        	   sb.append(" and gameid='").append(question.getGameid()).append("'");
	           }
	           if(question.getQuestiontype() != null){
	        	   sb.append(" and questiontype=").append(question.getQuestiontype());
	           }
	           if(question.getQuestionstatus() != null){
	        	   sb.append(" and questionstatus=").append(question.getQuestionstatus());
	           }
	           if(question.getEstimate() != null){
	        	   sb.append(" and estimate=").append(question.getEstimate());
	           }
	           if(question.getIsnew() != null){
	        	   sb.append(" and isnew=").append(question.getIsnew());
	           }
	           if(question.getUpgradestatus() != null){
	        	   sb.append(" and upgradestatus=").append(question.getUpgradestatus());
	           }
	           if(question.getFromcommittime() != null){
	        	   sb.append(" and committime>='").append(question.getFromcommittime()).append("'");
	           }
	           if(question.getTocommittime()!= null){
	        	   sb.append(" and committime<'").append(question.getTocommittime()).append("'");
	           }
	           list = questionBo.findBySql(Question.class, sb.toString(), new ArrayList());
	        }

	        FacesContext facesContext = FacesContext.getCurrentInstance();
	        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();        
	        List datas = new ArrayList();
	    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
			String now = sdf.format(new Date()); 
			Workbook wb = null;
			List estimateCollecton = null;
			List dealtype = null;
			List questionstatus = null;
			List questiontype = null;
	        if(list != null){
	        	estimateCollecton = getEstimate();
	        	dealtype = getDealType();
	        	questionstatus = getQuestionStatus();
	        	questiontype = getQuestionType();
	        	Games games1 = new Games();
	        	List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(games1, 0, 0);
	        	//填充数据
				for(Object obj:list){
					Question q = (Question)obj;
					List qlist = new ArrayList();	        	        	
					qlist.add(q.getQuestionid());	
					qlist.add(q.getUserid());
					qlist.add(q.getUsername());
					qlist.add(getGameName(gamesList,q.getGameid()));
					qlist.add(getEstimateName(questiontype,q.getQuestiontype()));//
					qlist.add(q.getTitle());
					qlist.add(q.getQuestioncontent());
					qlist.add(q.getCommittime());
					qlist.add(q.getLastdealtime());
					qlist.add(getEstimateName(questionstatus,q.getQuestionstatus()));//
					qlist.add(q.getCustomername());
					qlist.add(getEstimateName(estimateCollecton,q.getEstimate()));//
					qlist.add(q.getPhone());
					qlist.add(q.getQcgrade()==0?"":q.getQcgrade());
					qlist.add(q.getQccomment());
					qlist.add(q.getUpgradestatus()==2?"已升级":"");
					qlist.add(getDealTypeName(dealtype,q.getLastdealtype()));//
		        	datas.add(qlist);					
				}				
	        }				
			
			String title = "工单统计";
			String[] columnName = {"工单编号", "用户uid", "迅雷账号","游戏名称", "问题类型","问题标题","问题内容","问题提交时间","客服处理时间","工单进度","客服人员","用户评分","用户手机号","质检评分","质检评语","工单状态","最后处理方式"};
			String filePath = "/tmp/questiondetails.xls";
			long beginTime = System.currentTimeMillis();
			wb = ExcelUtil.create("工单统计",title,columnName,filePath,datas);
			long endTime = System.currentTimeMillis();
			logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
			
			if(estimateCollecton != null){
				estimateCollecton.clear();
				estimateCollecton = null;
			}
			if(dealtype != null){
				dealtype.clear();
				dealtype = null;
			}
			if(questionstatus != null){
				questionstatus.clear();
				questionstatus = null;
			}
			if(questiontype != null){
				questiontype.clear();
				questiontype = null;
			}
			
			//弹出下载窗口
			response.setHeader("Content-disposition", "attachment;filename="+now+"_data.xls"); 
			response.setContentType("application/x-download");
			OutputStream ouputStream = null;
			try {
				ouputStream = response.getOutputStream();
				wb.write(ouputStream);  
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}   						
			FacesContext.getCurrentInstance().responseComplete();	            
	}
	
	
	public String getEstimateName(List estimateCollecton,Integer estimate){
		for(Object obj:estimateCollecton){
			Map m = (Map)obj;
			String str = (String)(m.get(estimate+""));
			if(str != null&& !"".equals(str))return str;
		}
		return "";
	}
	public String getGameName(List<Games> estimateCollecton,String gameid){
		for(Games game:estimateCollecton){
		    if(game.getGameId().trim().equals(gameid.trim()))return game.getGameName();
		}
		return "";
	}
	
	public String getDealTypeName(List dealtype,Integer type){
		for(Object obj:dealtype){
			Map m = (Map)obj;
			String str = (String)(m.get(type));
			if(str != null&& !"".equals(str))return str;
		}
		return "";
	}

	public void setMessageStatus(Map<Integer, String> messageStatus) {
		this.messageStatus = messageStatus;
	}
	
	

	/**
	 * 工单质检评分
	 * @return
	 */
	public String edit(){
		logger.info("开始工单质检评分修改");
		this.authenticateDel();//删除权限
		Question question = this.findBean(Question.class,"question");

		try{
			if(question==null){
				logger.info("质检评分失败，原因：工单为空");
				throw new XLRuntimeException("质检评分失败，原因：工单为空");
			}
			questionBo.update(question);		
		}catch(Exception e){
			logger.error("质检评分失败", e);
			mergeJsmessage("质检评分失败，原因：" + e.getMessage());
		}
		return "";
	}
}
