package com.xunlei.niux.manager.web.model;


import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.QuestionGameCategoryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.QuestionGameCategory;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 问题和分类关系业务处理类
 * @author lisu
 *  2012-12-21
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_QUESTIONGAMECATEGORY)
public class QuestionGameCategoryManagedBean extends BaseManagedBean {

	private static final Logger logger = Logger.getLogger(QuestionGameCategoryManagedBean.class.getName());
	private QuestionGameCategoryBo questionGameCategoryBo = null;	
	private int rownum = 0;
	
	public  QuestionGameCategoryManagedBean(){
		questionGameCategoryBo = FacadeFactory.INSTANCE.getQuestionGameCategoryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
    
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 新增问题和分类关系
	 * @return
	 */
	public String add(){
		logger.info("开始问题和分类关系添加");
		this.authenticateAdd();//添加权限		
		QuestionGameCategory gameCategory = this.findBean(QuestionGameCategory.class,"questiongamecategory");				
		try{
			if(gameCategory==null){
				logger.info("问题和分类为空");
				throw new XLRuntimeException("问题和分类关系为空");
			}
			String gameid = gameCategory.getGameid();
			Long categoryid = gameCategory.getCategoryid();
			if(isExist(gameid,categoryid)){
				logger.info("该游戏与分类已经分配过，不能重复分配");
				throw new XLRuntimeException("该游戏与分类已经分配过，不能重复分配");
			}
			questionGameCategoryBo.insert(gameCategory);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改问题
	 * @return
	 */
	public String edit(){
		logger.info("开始问题和分类关系修改");
		this.authenticateEdit();//编辑权限
		QuestionGameCategory gameCategory = this.findBean(QuestionGameCategory.class,"questiongamecategory");	
		try{
			if(gameCategory==null){
				logger.info("问题和分类关系为空");
				throw new XLRuntimeException("问题和分类关系为空");
			}
			String gameid = gameCategory.getGameid();
			Long categoryid = gameCategory.getCategoryid();
			if(isExiste(gameid,categoryid,gameCategory.getSeqid())){
				logger.info("该游戏已经分配过类型，不能重复分配");
				throw new XLRuntimeException("该游戏已经分配过类型，不能重复分配");
			}
			questionGameCategoryBo.update(gameCategory);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 获得问题和分类关系
	 * @return
	 */
	public String getQueryQuestionGameCategoryList(){
		logger.info("开始问题和分类关系查询");
        this.authenticateRun();//验证运行权限
		QuestionGameCategory gameCategory = this.findBean(QuestionGameCategory.class,"questiongamecategory");		
		PagedFliper pagedFliper = this.getFliper();    
        int count = questionGameCategoryBo.count(gameCategory);    
        pagedFliper.setRecordCount(count);
        List<QuestionGameCategory> list = new ArrayList<QuestionGameCategory>();  
		 if (count > 0) {
	        	rownum = 1;
	        	Page page=new Page();
	        	page.setPageNo(pagedFliper.getPageNo());
	        	page.setPageSize(pagedFliper.getPageSize());
	        	page.addOrder("seqid", OrderType.DESC);
	            list = questionGameCategoryBo.find(gameCategory,page.getPageNo(),page.getPageSize());
	        } 
	        Sheet<QuestionGameCategory> sheet = new Sheet<QuestionGameCategory>(count, list);     
	        this.mergePagedDataModel(sheet, pagedFliper);
	        return "";
	}
	
	/**
	 * 查询该记录是否存在
	 * @return
	 */
	public boolean isExist(String gameid,Long categoryid){
		String sql = "select count(*) from questiongamecategory where gameid=? and categoryid=?";		
		int count = questionGameCategoryBo.count(sql, new Object[]{gameid,categoryid});
		return count>0?true:false;
	}
	
	/**
	 * 查询该记录是否存在
	 * @return
	 */
	public boolean isExiste(String gameid,Long categoryid,long seqid){
		String sql = "select count(*) from questiongamecategory where gameid=? and categoryid=? and seqid <> ?";		
		int count = questionGameCategoryBo.count(sql, new Object[]{gameid,categoryid,seqid});
		return count>0?true:false;
	}
	
	/**
	 * 删除接口人信息
	 * @return
	 */
	public String delete(){
		logger.info("开始问题和分类关系删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				questionGameCategoryBo.deleteById(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 更新缓存
	 * @return
	 */
	public String updateCache(){
		logger.info("开始更新问题分类关系和工单设置的缓存");
		this.authenticateRun();//运行权限
		String questionSettingsUpdateCacheUrl=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("qsUpdateCacheUrl");	
		//String url = "http://10.10.10.202:80/question/updatecache.do";
		try{
		    String responseString =  getHtml(questionSettingsUpdateCacheUrl);	    	
		    	if(responseString != null && !"".equals(responseString)){
		    		responseString = responseString.replace("callback(", "").replace(")", "");
System.out.println("responseString===>"+responseString);
		    		ObjectMapper objectMapper = new ObjectMapper();
		    		ResultData data =objectMapper.readValue(responseString, ResultData.class);		    		
		    		if(data == null){
		    			alertJS("缓存更新失败，原因:网络异常");
		    			return "";
		    		}
		    		if(data.getRtn()!=0){
		    			alertJS("缓存更新失败，原因:"+data.getErrmsg());
		    			return "";
		    		}

		    	}
		    	alertJS("缓存更新成功");
		    }catch(Exception e){
                logger.info(e.getMessage());
		    }
		return "";
	}
	
	public static String getHtml(String url) throws Exception {
		HttpGet httpGet = new HttpGet(url);
		HttpResponse response;
		String responseString = "";
		HttpEntity entity = null;
		try {
			DefaultHttpClient httpClient = new DefaultHttpClient();
			response = httpClient.execute(httpGet);
			entity = response.getEntity(); // 返回服务器响应
			// 这样获取返回的html就不需要象以前的打印流了
			responseString = EntityUtils.toString(response.getEntity()); //返回服务器响应HTML代码
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (entity != null) {
				entity.consumeContent(); // 释放连接
			}
		}
		return responseString;
	}
	
	
	static class ResultData{
		private int rtn ;
		private String errmsg;
		public int getRtn() {
			return rtn;
		}
		public void setRtn(int rtn) {
			this.rtn = rtn;
		}
		public String getErrmsg() {
			return errmsg;
		}
		public void setErrmsg(String errmsg) {
			this.errmsg = errmsg;
		}
		
	}
}
