package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Activity;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

public class NiuActivityManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(NiuActivityManagedBean.class.getName());
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Map<String, String> activityProduct;

    public List<SelectItem> getActivityProductList()
    {
        Activity query = new Activity();
        List<Activity> mplist = FacadeFactory.INSTANCE.getActivityBo().find(query, new Page());
        List<SelectItem> siList = new ArrayList<SelectItem>();
        if (mplist == null) {
            return siList;
        }
        for (Activity act : mplist) {
            if (!"2".equals(act.getActstatus()))
                siList.add(new SelectItem(act.getActno(), act.getTitle()));
        }
        return siList;
    }

    public Map<String, String> getActivityProduct()
    {
        System.out.println("activityProduct=============>" + this.activityProduct);
        Map tempMap = new HashMap();
        Activity query = new Activity();
        List<Activity> mplist = FacadeFactory.INSTANCE.getActivityBo().find(query, new Page());
        if ((mplist != null) && (mplist.size() > 0)) {
            for (Activity product : mplist) {
                tempMap.put(product.getActno(), product.getTitle());
            }
        }
        this.activityProduct = tempMap;

        return this.activityProduct;
    }

    public String getQueryActivityList()
    {
        authenticateRun();
        Activity t_activity = (Activity)findBean(Activity.class, "niuactivity");
        PagedFliper pagedFliper = getFliper();
        int count = FacadeFactory.INSTANCE.getActivityBo().count(t_activity);
        System.out.println("count:" + count);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("starttime", OrderType.DESC);
            list = FacadeFactory.INSTANCE.getActivityBo().find(t_activity, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public String add()
    {
        authenticateAdd();
        UserInfo user = currentUserInfo();
        String now = sdf.format(new Date());

        Activity t_activity = (Activity)findBean(Activity.class, "niuactivity");
        t_activity.setInputby(user.getTrueName());
        t_activity.setInputtime(now);

        if ((t_activity.getEndtime() == null) || ("".equals(t_activity.getEndtime()))) {
            t_activity.setEndtime("9999-12-31 00:00:00");
        }
        try
        {
            FacadeFactory.INSTANCE.getActivityBo().insert(t_activity);
        } catch (Exception e) {
            logger.error("执行失败", e);
            alertJS("插入失败，原因:" + e.getMessage());
        }
        return "";
    }

    public String delete()
    {
        authenticateDel();
        String paramseqids = findParameter("delseqids");
        String[] params = paramseqids.split(",");
        for (String id : params) {
            FacadeFactory.INSTANCE.getActivityBo().delete(Long.valueOf(id).longValue());
        }
        return "";
    }
    public String edit() {
        authenticateEdit();
        UserInfo user = currentUserInfo();
        String now = sdf.format(new Date());
        Activity t_activity = (Activity)findBean(Activity.class, "niuactivity");
        t_activity.setEditby(user.getTrueName());
        t_activity.setEdittime(now);

        if ((t_activity.getEndtime() == null) || ("".equals(t_activity.getEndtime()))) {
            t_activity.setEndtime("9999-12-31 00:00:00");
        }
        try
        {
            FacadeFactory.INSTANCE.getActivityBo().update(t_activity);
        } catch (Exception e) {
            logger.error("执行失败", e);
            alertJS("编辑失败，原因:" + e.getMessage());
        }
        return "";
    }
}