package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuDayReportBo;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuDetailReportBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuDayReport;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuDetailReport;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MOYUREPORT)
public class MoyuDetailReportManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(MoyuDetailReportManagedBean.class);

    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public String getQueryList(){
        logger.info("魔域详细统计查询");
        this.authenticateRun();//验证运行权限

        MoyuDetailReport moyuDetailReport = findBean(MoyuDetailReport.class, "moyudetailreport");

        if(moyuDetailReport.getFromReporttime() == null) {
            moyuDetailReport.setFromReporttime(DATE_FORMAT.format(DateUtil.yesterday()));
        }

        final MoyuDetailReportBo moyuDetailReportBo = FacadeFactory.INSTANCE.getMoyuDetailReportBo();
        int count = moyuDetailReportBo.count(moyuDetailReport);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<MoyuDetailReport> list = new ArrayList<MoyuDetailReport>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("reporttime", OrderType.ESC);

            list = moyuDetailReportBo.find(moyuDetailReport, page);
        }
        Sheet<MoyuDetailReport> sheet = new Sheet<MoyuDetailReport>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
}
