package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.MemberReceiveBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.MemberReceive;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 礼包领取记录业务处理类
 * @author lisu
 *  2013-05-20
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MEMBERGIFT)
public class MemberReceiveManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MemberReceiveManagedBean.class.getName());
	private MemberReceiveBo memberReceiveBo;
	private int rownum = 0;

	
	public MemberReceiveManagedBean(){
		memberReceiveBo = FacadeFactory.INSTANCE.getMemberReceiveBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询礼包领取记录
	 * @return
	 */
	public String getQueryMemberReceiveList(){
		logger.info("开始礼包领取记录查询");
        this.authenticateRun();//验证运行权限
        MemberReceive mg = findBean(MemberReceive.class, "memberreceive");
        if(mg.getType() != null && mg.getType().intValue() == -1){
        	mg.setType(null);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = memberReceiveBo.count(mg);
        pagedFliper.setRecordCount(count);
        List<MemberReceive> list = new ArrayList<MemberReceive>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = memberReceiveBo.find(mg,page.getPageNo(),page.getPageSize());
        }
        Sheet<MemberReceive> sheet = new Sheet<MemberReceive>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}	
	
}
