package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.MarketProductBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.MarketProduct;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PicUtil;

/**
 * 道具商城商品业务处理类
 * @author lisu
 *  2013-07-04
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MARKEPRODUCT)
public class MarketProductManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MarketProductManagedBean.class.getName());
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");//
    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
	private MarketProductBo marketProductBo;
	private int rownum = 0;	
	private Map<String,String> marketProduct;   
	
	public MarketProductManagedBean(){
		marketProductBo = FacadeFactory.INSTANCE.getMarketProductBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	  * 查询道具商城普通商品
	  * @return
	  */
	public List<SelectItem> getSmarketProductList(){
		MarketProduct query=new MarketProduct();
	    query.setIsValid(true);//商品状态为有效状态
	    query.setType(new Integer(1));//商品类型为普通商品
		List<MarketProduct> mplist=marketProductBo.findMarketProduct(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(mplist==null){
			return siList;
		}
		for(MarketProduct product:mplist){
			siList.add(new SelectItem(product.getSeqid()+"", product.getTitle())); 	
		}
		return siList;
	}
	
	public Map<String, String> getMarketProduct() {
        Map<String,String> tempMap=new HashMap<String,String>();
        MarketProduct query=new MarketProduct();
	    query.setType(new Integer(1));//商品类型为普通商品
		List<MarketProduct> mplist=marketProductBo.findMarketProduct(query,new Page());
        if(mplist!=null&&mplist.size()>0){
        	for(MarketProduct product:mplist){
        		tempMap.put(product.getSeqid()+"", product.getTitle()); 	
			}
        }
        marketProduct=tempMap;
		return marketProduct;
	}
	
	/**
	 * 查询道具商城商品
	 * @return
	 */
	public String getQueryMarketProductList(){
		logger.info("开始道具商城商品查询");
        this.authenticateRun();//验证运行权限
        MarketProduct product = findBean(MarketProduct.class, "marketproduct");
        PagedFliper pagedFliper = this.getFliper();
        int count = marketProductBo.count(product);
        pagedFliper.setRecordCount(count);
        List<MarketProduct> list = new ArrayList<MarketProduct>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("display", OrderType.ESC);
        	page.addOrder("inputTime", OrderType.DESC);
            list = marketProductBo.findMarketProduct(product, page);
        }
        Sheet<MarketProduct> sheet = new Sheet<MarketProduct>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增道具商城商品
	 * @return
	 */
	public String add(){
		logger.info("开始道具商城商品信息添加");		
		MarketProduct product = this.findBean(MarketProduct.class,"marketproduct");	
		try{
			if(product==null){
				logger.info("道具商城商品信息为空");
				throw new XLRuntimeException("道具商城商品信息为空");
			}		
			MarketProduct mp = new MarketProduct();
			mp.setProductNo(product.getProductNo().trim());
			List<MarketProduct> mplist = marketProductBo.findMarketProduct(mp, new Page());
			if(mplist != null&&mplist.size()>0){
				throw new XLRuntimeException("商品编号："+product.getProductNo()+"已存在，请不要重复添加");
			}
			String  content = product.getContent();
			if(content != null){
				if(content.indexOf(FILEPATH)!= -1){
					content = content.replaceAll(FILEPATH, REMOREFILEPATH);
				}
			}
			product.setContent(PicUtil.replacePicUrlAndSyn(content));
			product.setInputBy(this.currentUserLogo());
			product.setInputTime(now());			
			marketProductBo.insert(product);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改道具商城商品
	 * @return
	 */
	public String edit(){
		logger.info("开始道具商城商品信息修改");
		this.authenticateEdit();//编辑权限
		MarketProduct product =this.findBean(MarketProduct.class,"marketproduct");
		try{
			if(product==null){
				logger.info("道具商城商品信息为空");
				throw new XLRuntimeException("道具商城商品信息为空");
			}		
			MarketProduct mp = new MarketProduct();
			mp.setSeqid(product.getSeqid());
			List<MarketProduct> mplist = marketProductBo.findMarketProduct(mp, new Page());
			if(mplist != null&&mplist.size()>0){
				mp = mplist.get(0);
				if(!mp.getProductNo().equals(product.getProductNo())){
					throw new XLRuntimeException("商品编号："+mp.getProductNo()+"已存在，请不要重复添加");
				}			
			}
			String  content = product.getContent();
			if(content != null){
				if(content.indexOf(FILEPATH)!= -1){
					content = content.replaceAll(FILEPATH, REMOREFILEPATH);
				}
			}
			product.setContent(PicUtil.replacePicUrlAndSyn(content));
			product.setEditBy(this.currentUserLogo());
			product.setEditTime(now());
			marketProductBo.update(product);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除道具商城商品信息
	 * @return
	 */
	public String delete(){	
		logger.info("开始道具商城商品信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				marketProductBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
