package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpSession;

import com.xunlei.niux.client.gamebox.BroadCastClient;
import org.apache.commons.lang.StringUtils;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.LinkLocation;
import com.xunlei.niux.manager.template.thread.IndexPageToBoxThread;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.GameBoxPicProxy;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import com.xunlei.niux.manager.web.util.PicUtil;
import com.xunlei.util.StringTools;

/**
 * 链接管理
 *
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LINKINFO)
public class LinkInfoManagedBean extends BaseManagedBean {
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat sdf1=new SimpleDateFormat("yyMMddHHmmss");
    private static final String [] linkids = new String[]{"1516","1509","1502"};
    
    /**
     * 获取linklocation下拉列表
     * @return
     */
    public List<SelectItem> getLinklocationList() {
    	String linklocid = findParameter("linklocid");
    	String linkgroupid=findParameter("linkgroupid");
    	
    	LinkLocation linklocation=new LinkLocation();
    	if(linklocid!=null&&!"".equals(linklocid.trim())){
    		linklocation.setLinklocid(linklocid.trim());
    	}
    	if(linkgroupid!=null&&!"".equals(linkgroupid.trim())){
    		linklocation.setLinktype(linkgroupid.trim());
    	}
    	List<LinkLocation> lllist=FacadeFactory.INSTANCE.getLinkLocationBo().find(linklocation);
    	List<SelectItem> tempList=new ArrayList<SelectItem>();
    	for(LinkLocation ll:lllist){
    		SelectItem si=new SelectItem();
    		si.setValue(ll.getLinklocid());
    		si.setLabel(ll.getLinklocname());
    		tempList.add(si);
    	}
		return tempList;
	}
    public List<SelectItem> getLinklocationRemarkList() {
    	String linklocid = findParameter("linklocid");
    	String linkgroupid=findParameter("linkgroupid");
    	
    	LinkLocation linklocation=new LinkLocation();
    	if(linklocid!=null&&!"".equals(linklocid.trim())){
    		linklocation.setLinklocid(linklocid.trim());
    	}
    	if(linkgroupid!=null&&!"".equals(linkgroupid.trim())){
    		linklocation.setLinktype(linkgroupid.trim());
    	}
    	List<LinkLocation> lllist=FacadeFactory.INSTANCE.getLinkLocationBo().find(linklocation);
    	List<SelectItem> tempList=new ArrayList<SelectItem>();
    	for(LinkLocation ll:lllist){
    		SelectItem si=new SelectItem();
    		si.setValue(ll.getLinklocid());
    		si.setLabel(ll.getRemark()==null?"":ll.getRemark());
    		tempList.add(si);
    	}
		return tempList;
	}
    public String getInitDefaultLinklocid(){
    	String linklocid = findParameter("linklocid");
    	String linkgroupid=findParameter("linkgroupid");
    	LinkLocation linklocation=new LinkLocation();
    	if(linklocid!=null&&!"".equals(linklocid.trim())){
    		linklocation.setLinklocid(linklocid.trim());
    	}
    	if(linkgroupid!=null&&!"".equals(linkgroupid.trim())){
    		linklocation.setLinktype(linkgroupid.trim());
    	}
    	List<LinkLocation> lllist=FacadeFactory.INSTANCE.getLinkLocationBo().find(linklocation);
    	LinkLocation ll1=new LinkLocation();
    	if(lllist.size()>0){
    		ll1=lllist.get(0);
    	}
    	return ll1.getLinklocid();
    }
    public String getInitDefaultGameid(){
    	Games  session_rolegames= findBean(Games.class, "session_rolegames");
    	if(session_rolegames==null){
    		session_rolegames=new Games();
    	}
    	if(session_rolegames.getGameId()==null||"".equals(session_rolegames.getGameId())){
    		List<Games> gList=FacadeFactory.INSTANCE.getGamesBo().findGames(new Games(), 0, 0);
    		String gameId="";
    		if(gList.size()>0){
    			Games g=gList.get(0);
    			gameId=g.getGameId();
    		}
    		session_rolegames.setGameId(gameId);
    	}
    	return session_rolegames.getGameId();
    }
    /**
     * 获取该用户能够控制的游戏
     */
    public List<SelectItem> getRoleGameList(){
    	System.out.println("获取角色游戏");
    	List<Games> gList=FacadeFactory.INSTANCE.getGamesBo().findGames(new Games(), 0, 0);
    	List<SelectItem> tempList=new ArrayList<SelectItem>();
    	for(Games games:gList){
    		SelectItem si=new SelectItem();
    		si.setValue(games.getGameId());
    		si.setLabel(games.getGameName());
    		tempList.add(si);
    	}
    	return tempList;
    }
    
    
    private void makeIndexPageToBox(String linklocid){
    	for(String linkid:linkids){
    		if(linkid.trim().equals(linklocid.trim())){
    			new Thread(new IndexPageToBoxThread()).start();
    			break;
    		}
    	}
    }
    
	/**
     * 查询链接
     *
     * @return
     */
    public String getQueryGameDefaultLinkinfoList() {
        logger.info("开始链接查询");
        this.authenticateRun();//验证运行权限
        LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
        linkInfo.setLinklocid(getInitDefaultLinklocid());
        linkInfo.setGameid(getInitDefaultGameid());
        PagedFliper pagedFliper = this.getFliper();
        if(linkInfo.getLinklocid()==null||"".equals(linkInfo.getLinklocid())){
        	this.mergePagedDataModel(new Sheet<LinkInfo>(0,new ArrayList<LinkInfo>()), pagedFliper);
        	return "";
        }
        if(linkInfo.getGameid()==null||"".equals(linkInfo.getGameid())){
        	this.mergePagedDataModel(new Sheet<LinkInfo>(0,new ArrayList<LinkInfo>()), pagedFliper);
        	return "";
        }
        LinkInfoBo linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();
        int count = linkInfoBo.count(linkInfo);
        pagedFliper.setRecordCount(count);
        List<LinkInfo> list = new ArrayList<LinkInfo>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("validdatetime", OrderType.DESC);
        	page.addOrder("displayorder", OrderType.DESC);
            list = linkInfoBo.find(linkInfo,page);
        }
        Sheet<LinkInfo> sheet = new Sheet<LinkInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
	/**
     * 查询链接
     *
     * @return
     */
    public String getQueryLinkinfoList() {
        logger.info("开始链接查询");
        this.authenticateRun();//验证运行权限
        LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");

        int gameFeature = -1;
        String gameFeatureStr = findParameter("game_gameFeature");
        if(StringUtils.isNotEmpty(gameFeatureStr)){
            gameFeature = Integer.parseInt(gameFeatureStr);
        }



        String linklocid = getLinklocid();
        
        if(linkInfo.getGameid()!=null&&!"".equals(linkInfo.getGameid())){
        	logger.debug("addsessongameid:"+linkInfo.getGameid());
        	this.addSessionValue("gameId", linkInfo.getGameid());
        }
        if (linkInfo != null) {
            logger.debug(linkInfo.getLinkid());
            if (linkInfo.getLinkid() != null && linkInfo.getLinkid() == 0) {
                linkInfo = new LinkInfo();
            }
        }

        if(StringUtils.isNotBlank(linklocid) && StringUtils.isBlank(linkInfo.getLinklocid())) {
            linkInfo.setLinklocid(linklocid);
        }


        LinkInfoBo linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();


        PagedFliper pagedFliper = this.getFliper();
        int count=FacadeFactory.INSTANCE.getLinkInfoBo().count(linkInfo);
        pagedFliper.setRecordCount(count);
        List<LinkInfo> list = new ArrayList<LinkInfo>();
        if(count>0){
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("displaysort", OrderType.DESC);
            page.addOrder("validdatetime", OrderType.DESC);
            List<LinkInfo> resultList = linkInfoBo.find(linkInfo,page);
//            if(gameFeature < 0){
                list.addAll(resultList);
//            }else {//筛选对应gameFeature的列表
//                list.addAll(getLinkListByGameFeature(resultList, gameFeature));
//            }
        }


        Sheet<LinkInfo> sheet = new Sheet<LinkInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }

    private List<LinkInfo> getLinkListByGameFeature(List<LinkInfo> SourceList,int gameFeature){
        List<LinkInfo> linkInfoList = new ArrayList<LinkInfo>();
        GameCache gameCache = GameCache.getInstance();
        for(LinkInfo gameLinkInfo : SourceList){
            String gameId = gameLinkInfo.getGameidbytuijian();
            if(StringUtils.isEmpty(gameId)){
                continue;
            }
            Games game = gameCache.getGameByGameId(gameId);
            if(game == null){
                return linkInfoList;
            }
            if(game.getGameFeature()!=null && game.getGameFeature() == gameFeature){
                linkInfoList.add(gameLinkInfo);
            }

        }
        return linkInfoList;
    }
	/**
     * 查询链接
     *
     * @return
     */
    public String getQueryGameLinkinfoList() {
        logger.info("开始链接查询");
        this.authenticateRun();//验证运行权限
        LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
        PagedFliper pagedFliper = this.getFliper();
        if(linkInfo.getGameid()==null||"".equals(linkInfo.getGameid())){
        	 Sheet<LinkInfo> sheet = new Sheet<LinkInfo>(0, new ArrayList<LinkInfo>());
             this.mergePagedDataModel(sheet, pagedFliper);
             return "";
        }
        String linklocid = getLinklocid();

        if (linkInfo != null) {
            logger.debug(linkInfo.getLinkid());
            if (linkInfo.getLinkid() != null && linkInfo.getLinkid() == 0) {
                linkInfo = new LinkInfo();
            }
        }

        if(StringUtils.isNotBlank(linklocid) && StringUtils.isBlank(linkInfo.getLinklocid())) {
            linkInfo.setLinklocid(linklocid);
        }


        LinkInfoBo linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();
        int count = linkInfoBo.count(linkInfo);

        pagedFliper.setRecordCount(count);
        List<LinkInfo> list = new ArrayList<LinkInfo>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("validdatetime", OrderType.DESC);
        	page.addOrder("displayorder", OrderType.DESC);
//        	Page page=PageUtil.formatPage(pagedFliper, "displayorder","asc","validdatetime","desc");
            list = linkInfoBo.find(linkInfo,page);
        }

        Sheet<LinkInfo> sheet = new Sheet<LinkInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
    private String getLinklocid() {
        String linklocid = findParameter("linklocid");
        HttpSession session = (HttpSession) FacesContext.getCurrentInstance().getExternalContext().getSession(true);

        if(StringUtils.isNotBlank(linklocid) ) {
            session.setAttribute("SESSION_LINKLOCID", linklocid);
        } else {
            linklocid = (String) session.getAttribute("SESSION_LINKLOCID");
        }
        return linklocid;
    }

    public String getLinkLocationName() {
        String linklocid = getLinklocid();

        if(StringUtils.isNotBlank(linklocid)) {
            return FacadeFactory.INSTANCE.getLinkLocationBo()
                    .find(linklocid)
                    .getLinklocname();
        } else {
            return "链接配置";
        }
    }

    public String edit() {
        this.authenticateEdit();

        LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
        if (linkInfo == null) {
            logger.debug("编辑内容为空");
            alertJS("编辑失败，原因：编辑内容为空");
            return "";
        }

        try{
        	checkGameUnique(linkInfo,true);
            LinkInfoBo linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();
            UserInfo user=this.currentUserInfo();
            linkInfo.setEditby(user.getTrueName());
            linkInfo.setEdittime(sdf.format(new Date()));
            LinkLocation loc=FacadeFactory.INSTANCE.getLinkLocationBo().find(linkInfo.getLinklocid());
            linkInfo.setLinklocgroupid(loc.getLinktype());
            linkInfo.setLinkcontents(PicUtil.replacePicUrlAndSyn(linkInfo.getLinkcontents()));
            linkInfoBo.update(linkInfo);
            makeIndexPageToBox(linkInfo.getLinklocid());
            synchPicToBox(linkInfo);//同步图片给盒子
            sendUpdateBroadCast(linkInfo);//发送盒子后台更新通知

            
            alertJS("编辑成功！");
        }catch(Exception e){
            logger.error("编辑失败", e);
            alertJS("编辑失败，原因：" + e.getMessage());
        }

        return "";
    }

    public void init(){
    	LinkInfo query = new LinkInfo();
    	query.setLinklocid("300");
    	List<LinkInfo> logolist = FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
    	for(LinkInfo linkInfo:logolist){
    		if(StringTools.isEmpty(linkInfo.getPicurl()))continue;
    		GameBoxPicProxy.getInstance().synchPic(linkInfo.getPicurl(), "s", linkInfo.getGameid(),true);
    	}
    	query.setLinklocid("1510");
    	List<LinkInfo> list = FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
    	for(LinkInfo linkInfo:list){
    		if(StringTools.isEmpty(linkInfo.getExt1())&&StringTools.isEmpty(linkInfo.getPicurl()))continue;
    		GameBoxPicProxy.getInstance().synchPic(linkInfo.getExt1(), "m_b", linkInfo.getGameidbytuijian(),false);
    		GameBoxPicProxy.getInstance().synchPic(linkInfo.getPicurl(), "m_p", linkInfo.getGameidbytuijian(),false);    		
    	}
    	List<Games> gameslist = GameCache.getInstance().getAllGames();
    	for(Games games:gameslist){
    		if(StringTools.isEmpty(games.getPicUrl()))continue;
    		GameBoxPicProxy.getInstance().synchPic(games.getPicUrl(), "b", games.getGameId(),false);
    	}
    }
    
    public String add() {
        this.authenticateAdd();//添加权限

        LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
        if (linkInfo == null) {
            logger.debug("添加内容为空");
            alertJS("添加失败，原因：编辑内容为空");
            return "";
        }

        try{
        	checkGameUnique(linkInfo,false);
            UserInfo user=this.currentUserInfo();
            linkInfo.setInputby(user.getTrueName());
            linkInfo.setInputtime(sdf.format(new Date()));
            if(linkInfo.getDisplayorder()==null||"".equals(linkInfo.getDisplayorder())){
                linkInfo.setDisplayorder(sdf1.format(new Date()));
            }
            LinkLocation loc=FacadeFactory.INSTANCE.getLinkLocationBo().find(linkInfo.getLinklocid());
            linkInfo.setLinklocgroupid(loc.getLinktype());
            linkInfo.setLinkcontents(PicUtil.replacePicUrlAndSyn(linkInfo.getLinkcontents()));
            linkInfo.setValiddatetime(checkTime(linkInfo.getValiddatetime()));
            linkInfo.setInvaliddatetime(checkTime(linkInfo.getInvaliddatetime()));
            
            FacadeFactory.INSTANCE.getLinkInfoBo().add(linkInfo);
            makeIndexPageToBox(linkInfo.getLinklocid());
            copyToOtherGames(linkInfo);//同步数据到其他游戏
            
            synchPicToBox(linkInfo);//同步图片给盒子
            sendUpdateBroadCast(linkInfo);//发送盒子后台更新通知
        }catch(Exception e){
            logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
        }
        return "";
    }
    
    
    private void synchPicToBox(LinkInfo linkInfo){
    	String type = this.findParameter("synchType");
    	if(StringTools.isEmpty(type)||linkInfo==null)return;
    	if("s".equals(type)){//游戏logo
    		if(StringTools.isEmpty(linkInfo.getGameid()))return;
    		GameBoxPicProxy.getInstance().synchPic(linkInfo.getPicurl(), type, linkInfo.getGameid(),true);
    	}else if("m".equals(type)){//牛友推荐 背景图m_b 人物图 m_p
    		if(StringTools.isEmpty(linkInfo.getGameidbytuijian()))return;
    		GameBoxPicProxy.getInstance().synchPic(linkInfo.getExt1(), "m_b", linkInfo.getGameidbytuijian(),false);
    		GameBoxPicProxy.getInstance().synchPic(linkInfo.getPicurl(), "m_p", linkInfo.getGameidbytuijian(),false);    		
    	}   	
    }
    
    private void copyToOtherGames(LinkInfo linkInfo){
		String games=this.findParameter("gameids");
		if(StringTools.isEmpty(games)){
			return;
		}
		String[] gameArray=games.split("\\|");
		if(gameArray==null||gameArray.length==0){
			return;
		}
		for(String gameId:gameArray){
			if(gameId==null||"".equals(gameId)){
				continue;
			}
			linkInfo.setGameid(gameId);
			FacadeFactory.INSTANCE.getLinkInfoBo().add(linkInfo);
		}
	}
    
    public String addMore(){
    	this.authenticateAdd();//添加权限
		try{
			LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
		    UserInfo user=this.currentUserInfo();
		    linkInfo.setInputby(user.getTrueName());
		    linkInfo.setInputtime(sdf.format(new Date()));
		    String[] linkLocId=linkInfo.getLinklocid().split("\\|");
		    for(int i=0;i<linkLocId.length;i++){
		    	linkInfo.setLinklocid(linkLocId[i]);
		    	FacadeFactory.INSTANCE.getLinkInfoBo().add(linkInfo);
		    }
		}catch(Exception e){
			logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
		}
    	return "";
    }
    public String addmoregame(){
    	this.authenticateAdd();//添加权限
		try{
			LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
		    UserInfo user=this.currentUserInfo();
		    linkInfo.setInputby(user.getTrueName());
		    linkInfo.setInputtime(sdf.format(new Date()));
		    String[] gameIdArr=linkInfo.getGameid().split("\\|");
		    for(int i=0;i<gameIdArr.length;i++){
		    	if(gameIdArr[i]==null||"".equals(gameIdArr[i])){
		    		continue;
		    	}
		    	linkInfo.setGameid(gameIdArr[i]);
		    	FacadeFactory.INSTANCE.getLinkInfoBo().add(linkInfo);
		    }
		}catch(Exception e){
			logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
		}
    	return "";
    }
    /**
     * 获取所有的链接位置
     * @return
     */
    public List<SelectItem> getAllLinklocationList() {
    	Page page=new Page();
    	page.addOrder("linklocid", OrderType.ESC);
        List<LinkLocation> linkLocations = FacadeFactory.INSTANCE.getLinkLocationBo().find(new LinkLocation(),page);
        List<SelectItem> tempList = new ArrayList<SelectItem>();
        for (LinkLocation linkLocation : linkLocations) {
            SelectItem si = new SelectItem();
            si.setLabel(linkLocation.getLinklocname());
            si.setValue(linkLocation.getLinklocid());
            tempList.add(si);
        }
        return tempList;
    }


    public Map<Boolean, String> getStatusMap() {
        Map<Boolean, String> statusMap = new HashMap<Boolean, String>();

        statusMap.put(Boolean.TRUE, "是");
        statusMap.put(Boolean.FALSE, "否");
        return statusMap;
    }
    public Map<String, String> getStatusStrMap() {
        Map<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("true", "是");
        statusMap.put("false", "否");
        return statusMap;
    }
    private String checkTime(String time){
        try{
            if(time==null||"".equals(time)){
                return "";
            }
            Date d=sdf.parse(time);
            return sdf.format(d);
        }catch(Exception e){
            throw new RuntimeException("时间格式不正确，格式：yyyy-MM-dd hh:mm:ss");


     }
   }
    /**
     * 检验数据的唯一性
     * @param linkinfo
     * @return
     */
   private void checkGameUnique(LinkInfo linkinfo,boolean isUpdate){
	   LinkLocation loc=FacadeFactory.INSTANCE.getLinkLocationBo().find(linkinfo.getLinklocid());
	   if(!"1".equals(loc.getExt3())){
		   //不需要唯一性检查
		   return;
	   }
	   LinkInfo qli=new LinkInfo();
	   qli.setGameidbytuijian(linkinfo.getGameidbytuijian());
	   qli.setLinklocid(linkinfo.getLinklocid());
	   List<LinkInfo> list=FacadeFactory.INSTANCE.getLinkInfoBo().find(qli);
	   if(isUpdate){
		   //更新验证
		   if(list==null||list.size()==0){
			   return;
		   }else if(list.size()>1){
			   throw new RuntimeException("游戏id："+linkinfo.getGameidbytuijian()+"已插入");
		   }else{
			   LinkInfo templi=list.get(0);
			   if(!templi.getLinkid().equals(linkinfo.getLinkid())){
				   throw new RuntimeException("游戏id："+linkinfo.getGameidbytuijian()+"已插入");
			   }
		   }
	   }else{
		   //插入验证
		   if(list!=null&&list.size()>0){
			   throw new RuntimeException("游戏id："+linkinfo.getGameidbytuijian()+"已插入");
		   }
	   }
   }
   public String delete() {
       this.authenticateRun();
       String paramseqids = findParameter("delseqids");
       String[] params = paramseqids.split(",");
       try{
           for(String id : params) {

               FacadeFactory.INSTANCE.getLinkInfoBo().delete(Integer.valueOf(id));
           }
           alertJS("删除成功!");
       } catch (Exception e) {
           logger.error("删除失败", e);
           alertJS("删除失败，原因：" + e);
       }
       return "";
   }
   public String getQueryDefaultLinkinfoList(){
	   logger.info("开始默认查询");
	   String linklocid = findParameter("linklocid");
	   String linkgroupid=findParameter("linkgroupid");
	   String isDefaultGameId=findParameter("isDefaultGameId");
	   String isDefaultLinkLocId=findParameter("isDefaultLinkLocId");
	   String gameId="";
	   if("true".equals(isDefaultGameId)){
		   gameId=getSessionValue("gameId");
		   logger.debug("sessongameid:"+gameId);
		   if(gameId==null||"".equals(gameId)){
			   List<Games> gList=GameCache.getInstance().getAllGames();
			   gameId=(gList==null||gList.size()==0)?"":gList.get(0).getGameId();
		   }
		   addSessionValue("gameId", gameId);
	   }
	   if("true".equals(isDefaultLinkLocId)&&!"".equals(linkgroupid)){
		   linklocid=getDefaultLinklocid(linkgroupid);
	   }
       LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
       linkInfo.setLinklocid(linklocid);
       linkInfo.setLinklocgroupid(linkgroupid);
       linkInfo.setGameid(gameId);
       PagedFliper pagedFliper=this.getFliper();
       int count=FacadeFactory.INSTANCE.getLinkInfoBo().count(linkInfo);
       pagedFliper.setRecordCount(count);
       List<LinkInfo> list=new ArrayList<LinkInfo>();
       if(count>0){
           Page page=new Page();
           page.setPageNo(pagedFliper.getPageNo());
           page.setPageSize(pagedFliper.getPageSize());
           page.addOrder("displaysort", OrderType.DESC);
           page.addOrder("validdatetime", OrderType.DESC);
    	   list=FacadeFactory.INSTANCE.getLinkInfoBo().find(linkInfo, page);
       }
       Sheet<LinkInfo> sheet=new Sheet<LinkInfo>(count, list);
       this.mergePagedDataModel(sheet, pagedFliper);
	   return "";
   }
   public String getDefaultLinklocid(String linkgroupid){
	   	LinkLocation linklocation=new LinkLocation();
	   	linklocation.setLinktype(linkgroupid);
	   	List<LinkLocation> lllist=FacadeFactory.INSTANCE.getLinkLocationBo().find(linklocation);
	   	LinkLocation ll1=new LinkLocation();
	   	if(lllist.size()>0){
	   		ll1=lllist.get(0);
	   	}
	   	return ll1.getLinklocid();
   }
   public Map<String,String> getLinkLocMap(){
	   List<LinkLocation> list=FacadeFactory.INSTANCE.getLinkLocationBo().find(new LinkLocation());
	   Map<String,String> result=new HashMap<String,String>();
	   for(LinkLocation ll:list){
		   result.put(ll.getLinklocid(), ll.getLinklocname());
	   }
	   return result;
   }

    private void sendUpdateBroadCast(LinkInfo linkInfo){
        try {
            if(linkInfo.getLinklocid().equals("694") || linkInfo.getLinklocid().equals("695")){
                BroadCastClient.broadCastMobileOfficialUpdateMsg();
            }
        } catch (Exception e) {
            logger.error("sendUpdateBroadCast Exception",e);
        }
    }
}
