package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.PromoterProfitRate;
import com.xunlei.niux.manager.web.model.vo.LeagueRateInfo;

public class LeagueRateInfoManagedBean extends BaseManagedBean{

	public String add(){
		LeagueRateInfo leagueRateInfo=findBean(LeagueRateInfo.class,"leaguerateinfo");
		List<PromoterProfitRate> profitList=new ArrayList<PromoterProfitRate>();
		String[] profitrate=leagueRateInfo.getProfitRate().split("\\|");
		for(String rates:profitrate){
			if(rates==null||"".equals(rates)){
				continue;
			}
			String[] rarray=rates.split(",");
			PromoterProfitRate prr=new PromoterProfitRate();
			prr.setPromoterAccount(leagueRateInfo.getPromoterAccount());
			prr.setIsIncrementArea(leagueRateInfo.getIsProfitIncreaseArea());
			prr.setRateType("profit");
			prr.setMinMoney(Integer.valueOf(rarray[0]));
			if(rarray[1]!=null&&!"".equals(rarray[1])){
				prr.setMaxMoney(Integer.valueOf(rarray[1]));
			}else{
				prr.setMaxMoney(null);
			}
			prr.setRate(Double.valueOf(rarray[2]));
			profitList.add(prr);
		}
		try{
			FacadeFactory.INSTANCE.getPromoterProfitSo().add(profitList);
		}catch(Exception e){
			mergeJsmessage("分红利率异常,原因："+e.getMessage());
			return "";
		}
		
		List<PromoterProfitRate> taxList=new ArrayList<PromoterProfitRate>();
		String[] taxrate=leagueRateInfo.getTaxRate().split("\\|");
		for(String rates:taxrate){
			if(rates==null||"".equals(rates)){
				continue;
			}
			String[] rarray=rates.split(",");
			PromoterProfitRate prr=new PromoterProfitRate();
			prr.setPromoterAccount(leagueRateInfo.getPromoterAccount());
			prr.setIsIncrementArea(leagueRateInfo.getIsTaxIncreaseArea());
			prr.setRateType("tax");
			prr.setMinMoney(Integer.valueOf(rarray[0]));
			if(rarray[1]!=null&&!"".equals(rarray[1])){
				prr.setMaxMoney(Integer.valueOf(rarray[1]));
			}
			prr.setRate(Double.valueOf(rarray[2]));
			taxList.add(prr);
		}
		try{
			FacadeFactory.INSTANCE.getPromoterProfitSo().add(taxList);
		}catch(Exception e){
			mergeJsmessage("税收利率异常,原因："+e.getMessage());
			return "";
		}
		return "";
	}
	public String getQueryLeagueRate(){
		String promoterAccount=this.findParameter("promoterAccount");
		LeagueRateInfo leagueRateInfo=findBean(LeagueRateInfo.class,"leaguerateinfo");
		leagueRateInfo.setPromoterAccount(promoterAccount);
		PromoterProfitRate ppr=new PromoterProfitRate();
		ppr.setPromoterAccount(promoterAccount);
		ppr.setRateType("profit");
		Page page=new Page();
		page.addOrder("seqId", OrderType.ESC);
		List<PromoterProfitRate> profitList=FacadeFactory.INSTANCE.getPromoterProfitSo().finds(ppr,page);
		profitList=(profitList==null)?new ArrayList<PromoterProfitRate>():profitList;
		String profitStr="";
		for(PromoterProfitRate p1:profitList){
			leagueRateInfo.setIsProfitIncreaseArea(p1.getIsIncrementArea());
			String maxMoney=p1.getMaxMoney()==null||p1.getMaxMoney()==0?"":String.valueOf(p1.getMaxMoney());
			profitStr=profitStr+"|"+p1.getMinMoney()+","+maxMoney+","+p1.getRate();
		}
		leagueRateInfo.setProfitRate(profitStr);
		ppr.setRateType("tax");
		List<PromoterProfitRate> taxList=FacadeFactory.INSTANCE.getPromoterProfitSo().finds(ppr, page);
		taxList=(taxList==null)?new ArrayList<PromoterProfitRate>():taxList;
		String taxStr="";
		for(PromoterProfitRate p1:taxList){
			leagueRateInfo.setIsTaxIncreaseArea(p1.getIsIncrementArea());
			String maxMoney=p1.getMaxMoney()==null||p1.getMaxMoney()==0?"":String.valueOf(p1.getMaxMoney());
			taxStr=taxStr+"|"+p1.getMinMoney()+","+maxMoney+","+p1.getRate();
		}
		leagueRateInfo.setTaxRate(taxStr);
		return "";
	}
}
