package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LaXinYe;
import com.xunlei.niux.manager.web.util.PageUtil;

public class LaXinYeManagedBean extends BaseManagedBean{
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public String getQueryLaXinYeList(){
		LaXinYe query=findBean(LaXinYe.class, "laxinye");
        String status = findParameter("validStatus");
        if(status.equals("-1")){
            query.setIsValid(null);
        }else if(status.equals("0")){
            query.setIsValid(false);
        }else if(status.equals("1")){
            query.setIsValid(true);
        }
		PagedFliper pagedFliper = this.getFliper();
		List<LaXinYe> pagelist=new ArrayList<LaXinYe>();
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page =PageUtil.formatPage(pagedFliper, "laXinYeId","desc");
			pagelist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LaXinYe> sheet=new Sheet<LaXinYe>(count,pagelist);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String add(){
		LaXinYe laXinYe=findBean(LaXinYe.class, "laxinye");
		UserInfo user=this.currentUserInfo();
		laXinYe.setInputBy(user.getTrueName());
		laXinYe.setInputTime(sdf.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(laXinYe);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	public String edit(){
		LaXinYe laXinYe=findBean(LaXinYe.class, "laxinye");
		UserInfo user=this.currentUserInfo();
		laXinYe.setEditBy(user.getTrueName());
		laXinYe.setEditTime(sdf.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(laXinYe);
		}catch(Exception e){
			logger.error("编辑失败", e);
			mergeJsmessage("编辑失败，原因：" + e.getMessage());
		}
		return "";
	}
}
