package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.InterfaceManBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.InterfaceMan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

public class InterfaceManManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(InterfaceManManagedBean.class.getName());
    private InterfaceManBo interfaceManBo;
    private int rownum = 0;
    public static Map<Long, String> personMap;
    private static List<SelectItem> personList;
    private static List<SelectItem> salePersonList;
    private static List<SelectItem> daoJuPersonList;
    private static final int CTYPE = 4;
    private static final int ITYPE = 8;

    public InterfaceManManagedBean()
    {
        this.interfaceManBo = FacadeFactory.INSTANCE.getInterfaceManBo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public Map<Long, String> getPersonMap() {
        if (personMap == null) {
            initData(4);
        }
        return personMap;
    }

    private void initData(int type) {
        List bplist = getInterfaceMans(type);
        if (type == 4)
            initPersonMap(bplist);
        initPersonList(bplist, type);
    }
    public void initPersonMap(List<InterfaceMan> bplist) {
        Map tempMap = new HashMap();
        if (bplist != null) {
            for (InterfaceMan type : bplist) {
                tempMap.put(type.getSeqid(), type.getInterfaceName());
            }
        }
        personMap = tempMap;
    }

    public List<SelectItem> getDaoJuPersonList() {
        if (daoJuPersonList == null) {
            initData(8);
        }
        return daoJuPersonList;
    }

    public List<SelectItem> getPersonList() {
        if (personList == null) {
            initData(4);
        }
        return personList;
    }

    public List<SelectItem> getSalePersonList() {
        if (salePersonList == null) {
            initData(4);
        }
        return salePersonList;
    }

    private List<InterfaceMan> getInterfaceMans(int type) {
        InterfaceMan query = new InterfaceMan();
        query.setType(type);
        Page mypage = new Page();
        mypage.addOrder("inputtime", OrderType.DESC);
        List bplist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, mypage);
        return bplist;
    }

    private void initPersonList(List<InterfaceMan> bplist, int ttype)
    {
        if (ttype == 4) {
            InterfaceMan type;
            List siList = new ArrayList();
            List iList = new ArrayList();
            for (Iterator localIterator = bplist.iterator(); localIterator.hasNext(); ) { type = (InterfaceMan)localIterator.next();
                siList.add(new SelectItem(type.getSeqid(), type.getInterfaceName()));
                iList.add(new SelectItem(type.getInterfaceName(), type.getInterfaceName()));
            }
            personList = siList;
            salePersonList = iList;
        } else if (ttype == 8) {
            List iList = new ArrayList();
            for (InterfaceMan type : bplist) {
                iList.add(new SelectItem(type.getInterfaceEmail(), type.getInterfaceName()));
            }
            daoJuPersonList = iList;
        }
    }

    public int getRownum()
    {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryInterfaceManList()
    {
        logger.info("开始接口人查询");
        authenticateRun();
        int type = findParamInt("type");
        InterfaceMan interfaceMan = (InterfaceMan)findBean(InterfaceMan.class, "interfaceman");
        interfaceMan.setType(type);
        PagedFliper pagedFliper = getFliper();
        int count = this.interfaceManBo.count(interfaceMan);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputtime", OrderType.DESC);
            list = this.interfaceManBo.find(interfaceMan, page.getPageNo(), page.getPageSize());
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public String add()
    {
        logger.info("开始接口人信息添加");
        authenticateAdd();
        int type = findParamInt("type2");
        InterfaceMan interfaceMan = (InterfaceMan)findBean(InterfaceMan.class, "interfaceman");
        try {
            if (interfaceMan == null) {
                logger.info("接口人信息为空");
                throw new XLRuntimeException("接口人信息为空");
            }
            interfaceMan.setType(type);
            interfaceMan.setInputtime(now());
            interfaceMan.setInputby(currentUserLogo());
            this.interfaceManBo.insert(interfaceMan);
            if ((interfaceMan.getType() == 4) || (interfaceMan.getType() == 8))
                initData(interfaceMan.getType());
        }
        catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String edit()
    {
        logger.info("开始接口人信息修改");
        authenticateEdit();
        InterfaceMan interfaceMan = (InterfaceMan)findBean(InterfaceMan.class, "interfaceman");
        try {
            if (interfaceMan == null) {
                logger.info("接口人信息为空");
                throw new XLRuntimeException("接口人信息为空");
            }
            interfaceMan.setEdittime(now());
            interfaceMan.setEditby(currentUserLogo());
            this.interfaceManBo.update(interfaceMan);
            if ((interfaceMan.getType() == 4) || (interfaceMan.getType() == 8))
                initData(interfaceMan.getType());
        }
        catch (Exception e) {
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete()
    {
        logger.info("开始接口人信息删除");
        authenticateDel();
        String delseqids = findParameter("delseqids");
        try {
            String[] ids = delseqids.split(",");
            for (String id : ids)
                this.interfaceManBo.deleteById(new Long(id).longValue());
        } catch (Exception e) {
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}