package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.businesss.IncomeBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.*;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.MoneyUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.util.StringTools;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_INCOME)
public class IncomeManagedBean  extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(IncomeManagedBean.class);
    private static String oldgameids = EnvPropertyUtil.loadProperty("niux", "oldgameids");
    
    private static Map<Integer,String> compareMap;
    
    static{
    	if(compareMap==null){
    		compareMap = new HashMap<Integer,String>();
    		compareMap.put(1, "深圳市迅雷网络技术有限公司");
    		compareMap.put(2, "深圳市迅雷游戏开发有限公司");
    	}    	
    }

    private String year;

    private String month;

    private Income totalIncome;

    public Income getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(Income totalIncome) {
        this.totalIncome = totalIncome;
    }

    public String getYear() {
        return year !=null ? year : getNowYear();
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }
    
    /**
     * 获得公司名
     * @param gameid
     * @return
     */
    private String getCompareName(String gameid){
    	if(StringTools.isEmpty(oldgameids))return compareMap.get(1);
    	if(oldgameids.indexOf(",")==-1){
    		if(oldgameids.trim().equals(gameid)){
    			return compareMap.get(2);
    		}else{
    			return compareMap.get(1);
    		}
    	}else{
    		String gameids [] = oldgameids.split(",");
    		for(String mygameid:gameids){
    			if(StringTools.isEmpty(mygameid))continue;
    			if(mygameid.trim().equals(gameid)){
    				return compareMap.get(2);
    			}
    		}
    		return compareMap.get(1);
    	}
    }

    public String getQueryList() {
        this.authenticateRun();//验证运行权限
//        checkData();

        Income income = getInItIncome();

        final IncomeBo incomeBo = FacadeFactory.INSTANCE.getIncomeBo();
        int count = incomeBo.count(income);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<Income> list = new ArrayList<Income>();
        if (count > 0) {
            list = incomeBo.find(income, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }

        BigDecimal total = BigDecimal.ZERO;
        BigDecimal secondprincipal = BigDecimal.ZERO;
        BigDecimal firstprincipal = BigDecimal.ZERO;
        BigDecimal money = BigDecimal.ZERO;
        for(Income temp : list) {
            total = total.add(temp.getTotal());
            secondprincipal = secondprincipal.add(temp.getSecondprincipal() != null ? temp.getSecondprincipal() : BigDecimal.ZERO);
            firstprincipal = firstprincipal.add(temp.getFirstprincipal() != null ? temp.getFirstprincipal(): BigDecimal.ZERO);
            money = money.add(temp.getMoney() != null ? temp.getMoney() : BigDecimal.ZERO);
        }

        totalIncome = new Income();
        totalIncome.setTotal(total);
        totalIncome.setSecondprincipal(secondprincipal);
        totalIncome.setFirstprincipal(firstprincipal);
        totalIncome.setMoney(money);


        Sheet<Income> sheet = new Sheet<Income>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    private Income getInItIncome() {
        Income income = findBean(Income.class, "income");
        if(income.getGameid() == null) {
            income.setGameid("000000");
        }

        if(this.month == null || "".equals(this.month)) {
            income.setFromMonth(this.getYear() +"-01");
            income.setToMonth(getNextYaer() + "-01");
        } else {
            income.setIncomemonth(this.year + "-" + this.month);
        }
        return income;
    }

    /**
     * 导出
     */
    public void export() {
        //checkData();

        HttpServletResponse response = (HttpServletResponse) FacesContext.getCurrentInstance().getExternalContext()
                .getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");

        Income income = getInItIncome();
        String gameId = income.getGameid();

        String gameName;
        if("000000".equals(gameId)) {
            gameName = "全部游戏";
        } else {
            gameName = GameCache.getInstance().getGameIdNameMap().get(gameId);
        }

        String fileName = gameName + "收益结算单";
        try {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        } catch (UnsupportedEncodingException e) {
        }

        response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
        InputStream inp = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream("/excel/income.xls");

        try {
            Workbook wb = WorkbookFactory.create(inp);
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);


            List<Income> list = FacadeFactory.INSTANCE.getIncomeBo().find(income, 0, 0);

            int rowNum = 2;
            Row defaultRow = sheet.getRow(rowNum);

            if(list.size() > 0) {
                Income income1 = list.get(0);
                defaultRow.getCell(0).setCellValue(income1.getIncomemonth());
                defaultRow.getCell(1).setCellValue(income1.getTotal().doubleValue());
                defaultRow.getCell(2).setCellValue(income1.getSecondprincipal().doubleValue());
                defaultRow.getCell(3).setCellValue(income1.getFirstprincipal().doubleValue());
                defaultRow.getCell(4).setCellValue(income1.getMoney().doubleValue());

                for(int i = 1; i < list.size(); i++) {
                    Row row = sheet.createRow(i + rowNum);

                    Income temp = list.get(i);
                    copyStyle(row, defaultRow, 0).setCellValue(temp.getIncomemonth());
                    copyStyle(row, defaultRow, 1).setCellValue(temp.getTotal().doubleValue());
                    copyStyle(row, defaultRow, 2).setCellValue(temp.getSecondprincipal().doubleValue());
                    copyStyle(row, defaultRow, 3).setCellValue(temp.getFirstprincipal().doubleValue());
                    copyStyle(row, defaultRow, 4).setCellValue(temp.getMoney().doubleValue());
                }

            }

            OutputStream os  = response.getOutputStream();
            wb.write(os);
        } catch (Exception e) {
            logger.error("导出excel出错", e);
            alertJS("导出excel出错,原因:" + e.getMessage());
        }

        FacesContext.getCurrentInstance().responseComplete();
    }

    /**
     * 对账账单
     */
    public void exportCheck() {
        HttpServletResponse response = (HttpServletResponse) FacesContext.getCurrentInstance().getExternalContext()
                .getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");

        String seqid = findParameter("seqid");
        IncomeBo incomeBo =  FacadeFactory.INSTANCE.getIncomeBo();
        Income income = incomeBo.findById(Integer.parseInt(seqid));
        String gameName = GameCache.getInstance().getGameIdNameMap().get(income.getGameid());

        String month = income.getIncomemonth().substring(0, 4) + "年" + income.getIncomemonth().substring(5) + "月";
        String fileName = gameName + month + "对账单";
        try {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        } catch (UnsupportedEncodingException e) {
        }

        response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
        InputStream inp = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream("/excel/check.xls");

        try {
            Workbook wb = WorkbookFactory.create(inp);

            wb.setSheetName(0, month + "结算确认函");
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);

            //公司名
            CorporationInfo cpTemp = new CorporationInfo();
            cpTemp.setGameid(income.getGameid());
            final List<CorporationInfo> corporationInfos = FacadeFactory.INSTANCE.getCorporationInfoBo().find(cpTemp, 1, 1);
            CorporationInfo cpInfo = new CorporationInfo();
            if (corporationInfos.size() > 0) {
                cpInfo = corporationInfos.get(0);
            }

            String cpName = cpInfo.getSalecompany();
            String compareName = getCompareName(income.getGameid());
            System.out.println("compareName:"+compareName);
            sheet.getRow(5).getCell(2).setCellValue(compareName);
            sheet.getRow(5).getCell(4).setCellValue(cpName);
            sheet.getRow(6).getCell(7).setCellValue(cpName);
           
            
            //月份
            sheet.getRow(7).getCell(0).setCellValue(month);

            //游戏名称
            sheet.getRow(7).getCell(2).setCellValue(gameName);

            //总收益
            sheet.getRow(7).getCell(4).setCellValue(income.getTotal().doubleValue());
            //迅雷收益
            sheet.getRow(7).getCell(5).setCellValue(income.getSecondprincipal().doubleValue());

            //合作方收益
            sheet.getRow(7).getCell(7).setCellValue(income.getFirstprincipal().doubleValue());

            //支付金额
            sheet.getRow(8).getCell(1).setCellValue(income.getMoney().doubleValue());
            sheet.getRow(8).getCell(5).setCellValue(MoneyUtil.toChinese(income.getMoney().toPlainString()));

            //测试账号
            TestIncome testIncome = new TestIncome();
            testIncome.setGameid(income.getGameid());
            testIncome.setIncomemonth(income.getIncomemonth());
            List<TestIncome> testIncomeList = FacadeFactory.INSTANCE.getTestIncomeBo().find(testIncome, 0, 0);

            if (testIncomeList.size() > 0) {
                TestIncome temp = testIncomeList.get(0);
                sheet.getRow(9).getCell(3).setCellValue(temp.getMoney().longValue());
            }

            /*for(int i=0 ;i < testIncomeList.size(); i++) {
                TestIncome temp = testIncomeList.get(i);

                if(i <= 1) {
                    sheet.getRow(9 + i).getCell(1).setCellValue(getTestAcountNameById(temp.getTestacount(), income.getGameid()));
                    sheet.getRow(9 + i).getCell(3).setCellValue(temp.getMoney().longValue());
                } else {
                   *//* Row targetRow = sheet.createRow(9 + i);
                    Row defaultRow = sheet.getRow(9);

                    copyStyle(targetRow, defaultRow, 0).setCellValue("测试账号" + i + 1);
                    copyStyle(targetRow, defaultRow, 1).setCellValue(temp.getTestacount());
                    copyStyle(targetRow, defaultRow, 2).setCellValue("测试账号金额" + i + 1);
                    copyStyle(targetRow, defaultRow, 3).setCellValue(temp.getMoney().longValue());*//*
                }
            }*/

            //分成方式
            sheet.getRow(9).getCell(5).setCellValue(getBalancedesc(income.getGameid()));

            //甲方
            sheet.getRow(12).getCell(1).setCellValue(compareName);
            
            //乙方
            sheet.getRow(12).getCell(5).setCellValue(cpName);
            
         

            //开户银行
            sheet.getRow(13).getCell(5).setCellValue(cpInfo.getBankname());

            //银行账号
            sheet.getRow(14).getCell(5).setCellValue(cpInfo.getBankaccount());

            OutputStream os  = response.getOutputStream();
            wb.write(os);
        } catch (Exception e) {
            logger.error("导出excel出错", e);
            alertJS("导出excel出错,原因:" + e.getMessage());
        }

        FacesContext.getCurrentInstance().responseComplete();
    }

    /**
     * 获取分成信息
     * @param gameid
     * @return
     */
    private String getBalancedesc(String gameid) {
        IntoSystem intoSystem = new IntoSystem();
        intoSystem.setGameid(gameid);
        List<IntoSystem> list = FacadeFactory.INSTANCE.getIntoSystemBo().find(intoSystem, 0, 0);

        if(list.size() > 0) {
            IntoSystem one = list.get(0);

            if(one.getSystype().intValue()==0) {
                return "分成比例:迅雷方分成" + one.getIntoratio() + "%";
            } else if(!one.getNoregulartype()) {
                StringBuilder desc = new StringBuilder("不固定类型:按区间值 ");
                for (IntoSystem temp : list) {
                    desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                            .append(", 迅雷方分成 : ")
                            .append(temp.getIntoratio()).append("% ;");
                }

                return desc.toString();
            } else {
                StringBuilder desc = new StringBuilder("不固定类型:按区间增量值 ");

                int i = 0;
                for (IntoSystem temp : list) {
                    desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                            .append(", 迅雷方分成 : ( 收益 - ").append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                            .append("% ")
                            .append(descNoregulartype(list, i)).append(";");

                    i++;
                }

                return desc.toString();
            }
        }

        return null;
    }

    private long changNum(int money) {
        return money * 10000L ;
    }

    private String descNoregulartype(List<IntoSystem> list, int i) {
        StringBuilder builder = new StringBuilder(" ");

        if (i == 0) {
            return builder.toString();
        } else {
            final IntoSystem temp = list.get(i - 1);
            builder.append(" + (").append(changNum(temp.getEndmoney())).append(" - ")
                    .append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                    .append("% ");

            return builder.append(descNoregulartype(list, i - 1)).toString();
        }
    }

    private String getTestAcountNameById(String id, String gameid) {
        TestAcount testAcount = new TestAcount();
        testAcount.setGameid(gameid);
        testAcount.setUserid(id);

        List<TestAcount> list = FacadeFactory.INSTANCE.getTestAcountBo().find(testAcount, 1, 1);
        if(list.size() > 0) {
            return  list.get(0).getCustomerno();
        } else {
            return null;
        }
    }

    private Cell copyStyle(Row targetRow, Row defaultRow, int num) {
        Cell cell = targetRow.createCell(num);
        cell.setCellStyle(defaultRow.getCell(num).getCellStyle());

        return cell;
    }

    private String getNowYear() {
        return DateUtil.formatNow("yyyy");
    }

    private String getNextYaer() {
        return DateUtil.format(DateUtil.nextYear(), "yyyy");
    }

    private void checkData(){
        String findUnllSql = "select * from income where gameid not like '05%' and gameid not in ('000150','000149','000148') and secondprincipal is null";

        List<Income> list =  FacadeFactory.INSTANCE.getIncomeBo().findSql(findUnllSql);

        if(list.size() > 0) {
            for(Income income : list) {
                //计算收益
                countIncome(income);
            }

            //计算全部收益
            countTotalIcome();
        }
    }

    /**
     * 计算全部游戏收益
     */
    private void countTotalIcome() {
        String deleteSql = "delete from income where gameid = 000000";

        IncomeBo incomeBo = FacadeFactory.INSTANCE.getIncomeBo();
        incomeBo.execute(deleteSql, new ArrayList<Object>());

        String insertSql = "insert into income (" +
                "  gameid," +
                "  incomemonth," +
                "  total," +
                "  secondprincipal," +
                "  firstprincipal," +
                "  money" +
                ") " +
                "SELECT " +
                "  '000000'," +
                "  incomemonth," +
                "  SUM(total)," +
                "  SUM(secondprincipal)," +
                "  SUM(firstprincipal)," +
                "  SUM(money) " +
                "FROM" +
                "  income " +
                "GROUP BY incomemonth ";
        incomeBo.execute(insertSql, new ArrayList<Object>());

    }

    private void countIncome(Income income) {
        String gameId = income.getGameid();
        IntoSystem tempIntoSys = new IntoSystem();
        tempIntoSys.setGameid(gameId);

        List<IntoSystem> list =  FacadeFactory.INSTANCE.getIntoSystemBo().find(tempIntoSys, 0, 0);
        if(list.size() > 0) {
            IntoSystem intoSystem = list.get(0);

            //固定分成
            if(intoSystem.getSystype().intValue()==0) {
                Integer ratios = intoSystem.getIntoratio();
                countByRadio(income, ratios);

            } else if(!intoSystem.getNoregulartype()) {
                //固定区间值

                Integer ratios = 0;
                for(IntoSystem temp : list) {
                    long beginMoney = temp.getBeginmoney() * 10000;
                    long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;

                    long nowMoney = income.getTotal().longValue();
                    if(nowMoney > beginMoney && nowMoney<= endMoney) {
                        ratios = temp.getIntoratio();
                        break;
                    }
                }
                countByRadio(income, ratios);
            } else {
                //区间增量
                countByRadioAdd(list, income);
            }

        }
    }

    private void countByRadioAdd(final List<IntoSystem> list, Income income) {
        int num = 0;
        for(IntoSystem temp : list) {
            long beginMoney = temp.getBeginmoney() * 10000;
            long endMoney = temp.getEndmoney() != 0 ? temp.getEndmoney() * 10000 : Long.MAX_VALUE;

            long nowMoney = income.getTotal().longValue();
            if(nowMoney > beginMoney && nowMoney<= endMoney) {
                break;
            }
            num++;
        }


        if (num > list.size() - 1) return;
        IntoSystem temp = (IntoSystem)list.get(num);

        BigDecimal secondprincipal = (income.getTotal().subtract(BigDecimal.valueOf(temp.getBeginmoney() * 10000)))
                .multiply(BigDecimal.valueOf(temp.getIntoratio()))
                .divide(BigDecimal.valueOf(100L));


        if(num > 0) {
            for(int i = num - 1; i >=0; i--) {
                IntoSystem is = list.get(i);

                long beginMoney = is.getBeginmoney() * 10000;
                long endMoney = is.getEndmoney() * 10000;

                long value = (endMoney - beginMoney) * is.getIntoratio() / 100 ;

                secondprincipal = secondprincipal.add(BigDecimal.valueOf(value));
            }
        }

        countFirstprincipal(income, secondprincipal);
        

    }

    private void countByRadio(Income income, Integer ratios) {
        BigDecimal secondprincipal = income.getTotal().multiply(BigDecimal.valueOf(ratios))
                .divide(BigDecimal.valueOf(100L));

        countFirstprincipal(income, secondprincipal);
    }

    private void countFirstprincipal(Income income, BigDecimal secondprincipal) {
        secondprincipal = secondprincipal.setScale(2);

        BigDecimal firstprincipal = income.getTotal().subtract(secondprincipal);

        income.setSecondprincipal(secondprincipal);
        income.setFirstprincipal(firstprincipal);
        income.setMoney(firstprincipal);

        FacadeFactory.INSTANCE.getIncomeBo().update(income);
    }

    public String updateMoney() {
        String money = findParameter("updateValue");
        String seqid = findParameter("seqid");

        BigDecimal newMoney;
        try {
            newMoney = BigDecimal.valueOf(Double.valueOf(money));
            newMoney = newMoney.setScale(2);
        } catch (Exception e) {
            alertJS("不是有效的数字");
            return "";
        }


        try {
            IncomeBo incomeBo =  FacadeFactory.INSTANCE.getIncomeBo();
            Income income = incomeBo.findById(Integer.valueOf(seqid));

            BigDecimal oldMoney = income.getMoney();

            income.setMoney(newMoney);
            incomeBo.update(income);

            //更新总计数据
            Income total = new Income();
            total.setGameid("000000");
            total.setIncomemonth(income.getIncomemonth());

            Income totalTemp = incomeBo.find(total, 0, 0).get(0);
            totalTemp.setMoney(totalTemp.getMoney().subtract(oldMoney).add(newMoney));
            incomeBo.update(totalTemp);

        } catch (Exception e) {
            logger.error("修改出错", e);
            alertJS("修改出错,原因:" + e.getMessage());
        }

        return "";
    }

    public String updateRemark() {
        try {

            String remark = findParameter("updateValue");
            String seqid = findParameter("seqid");

            IncomeBo incomeBo =  FacadeFactory.INSTANCE.getIncomeBo();
            Income income = incomeBo.findById(Integer.valueOf(seqid));
            income.setRemark(remark);

            incomeBo.update(income);

        } catch (Exception e) {
            logger.error("修改出错", e);
            alertJS("修改出错,原因:" + e.getMessage());
        }

        return "";
    }

    public void exportTotal() {
//        checkData();

        HttpServletResponse response = (HttpServletResponse) FacesContext.getCurrentInstance().getExternalContext()
                .getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");

        String fileName = "收益结算单";
        try {
            fileName = new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
        } catch (UnsupportedEncodingException e) {
        }

        response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
        InputStream inp = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream("/excel/totalincome.xls");

        try {
            Workbook wb = WorkbookFactory.create(inp);
            org.apache.poi.ss.usermodel.Sheet sheet = wb.getSheetAt(0);

            Map<String, Object> list = countByYear();

            int rowNum = 2;
            Row defaultRow = sheet.getRow(rowNum);

            if(list.size() > 0) {

            }

            OutputStream os  = response.getOutputStream();
            wb.write(os);
        } catch (Exception e) {
            logger.error("导出excel出错", e);
            alertJS("导出excel出错,原因:" + e.getMessage());
        }

        FacesContext.getCurrentInstance().responseComplete();
    }

    /**
     * 计算年收益
     * @return
     */
    private Map<String, Object> countByYear() {
        String sql = "SELECT  " +
                "  t.gameid gameid, " +
                "  c.salecompany, " +
                "  t.total total, " +
                "  t.secondprincipal secondprincipal, " +
                "  t.firstprincipal firstprincipal  " +
                "FROM " +
                "  (SELECT  " +
                "    gameid, " +
                "    SUM(total) total, " +
                "    SUM(secondprincipal) secondprincipal, " +
                "    SUM(firstprincipal) firstprincipal  " +
                "  FROM " +
                "    income  " +
                "  WHERE gameid != '000000'  " +
                "    AND incomemonth LIKE '2012-%' " +
                "  GROUP BY gameid) t, " +
                "  corporationinfo c  " +
                "WHERE t.gameid = c.gameid ";

        //todo
        return null;
    }
}
