package com.xunlei.niux.manager.web.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.GameXmlMetaBo;
import com.xunlei.niux.data.vipgame.bo.GamesBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.file.Game;
import com.xunlei.niux.manager.web.file.Gameid;
import com.xunlei.niux.manager.web.file.Property;
import com.xunlei.niux.manager.web.file.XmlUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PropertyUtil;


/**
 * 游戏xml文件业务处理类
 * @author lisu
 *  2013-04-16
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEXMLMETA)
public class GameXmlMetaManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GameXmlMetaManagedBean.class.getName());
	private static String LONGNFILEPATH = "loginFile/";
	private static String CUSTOMERSQLFILEPATH = "customerSqlFile/";
	private static String CUSTOMERSERVERSQLFILEPATH = "customerServerSqlFile/";
	private static String COPYURL = "/usr/local/ly_gameservers/ly_authserver/games/";//备份url
	private static final String SYNCPICCOMMOND = "rsync_to_twin08a44_twin08a45_t23124_t23121_twin08a50_twin08a51.sh";//同步xml文件脚本名称
	private static final String BACKCOMMOND = "rsync_from_twin08a44_twin08a50.sh";//从远程服务器取回配置文件
	
	private GameXmlMetaBo gameXmlMetaBo;
	private GamesBo gamesBo;
	private int rownum = 0;
	
	
	public GameXmlMetaManagedBean(){
        super();
		gameXmlMetaBo = FacadeFactory.INSTANCE.getGameXmlMetaBo();
		gamesBo = FacadeFactory.INSTANCE.getGamesBo();
		//初始化行号
//		int pageNo=this.getFliper().getPageNo();
//		int pageSize=this.getFliper().getPageSize();
//		rownum=rownum+(pageNo-1)*pageSize+1;
        rownum = 0;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询游戏xml
	 * @return
	 */
	public String getQueryGameXmlMetaList(){
		logger.info("开始游戏xml查询");
        this.authenticateRun();//验证运行权限
        GameXmlMeta meta = findBean(GameXmlMeta.class, "gamexmlmeta");
        PagedFliper pagedFliper = this.getFliper();
        int count = gameXmlMetaBo.count(meta);
        pagedFliper.setRecordCount(count);
        List<GameXmlMeta> list = new ArrayList<GameXmlMeta>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = gameXmlMetaBo.find(meta, page);
        }
        Sheet<GameXmlMeta> sheet = new Sheet<GameXmlMeta>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增游戏xml
	 * @return
	 */
	public String add(){
		logger.info("开始游戏xml添加");		
		GameXmlMeta meta = this.findBean(GameXmlMeta.class,"gamexmlmeta");
        String one_synchonline = findParameter("one_synchonline");
        boolean synchonlineFlag = Boolean.parseBoolean(one_synchonline);
		try{
            addGameXmlMeta(meta,synchonlineFlag,this.currentUserLogo());
        }catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

    public void addGameXmlMeta(GameXmlMeta meta,boolean synchonlineFlag,String userName) throws Exception{
        if(meta == null){
            logger.info("游戏xml为空");
            throw new XLRuntimeException("游戏xml为空");
        }

        //拉回最新的配置
        //back();

        String gameid = meta.getGameid();
        GameXmlMeta  gxm = new GameXmlMeta();
        gxm.setGameid(gameid);
        List<GameXmlMeta> gxmlist = gameXmlMetaBo.find(gxm, new Page());
        if(gxmlist != null && gxmlist.size()>0){
            logger.info("gameid:"+gameid+"系统中已存在，不能重复添加");
            throw new XLRuntimeException("gameid:"+gameid+"系统中已存在，不能重复添加");
        }
        if(gameid != null && !"".equals(gameid)){
            if(gameid.length()==5){
                meta.setNewgameid("0"+gameid);
            }else{
                meta.setNewgameid(gameid);
            }
        }
        Games games = new Games();
        games.setGameId(meta.getNewgameid().trim());
        List<Games> gameslist = gamesBo.findGames(games, new Page());
        if(gameslist == null || gameslist.size()==0){
            logger.info("gameid:"+gameid+"系统中不存在，请重新录入");
            throw new XLRuntimeException("gameid:"+gameid+"系统中不存在，请重新录入");
        }
        Games gs = gameslist.get(0);

        meta.setInputBy(userName);
        meta.setInputTime(now());
//        if(meta.getRoleurl() != null && !"".equals(meta.getRoleurl())){
//            meta.setIsLevelInterface(true);
//        }else{
//            meta.setIsLevelInterface(false);
//        }
//        if(meta.getOnlineurl() != null && !"".equals(meta.getOnlineurl())){
//            meta.setIsOnlineInterface(true);
//        }else{
//            meta.setIsOnlineInterface(false);
//        }
        gameXmlMetaBo.insert(meta);


        String BasePath = meta.getFilePath().trim();
        /**
         * 生成xml文件
         */
        //生成每个游戏独有的xml文件
        makeGameXml(gs,meta,BasePath+"conf/");
        //每个游戏id生成器的xml文件
        makeGameIdKeyXml(gs,meta,BasePath+"bin/");

        //生成games.xml文件
        makeGamesXml(gs,meta,BasePath+"conf/");
        makeGamesXml(gs,meta,BasePath+"bin/");

        //生成gameUserServer.xml文件
        makeGameUserServerXml(gs,meta,BasePath+"conf/");

        //生成gameUser.xml文件
        makeGameUserXml(gs,meta,BasePath+"classes/");

        /**
         * 生成property文件
         */
        //生成web-game-key.properties.properties文件，如果某游戏的配置信息已经存在，则更新为最新的配置。如果不存在，则追加。
        //PropertyUtil.writeData(meta.getNewgameid()+"_publicKey", meta.getPublicKey(),gs.getGameNo()+".niu.xunlei.com", BasePath+"classes/"+"web-game-key.properties");
        //PropertyUtil.writeData(meta.getNewgameid()+"_privateKey", meta.getPrivateKey(), BasePath+"classes/"+"web-game-key.properties");
        File fil = new File(BasePath+"classes/"+"web-game-key.properties");
        if(!fil.exists()){
            throw new XLRuntimeException(BasePath+"classes/目录下的web-game-key.properties文件不存在");
        }
        PropertyUtil.writerString(meta.getNewgameid(),meta.getNewgameid()+"_publicKey="+meta.getPublicKey(),meta.getNewgameid()+"_privateKey="+meta.getPrivateKey(),"#"+gs.getGameNo()+".niu.xunlei.com",BasePath+"classes/"+"web-game-key.properties");
        //生成games.properties文件
        File file = new File(BasePath+"classes/"+"games.properties");
        if(!file.exists()){
            throw new XLRuntimeException(BasePath+"classes下的games.properties文件不存在");
        }
        String weiduangame = PropertyUtil.readData("weiduangame", BasePath+"classes/"+"games.properties");
        if(meta.getIsWeiDuan()){           
            if(weiduangame == null || "".equals(weiduangame)){
                PropertyUtil.writeData("weiduangame", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }else{
                if(weiduangame.indexOf(meta.getNewgameid())==-1)
                    PropertyUtil.writeData("weiduangame", weiduangame+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }
        }else{
			if(!StringTools.isEmpty(weiduangame)){
		     	if(weiduangame.indexOf(","+meta.getNewgameid())!=-1){
		     		weiduangame = weiduangame.replace(","+meta.getNewgameid(), "");
		     	}
		     	if(weiduangame.indexOf(meta.getNewgameid())!=-1){
		     		weiduangame = weiduangame.replace(meta.getNewgameid(), "");
		     	}
		     	PropertyUtil.writeData("weiduangame", weiduangame, BasePath+"classes/"+"games.properties");
		}
	}		
        String online_of_niux_gameids = PropertyUtil.readData("online_of_niux_gameids", BasePath+"classes/"+"games.properties");
        if(meta.getIsOnlineInterface()){           
            if(online_of_niux_gameids == null || "".equals(online_of_niux_gameids)){
                PropertyUtil.writeData("online_of_niux_gameids", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }else{
                if(online_of_niux_gameids.indexOf(meta.getNewgameid())==-1)
                    PropertyUtil.writeData("online_of_niux_gameids", online_of_niux_gameids+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }
        }else{
			if(!StringTools.isEmpty(online_of_niux_gameids)){
		     	if(online_of_niux_gameids.indexOf(","+meta.getNewgameid())!=-1){
		     		online_of_niux_gameids = online_of_niux_gameids.replace(","+meta.getNewgameid(), "");
		     	}
		     	if(online_of_niux_gameids.indexOf(meta.getNewgameid())!=-1){
		     		online_of_niux_gameids = online_of_niux_gameids.replace(meta.getNewgameid(), "");
		     	}
		     	 PropertyUtil.writeData("online_of_niux_gameids", online_of_niux_gameids, BasePath+"classes/"+"games.properties");
		}
	}
        String level_of_niux_gameids = PropertyUtil.readData("level_of_niux_gameids", BasePath+"classes/"+"games.properties");
        if(meta.getIsLevelInterface()){            
            if(level_of_niux_gameids == null || "".equals(level_of_niux_gameids)){
                PropertyUtil.writeData("level_of_niux_gameids", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }else{
                if(level_of_niux_gameids.indexOf(meta.getNewgameid())==-1)
                    PropertyUtil.writeData("level_of_niux_gameids", level_of_niux_gameids+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }
        }else{
			if(!StringTools.isEmpty(level_of_niux_gameids)){
		     	if(level_of_niux_gameids.indexOf(","+meta.getNewgameid())!=-1){
		     		level_of_niux_gameids = level_of_niux_gameids.replace(","+meta.getNewgameid(), "");
		     	}
		     	if(level_of_niux_gameids.indexOf(meta.getNewgameid())!=-1){
		     		level_of_niux_gameids = level_of_niux_gameids.replace(meta.getNewgameid(), "");
		     	}
		     	PropertyUtil.writeData("level_of_niux_gameids", level_of_niux_gameids, BasePath+"classes/"+"games.properties");
		    }
			
		}
        
        String rank_of_niux_gameids = PropertyUtil.readData("rank_of_niux_gameids", BasePath+"classes/"+"games.properties");
        if(meta.getIsRank()){//如果配置了排行榜           
            if(rank_of_niux_gameids == null || "".equals(rank_of_niux_gameids)){
                PropertyUtil.writeData("rank_of_niux_gameids", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }else{
                if(rank_of_niux_gameids.indexOf(meta.getNewgameid())==-1)
                    PropertyUtil.writeData("rank_of_niux_gameids", rank_of_niux_gameids+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
            }
        }else{
			if(!StringTools.isEmpty(rank_of_niux_gameids)){
		     	if(rank_of_niux_gameids.indexOf(","+meta.getNewgameid())!=-1){
		     		rank_of_niux_gameids = rank_of_niux_gameids.replace(","+meta.getNewgameid(), "");
		     	}
		     	if(rank_of_niux_gameids.indexOf(meta.getNewgameid())!=-1){
		     		rank_of_niux_gameids = rank_of_niux_gameids.replace(meta.getNewgameid(), "");
		     	}
		     	PropertyUtil.writeData("rank_of_niux_gameids", rank_of_niux_gameids, BasePath+"classes/"+"games.properties");
		    }
        }

        /**
         * 同步xml
         */
        if(synchonlineFlag){
            synchGame();
        }
    }
	
	
	
	/**
	 * 根据游戏编号，查询游戏对应的文件
	 * @param gamesElementItor
	 * @param gameid
	 * @return
	 */
	private String findGameXml(Iterator<Element> gamesElementItor,String gameid){
		if(gameid == null || "".equals(gameid))return null;
		 while(gamesElementItor.hasNext()){
			 Element gameElement = gamesElementItor.next();	
			 String mygameid = gameElement.attribute("id").getText();
			 if(mygameid.trim().equals(gameid.trim())){
				 return gameElement.attribute("configfile").getText();
			 }			 
		 }
		return null;
	}
	
	/**
	 * 判断游戏编号在系统中，是否已经存在
	 * @param gxmlist
	 * @param gameid
	 * @return
	 */
	private boolean isExist(List<GameXmlMeta> gxmlist,String gameid){
		if(gameid == null||"".equals(gameid))return false;
		for(GameXmlMeta gxm:gxmlist){
			if(gxm.getGameid().trim().equals(gameid.trim()))return true;
		}
		return false;
	}
	
	/**
	 * 生成每个游戏独有的xml
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGameXml(Games gs,GameXmlMeta meta,String basePath) throws Exception{
		String gameNo = gs.getGameNo();//游戏拼音缩写
		String simpleName = meta.getSimpleName();//游戏全拼
		Gameid game = new Gameid();
		game.setId(meta.getGameid());
		game.setName(gs.getGameName());
		
		List<Object> plist = new ArrayList<Object>();
        Property p1 = new Property();
        p1.setName("customerIdPrefix");
        p1.setValue("xl"+gameNo);
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("publicKey");
        p1.setValue(meta.getPublicKey());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("privateKey");
        p1.setValue(meta.getPrivateKey());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("loginFilePath");
        p1.setValue(meta.getFilePath()+LONGNFILEPATH+meta.getGameid()+"/");
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("customerSqlFilePath");
        p1.setValue(meta.getFilePath()+CUSTOMERSQLFILEPATH+meta.getGameid()+"/");
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("adultCheckFlag");
        p1.setValue(meta.getAdultCheckFlag()+"");
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("checkRegisterTimeFlag");
        p1.setValue(meta.getCheckRegisterTimeFlag()+"");
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("databaseName");
        p1.setValue(meta.getDatabaseName());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("customerServerSqlFilePath");
        p1.setValue(meta.getFilePath()+CUSTOMERSERVERSQLFILEPATH+meta.getGameid()+"/");
        plist.add(p1);
        XmlUtil.makeGameXml(game,plist,basePath+simpleName+".xml");
	}
	
	/**
	 * 每个游戏ID生成器的xml
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGameIdKeyXml(Games gs,GameXmlMeta meta,String basePath) throws Exception{
		String gameNo = gs.getGameNo();//游戏拼音缩写
		String simpleName = meta.getSimpleName();//游戏全拼
		Gameid game = new Gameid();
		game.setId(meta.getGameid());
		game.setName(gs.getGameName());
		
		List<Object> plist = new ArrayList<Object>();
        Property p1 = new Property();
        p1.setName("customerIdPrefix");
        p1.setValue("xl"+gameNo);
        plist.add(p1);   
        
        p1 = new Property();
        p1.setName("databaseName");
        p1.setValue(meta.getDatabaseName());
        plist.add(p1);
        
        XmlUtil.makeGameXml(game,plist,basePath+simpleName+".xml");
	}
	
	/**
	 * 生成每games.xml
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGamesXml(Games gs,GameXmlMeta meta,String basePath) throws Exception{
		String simpleName = meta.getSimpleName();//游戏全拼
		Game game = new Game();
		game.setId(meta.getGameid());
		game.setName(gs.getGameName());
		game.setConfigfile("/"+simpleName+".xml");	
		File file = new File(basePath+"games.xml");
		if(!file.exists()){
			throw new XLRuntimeException(basePath+"下的games.xml文件不存在");
		}
        XmlUtil.makeGamesXml(game,basePath+"games.xml");
	}
	
	/**
	 * 生成每gameUserServer.xml
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGameUserServerXml(Games gs,GameXmlMeta meta,String basePath) throws Exception{
		Game game = new Game();
		game.setId(meta.getNewgameid());
		game.setName(gs.getGameName());
		
		List<Property> plist = new ArrayList<Property>();
        Property p1 = new Property();
        p1.setName("roleurl");
        p1.setValue(meta.getRoleurl()==null?"":meta.getRoleurl());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("onlineurl");
        p1.setValue(meta.getOnlineurl()==null?"":meta.getOnlineurl());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("rolekey");
        p1.setValue(meta.getRolekey()==null?"":meta.getRolekey());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("onlinekey");
        p1.setValue(meta.getOnlinekey()==null?"":meta.getOnlinekey());
        plist.add(p1);
        
        if(meta.getRankurl() != null && !"".equals(meta.getRankurl())){
        	p1 = new Property();
            p1.setName("rankurl");
            p1.setValue(meta.getRankurl()==null?"":meta.getRankurl());
            plist.add(p1);
        }
        if(meta.getRankkey() != null && !"".equals(meta.getRankkey())){
        	p1 = new Property();
            p1.setName("rankkey");
            p1.setValue(meta.getRankkey()==null?"":meta.getRankkey());
            plist.add(p1);
        }
        p1 = new Property();
        p1.setName("database");
        p1.setValue(meta.getDatabaseName());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("defaultQuery");
        p1.setValue(meta.getDefaultQuery()+"");
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("openQueryRoleName");
        p1.setValue(meta.getOpenQueryRoleName()+"");
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("loginKey");
        p1.setValue(meta.getLoginKey());
        plist.add(p1);

        String totalConsumeUrl = meta.getTotalConsumeUrl();
        if(totalConsumeUrl != null && !"".equals(totalConsumeUrl)){
            p1 = new Property();
            p1.setName("TotalConsumeUrl");
            p1.setValue(totalConsumeUrl);
            plist.add(p1);
        }

        String totalConsumeKey = meta.getTotalConsumeKey();
        if(totalConsumeKey != null && !"".equals(totalConsumeKey)){
            p1 = new Property();
            p1.setName("TotalConsumeKey");
            p1.setValue(totalConsumeKey);
            plist.add(p1);
        }

        String detailConsumeUrl = meta.getDetailConsumeUrl();
        if(detailConsumeUrl != null && !"".equals(detailConsumeUrl)){
            p1 = new Property();
            p1.setName("detailConsumeUrl");
            p1.setValue(detailConsumeUrl);
            plist.add(p1);
        }

        String detailConsumeKey = meta.getDetailConsumeKey();
        if(detailConsumeKey != null && !"".equals(detailConsumeKey)){
            p1 = new Property();
            p1.setName("detailConsumeKey");
            p1.setValue(detailConsumeKey);
            plist.add(p1);
        }

        String giftDeailUrl = meta.getGiftDeailUrl();
        if(giftDeailUrl != null && !"".equals(giftDeailUrl)){
            p1 = new Property();
            p1.setName("giftDeailUrl");
            p1.setValue(giftDeailUrl);
            plist.add(p1);
        }

        String giftDeailKey = meta.getGiftDeailKey();
        if(giftDeailKey != null && !"".equals(giftDeailKey)){
            p1 = new Property();
            p1.setName("giftDeailKey");
            p1.setValue(giftDeailKey);
            plist.add(p1);
        }


        String gamesendvipkey = meta.getGamesendvipkey();
        if(gamesendvipkey != null && !"".equals(gamesendvipkey)) {
            p1 = new Property();
            p1.setName("gamesendvipkey");
            p1.setValue(gamesendvipkey);
            plist.add(p1);
        }

        String type_1 = meta.getType_1();
        if(type_1 != null && !"".equals(type_1)){
            p1 = new Property();
            p1.setName("type_1");
            p1.setValue(type_1);
            plist.add(p1);
        }
        String type_2 = meta.getType_2();
        if(type_2 != null && !"".equals(type_2)){
            p1 = new Property();
            p1.setName("type_2");
            p1.setValue(type_2);
            plist.add(p1);
        }
        String type_3 = meta.getType_3();
        if(type_3 != null && !"".equals(type_3)){
            p1 = new Property();
            p1.setName("type_3");
            p1.setValue(type_3);
            plist.add(p1);
        }

        File file = new File(basePath+"gameUserServer.xml");
        if(!file.exists()){
			throw new XLRuntimeException(basePath+"下的gameUserServer.xml文件不存在");
		}  
        XmlUtil.makeGameUserServerXml(game,plist,basePath+"gameUserServer.xml");
	}
	
	/**
	 * 生成每gameUser.xml
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGameUserXml(Games gs,GameXmlMeta meta,String basePath) throws Exception{
		Game game = new Game();
		game.setId(meta.getNewgameid());
		game.setName(gs.getGameName());
		
		List<Property> plist = new ArrayList<Property>();
        Property p1 = new Property();
        p1.setName("roleurl");
        p1.setValue(meta.getRoleurl()==null?"":meta.getRoleurl());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("onlineurl");
        p1.setValue(meta.getOnlineurl()==null?"":meta.getOnlineurl());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("rolekey");
        p1.setValue(meta.getRolekey()==null?"":meta.getRolekey());
        plist.add(p1);
        
        p1 = new Property();
        p1.setName("onlinekey");
        p1.setValue(meta.getOnlinekey()==null?"":meta.getOnlinekey());
        plist.add(p1);
        
        if(meta.getRankurl() != null && !"".equals(meta.getRankurl())){
        	p1 = new Property();
            p1.setName("rankurl");
            p1.setValue(meta.getRankurl()==null?"":meta.getRankurl());
            plist.add(p1);
        }
        if(meta.getRankkey() != null && !"".equals(meta.getRankkey())){
        	p1 = new Property();
            p1.setName("rankkey");
            p1.setValue(meta.getRankkey()==null?"":meta.getRankkey());
            plist.add(p1);
        }
        p1 = new Property();
        p1.setName("database");
        p1.setValue(meta.getDatabaseName());
        plist.add(p1);       
        
        p1 = new Property();
        p1.setName("loginKey");
        p1.setValue(meta.getLoginKey());
        plist.add(p1);
        
        
        String gamesendvipkey = meta.getGamesendvipkey();
        if(gamesendvipkey != null && !"".equals(gamesendvipkey)) {
            p1 = new Property();
            p1.setName("gamesendvipkey");
            p1.setValue(gamesendvipkey);
            plist.add(p1);
        }

        String type_1 = meta.getType_1();
        if(type_1 != null && !"".equals(type_1)){
            p1 = new Property();
            p1.setName("type_1");
            p1.setValue(type_1);
            plist.add(p1);
        }
        String type_2 = meta.getType_2();
        if(type_2 != null && !"".equals(type_2)){
            p1 = new Property();
            p1.setName("type_2");
            p1.setValue(type_2);
            plist.add(p1);
        }
        
        String totalConsumeUrl = meta.getTotalConsumeUrl();
        if(totalConsumeUrl != null && !"".equals(totalConsumeUrl)){
            p1 = new Property();
            p1.setName("TotalConsumeUrl");
            p1.setValue(totalConsumeUrl);
            plist.add(p1);
        }

        String totalConsumeKey = meta.getTotalConsumeKey();
        if(totalConsumeKey != null && !"".equals(totalConsumeKey)){
            p1 = new Property();
            p1.setName("TotalConsumeKey");
            p1.setValue(totalConsumeKey);
            plist.add(p1);
        }
        
        String detailConsumeUrl = meta.getDetailConsumeUrl();
        if(detailConsumeUrl != null && !"".equals(detailConsumeUrl)){
            p1 = new Property();
            p1.setName("detailConsumeUrl");
            p1.setValue(detailConsumeUrl);
            plist.add(p1);
        }

        String detailConsumeKey = meta.getDetailConsumeKey();
        if(detailConsumeKey != null && !"".equals(detailConsumeKey)){
            p1 = new Property();
            p1.setName("detailConsumeKey");
            p1.setValue(detailConsumeKey);
            plist.add(p1);
        }
        
        File file = new File(basePath+"gameUserServer.xml");
        if(!file.exists()){
			throw new XLRuntimeException(basePath+"下的gameUserServer.xml文件不存在");
		}        
        XmlUtil.makeGameUserServerXml(game,plist,basePath+"gameUserServer.xml");
	}
	
	public String synch(){
		synchGame();
		return "";
	}
	
	/**
	 * 同步游戏xml
	 * @throws Exception
	 */
	private void synchGame() {
		try {
			 logger.info("开始同步新游接入的相关xml文件,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);	
			 logger.info("新游接入xml同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	public 	String location(){
		back();
		return "";
	}
	
	public 	String backup(){
		copy();
		return "";
	}

	/**
	 * 从远程服务器自动拉回最新的配置文件到本地服务器
	 */
	private void back(){
		try {
			 logger.info("开始拉回新游接入的相关xml文件,地址:/usr/local/bin/"+BACKCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+BACKCOMMOND);	
			 logger.info("新游接入xml拉回成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
		
	}
	
	
	/**
	 * 备份从远程服务器拉回的文件
	 */
	private void copy(){
		try {
			 logger.info("开始备份文件");
			 File file = new File(COPYURL);
			 logger.info("COPYURL===============>"+COPYURL);
			 if(file.isDirectory()){
				 File subfiles [] = file.listFiles();
				 for(File subfile:subfiles){	
					 if(subfile.isDirectory()){
						 File twofiles[] = subfile.listFiles();
						 for(File twofile:twofiles){
							 if(twofile.isFile()){
								 if(twofile.getName().indexOf(".bak") == -1){
									 File newfile = new File(twofile.getAbsolutePath()+".bak");
									 if(!newfile.exists()){
										 newfile.createNewFile();
									 }
									 copyFile(twofile,newfile); 
								 }
								
							 }
						 }
					 }else if(subfile.isFile()){
						 if(subfile.getName().indexOf(".bak") == -1){
							 File newfile = new File(subfile.getAbsolutePath()+".bak");
							 if(!newfile.exists()){
								 newfile.createNewFile();
							 }
							 copyFile(subfile,newfile);
						 }
						 
					 }
				 }
			 }
			 logger.info("文件备份成功！");
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        BufferedOutputStream outBuff = null;
        try {
            // 新建文件输入流并对它进行缓冲
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));

            // 新建文件输出流并对它进行缓冲
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));

            // 缓冲数组
            byte[] b = new byte[1024 * 5];
            int len;
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
            // 刷新此缓冲的输出流
            outBuff.flush();
            
        } finally {
            // 关闭流
            if (inBuff != null)
                inBuff.close();
            if (outBuff != null)
                outBuff.close();
        }
    }


	/**
	 * 修改游戏xml
	 * @return
	 */
	public String edit(){
		logger.info("开始游戏xml修改");
		this.authenticateEdit();//编辑权限
		GameXmlMeta meta = this.findBean(GameXmlMeta.class,"gamexmlmeta");
		try{
			if(meta == null){
				logger.info("游戏xml为空");
				throw new XLRuntimeException("游戏xml为空");
			}
			//拉回最新的配置
			//back();
			
			String gameid = meta.getGameid();
			Long myseqid = meta.getSeqid();
			GameXmlMeta  gxm = new GameXmlMeta();
			gxm.setGameid(gameid);
			List<GameXmlMeta> gxmlist = gameXmlMetaBo.find(gxm, new Page());
			if(gxmlist != null){
				if(gxmlist.size() == 1){
					GameXmlMeta g = gxmlist.get(0);
					if(g.getSeqid().longValue() != myseqid.longValue()){
						logger.info("gameid:"+gameid+"系统中已存在，不能重复添加");
						throw new XLRuntimeException("gameid:"+gameid+"系统中已存在，不能重复添加");
					}
				}else if(gxmlist.size() >= 2){
					logger.info("gameid:"+gameid+"系统中已存在，不能重复添加");
					throw new XLRuntimeException("gameid:"+gameid+"系统中已存在，不能重复添加");
				}
			}
			
			if(gameid != null && !"".equals(gameid)){
				if(gameid.length()==5){
					meta.setNewgameid("0"+gameid);
				}else{
					meta.setNewgameid(gameid);
				}
			}
			
			Games games = new Games();
			games.setGameId(meta.getNewgameid().trim());
			List<Games> gameslist = gamesBo.findGames(games, new Page());
			if(gameslist == null || gameslist.size()==0){
				logger.info("gameid:"+gameid+"系统中不存在，请重新录入");
				throw new XLRuntimeException("gameid:"+gameid+"系统中不存在，请重新录入");
			}
			Games gs = gameslist.get(0);
			
			meta.setEditBy(this.currentUserLogo());
			meta.setEditTime(now());
//			if(meta.getRoleurl() != null && !"".equals(meta.getRoleurl())){
//				meta.setIsLevelInterface(true);
//			}else{
//				meta.setIsLevelInterface(false);
//			}
//			if(meta.getOnlineurl() != null && !"".equals(meta.getOnlineurl())){
//				meta.setIsOnlineInterface(true);
//			}else{
//				meta.setIsOnlineInterface(false);
//			}
			gameXmlMetaBo.update(meta);	
			
			String BasePath = meta.getFilePath().trim();
			/**
			 * 生成xml文件
			 */
			//生成每个游戏独有的xml文件
			makeGameXml(gs,meta,BasePath+"conf/");
	        //每个游戏id生成器的xml文件
			makeGameIdKeyXml(gs,meta,BasePath+"bin/");
			
			//生成games.xml文件
			makeGamesXml(gs,meta,BasePath+"conf/");
			makeGamesXml(gs,meta,BasePath+"bin/");
			
			//生成gameUserServer.xml文件
			makeGameUserServerXml(gs,meta,BasePath+"conf/");
			
			//生成gameUser.xml文件
			makeGameUserXml(gs,meta,BasePath+"classes/");
			
			/**
			 * 生成property文件
			 */
			//生成web-game-key.properties.properties文件，如果某游戏的配置信息已经存在，则更新为最新的配置。如果不存在，则追加。
			//PropertyUtil.writeData(meta.getNewgameid()+"_publicKey", meta.getPublicKey(),gs.getGameNo()+".niu.xunlei.com", BasePath+"classes/"+"web-game-key.properties");
			//PropertyUtil.writeData(meta.getNewgameid()+"_privateKey", meta.getPrivateKey(), BasePath+"classes/"+"web-game-key.properties");			
			PropertyUtil.writerString(meta.getNewgameid(),meta.getNewgameid()+"_publicKey="+meta.getPublicKey(),meta.getNewgameid()+"_privateKey="+meta.getPrivateKey(),"#"+gs.getGameNo()+".niu.xunlei.com",BasePath+"classes/"+"web-game-key.properties");
			//生成games.properties文件
			
			String weiduangame = PropertyUtil.readData("weiduangame", BasePath+"classes/"+"games.properties");		
			if(meta.getIsWeiDuan()){								
				if(weiduangame == null || "".equals(weiduangame)){
					PropertyUtil.writeData("weiduangame", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}else{
					if(weiduangame.indexOf(meta.getNewgameid())==-1)
					   PropertyUtil.writeData("weiduangame", weiduangame+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}
			}else{
				if(!StringTools.isEmpty(weiduangame)){
			     	if(weiduangame.indexOf(","+meta.getNewgameid())!=-1){
			     		weiduangame = weiduangame.replace(","+meta.getNewgameid(), "");
			     	}
			     	if(weiduangame.indexOf(meta.getNewgameid())!=-1){
			     		weiduangame = weiduangame.replace(meta.getNewgameid(), "");
			     	}
			     	PropertyUtil.writeData("weiduangame", weiduangame, BasePath+"classes/"+"games.properties");
			}
		}		
			String online_of_niux_gameids = PropertyUtil.readData("online_of_niux_gameids", BasePath+"classes/"+"games.properties");		
			if(meta.getIsOnlineInterface()){					
				if(online_of_niux_gameids == null || "".equals(online_of_niux_gameids)){
					PropertyUtil.writeData("online_of_niux_gameids", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}else{
					if(online_of_niux_gameids.indexOf(meta.getNewgameid())==-1)
					   PropertyUtil.writeData("online_of_niux_gameids", online_of_niux_gameids+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}
			}else{
				if(!StringTools.isEmpty(online_of_niux_gameids)){
				     	if(online_of_niux_gameids.indexOf(","+meta.getNewgameid())!=-1){
				     		online_of_niux_gameids = online_of_niux_gameids.replace(","+meta.getNewgameid(), "");
				     	}
				     	if(online_of_niux_gameids.indexOf(meta.getNewgameid())!=-1){
				     		online_of_niux_gameids = online_of_niux_gameids.replace(meta.getNewgameid(), "");
				     	}
				     	 PropertyUtil.writeData("online_of_niux_gameids", online_of_niux_gameids, BasePath+"classes/"+"games.properties");
				}
			}
			String level_of_niux_gameids = PropertyUtil.readData("level_of_niux_gameids", BasePath+"classes/"+"games.properties");		
			if(meta.getIsLevelInterface()){			
				if(level_of_niux_gameids == null || "".equals(level_of_niux_gameids)){
					PropertyUtil.writeData("level_of_niux_gameids", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}else{
					if(level_of_niux_gameids.indexOf(meta.getNewgameid())==-1)
					   PropertyUtil.writeData("level_of_niux_gameids", level_of_niux_gameids+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}
			}else{
				if(!StringTools.isEmpty(level_of_niux_gameids)){
			     	if(level_of_niux_gameids.indexOf(","+meta.getNewgameid())!=-1){
			     		level_of_niux_gameids = level_of_niux_gameids.replace(","+meta.getNewgameid(), "");
			     	}
			     	if(level_of_niux_gameids.indexOf(meta.getNewgameid())!=-1){
			     		level_of_niux_gameids = level_of_niux_gameids.replace(meta.getNewgameid(), "");
			     	}
			     	PropertyUtil.writeData("level_of_niux_gameids", level_of_niux_gameids, BasePath+"classes/"+"games.properties");
			    }
				
			}
			String rank_of_niux_gameids = PropertyUtil.readData("rank_of_niux_gameids", BasePath+"classes/"+"games.properties");			
			if(meta.getIsRank()){//如果配置了排行榜				
				if(rank_of_niux_gameids == null || "".equals(rank_of_niux_gameids)){
					PropertyUtil.writeData("rank_of_niux_gameids", meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}else{
					if(rank_of_niux_gameids.indexOf(meta.getNewgameid())==-1)
					   PropertyUtil.writeData("rank_of_niux_gameids", rank_of_niux_gameids+","+meta.getNewgameid(), BasePath+"classes/"+"games.properties");
				}
			}else{
				if(!StringTools.isEmpty(rank_of_niux_gameids)){
			     	if(rank_of_niux_gameids.indexOf(","+meta.getNewgameid())!=-1){
			     		rank_of_niux_gameids = rank_of_niux_gameids.replace(","+meta.getNewgameid(), "");
			     	}
			     	if(rank_of_niux_gameids.indexOf(meta.getNewgameid())!=-1){
			     		rank_of_niux_gameids = rank_of_niux_gameids.replace(meta.getNewgameid(), "");
			     	}
			     	PropertyUtil.writeData("rank_of_niux_gameids", rank_of_niux_gameids, BasePath+"classes/"+"games.properties");
			    }
				
				
			}
			
			/**
			 * 同步xml
			 */
			String one_synchonline = findParameter("one_synchonline");
			boolean synchonlineFlag = Boolean.parseBoolean(one_synchonline);
            if(synchonlineFlag){
            	synchGame();
            }				
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}	
	
}
