package com.xunlei.niux.manager.web.model;


import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.GamePayXmlMetaBo;
import com.xunlei.niux.data.vipgame.bo.GameXmlMetaBo;
import com.xunlei.niux.data.vipgame.bo.GamesBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GamePayXmlMeta;
import com.xunlei.niux.data.vipgame.vo.GameXmlMeta;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.file.Game;
import com.xunlei.niux.manager.web.file.Gameid;
import com.xunlei.niux.manager.web.file.Parameter;
import com.xunlei.niux.manager.web.file.XmlUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;



/**
 * 游戏充值配置业务处理类
 * @author lisu
 *  2013-06-21
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEXMLMETA)
public class GamePayXmlMetaManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GamePayXmlMetaManagedBean.class.getName());
	private static String BASEPATH = "/usr/local/ly_gameservers/ly_authserver/pay/";
	private static String PATHURL = "http://pay.niu.xunlei.com/";
	private static final String SYNCPICCOMMOND = "rsync_game_pay_xml_to_14241.sh";//同步xml文件脚本名称
	private static final String BACKCOMMOND = "rsync_game_pay_xml_from_14241.sh";//从远程服务器取回配置文件
	private static final String PAYHOST = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("payhost");//充值主机
	private static final String PAYPORT = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("payport");//充值主机端口号
	private GamePayXmlMetaBo gamePayXmlMetaBo;
	private GameXmlMetaBo gameXmlMetaBo;
	private GamesBo gamesBo;
	private int rownum = 0;
	private String dataBaseName =null;
	
	
	public GamePayXmlMetaManagedBean(){
		gamePayXmlMetaBo = FacadeFactory.INSTANCE.getGamePayXmlMetaBo();
		gamesBo = FacadeFactory.INSTANCE.getGamesBo();
		gameXmlMetaBo = FacadeFactory.INSTANCE.getGameXmlMetaBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public String synch(){
		synchGame();
		return "";
	}
	
	/**
	 * 同步游戏xml
	 * @throws Exception
	 */
	private void synchGame() {
		try {
			 logger.info("开始同步新游接入充值的相关xml文件,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);	
			 logger.info("新游接入充值xml同步成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	}
	
	public 	String location(){
		back();
		return "";
	}
	
	public 	String backup(){
		copy();
		return "";
	}
	
	/**
	 * 查询游戏充值的相关配置xml
	 * @return
	 */
	public String getQueryGamePayXmlMetaList(){
		logger.info("开始游戏充值的相关配置xml查询");
        this.authenticateRun();//验证运行权限
        GamePayXmlMeta meta = findBean(GamePayXmlMeta.class, "gamepayxmlmeta");
        PagedFliper pagedFliper = this.getFliper();
        String gameid = meta.getGameId();
        System.out.println("gameid======>"+gameid);
        if(gameid == null|| "".equals(gameid)){
        	meta.setGameId(null);
        }
        if(gameid != null){
        	if(gameid.length() == 6){
        		gameid = gameid.substring(1);
        	}
        }
        meta.setGameId(gameid);
        int count = gamePayXmlMetaBo.count(meta);
        pagedFliper.setRecordCount(count);
        List<GamePayXmlMeta> list = new ArrayList<GamePayXmlMeta>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = gamePayXmlMetaBo.find(meta, page);
        }
        Sheet<GamePayXmlMeta> sheet = new Sheet<GamePayXmlMeta>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增游戏充值配置xml
	 * @return
	 */
	public String add(){
		logger.info("开始游戏充值配置xml添加");		
		GamePayXmlMeta meta = this.findBean(GamePayXmlMeta.class,"gamepayxmlmeta");					
		try{
			if(meta == null){
				logger.info("游戏充值配置xml为空");
				throw new XLRuntimeException("游戏充值配置xml为空");
			}	
			meta.setNewGameId("0"+meta.getGameId());
			String rechargeUrl = meta.getRechargeUrl();
			if(rechargeUrl.indexOf("&")>-1){
				rechargeUrl = rechargeUrl.replaceAll("&", "&amp;");
			}
			String rechargeKey = meta.getRechargeKey();
			if(rechargeKey.indexOf("&")>-1||rechargeKey.indexOf(">")>-1||rechargeKey.indexOf("<")>-1||rechargeKey.indexOf("'")>-1||rechargeKey.indexOf("\"")>-1){
				logger.info("游戏方支付密钥中包含特殊字符");
				throw new XLRuntimeException("游戏方支付密钥中包含特殊字符，请不要包含 &、大于、小于、单引号 和 双引号");
				
			}
			GamePayXmlMeta gpxm = new GamePayXmlMeta();
			gpxm.setGameId(meta.getGameId());
			List<GamePayXmlMeta> gpxmlist = gamePayXmlMetaBo.find(gpxm, new Page());
			if(gpxmlist != null){
				if(gpxmlist.size()>=1){
					logger.info("gameid 为："+meta.getGameId()+"的游戏已经配置过充值xml");
					throw new XLRuntimeException("gameid 为："+meta.getGameId()+"的游戏已经配置过充值xml");
				}
			}
			
			Games games = new Games();
			games.setGameId(meta.getNewGameId().trim());
			List<Games> gameslist = gamesBo.findGames(games, new Page());
			if(gameslist ==null || gameslist.size()==0){
				logger.info("游戏列表中没有找到编号为:"+meta.getNewGameId()+"的游戏");
				throw new XLRuntimeException("游戏列表中没有找到编号为:"+meta.getNewGameId()+"的游戏");
			}						
			
			Games game = gameslist.get(0);
			//生成xml文件
			makeGameXmlFile(game,meta);
			
			meta.setInputBy(this.currentUserLogo());
			meta.setInputTime(now());
			gamePayXmlMetaBo.insert(meta);			
			
			//生成game.xml文件
			String gameId = meta.getNewGameId();
			if(gameId != null && gameId.length()==5){
				gameId = "0"+gameId;
			}
			Games ga = GameCache.getInstance().getGameByGameId(gameId);
			makeGamesXml(ga,meta,BASEPATH+"conf/");
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 生成每个游戏独有的xml,如：maoxianqiyue.xml
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGameXml(Games gs,String simpleName,GamePayXmlMeta meta,String basePath) throws Exception{
		Gameid game = new Gameid();
		game.setId(meta.getGameId());
		game.setName(gs.getGameName());
		
		List<Object> plist = new ArrayList<Object>();
		Parameter p1 = new Parameter();
        p1.setName("databaseName");
        p1.setValue(dataBaseName);
        plist.add(p1);
        
        p1 = new Parameter();
        p1.setName("copartnerProxy");
        p1.setValue(meta.getCopartnerProxy());
        plist.add(p1);
        
        p1 = new Parameter();
        p1.setName("vrySecretKey");
        p1.setValue(meta.getVrySecretKey());
        plist.add(p1);
        
        p1 = new Parameter();
        p1.setName("rechargeUrl");
        p1.setValue(meta.getRechargeUrl());
        plist.add(p1);
        
        p1 = new Parameter();
        p1.setName("rechargeKey");
        p1.setValue(meta.getRechargeKey());
        plist.add(p1);
        
        p1 = new Parameter();
        p1.setName("calltype");
        p1.setValue(meta.getRechargeCallType()?"post":"get");
        plist.add(p1);
        
        if(meta.getRolesQueryUrl() != null && !"".equals(meta.getRolesQueryUrl())){
        	   p1 = new Parameter();
               p1.setName("queryRoleUrl");
               p1.setValue(meta.getRolesQueryUrl());
               plist.add(p1);
        }
     
        if(meta.getRolesKey() != null && !"".equals(meta.getRolesKey())){
        	   p1 = new Parameter();
               p1.setName("queryRoleKey");
               p1.setValue(meta.getRolesKey());
               plist.add(p1);
        }
        if(meta.getRolesCallType().intValue() >0){
              p1 = new Parameter();
              p1.setName("rolecalltpye");
              p1.setValue(meta.getRolesCallType().intValue()==1?"post":"get");
              plist.add(p1);
        }
        p1 = new Parameter();
        p1.setName("rate");
        p1.setValue(meta.getRate()+"");
        plist.add(p1);
 
        XmlUtil.makeGameXml(game,plist,basePath+simpleName+".xml");
	}
	
	/**
	 * 生成每games.xml 
	 * @param gs
	 * @param meta
	 * @throws Exception
	 */
	private void makeGamesXml(Games gs,GamePayXmlMeta gpxm,String basePath) throws Exception{
		logger.info("======start make games.xml=========");
		GameXmlMeta meta = new GameXmlMeta();
		if(gpxm == null){
			throw new XLRuntimeException("游戏充值配置为空");
		}		
		meta.setGameid(gpxm.getGameId());
		List<GameXmlMeta> list = gameXmlMetaBo.find(meta, new Page());
		if(list == null||list.size()==0){
			throw new XLRuntimeException("请新配置登录xml");
		}
		meta = list.get(0);
		dataBaseName = meta.getDatabaseName();//获得登录配置中的数据源
		String simpleName = meta.getSimpleName();//游戏全拼
		Game game = new Game();
		game.setId(meta.getGameid());
		game.setName(gs.getGameName());
		game.setConfigfile("/"+simpleName+".xml");	
		File file = new File(basePath+"games.xml");
		
		if(!file.exists()){
			throw new XLRuntimeException(basePath+"下的games.xml文件不存在");
		}
        XmlUtil.makeGamesXml(game,basePath+"games.xml");
        logger.info("======games.xml   success =========");
        
        makeGameXml(gs,simpleName,gpxm,basePath);
	}
	
	/**
	 * 生成游戏充值相关的 gamePayConfig.xml  和 server.xml
	 * @param games 游戏实体类
	 * @param meta 游戏充值配置实体类
	 * @throws Exception
	 */
	private void makeGameXmlFile(Games games,GamePayXmlMeta meta) throws Exception {
		logger.info("======start make gamePayConfig.xml =========");
		String gameFileName = BASEPATH +"gamePayConfig.xml";		
		Map<String,String> attMap = new LinkedHashMap<String,String>();//子标签属性
		attMap.put("business-close", meta.getIsclose()+"");
		attMap.put("payurl", PATHURL+games.getGameNo());
		attMap.put("payhost", PAYHOST);
		attMap.put("payport", PAYPORT);
		attMap.put("maxMoney", "-1");
		attMap.put("minMoney", "-1");
		attMap.put("paykey", meta.getVrySecretKey());
		attMap.put("googsname", meta.getGoogsname());
		attMap.put("effectpaytime", meta.getEffectpaytime());
		attMap.put("showmessage", meta.getShowmessage());
		attMap.put("bizType", String.valueOf(meta.getBizType()));
		String tagName = "gameid-"+meta.getGameId()+"-0";
		XmlUtil.commonOneLevelXml(gameFileName, tagName, attMap);
		logger.info("======gamePayConfig.xml success=========");
	}
	
	/**
	 * 修改游戏充值配置xml
	 * @return
	 */
	public String edit(){
		logger.info("开始游戏充值配置xml修改");
		this.authenticateEdit();//编辑权限
		GamePayXmlMeta meta = this.findBean(GamePayXmlMeta.class,"gamepayxmlmeta");
		try{
			if(meta == null){
				logger.info("游戏充值配置xml为空");
				throw new XLRuntimeException("游戏充值配置xml为空");
			}		
			
			String rechargeKey = meta.getRechargeKey();
			if(rechargeKey.indexOf("&")>-1||rechargeKey.indexOf(">")>-1||rechargeKey.indexOf("<")>-1||rechargeKey.indexOf("'")>-1||rechargeKey.indexOf("\"")>-1){
				logger.info("游戏方支付密钥中包含特殊字符");
				throw new XLRuntimeException("游戏方支付密钥中包含特殊字符，请不要包含 &、大于、小于、单引号 和 双引号");				
			}
			
			Games games = new Games();
			games.setGameId(meta.getNewGameId().trim());
			List<Games> gameslist = gamesBo.findGames(games, new Page());
			if(gameslist ==null || gameslist.size()==0){
				logger.info("游戏列表中没有找到编号为:"+meta.getNewGameId()+"的游戏");
				throw new XLRuntimeException("游戏列表中没有找到编号为:"+meta.getNewGameId()+"的游戏");
			}
			Games game = gameslist.get(0);
			
			//生成xml文件
			makeGameXmlFile(game,meta);
			
			//生成game.xml文件
			String gameId = meta.getNewGameId();
			if(gameId != null && gameId.length()==5){
				gameId = "0"+gameId;
			}
			Games ga = GameCache.getInstance().getGameByGameId(gameId);
			makeGamesXml(ga,meta,BASEPATH+"conf/");
			
			meta.setEditBy(this.currentUserLogo());
			meta.setEditTime(now());
			gamePayXmlMetaBo.update(meta);
						
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}	
	
	

	/**
	 * 从远程服务器自动拉回最新的配置文件到本地服务器
	 */
	private void back(){
		try {
			 logger.info("开始拉回新游接入充值的相关xml文件,地址:/usr/local/bin/"+BACKCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+BACKCOMMOND);	
			 logger.info("新游接入充值xml拉回成功！");
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
		
	}
	
	
	/**
	 * 备份从远程服务器拉回的文件
	 */
	private void copy(){
		try {
			 logger.info("开始备份文件");
			 File file = new File(BASEPATH);
			 logger.info("BASEPATH===============>"+BASEPATH);
			 if(file.isDirectory()){
				 File subfiles [] = file.listFiles();
				 for(File subfile:subfiles){	
					 if(subfile.isDirectory()){
						 File twofiles[] = subfile.listFiles();
						 for(File twofile:twofiles){
							 if(twofile.isFile()){
								 if(twofile.getName().indexOf(".bak") == -1){
									 File newfile = new File(twofile.getAbsolutePath()+".bak");
									 if(!newfile.exists()){
										 newfile.createNewFile();
									 }
									 copyFile(twofile,newfile); 
								 }
								
							 }
						 }
					 }else if(subfile.isFile()){
						 if(subfile.getName().indexOf(".bak") == -1){
							 File newfile = new File(subfile.getAbsolutePath()+".bak");
							 if(!newfile.exists()){
								 newfile.createNewFile();
							 }
							 copyFile(subfile,newfile);
						 }
						 
					 }
				 }
			 }
			 logger.info("文件备份成功！");
			 
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        BufferedOutputStream outBuff = null;
        try {
            // 新建文件输入流并对它进行缓冲
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));

            // 新建文件输出流并对它进行缓冲
            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));

            // 缓冲数组
            byte[] b = new byte[1024 * 5];
            int len;
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
            // 刷新此缓冲的输出流
            outBuff.flush();
            
        } finally {
            // 关闭流
            if (inBuff != null)
                inBuff.close();
            if (outBuff != null)
                outBuff.close();
        }
    }

}
