package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.GamePayInfoBo;
import com.xunlei.niux.data.vipgame.bo.TemplateSchemaBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.LiveCount;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.template.builder.ITemplateBuilder;
import com.xunlei.niux.manager.template.builder.gameofficial.ArticleBuilder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.util.StringTools;

/**
 * 支付模板管理
 *
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEPAYINFO)
public class GamePayInfoManagedBean extends BaseManagedBean {

	private static final long pay_seq = 3L;//支付开关在表中的位置
    private List<SelectItem> payTemplateList;

    private Map<String, String> payTemplateMap;
    
    
    public String editCustomer(){
    	String gameids = this.findParameter("gameids");
    	GamePayInfo gamepayinfo = findBean(GamePayInfo.class, "gamepayinfo");
    	String customerServiceName = gamepayinfo.getCustomerserviceName();
    	String customerServiceQQ = gamepayinfo.getCustomerserviceQQ();
    	if(!StringTools.isEmpty(gameids)){
    		String[] gameArray=gameids.split("\\|");
    		if(gameArray==null||gameArray.length==0){
    			return "";
    		}
    		for(String gameId:gameArray){
    			if(gameId==null||"".equals(gameId)){
    				continue;
    			}
    			GamePayInfo query = new GamePayInfo();
    			query.setGameid(gameId);
    			GamePayInfo mygame = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    			if(mygame==null)continue;
    			mygame.setCustomerserviceName(customerServiceName);
    			mygame.setCustomerserviceQQ(customerServiceQQ);
    		    FacadeFactory.INSTANCE.getBaseSo().updateObjectById(mygame);
    		}
    	}
    	gamepayinfo.setCustomerserviceName(customerServiceName);
    	gamepayinfo.setCustomerserviceQQ(customerServiceQQ);
    	FacadeFactory.INSTANCE.getBaseSo().updateObjectById(gamepayinfo);
    	return "";
    }

    public String getQueryGamePayInfoList() {
        this.authenticateRun();

        GamePayInfo gamepayinfo = findBean(GamePayInfo.class, "gamepayinfo");

        String status = this.findParameter("status");
        if(!StringTools.isEmpty(status)){
        	gamepayinfo.setStatus(Integer.parseInt(status));
        }
        PagedFliper pagedFliper = this.getFliper();
        GamePayInfoBo GamePayInfoBo = FacadeFactory.INSTANCE.getGamePayInfoBo();
        int count = GamePayInfoBo.count(gamepayinfo);
        pagedFliper.setRecordCount(count);

        List<GamePayInfo> list = new ArrayList<GamePayInfo>();
        if (count > 0) {
            list = GamePayInfoBo.find(gamepayinfo,
                    pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<GamePayInfo> sheet = new Sheet<GamePayInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);


        return "";
    }
    
    public String getQueryGamePayInfoOpenList() {
        this.authenticateRun();
        GamePayInfo gamepayinfo = findBean(GamePayInfo.class, "gamepayinfo");
        gamepayinfo.setStatus(1);
        gamepayinfo.setTemplateid("000032");
        PagedFliper pagedFliper = this.getFliper();
        GamePayInfoBo GamePayInfoBo = FacadeFactory.INSTANCE.getGamePayInfoBo();
        int count = GamePayInfoBo.count(gamepayinfo);
        pagedFliper.setRecordCount(count);

        List<GamePayInfo> list = new ArrayList<GamePayInfo>();
        if (count > 0) {
            list = GamePayInfoBo.find(gamepayinfo,
                    pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<GamePayInfo> sheet = new Sheet<GamePayInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);


        return "";
    }
    

    public String changeStatus(){
    	 this.authenticateRun();
    	 String openstatus = this.findParameter("openstatus");
    	 if(openstatus == null||"".equals(openstatus)){
    		 logger.debug("支付开关状态异常");
    		 alertJS("添加失败，原因：支付开关状态为空");
             return "";
    	 }
    	 try{
        	 LiveCount liveCount = FacadeFactory.INSTANCE.getLiveCountBo().find(pay_seq);
        	 if("1".equals(openstatus)){
        		liveCount.setLiveCount(new Long(1));
        	 }else{
        		 liveCount.setLiveCount(new Long(0));
        	 }
        	 FacadeFactory.INSTANCE.getLiveCountBo().update(liveCount);
    	 }catch(Exception e){
    		 alertJS("添加失败，原因："+e.getMessage());
    	 }
       alertJS("开关设置成功");
    	return "";
    }
    
    public String add() {
        this.authenticateRun();

        GamePayInfo gamepayinfo = findBean(GamePayInfo.class, "gamepayinfo");
        if (gamepayinfo == null) {
            logger.debug("添加内容为空");
            mergeJsmessage("添加失败，原因：添加内容为空");
            return "";
        }
        try {
            if(FacadeFactory.INSTANCE.getGamePayInfoBo().findByGameId(gamepayinfo.getGameid()) != null) {
                alertJS("此款游戏已经添加过了");
                return "";
            }
            Games query = new Games();
            query.setGameId(gamepayinfo.getGameid());
            List<Games> gameslist = FacadeFactory.INSTANCE.getGamesBo().findGames(query, new Page());
            if(gameslist != null&&gameslist.size()>0){
            	Games games = gameslist.get(0);
                if("1".equals(games.getStatus())){//游戏已接入
                	gamepayinfo.setIsOpen(1);
                }else{
                	gamepayinfo.setIsOpen(0);
                }
            }
            FacadeFactory.INSTANCE.getGamePayInfoBo().insert(gamepayinfo);
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }

        return "";

    }
    
    /**
     *  初始化默认选中金额
     * @return
     */
    public String init(){
    	logger.info("===开始初始化默认选中金额=======");
    	 GamePayInfoBo GamePayInfoBo = FacadeFactory.INSTANCE.getGamePayInfoBo();
    	 List<GamePayInfo>gpilist = GamePayInfoBo.find(new GamePayInfo(), 0, 0);
    	 for(GamePayInfo gpi:gpilist){
    		 String money = gpi.getShowmoney();
    		 if(money != null ){
    			 if(money.indexOf(",")==-1){
    				 gpi.setDefaultmoney(Integer.parseInt(money));
    			 }else{
    				 String submoneys[] = money.split(",");
    				 gpi.setDefaultmoney(Integer.parseInt(submoneys[0]));
    			 }
    			 GamePayInfoBo.update(gpi);
    		 }
    	 }
    	logger.info("===初始化默认选中金额结束=======");
    	return "";
    }

    public String edit() {
        this.authenticateRun();

        GamePayInfo GamePayInfo = findBean(GamePayInfo.class, "gamepayinfo");

        if (GamePayInfo == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }

        try {
            GamePayInfoBo GamePayInfoBo = FacadeFactory.INSTANCE.getGamePayInfoBo();

            GamePayInfo temp = GamePayInfoBo.findById(GamePayInfo.getSeqid());
            if (temp == null) {
                logger.debug("编辑内容为空");
                mergeJsmessage("编辑失败，原因：编辑内容为空");
                return "";
            }
            //Games games = GameCache.getInstance().getGameByGameId(GamePayInfo.getGameid());
            Games query = new Games();
            query.setGameId(GamePayInfo.getGameid());
            List<Games> gameslist = FacadeFactory.INSTANCE.getGamesBo().findGames(query, new Page());
            if(gameslist != null&&gameslist.size()>0){
            	Games games = gameslist.get(0);
                if("1".equals(games.getStatus())){//游戏已接入
                	GamePayInfo.setIsOpen(1);
                }else{
                	GamePayInfo.setIsOpen(0);
                }
            }

            GamePayInfoBo.update(GamePayInfo);

            //getQueryGamePayInfoList();
        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }

        return "";
    }

    public List<SelectItem> getPayTemplateList() {
        if (payTemplateList == null) {
            HtmlTemplate htmlTemplate = new HtmlTemplate();
            htmlTemplate.setExt1("gamepay");

            List<HtmlTemplate> templateList = FacadeFactory.INSTANCE.getHtmlTemplateBo().find(htmlTemplate);
            payTemplateList = new ArrayList<SelectItem>();

            for (HtmlTemplate template : templateList) {
                SelectItem selectItem = new SelectItem();
                selectItem.setLabel(template.getTemplatename());
                selectItem.setValue(template.getTemplateid());

                payTemplateList.add(selectItem);
            }

        }

        return payTemplateList;
    }

    public Map<String, String> getPayTemplateMap() {
        if(payTemplateMap == null) {
            HtmlTemplate htmlTemplate = new HtmlTemplate();
            htmlTemplate.setExt1("gamepay");

            List<HtmlTemplate> templateList = FacadeFactory.INSTANCE.getHtmlTemplateBo().find(htmlTemplate);
            payTemplateMap = new HashMap<String, String>();
            payTemplateMap.put("000000", "无模版");

            for (HtmlTemplate template : templateList) {
                payTemplateMap.put(template.getTemplateid(), template.getTemplatename());
            }
        }

        return payTemplateMap;
    }

    public String build() {
        String buildseqids = findParameter("buildseqids");

        try {
            GamePayInfoBo gamePayInfoBo =  FacadeFactory.INSTANCE.getGamePayInfoBo();
            TemplateSchemaBo templateSchemaBo =  FacadeFactory.INSTANCE.getTemplateSchemaBo();

            for (String seqid : buildseqids.split(",")) {
                GamePayInfo gamePayInfo = gamePayInfoBo.findById(Long.valueOf(seqid));

                if(gamePayInfo != null && !"000000".equals(gamePayInfo.getTemplateid())) {
                    TemplateSchema templateSchema = new TemplateSchema();
                    templateSchema.setTemplateid(gamePayInfo.getTemplateid());
                    templateSchema.setExt1(gamePayInfo.getGameid());
                    templateSchema.setIspreview(false);
                    final String now = DateUtil.formatNowByDefault();
                    templateSchema.setSchematime(now);

                    UserInfo user=this.currentUserInfo();
                    templateSchema.setInputby(user.getTrueName());
                    templateSchema.setInputtime(now);

                    templateSchema.setIsexecuted(false);

                    HtmlTemplate ht=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(gamePayInfo.getTemplateid());
                    Class<?> clazz=Class.forName(ht.getExecclass());
                    ITemplateBuilder builder=(ITemplateBuilder)clazz.newInstance();
                    builder.manualAddTemplateSchema(ht, templateSchema);
                }
            }

            alertJS("添加生成支付页成功");
        } catch (Exception e) {
            logger.error("添加生成支付页失败，原因:", e);
            alertJS("添加生成支付页失败，原因:" + e.getMessage());
        }


        return "";
    }


}
