/**
 * 
 */
package com.xunlei.niux.manager.web.model;


import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.manager.facade.FacadeFactory;
import com.xunlei.niux.data.manager.vo.Game;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * @author lin
 * @date 2012-8-8
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAME)
public class GameManagedBean extends BaseManagedBean{
	private static final Logger logger = Logger.getLogger(GameManagedBean.class.getName());
	private UploadedFile upfile;
	
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
	/**
	 * 查询热门游戏
	 * @return
	 */
	public String getQueryGameList(){
		logger.info("开始热门游戏查询");
		this.authenticateRun();//验证运行权限
		//获取查询条件
		Game game=this.findBean(Game.class,"game");
		if(game!=null){
			logger.info(game.getGameNo());
		}
		//获取条件
		PagedFliper fliper=this.getFliper();//
		Sheet<Game> sheet=FacadeFactory.INSTANCE.getGameBo().queryGames(game, fliper);
		this.mergePagedDataModel(sheet, fliper);
		logger.info("完成热门游戏查询");
		return "";		//获取条件
	}
	/**
	 * 编辑游戏
	 * @return
	 */
	public String edit(){
		logger.info("编辑游戏");
		Game querygame=this.findBean(Game.class, "game");
		if(querygame==null){
			logger.info("游戏为空");
			mergeBean("游戏为空", "jsmessage");
			return "";
		}
		try{
			String filename=null;
			if(upfile!=null){
				filename=FileUploadUtil.upLoadFile(upfile);
			}
			Game game=FacadeFactory.INSTANCE.getGameBo().queryGameById(querygame.getGameNo());
			if(game==null){
				logger.info(querygame.getGameNo()+"不存在");
				mergeBean("活动["+querygame.getGameNo()+"]不存在", "jsmessage");
				return "";
			}
			game.setGameName(querygame.getGameName());
			game.setGameDesc(querygame.getGameDesc());
			game.setLinkPath(querygame.getLinkPath());

			game.setRemark(querygame.getRemark());
			game.setShowBeginDate(querygame.getShowBeginDate());
			game.setShowEndDate(querygame.getShowEndDate());
			game.setDisplayorder(querygame.getDisplayorder());
			if(filename!=null){
				game.setPicPath(filename);
			}
//			game.setGameId(querygame.getGameId());
			FacadeFactory.INSTANCE.getGameBo().updateGame(game);
			logger.info("完成专题活动编辑");
			Runtime.getRuntime().exec("syn_niuxpic.sh");
			alertJS("编辑成功");
			return "";
		}catch(Exception e){
			logger.info("编辑失败",e);
			alertJS("编辑失败，原因："+e.getMessage());
			return "";
		}
	}
	/**
	 * 添加游戏
	 * @return
	 */
	public String add(){
		logger.info("开始添加游戏");
		this.authenticateAdd();//添加权限
		if(upfile==null){
			logger.info("图片为空");
			alertJS("添加失败，原因：图片为空");
		    return "";
		}
		String fileName="";
		try {
			fileName=FileUploadUtil.upLoadFile(upfile);
		} catch (Exception e) {
			logger.info("添加失败", e);
			alertJS("添加失败，原因："+e.getMessage());
			return "";
		}
		Game game=this.findBean(Game.class, "game");
		if(game==null){
			logger.info("游戏为空");
			alertJS("添加失败，原因：游戏为空");
			return "";
		}
		game.setPicPath(fileName);
		try{
			FacadeFactory.INSTANCE.getGameBo().addGame(game);
			Runtime.getRuntime().exec("syn_niuxpic.sh");
			alertJS("添加成功");
			return "";
		}catch(Exception e){
			logger.info("添加失败",e);
			alertJS("添加失败，原因："+e.getMessage());
			return "";
		}

	}
}
