package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.GameInsideplaceBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameInsideplace;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;

/**
 * 游戏内运营位
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEINSIDEPLACE)
public class GameInsidePlaceManagedBean extends BaseManagedBean {

    private String fristtitleid;

    private String secondtitleid;

    private String gameid;

    private List<SelectItem> firstTitleIdList = new ArrayList<SelectItem>();

    private List<SelectItem> secondTitleIdList = new ArrayList<SelectItem>();

    public String getGameid() {
        return gameid;
    }

    public void setGameid(String gameid) {
        this.gameid = gameid;
    }

    public List<SelectItem> getSecondTitleIdList() {
        return secondTitleIdList;
    }

    public void setSecondTitleIdList(List<SelectItem> secondTitleIdList) {
        this.secondTitleIdList = secondTitleIdList;
    }

    public String getFristtitleid() {
        return fristtitleid;
    }

    public void setFristtitleid(String fristtitleid) {
        this.fristtitleid = fristtitleid;
    }

    public String getSecondtitleid() {
        return secondtitleid;
    }

    public void setSecondtitleid(String secondtitleid) {
        this.secondtitleid = secondtitleid;
    }

    public List<SelectItem> getFirstTitleIdList() {
        return firstTitleIdList;
    }



    public String getQueryList() {
        this.authenticateRun();

        if(gameid == null || gameid.length() == 0) {
            return "";
        }

        GameInsideplace gameInsideplace =  findBean(GameInsideplace.class, "gameinsideplace");
        if(gameInsideplace.getSeqid() != null && gameInsideplace.getSeqid() == 0) {
            gameInsideplace.setSeqid(null);
        }
        gameInsideplace.setGameid(gameid);

        PagedFliper pagedFliper = this.getFliper();
        GameInsideplaceBo gameInsideplaceBo = FacadeFactory.INSTANCE.getGameInsideplaceBo();
        int count = gameInsideplaceBo.count(gameInsideplace);
        pagedFliper.setRecordCount(count);

        List<GameInsideplace> list = new ArrayList<GameInsideplace>();
        if (count > 0) {
            list = gameInsideplaceBo.find(gameInsideplace,
                    pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<GameInsideplace> sheet = new Sheet<GameInsideplace>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }

    public String add() {
        this.authenticateRun();

        GameInsideplace gameInsideplace = findBean(GameInsideplace.class, "gameinsideplace");
        if (gameInsideplace == null) {
            logger.debug("添加内容为空");
            mergeJsmessage("添加失败，原因：添加内容为空");
            return "";
        }

        if(secondtitleid != null && secondtitleid.length() > 0) {
            gameInsideplace.setTitlepid(secondtitleid);
        } else if(fristtitleid != null && fristtitleid.length() > 0) {
            gameInsideplace.setTitlepid(fristtitleid);
        } else {
            gameInsideplace.setTitlepid("0");
        }

        gameInsideplace.setGameid(gameid);

        try {
            FacadeFactory.INSTANCE.getGameInsideplaceBo().insert(gameInsideplace);
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }

        getQueryList();

        return "";
    }

    public String edit() {
        this.authenticateRun();

        GameInsideplace gameInsideplace = findBean(GameInsideplace.class, "gameinsideplace");

        if (gameInsideplace == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }

        try {
            GameInsideplaceBo gameInsideplaceBo = FacadeFactory.INSTANCE.getGameInsideplaceBo();

            GameInsideplace temp = gameInsideplaceBo.findById(gameInsideplace.getSeqid());
            if (temp == null) {
                logger.debug("编辑内容为空");
                mergeJsmessage("编辑失败，原因：编辑内容为空");
                return "";
            }

            gameInsideplace.setGameid(temp.getGameid());
            gameInsideplaceBo.update(gameInsideplace);

            getQueryList();
        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }

        return "";
    }

    public String delete() {
        this.authenticateRun();

        String paramseqids = findParameter("delseqids");
        String[] params = paramseqids.split(",");

        try{
            for(String id : params) {

                FacadeFactory.INSTANCE.getGameInsideplaceBo().delete(Long.parseLong(id));
            }
            alertJS("删除成功!");
        } catch (Exception e) {
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e);
        }

        getQueryList();

        return "";
    }

    public String exchangeOrder() {
        String seqid = findParameter("exchangeOrder_seqid");
        String wapStr = findParameter("exchangeOrder_way");

        boolean flag = FacadeFactory.INSTANCE.getGameInsideplaceBo().exchangeOrder(Long.parseLong(seqid), wapStr);

        String waymsg = "1".equals(wapStr) ? "上移" : "下移";
        if(flag)
            alertJS((new StringBuilder()).append(waymsg).append("菜单成功").toString());
        else
            alertJS((new StringBuilder()).append("菜单不能进行").append(waymsg).toString());

        getQueryList();

        return "";
    }


    public void select() {
        logger.debug("一级标题ID：" + fristtitleid);

        if(fristtitleid != null && fristtitleid.length() > 0) {
            secondTitleIdList = new ArrayList<SelectItem>();

            GameInsideplace gameInsideplace = new GameInsideplace();
            gameInsideplace.setTitlepid(fristtitleid);
            gameInsideplace.setGameid(gameid);

            List<GameInsideplace> temp = FacadeFactory.INSTANCE.getGameInsideplaceBo().find(gameInsideplace,0, 0);

            for(GameInsideplace gameInsideplace1: temp) {
                SelectItem selectItem = new SelectItem();
                selectItem.setLabel(gameInsideplace1.getName());
                selectItem.setValue(gameInsideplace1.getTitleid());
                secondTitleIdList.add(selectItem);
            }

        }

    }

    public void gameSelect() {
        logger.debug("游戏ID：" + gameid);

        if(gameid != null && gameid.length() > 0) {
            firstTitleIdList = new ArrayList<SelectItem>();

            GameInsideplace gameInsideplace = new GameInsideplace();
            gameInsideplace.setTitlepid("0");
            gameInsideplace.setGameid(gameid);


            List<GameInsideplace> temp = FacadeFactory.INSTANCE.getGameInsideplaceBo().find(gameInsideplace,0, 0);

            for(GameInsideplace gameInsideplace1: temp) {
                SelectItem selectItem = new SelectItem();
                selectItem.setLabel(gameInsideplace1.getName());
                selectItem.setValue(gameInsideplace1.getTitleid());
                firstTitleIdList.add(selectItem);
            }

        }

    }

    public void addinit() {
        //点击添加按钮时，参数置空
        gameid = null;
        fristtitleid = null;
        secondtitleid = null;
        firstTitleIdList = new ArrayList<SelectItem>();
        secondTitleIdList = new ArrayList<SelectItem>();

    }

}
