package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.ForbidUser;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_set;
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_FORBIDUSER)
public class ForbidUserManagedBean extends BaseManagedBean {
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public String getQueryForbidUserList(){
		this.authenticateRun();
		ForbidUser user=this.findBean(ForbidUser.class,"forbiduser");
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getForbidUserBo().count(user);
		pagedFliper.setRecordCount(count);
		List<ForbidUser> list=new ArrayList<ForbidUser>();
		if(count>0){
			Page page=new Page();
			page.setPageNo(pagedFliper.getPageNo());
			page.setPageSize(pagedFliper.getPageSize());
			page.addOrder("inputtime", OrderType.DESC);
			list=FacadeFactory.INSTANCE.getForbidUserBo().find(user, page);
		}
		Sheet<ForbidUser> sheet=new Sheet<ForbidUser>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String add(){
		this.authenticateAdd();
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		ForbidUser forbiduser=this.findBean(ForbidUser.class,"forbiduser");
		String usernames=forbiduser.getUsername();
		String[] usernamearray=usernames.split(" ");
		for(String username:usernamearray){
			username=username.trim();
			if("".equals(username)){
				continue;
			}
			ForbidUser fbu=new ForbidUser();
			fbu.setReason(forbiduser.getReason());
			fbu.setUsername(username);
			fbu.setLiftabantime(forbiduser.getLiftabantime());
			fbu.setInputby(user.getTrueName());
			fbu.setInputtime(sdf.format(now));
			fbu.setStatus("0");
			addOnde(fbu);
		}
		return "";
	}
	private void addOnde(ForbidUser forbiduser){
		try{
			//获取用户账号信息
			UserInfoProxy userInfoProxy=ProxyFactory.getInstance().getUserInfoProxy();
			Resp_set resp=userInfoProxy.setuserinfo(forbiduser.getUsername(), (byte)-1, "state",1);
			if(resp.isOk()){
				FacadeFactory.INSTANCE.getForbidUserBo().insert(forbiduser);
			}
		}catch(Exception e){
			logger.error("封疆失败",e);
		}
	}
	public String edit(){
		this.authenticateAdd();
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		ForbidUser fu=this.findBean(ForbidUser.class,"forbiduser");
		ForbidUser forbiduser=FacadeFactory.INSTANCE.getForbidUserBo().find(fu.getSeqid());
		forbiduser.setEditby(user.getTrueName());
		forbiduser.setEdittime(sdf.format(now));
		forbiduser.setStatus("1");
		//获取用户账号信息
		UserInfoProxy userInfoProxy=ProxyFactory.getInstance().getUserInfoProxy();
		Resp_set resp=userInfoProxy.setuserinfo(forbiduser.getUsername(), (byte)-1, "state",0);
		if(!resp.isOk()){
			alertJS(resp.getRespMessage());
			return "";
		}
		FacadeFactory.INSTANCE.getForbidUserBo().update(forbiduser);
		return "";
	}
}

