package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.ExchangeTrans;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_EXCHANGETRANS)
public class ExchangeTransManagedBean extends BaseManagedBean{
	public String getQueryExchangeTransList(){
		this.authenticateRun();//验证运行权限
		ExchangeTrans query=findBean(ExchangeTrans.class,"exchangetrans");
		 PagedFliper pagedFliper = this.getFliper();
		Page page=new Page();
		page.setPageNo(pagedFliper.getPageNo());
		page.setPageSize(pagedFliper.getPageSize());
		page.addOrder("exchangeTime", OrderType.DESC);
		int count=FacadeFactory.INSTANCE.getExchangeTransBo().count(query);
		List<ExchangeTrans> list=null;
		if(count>0){
			list=FacadeFactory.INSTANCE.getExchangeTransBo().find(query, page);
		}
		if(list==null){
			list=new ArrayList<ExchangeTrans>();
		}
		Sheet<ExchangeTrans> sheet = new Sheet<ExchangeTrans>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
}
