package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.EmergencyMessage;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.web.util.PageUtil;
public class EmergencyMessageManagedBean  extends BaseManagedBean {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public String getQueryEmergencyMessageList(){
		EmergencyMessage query=this.findBean(EmergencyMessage.class,"emergencyMessage");
		if(query.getMessageId()!=null&&query.getMessageId()==0){
			query.setMessageId(null);
		}
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count==0){
			return this.mergePagedDataModel(0, new ArrayList<EmergencyMessage>());
		}
		Page page=PageUtil.formatPage(this.getFliper(), "messageId","desc");
		List<EmergencyMessage> mmList=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		return this.mergePagedDataModel(count, mmList);
	}
	public String adds(){
		this.authenticateAdd();
		EmergencyMessage message=this.findBean(EmergencyMessage.class,"emergencyMessage");
		message.setMessageLot(String.valueOf(System.currentTimeMillis()));
		String fenQuNums=findParameter("fenQuNums");//分区用|分割
		//设置
		try{
			String[] fenQuNumArray=fenQuNums.split("\\|");
			for(String fenQuNum:fenQuNumArray){
	          	if(fenQuNum==null||"".equals(fenQuNum)){
	          		continue;
	          	}
	          	message.setFenQuNum(fenQuNum);
	          	FacadeFactory.INSTANCE.getBaseSo().addObject(message);
	        }
			if(message.getIsAutoChangeServerStatus()){
				EmergencyMessage query=new EmergencyMessage();
				query.setMessageLot(message.getMessageLot());
				List<EmergencyMessage> emList=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
				for(EmergencyMessage em:emList){
					addTemplateSchema(em.getMessageId()+"", em.getGameId(), em.getBeginMaintainTime(), "1");//分区状态设置为维护中
	             	addTemplateSchema(em.getMessageId()+"", em.getGameId(), em.getEndMaintainTime(), "2");//分区状态由位置中设置为开区
				}
			}
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	public String delete() {
		   this.authenticateDel();
	       String paramseqids = findParameter("delseqids");
	       String[] params = paramseqids.split(",");
	       try{
	           for(String id : params) {
	               FacadeFactory.INSTANCE.getBaseSo().deleteById(EmergencyMessage.class, id);
	           }
	           alertJS("删除成功!");
	       } catch (Exception e) {
	           logger.error("删除失败", e);
	           alertJS("删除失败，原因：" + e);
	       }
	       return "";
	}
	private void addTemplateSchema(String seqId,String gameId,String schemaTime,String direct){
		String nowStr=sdf.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000039");
		ts.setSchematime(schemaTime);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		ts.setExt2(seqId);
		ts.setExt3(direct);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
}
