package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.LinkLocation;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;
import com.xunlei.niux.manager.web.util.PicUtil;

/**
 * 下载中心
 * @author Administrator
 *
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_LINKINFO)
public class DownLoadManagedBean extends BaseManagedBean {
    private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	public String add(){
		this.authenticateAdd();//添加权限
		LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
		if (linkInfo == null) {
			alertJS("添加失败，原因：编辑内容为空");
            return "";
		}
		UserInfo user=this.currentUserInfo();
		linkInfo.setInputby(user.getTrueName());
        linkInfo.setInputtime(sdf.format(new Date()));
		try{
			linkInfo.setLinkcontents(PicUtil.replacePicUrlAndSyn(linkInfo.getLinkcontents()));
			FacadeFactory.INSTANCE.getLinkInfoBo().add(linkInfo);
		}catch(Exception e){
			logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	public String edit(){
		this.authenticateEdit();
		LinkInfo linkInfo = findBean(LinkInfo.class, "linkinfo");
		if (linkInfo == null) {
			 alertJS("编辑失败，原因：编辑内容为空");
	         return "";
		}
		UserInfo user=this.currentUserInfo();
        linkInfo.setEditby(user.getTrueName());
        linkInfo.setEdittime(sdf.format(new Date()));
        try{
        	 linkInfo.setLinkcontents(PicUtil.replacePicUrlAndSyn(linkInfo.getLinkcontents()));
        	 FacadeFactory.INSTANCE.getLinkInfoBo().update(linkInfo);
        }catch(Exception e){
        	 logger.error("编辑失败", e);
             alertJS("编辑失败，原因：" + e.getMessage());
        }
        return "";
	}
	 public String getQueryDowndCliectElementList(){
		String downClientId=findParameter("downClientId");
		LinkInfo query=new LinkInfo();
		query.setLinklocid(downClientId);
		int count = FacadeFactory.INSTANCE.getLinkInfoBo().count(query);
		PagedFliper pagedFliper = this.getFliper();
		List<LinkInfo> list = new ArrayList<LinkInfo>();
		if (count > 0) {
			Page page=PageUtil.formatPage(pagedFliper,"displaysort","asc","validdatetime","desc");
		    list = FacadeFactory.INSTANCE.getLinkInfoBo().find(query,page);
		}
		Sheet<LinkInfo> sheet = new Sheet<LinkInfo>(count, list);
	    this.mergePagedDataModel(sheet, pagedFliper);
	    return "";
	}
	public String getDownClientLinkLocId(){
		return findParameter("downClientId");
	}
	public void setDownClientLinkLocId(){
		
	}
}
