package com.xunlei.niux.manager.web.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.lang.StringUtils;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.vo.CustomerServers;
import com.xunlei.niux.manager.web.model.vo.Customers;


/**
 * @author Administrator
 */
public class CustomersManagedBean extends BaseManagedBean {
	private static String databasepassword = "t14284";
	private static String databaseusername = "yeyouser";
	private static String databaseurl = "10.1.2.84:3306";
	private static String databasepassword_manager = "t14283";
	private static String databaseusername_manager = "yeyouser";
	private static String databaseurl_manager = "10.1.2.83:3306";
//	private static String databasepassword = "sd-9898w";
//	private static String databaseusername = "root";
//	private static String databaseurl = "10.10.10.203:3306";
//	private static String databasepassword_manager = "sd-9898w";
//	private static String databaseusername_manager = "root";
//	private static String databaseurl_manager = "10.10.10.203:3306";
    
    //游戏ID
    private String gameId = "";
    
    public String getQueryCustomersList() {
        this.authenticateRun();
        logger.info("[getQueryCustomersList customers]gameid:"+gameId);
        PagedFliper fliper = this.getFliper();
        Customers customers = this.findBean(Customers.class, "customers");
        logger.info("[getQueryCustomersList customers]gameid:"+gameId+",customers:"+customers);

        if(customers == null){
        	return "";
        }
        
        try {
            String dbname = getDBName(gameId);
            
            if(StringUtils.isEmpty(dbname)){
            	return "";
            }
            
        	int count = getCountCustomerss(customers, dbname);
        	fliper.setRecordCount(count);
        	
            List<Customers> list = getCustomerss(customers, dbname, fliper.getPageSize(), fliper.getPageNo());
            list = list == null ? new ArrayList<Customers>() : list;
            Sheet<Customers> sheet = new Sheet<Customers>(count, list);
            this.mergePagedDataModel(sheet, fliper);
        } catch (Exception e) {
            logger.error("getQueryCustomersList customers exception", e);
        }

        return "";
    }

    private static List<Customers> getCustomerss(Customers customers, String dbname, int pageSize, int pageNo) throws Exception {
    	int index = (pageNo - 1) * pageSize;
        List<Object> paramList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("select * from customers where 1=1 ");
    	if(!StringUtils.isEmpty(customers.getUserId())){
    		sb.append(" and userid=?");
    		paramList.add(customers.getUserId());
    	}
    	
    	if(!StringUtils.isEmpty(customers.getLastLoginIp())){
    		sb.append(" and LastLoginIp=?");
    		paramList.add(customers.getLastLoginIp());
    	}
    	
        sb.append(" limit " + index + "," + pageSize);
    	
        logger.info("[getCustomerss customers]sql:"+sb+",paramList:"+paramList);
        Connection conn = getConnection(dbname);
        ResultSet rs = query(sb.toString(), paramList, conn);
        return formatCustomers(rs);
    }
    
    /**
     * 通过角色名查找UID
     * @param customerservers
     * @param dbname
     * @return
     * @throws Exception
     */
    public static List<CustomerServers> getCustomerservers(CustomerServers customerservers, String dbname) throws Exception {
        List<Object> paramList = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder("select * from customerServers where 1=1 ");
    	if(!StringUtils.isEmpty(customerservers.getUserId())){
    		sb.append(" and userid=?");
    		paramList.add(customerservers.getUserId());
    	}
    	
    	if(!StringUtils.isEmpty(customerservers.getRoleName())){
    		sb.append(" and roleName=?");
    		paramList.add(customerservers.getRoleName());
    	}
    	
        sb.append(" limit 1");
    	
        logger.info("[getCustomerss customers]sql:"+sb+",paramList:"+paramList);
        Connection conn = getConnection(dbname);
        ResultSet rs = query(sb.toString(), paramList, conn);
        return formatCustomerservers(rs);
    }
    
    private static int getCountCustomerss(Customers customers, String dbname) throws Exception {
    	int count = 0;
    	List<Object> paramList = new ArrayList<Object>();
    	StringBuilder sb = new StringBuilder("select count(*) as count from customers where 1=1 ");
    	if(!StringUtils.isEmpty(customers.getUserId())){
    		sb.append(" and userid=?");
    		paramList.add(customers.getUserId());
    	}
    	
    	if(!StringUtils.isEmpty(customers.getLastLoginIp())){
    		sb.append(" and LastLoginIp=?");
    		paramList.add(customers.getLastLoginIp());
    	}
    	
    	
    	logger.info("[getCountCustomerss customers]sql:"+sb+",paramList:"+paramList);
    	Connection conn = getConnection(dbname);
    	ResultSet rs = query(sb.toString(), paramList, conn);

    	while (rs.next()) {
    		count = rs.getInt("count");
    	}
    	
    	logger.info("[getCountCustomerss customers]sql:"+sb+",paramList:"+paramList+",count:"+count);
    	return count;
    }

    private static ResultSet query(String prepareSql, List<Object> paramList, Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(prepareSql);
        paramList = paramList == null ? new ArrayList<Object>() : paramList;
        for (int i = 0; i < paramList.size(); i++) {
            ps.setObject(i + 1, paramList.get(i));
        }
        return ps.executeQuery();
    }

    private static List<Customers> formatCustomers(ResultSet rs) throws Exception {
        List<Customers> list = new ArrayList<Customers>();
        while (rs.next()) {
            Customers config = new Customers();
            config.setSeqid(rs.getLong("SeqId"));
            config.setUserId(rs.getString("userid"));
            config.setDigitAccount(rs.getString("DigitAccount"));
            config.setCustomerNo(rs.getString("CustomerNo"));
            config.setFirstLoginTime(rs.getString("FirstLoginTime"));
            config.setLastLoginIp(rs.getString("LastLoginIp"));
            config.setLastLoginTime(rs.getString("LastLoginTime"));
            config.setLastLoginPeerId(rs.getString("LastLoginPeerId"));
            list.add(config);
        }
        return list;
    }

    
    private static List<CustomerServers> formatCustomerservers(ResultSet rs) throws Exception {
        List<CustomerServers> list = new ArrayList<CustomerServers>();
        while (rs.next()) {
        	CustomerServers config = new CustomerServers();
            config.setSeqid(rs.getLong("SeqId"));
            config.setUserId(rs.getString("userid"));
            config.setDigitAccount(rs.getString("DigitAccount"));
            config.setCustomerNo(rs.getString("CustomerNo"));
            config.setFirstLoginTime(rs.getString("FirstLoginTime"));
            config.setLastLoginIp(rs.getString("LastLoginIp"));
            config.setLastLoginTime(rs.getString("LastLoginTime"));
            config.setLastLoginPeerId(rs.getString("LastLoginPeerId"));
            config.setServerId(rs.getString("serverId"));
            config.setStattus(rs.getString("stattus"));
            config.setCounts(rs.getString("counts"));
            config.setRoleName(rs.getString("roleName"));
            list.add(config);
        }
        return list;
    }

    /**
     * 获取的数据库链接
     *
     * @param gameId
     * @return
     * @throws Exception
     */
    
    private static Connection getManagerConnection() throws Exception {
    	logger.info("[getManagerConnection blackwhiteinfo]");
    	String url = "jdbc:mysql://" + databaseurl_manager + "/niux_manager"
                + "?useUnicode=true&amp;characterEncoding=utf8";
        BasicDataSource dataSource = createManagerDatasource(url);
        logger.info("[getManagerConnection blackwhiteinfo]dataSource:"+dataSource);
        Connection conn = dataSource.getConnection();
        logger.info("[getManagerConnection blackwhiteinfo]conn:"+conn);
    	return conn;
    }
    
    
    private static String getDBName(String gameId) {
    	logger.info("[getDBName]gameId:"+gameId);
    	String dbname = null;
    	
    	if(StringUtils.isEmpty(gameId)){// || gameId.startsWith("05")){
    		logger.info("[getDBName]游戏[" + gameId + "]数据源数据不在，不能使用黑白名单功能。");;//或属于手机游戏，不能使用黑白名单功能。");
    		return dbname;
    	}
    	
    	//变成五位
    	gameId = gameId.substring(1);
    	
    	Connection conn = null;
		try {
			conn = getManagerConnection();
			conn.setAutoCommit(false);
	        PreparedStatement ps = conn.prepareStatement("select dbname from dbconfig where gameid=?");
	        ps.setObject(1, gameId);
	        ResultSet rs = ps.executeQuery();
	        
	        while (rs.next()) {
	        	dbname = rs.getString("dbname");
	        	if(!StringUtils.isEmpty(dbname)){
	        		break;
	        	}else{
	        		logger.warn("[getDBNames]dbname empty,sql:"+ps+"gameid:"+gameId+",dbname:"+dbname);
	        	}
	    	}
	    	
	        conn.commit();
		} catch (Exception e) {
			logger.error("[getDBName]error!gameId："+gameId,e);
		}finally{
			if(conn != null){
				try {
					conn.close();
				} catch (SQLException e) {
					logger.error("[getDBName]conn.close()gameId："+gameId,e);
				}
				
			}
			
		}
		logger.info("[getDBName]gameId:"+gameId+",dbname:"+dbname);
        return dbname;
    }
    
    
	  private static Connection getConnection(String dbName) throws Exception {
		  logger.info("[getConnection]dbName:"+dbName);
		  
		  if(StringUtils.isEmpty(dbName)){
			  return null;
		  }
		  
	    String url = "jdbc:mysql://" + databaseurl + "/" + dbName
	            + "?useUnicode=true&amp;characterEncoding=utf8";
	    BasicDataSource dataSource = createDatasource(url);
	    return dataSource.getConnection();
	}


    /**
     * 创建数据链接
     *
     * @param url
     * @return
     * @throws Exception
     */
    private static BasicDataSource createDatasource(String url) throws Exception {
        Properties p = new Properties();
        p.setProperty("driverClassName", "com.mysql.jdbc.Driver");
        p.setProperty("url", url);
        p.setProperty("password", databasepassword);
        p.setProperty("username", databaseusername);
        return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
    }
    
    /**
     * 创建数据链接
     *
     * @param url
     * @return
     * @throws Exception
     */
    private static BasicDataSource createManagerDatasource(String url) throws Exception {
    	Properties p = new Properties();
    	p.setProperty("driverClassName", "com.mysql.jdbc.Driver");
    	p.setProperty("url", url);
    	p.setProperty("password", databasepassword_manager);
    	p.setProperty("username", databaseusername_manager);
    	return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
    }

	public String getGameId() {
		return gameId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

}
