package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerRole;
import com.xunlei.niux.data.vipgame.vo.CustomerUser;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 客户系统用户业务处理类
 * @author lisu
 *  2013-09-12
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CUSTOMERUSER)
public class CustomerUserManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CustomerUserManagedBean.class.getName());
	private BaseSo baseBo;
	private int rownum = 0;
	private List<CustomerRole> crlist;
	
	
	public CustomerUserManagedBean(){
		baseBo = FacadeFactory.INSTANCE.getBaseSo();

		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	 public List<SelectItem> getCustomerRoleList() {		    
	        List<SelectItem> tempList = new ArrayList<SelectItem>();	 
	        if(crlist == null){
	        	Page page = new Page();
		        page.addOrder("vipGrade", OrderType.ESC);
		        crlist = baseBo.findObjects(new CustomerRole(), page);
	        }
	        for(CustomerRole role:crlist){
	        	SelectItem sm = new SelectItem();
	 	        sm.setLabel(role.getRoleName());
	 	        sm.setValue(String.valueOf(role.getSeqid()));
	 	        tempList.add(sm);
	        }	      
	        return tempList;
	 }
	
	 public Map<String,String> getCustomerRoleMap(){
		 Map<String,String> result = new HashMap<String,String>();
		 if(crlist == null){
	        	Page page = new Page();
		        page.addOrder("vipGrade", OrderType.ESC);
		        crlist = baseBo.findObjects(new CustomerRole(), page);
	      }
		 for(CustomerRole role:crlist){
	        	result.put(String.valueOf(role.getSeqid()), role.getRoleName());
	      }	    
		 return result;
	 }
	 
	/**
	 * 查询客户系统用户
	 * @return
	 */
	public String getQueryCustomerUserList(){
		logger.info("开始客户系统用户查询");
        this.authenticateRun();//验证运行权限
        CustomerUser user = findBean(CustomerUser.class, "customeruser");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseBo.countObject(user);
        pagedFliper.setRecordCount(count);
        List<CustomerUser> list = new ArrayList<CustomerUser>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseBo.findObjects(user, page);
        }
        Sheet<CustomerUser> sheet = new Sheet<CustomerUser>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增客户系统用户
	 * @return
	 */
	public String add(){
		logger.info("开始客户系统用户添加");	
		this.authenticateAdd();//新增权限
		 CustomerUser user = findBean(CustomerUser.class, "customeruser");	
		try{
			if(user==null){
				logger.info("客户系统用户为空");
				throw new XLRuntimeException("客户系统用户为空");
			}		
			CustomerUser cu = new CustomerUser();
			cu.setUserName(user.getUserName());
			CustomerUser customerRole = baseBo.findObject(cu);
			if(customerRole != null){
				throw new XLRuntimeException("编号为:"+customerRole.getUserName()+"已经存在，请不要重复添加");
			}
			user.setInputBy(this.currentUserLogo());
			user.setInputTime(now());
			baseBo.addObject(user);			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改客户系统用户
	 * @return
	 */
	public String edit(){
		logger.info("开始客户系统用户修改");
		this.authenticateEdit();//编辑权限
		 CustomerUser user = findBean(CustomerUser.class, "customeruser");	
		try{
			if(user==null){
				logger.info("客户系统用户为空");
				throw new XLRuntimeException("客户系统用户为空");
			}	
			user.setEditBy(this.currentUserLogo());
			user.setEditTime(now());
			baseBo.updateObjectById(user);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除客户系统用户
	 * @return
	 */
	public String delete(){	
		logger.info("开始客户系统用户删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseBo.deleteById(CustomerUser.class, id);		
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
