package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerReport;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.util.StringTools;

/**
 * 客户销售报表业务处理类
 * @author lisu
 * 2013-04-02
 */
public class CustomerReportManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private static final Logger logger = Logger.getLogger(CustomerReportManagedBean.class.getName());
 
	public CustomerReportManagedBean(){
		baseSo =  FacadeFactory.INSTANCE.getBaseSo();
	}

    private static DecimalFormat  myformat = new DecimalFormat();
	static{
		myformat.applyPattern("#.00");
	}
	
	/**
	 * 查询客户销售报表信息
	 * @return
	 */
	public String getQueryCustomerReportList(){
		logger.info("开始客户销售报表信息查询");
        this.authenticateRun();//验证运行权限
        CustomerReport info = findBean(CustomerReport.class, "customerreport");
       
        PagedFliper pagedFliper = this.getFliper();
        if(info != null){
        	if(info.getVipGrade()!=null&&info.getVipGrade().intValue()==0){
        		info.setVipGrade(null);
        	}
        	String gameid = info.getGameId();
        	
        	if(!StringTools.isEmpty(gameid)&&!"00".equals(gameid)){
        		Integer vipgrade = info.getVipGrade();
        		if(vipgrade != null&&vipgrade.intValue() == 101){
        			info.setVipGrade(100);
        		}
        	}
        }
        int count = baseSo.countObject(info);
        pagedFliper.setRecordCount(count);
        List<CustomerReport> list = new ArrayList<CustomerReport>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
        	page.addOrder("gameId", OrderType.DESC);
        	page.addOrder("vipGrade", OrderType.ESC);
            list = baseSo.findObjects(info, page);
        }
        for(CustomerReport cr :list){
        	if("00".equals(cr.getGameId())){
        		cr.setGameId("");
        	}
        }
//        Page page=new Page();
//        List<CustomerReport>  sumlist = baseSo.findObjects(info, page);
//        CustomerReport sumReport = new CustomerReport();
//        long peopleCount = 0L;
//        long contactCount = 0L;
//        long saleCount = 0L;
//        long rebateCount = 0L;
//        long addCount = 0L;
//        long addContactCount = 0L;
//        long addSaleCount = 0L;
//        long addRebateCount = 0L;
//        for(CustomerReport cr:sumlist){
//        	int vipgrade = cr.getVipGrade().intValue();
//        	if(vipgrade==100){
//        		cr.setGameId("");
//        	}else{
//            	peopleCount+=cr.getPeopleCount();
//            	contactCount += cr.getContactCount();
//            	saleCount += cr.getSaleCount();
//            	rebateCount += cr.getRebateCount();
//            	addCount += cr.getAddCount();
//            	addContactCount += cr.getAddContactCount();
//            	addSaleCount += cr.getAddSaleCount();
//            	addRebateCount += cr.getAddRebateCount();
//        	}
//        }
//        sumReport.setPeopleCount(peopleCount);
//        sumReport.setContactCount(contactCount);
//        sumReport.setSaleCount(saleCount);
//        sumReport.setRebateCount(rebateCount);
//        sumReport.setAddCount(addCount);
//        sumReport.setAddContactCount(addContactCount);
//        sumReport.setAddSaleCount(addSaleCount);
//        sumReport.setAddRebateCount(addRebateCount);
//        sumReport.setContactPercent(sumReport.getPeopleCount()==0?0:(new Double(100*sumReport.getContactCount())/new Double(sumReport.getPeopleCount())));
//        sumReport.setContactPercent(new Double(myformat.format(sumReport.getContactPercent())));
//        sumReport.setSalePercent(sumReport.getContactCount()==0?0:(new Double(100*sumReport.getSaleCount())/new Double(sumReport.getContactCount())));
//        sumReport.setSalePercent(new Double(myformat.format(sumReport.getSalePercent())));
//        sumReport.setRebatePercent(sumReport.getSaleCount()==0?0:(new Double(100*sumReport.getRebateCount())/new Double(sumReport.getSaleCount())));
//        sumReport.setRebatePercent(new Double(myformat.format(sumReport.getRebatePercent())));
        Sheet<CustomerReport> sheet = new Sheet<CustomerReport>(count, list);
//        if(sheet.getRowcount() > 0){
//            sheet.getDatas().add(sumReport);
//        } 
//        if(sumlist != null){
//        	sumlist.clear();
//        	sumlist = null;
//        }
//        
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始客户销售报表信息导出到excel文件");
    	CustomerReport info = findBean(CustomerReport.class, "customerreport");
    	PagedFliper pagedFliper = this.getFliper();
    	Page page=new Page();
    	page.setPageNo(pagedFliper.getPageNo());
    	page.setPageSize(10000);
    	page.addOrder("gameId", OrderType.DESC);
    	page.addOrder("vipGrade", OrderType.ESC);
        List<CustomerReport> crlist = baseSo.findObjects(info, page);  
        long peopleCount = 0L;
        long contactCount = 0L;
        long saleCount = 0L;
        long rebateCount = 0L;
        long addCount = 0L;
        long addContactCount = 0L;
        long addSaleCount = 0L;
        long addRebateCount = 0L;
        for(CustomerReport cr:crlist){
        	int vipgrade = cr.getVipGrade().intValue();
        	if(vipgrade==100){
        		cr.setGameId("");
        	}else{
            	peopleCount+=cr.getPeopleCount();
            	contactCount += cr.getContactCount();
            	saleCount += cr.getSaleCount();
            	rebateCount += cr.getRebateCount();
            	addCount += cr.getAddCount();
            	addContactCount += cr.getAddContactCount();
            	addSaleCount += cr.getAddSaleCount();
            	addRebateCount += cr.getAddRebateCount();
        	}
        }
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title ="客户销售报表";	    
 	    List datas = new ArrayList();
 	    for(CustomerReport cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getDaytime());
 	    	String gameid = cr.getGameId();
 	    	Games games = GameCache.getInstance().getGameByGameId(gameid);
 	    	if(games == null){
 	    		list.add("汇总");
 	    	}else{
 	    		list.add(games.getGameName());
 	    	}	    	
 	    	if(cr.getVipGrade().intValue()==100){
 	    		list.add("");
 	    	}else{
 	    		list.add(cr.getVipGrade());
 	    	}
 	    	
 	    	list.add(cr.getPeopleCount());
 	    	list.add(cr.getContactCount());
 	    	list.add(cr.getContactPercent()+"%");
 	    	list.add(cr.getSaleCount());
 	    	list.add(cr.getSalePercent()+"%");
 	    	list.add(cr.getRebateCount());
 	    	list.add(cr.getRebatePercent()+"%");
 	    	list.add(cr.getAddCount());
 	    	list.add(cr.getAddContactCount());
 	    	list.add(cr.getAddSaleCount());
 	    	list.add(cr.getAddRebateCount());
 	    	datas.add(list);
 	    }	 
 	    
 	    //汇总数据
 	    List list = new ArrayList();
 	    list.add("");
    	list.add("汇总");
    	list.add("");
    	list.add(peopleCount);
    	list.add(contactCount);
    	list.add(peopleCount==0?0:(myformat.format(new Double(100*contactCount)/new Double(peopleCount)))+"%");
    	list.add(saleCount);
    	list.add(contactCount==0?0:(myformat.format(new Double(100*saleCount)/new Double(contactCount)))+"%");
    	list.add(rebateCount);
    	list.add(saleCount==0?0:(myformat.format(new Double(100*rebateCount)/new Double(saleCount)))+"%");
    	list.add(addCount);
    	list.add(addContactCount);
    	list.add(addSaleCount);
    	list.add(addRebateCount);
    	datas.add(list);
 	    
 	    
 	    //生成数据到excel中
		String[] columnName = {"日前","游戏名", "VIP等级", "总人数", "有联系方式玩家数","联系方式覆盖率","销售触达人数","触达覆盖率","成单人数","成功率","新增玩家","新增有联系方式玩家","新增销售触达","新增成单人数"};
		String filePath = "/tmp/customerreport.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("大客户销售报表",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_customerreport.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
	
	
}
