package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.util.CollectionUtils;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CustomerDetailQueryBo;
import com.xunlei.niux.data.vipgame.bo.CustomerInfoBo;
import com.xunlei.niux.data.vipgame.bo.CustomerQueryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.CustomerQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.CustomerUserProxy;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.vo.GameServerVo;
import com.xunlei.niux.manager.web.vo.JsonRecord;
import com.xunlei.niux.manager.web.vo.PayRecord;
import com.xunlei.niux.manager.web.vo.Record;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;

/**
 * 客户查询业务处理类
 * @author lisu
 * 2013-02-20
 */
public class CustomerQueryManagedBean extends BaseManagedBean {
    private CustomerQueryBo customerQueryBo;
    private CustomerInfoBo customerInfoBo;
    private CustomerDetailQueryBo customerDetailQueryBo;
    private static final Logger logger = Logger.getLogger(CustomerQueryManagedBean.class.getName());
    private List<GameServerVo> detailLists = null;
    private List<GameServerVo> gameLists = null;
    private int rownum = 0;
    private int rownum2 = 0;
    private Map<String,Object> customerInfoMap = null;
    private SimpleDateFormat format =   new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss" );
    private static String userTypeUrl = "http://vipcache.reg:8001/cache?";
    private static final String payhistoryurl = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("payHistoryUrl");	
    private static String BONUSURL = "http://bonus.niu.xunlei.com:7070/querybonus.do?";//查询用户平台总积分接口地址
    private static String customerInterface=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("customerInterface");	
    private static List<CustomerGrade> gradeList = null;
	private static final String getPayRecord = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("getPayRecord");	
    private static final Page defaultPage = new Page();
    
    static{
    	if(gradeList == null){
    		gradeList = new ArrayList<CustomerGrade>();
			CustomerGrade grade = new CustomerGrade();	
			Page qpage = new Page();
			qpage.addOrder("vipGrade", OrderType.ESC);
			gradeList = FacadeFactory.INSTANCE.getCustomerGradeBo().find(grade, qpage);
    	}
    	
    }
    
    
    private static DecimalFormat  myformat = new DecimalFormat();
	static{
		myformat.applyPattern("##,###.0");
	}
    
	public CustomerQueryManagedBean(){
		customerQueryBo =  FacadeFactory.INSTANCE.getCustomerQueryBo();
		customerInfoBo = FacadeFactory.INSTANCE.getCustomerInfoBo();
		customerDetailQueryBo = FacadeFactory.INSTANCE.getCustomerDetailQueryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		if(detailLists == null){
			detailLists = new ArrayList<GameServerVo>();
		}
		if(gameLists == null){
			gameLists = new ArrayList<GameServerVo>();
		}
	}

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 获得用户平台总积分
	 * @return
	 */
	public static int getBonusSum(String uid){
		String url = BONUSURL + "userId="+uid;
		int sum = 0;
		try{
			String reponseText = HttpClientUtil.getInfoForHttpGetMothed(url);
			String subs[] = reponseText.split(",");			
			for(String sub:subs){
				if(sub.indexOf("rechargeSum")>-1){
					String datas[] = sub.split(":");
					sum = Integer.parseInt(datas[1]);
					break;
				}
			}
		}catch(Exception e){
			
		}
		
	  return sum;	
	}	
	
	/**
	 * 查询新增客户、流失客户
	 * @return
	 */
	public String getQueryCustomerQueryList(){	
		this.authenticateRun();//验证运行权限
        CustomerQuery customer = findBean(CustomerQuery.class, "customerquery");
        String typestr = this.findParameter("type");
        String mytype = this.findParameter("mytype");
        String phone = findParameter("phone");
        String contactNumber = findParameter("contactNumber");
        String payGameId = findParameter("payGameId");
        String loginGameId = findParameter("loginGameId");
        int type = 0;
        if(mytype != null && !"".equals(mytype)){
        	type = Integer.parseInt(mytype);       	
        }      
        if(typestr != null && !"".equals(typestr)){
        	type = Integer.parseInt(typestr);
        }
        
        if(type == 1){
        	logger.info("===开始新增客户查询===");	
        }else if(type == 2){
        	logger.info("===开始流失客户查询===");
        }
        customer.setType(type);
        Integer vipGrade = customer.getVipGrade();
        if(vipGrade != null){
        	if(vipGrade.intValue() == 0){
        		customer.setVipGrade(null);
        	}
        }
        String username = this.currentUserLogo();
        int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
        StringBuffer sb = new StringBuffer();
        sb.append("select count(*) from customerquery where type = "+type);
        sb.append(" and vipGrade<=").append(customerVipGrade);
        if(customer.getUid() != null && !"".equals(customer.getUid())){
        	sb.append(" and uid = "+customer.getUid());
        }
        if(customer.getFromdaytime() != null && !"".equals(customer.getFromdaytime())){
        	sb.append(" and daytime >= '"+customer.getFromdaytime()+"'");
        }        
        if(customer.getTodaytime() != null && !"".equals(customer.getTodaytime())){
        	sb.append(" and daytime < '"+customer.getTodaytime()+"'");
        }
        if(vipGrade !=null && !"".equals(vipGrade)){
        	if(vipGrade.intValue() != 0)
        	   sb.append(" and vipGrade="+vipGrade);
        }  
        if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
            if("1".equals(phone.trim())){//如果选择的是有安全手机的
            	sb.append(" and phone <> '' ");
            }else{
            	sb.append(" and phone = ''");
            }
        }        
        if(loginGameId != null && !"".equals(loginGameId)){
        	sb.append(" and  loginGameId='"+loginGameId+"'");
        }
        if(payGameId != null && !"".equals(payGameId)){
        	sb.append(" and payGameId='"+payGameId+"'");
        }
        if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
            if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
            	sb.append(" and contactNumber <> ''");
            }else{
            	sb.append(" and contactNumber = ''");
            }
        }        
        System.out.println("sql:"+sb);
        PagedFliper pagedFliper = this.getFliper();       
        int count = customerQueryBo.count(sb.toString(), null);
        pagedFliper.setRecordCount(count);
        List<CustomerQuery> list = new ArrayList<CustomerQuery>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());  
        	if(pagedFliper.isNotEmptySortColumn()){ 
        		String str[] = pagedFliper.getSortColumn().split(" ");
        		if(!"daytime".equals(str[0].trim())){
        			page.addOrder("daytime", OrderType.DESC);
        		}
        		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
        	}else{
        		page.addOrder("daytime", OrderType.DESC);
        		page.addOrder("vipGrade", OrderType.DESC);
        	}
        	StringBuffer sqlsb = new StringBuffer();
        	sqlsb.append("  and vipGrade<=").append(customerVipGrade);
        	if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
                if("1".equals(phone.trim())){//如果选择的是有安全手机的
                	sqlsb.append(" and phone <> ''");
                }else{
                	sqlsb.append(" and phone = ''");
                }
            }        
            if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
                if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
                	sqlsb.append(" and contactNumber <> ''");
                }else{
                	sqlsb.append(" and contactNumber = ''");
                }
            }        
            if(loginGameId != null && !"".equals(loginGameId)){
            	sqlsb.append(" and  loginGameId='"+loginGameId+"'");
            }
            if(payGameId != null && !"".equals(payGameId)){
            	sqlsb.append(" and payGameId='"+payGameId+"'");
            }
            list = customerQueryBo.find(customer, sqlsb.toString(), page);
        }

        Sheet<CustomerQuery> sheet = new Sheet<CustomerQuery>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){   	
    	//获得页面查询的数据
    	CustomerQuery customer = findBean(CustomerQuery.class, "customerquery");	
        String typestr = this.findParameter("type");
        String mytype = this.findParameter("mytype");
        String phone = findParameter("phone");
        String contactNumber = findParameter("contactNumber");
        String payGameId = findParameter("payGameId");
        String loginGameId = findParameter("loginGameId");
        int type = 0;
        if(mytype != null && !"".equals(mytype)){
        	type = Integer.parseInt(mytype);       	
        }      
        if(typestr != null && !"".equals(typestr)){
        	type = Integer.parseInt(typestr);
        }
        customer.setType(type);
        Integer vipGrade = customer.getVipGrade();
        if(vipGrade != null){
        	if(vipGrade.intValue() == 0){
        		customer.setVipGrade(null);
        	}
        }
        String username = this.currentUserLogo();
        int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
        PagedFliper pagedFliper = this.getFliper();    
        Page page = new Page();
        if(pagedFliper.isNotEmptySortColumn()){ 
    		String str[] = pagedFliper.getSortColumn().split(" ");
    		if(!"daytime".equals(str[0].trim())){
    			page.addOrder("daytime", OrderType.DESC);
    		}
    		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
    	}else{
    		page.addOrder("daytime", OrderType.DESC);
    		page.addOrder("vipGrade", OrderType.DESC);
    	}
    	StringBuffer sqlsb = new StringBuffer();
    	sqlsb.append("  and vipGrade<=").append(customerVipGrade);
    	if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
            if("1".equals(phone.trim())){//如果选择的是有安全手机的
            	sqlsb.append(" and phone <> ''");
            }else{
            	sqlsb.append(" and phone = ''");
            }
        }        
        if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
            if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
            	sqlsb.append(" and contactNumber <> ''");
            }else{
            	sqlsb.append(" and contactNumber = ''");
            }
        }      
        if(loginGameId != null && !"".equals(loginGameId)){
        	sqlsb.append(" and  loginGameId='"+loginGameId+"'");
        }
        if(payGameId != null && !"".equals(payGameId)){
        	sqlsb.append(" and payGameId='"+payGameId+"'");
        }
    	List<CustomerQuery> crlist = customerQueryBo.find(customer, sqlsb.toString(), page);
    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
	    if(customer.getVipGrade() != null){
	    	sb.append("等级为"+customer.getVipGrade()+"的");
	    }else{
	    	sb.append("所有");
	    }
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
        String title = "";
		//更新标题
        if(type == 1){
        	logger.info("开始新增客户查询导出到excel文件");	
        	 title = sb+"新增客户";
        }else if(type == 2){
        	logger.info("开始流失客户查询导出到excel文件");
        	 title = sb+"流失客户";
        }	   	    
 	    List datas = new ArrayList();
 	    initData(type,datas,crlist);
 	    //生成数据到excel中
		String[] columnName = null;
		if(type == 1){//新增客户
			columnName = new String[]{"UID", "迅雷账号", "VIP等级", "VIP状态","激活游戏数","充值游戏数","付费总金额","最后充值时间","最后充值游戏","最后登录时间","外呼次数","平台总积分","安全手机号","联系电话","QQ","邮箱","最后外呼人","最后外呼时间","专属客服"};
		}else{//流失客户
			columnName = new String[]{"UID", "迅雷账号", "VIP等级", "VIP状态","激活游戏数","充值游戏数","付费总金额","最后充值时间","最后充值游戏","最后登录时间","最后登录游戏","外呼次数","平台总积分","安全手机号","联系电话","QQ","邮箱","最后外呼人","最后外呼时间","专属客服"};
		}
		
		String filePath = type==1?"/tmp/addcustomerquery.xls":"/tmp/lostcustomerquery.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create(type==1?"新增客户":"流失客户",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+(type==1?"_addcustomerdata.xls":"_lostcustomerdata.xls")); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if(datas != null){
				datas.clear();
				datas = null;
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
    private void initData(int type,List datas,List<CustomerQuery> crlist){
    	  for(CustomerQuery cr:crlist){
   	    	List list = new ArrayList();
   	    	list.add(cr.getUid());
   	    	list.add(cr.getAccount());
   	    	list.add(cr.getVipGrade());
   	    	list.add(cr.getVipStatus()==1?"保有":"流失");
   	    	list.add(cr.getGameCount());
   	    	list.add(cr.getPayCount());
   	    	list.add(cr.getPayTotalAmt());
   	    	list.add(cr.getLastPayTime());
   	    	if(type==1){//新增	    		
   	    		Games games = GameCache.getInstance().getGameByGameId(cr.getUpGameId());
   	    		list.add(games ==null?"":games.getGameName());
   	    	}else{//流失
   	    		Games games = GameCache.getInstance().getGameByGameId(cr.getPayGameId());
   	    		list.add(games ==null?"":games.getGameName());
   	    	}
   	    	list.add(cr.getLastLoginTime());
   	    	if(type==2){//流失
   	    		Games games = GameCache.getInstance().getGameByGameId(cr.getLoginGameId());
   	    		list.add(games ==null?"":games.getGameName());
   	    	}
   	    	list.add(cr.getCallCount());
   	    	list.add(cr.getIntegral());
   	    	list.add(cr.getCallCount());
   	    	list.add(cr.getPhone());
   	    	list.add(cr.getContactNumber());
   	    	list.add(cr.getQq());
   	    	list.add(cr.getEmail());
   	    	list.add(cr.getLastCaller());
   	    	list.add(cr.getLastCallTime());
   	    	list.add(cr.getCustomerService());
   	    	datas.add(list);
   	    }	    
    }
    
    public static String getUserIdByUserName(UserInfoProxy userInfoProxy,String userName)
    {
        String userid = null;
        try
        {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(userName, (byte)-1);
            if(userInfo.isOk())
                userid = String.valueOf(userInfo.getUserno());
        }
        catch(Exception e)
        {
            logger.error((new StringBuilder()).append("getUserIdByUserName exception:").append(e).toString());
            throw new XLRuntimeException(e);
        }
        return userid;
    }
    
    
    private void addLoginPay(CustomerDetailQuery customerdetail,Resp_getuserinfo_sec userinfo){
		customerInfoMap.put("auid", customerdetail.getUid());
		customerInfoMap.put("uid", customerdetail.getUid());
		customerInfoMap.put("account", customerdetail.getAccount());			
		long resigterdate =  userinfo.getRegisterdate()==null?0:Long.parseLong(userinfo.getRegisterdate()) * 1000;
		customerInfoMap.put("createTime", resigterdate==0?"":(format.format(resigterdate)));
		customerInfoMap.put("registerType", getUserType(customerdetail.getUid()));
		customerInfoMap.put("vipGrade", customerdetail.getVipGrade());
		customerInfoMap.put("customerService", customerdetail.getCustomerService());
		customerInfoMap.put("vipStatus",customerdetail.getVipStatus()==1?"保有":"流失");
		customerInfoMap.put("phone", customerdetail.getPhone());
		customerInfoMap.put("integral", customerdetail.getIntegral());
		customerInfoMap.put("callCount", customerdetail.getCallCount());
		customerInfoMap.put("rebateCount", customerdetail.getRebateCount());
		customerInfoMap.put("rebateMoney", customerdetail.getRebateMoney());
    }
    
    private void addCustomerBaseInfo(CustomerDetailQuery customerdetail,CustomerInfo customerinfo){		
		if(customerinfo != null){
			customerInfoMap.put("username", customerinfo.getUsername());
			customerInfoMap.put("sex", customerinfo.getSex());
			customerInfoMap.put("age", customerinfo.getAge());
			customerInfoMap.put("birthday", customerinfo==null?customerdetail.getBirthday():(customerinfo.getBirthday()==null||"".equals(customerinfo.getBirthday())?customerdetail.getBirthday():customerinfo.getBirthday()));
			customerInfoMap.put("degree",customerinfo.getDegree());
			customerInfoMap.put("profession", customerinfo.getProfession());
			customerInfoMap.put("area", customerinfo.getArea());
			customerInfoMap.put("qq", customerinfo==null?customerdetail.getQq():(customerinfo.getQq()==null||"".equals(customerinfo.getQq())?customerdetail.getQq():customerinfo.getQq()));
			customerInfoMap.put("email", customerinfo==null?customerdetail.getEmail():(customerinfo.getEmail()==null||"".equals(customerinfo.getEmail())?customerdetail.getEmail():customerinfo.getEmail()));
			customerInfoMap.put("telphone", customerinfo==null?customerdetail.getContactNumber():(customerinfo.getPhone()==null||"".equals(customerinfo.getPhone())?customerdetail.getContactNumber():customerinfo.getPhone()));	
		}else{
			customerInfoMap.put("username", "");
			customerInfoMap.put("sex", "");
			customerInfoMap.put("age", "");
			customerInfoMap.put("birthday",customerdetail.getBirthday());
			customerInfoMap.put("degree","");
			customerInfoMap.put("profession", "");
			customerInfoMap.put("area", "");
			customerInfoMap.put("qq", customerdetail.getQq());
			customerInfoMap.put("email", customerdetail.getEmail());
			customerInfoMap.put("telphone", customerdetail.getContactNumber());
		}
    }
    
    private void defaultCustomerInfo(CustomerDetailQuery customerdetail,Resp_getuserinfo_sec userinfo,String uid){
    	CustomerInfo info = new CustomerInfo();		
		info.setUid(customerdetail.getUid());
		if(!StringTools.isEmpty(uid)){
			uid = uid.trim();
		}
		List<CustomerInfo> customerinfolist = customerInfoBo.find(info, defaultPage);
						
		//获得登录信息
		addLoginPay(customerdetail,userinfo);
				
		setDefaultMap();//设置默认值
		
		//获得用户达到某个VIP等级的时间
		getAveralVipGradeTime(customerInfoMap,gradeList,uid);
		//获得充值信息
		getPlatform(customerInfoMap,uid);											
		//获得客户信息
		CustomerInfo customerinfo = null;
		if(!CollectionUtils.isEmpty(customerinfolist)){
			customerinfo = customerinfolist.get(0);	
		}
		addCustomerBaseInfo(customerdetail,customerinfo);
    }
    
    /**
     * 取得客户详情信息
     * @return
     */
    public Map<String,Object> getCustomerInfo(){
		logger.info("开始客户信息查询");
		this.authenticateRun();//添加权限		
		
		//从session当中去结果集
		HttpServletRequest request = getHttpServletRequest();
		HttpSession session = request.getSession();
		customerInfoMap = (Map<String,Object>)session.getAttribute("customerinfomap");		
		String daytime = format.format(new Date()).split(" ")[0];
		String username = this.currentUserLogo();
		int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
		String uid = findParameter("uid");			
		String puid = findParameter("puid");
		if(!StringTools.isEmpty(puid))uid = puid;		
		String account = findParameter("account");
		if(StringTools.isEmpty(uid)&& StringTools.isEmpty(account)){
			if(customerInfoMap != null){
				customerInfoMap.clear();
				customerInfoMap  = null;
			}
			return null;
		}
	
		if(customerInfoMap == null){						
			customerInfoMap = new HashMap<String,Object>();
			CustomerDetailQuery customer = new CustomerDetailQuery();
			if(!StringTools.isEmpty(uid))
			    customer.setUid(uid);
			if(!StringTools.isEmpty(account))
				customer.setAccount(account);
			List<CustomerDetailQuery> customerdetaillist =  customerDetailQueryBo.find(customer, defaultPage);
			UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();	
			Resp_getuserinfo_sec userinfo = getUserInfo(userInfoProxy,uid);	
			Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
			if(!StringTools.isEmpty(account)){//如果账号不为空则按照账号的值为准
				uid = getUserIdByUserName(userInfoProxy,account);
			}
			if(StringTools.isEmpty(uid)){
				if(customerInfoMap != null){
					customerInfoMap.clear();
					customerInfoMap  = null;
				}
				return null;
			}
			if(CollectionUtils.isEmpty(customerdetaillist)){//如果不是大客户
				getCustomerBaseInfo(userInfoProxy,userinfo,userinfobase,uid,account);	
				getPlatform(customerInfoMap,uid);
				if(StringTools.isEmpty(account)){
					customerInfoMap.put("account", userinfobase.getUsrname());
				}else{
					customerInfoMap.put("account", account);
				}	
				String lastLoginTime = (String)customerInfoMap.get("lastLoginTime");
				boolean loststatus = checkCustomerIsLost(daytime,lastLoginTime,1);
				customerInfoMap.put("vipStatus",loststatus?"流失":"保有");
				return customerInfoMap;
			}
			CustomerDetailQuery customerdetail = customerdetaillist.get(0);
            if(customerdetail.getVipGrade()>customerVipGrade)return customerInfoMap;//详情页面权限控制
			//初始化
            defaultCustomerInfo(customerdetail,userinfo,uid);
						
			session.setAttribute("customerinfomap", customerInfoMap);
		}else{
			String muid = (String)customerInfoMap.get("uid");
			String maccount = (String)customerInfoMap.get("account");
            if(!StringTools.isEmpty(muid) && !StringTools.isEmpty(uid) && uid.equals(muid)){
            	return customerInfoMap;
            }
            if(!StringTools.isEmpty(maccount) && !StringTools.isEmpty(account) && account.equals(maccount)){
            	return customerInfoMap;
            }          
            customerInfoMap = new HashMap();
			CustomerDetailQuery customer = new CustomerDetailQuery();
			if(uid != null && !"".equals(uid))
			    customer.setUid(uid);
			if(account != null && !"".equals(account))
				customer.setAccount(account);
			UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();	
			Resp_getuserinfo_sec userinfo = getUserInfo(userInfoProxy,uid);	
			Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
			if(!StringTools.isEmpty(account)){//如果账号不为空则按照账号的值为准
				uid = getUserIdByUserName(userInfoProxy,account);
			}
			List<CustomerDetailQuery> customerdetaillist =  customerDetailQueryBo.find(customer,defaultPage);	
			if(customerdetaillist == null || customerdetaillist.size()==0){//如果不是大客户
				if(!uid.equals(muid)){//如果不是之前缓存的uid
					if(customerdetaillist == null || customerdetaillist.size()==0){
						if(StringTools.isEmpty(uid)){
							if(customerInfoMap != null){
								customerInfoMap.clear();
								customerInfoMap  = null;
							}
							return null;
						}
						getCustomerBaseInfo(userInfoProxy,userinfo,userinfobase,uid,account);		
						getPlatform(customerInfoMap,uid);
						if(StringTools.isEmpty(account)){
							customerInfoMap.put("account", userinfobase.getUsrname());
						}else{
							customerInfoMap.put("account", account);
						}						
						String lastLoginTime = (String)customerInfoMap.get("lastLoginTime");
						boolean loststatus = checkCustomerIsLost(daytime,lastLoginTime,1);
						customerInfoMap.put("vipStatus",loststatus?"流失":"保有");
					}
				   return customerInfoMap;
		     	}
			}
			CustomerDetailQuery customerdetail = customerdetaillist.get(0);
			if(customerdetail.getVipGrade()>customerVipGrade)return customerInfoMap;//详情页面权限控制
			
			//初始化
            defaultCustomerInfo(customerdetail,userinfo,uid);
			
			session.setAttribute("customerinfomap", customerInfoMap);
		}
		return customerInfoMap;
	}
    
    
    private void setDefaultMap(){
    	customerInfoMap.put("vip1", "-");
		customerInfoMap.put("vip2", "-");
		customerInfoMap.put("vip3", "-");
		customerInfoMap.put("vip4", "-");
		customerInfoMap.put("vip5", "-");
		customerInfoMap.put("vip6", "-");
		customerInfoMap.put("vip7", "-");
		customerInfoMap.put("vip8", "-");
		customerInfoMap.put("vip9", "-");
		customerInfoMap.put("vip10", "-");
    }
    
    private void getCustomerBaseInfo(UserInfoProxy userInfoProxy,
    		Resp_getuserinfo_sec userinfo,
    		Resp_getuserinfo_base userinfobase,
    		String uid,
    		String account){
		customerInfoMap.put("auid", uid);
		customerInfoMap.put("uid", uid);
		long resigterdate =  userinfo.getRegisterdate()==null?0:Long.parseLong(userinfo.getRegisterdate()) * 1000;
		customerInfoMap.put("createTime", resigterdate==0?"":(format.format(resigterdate)));
		String registerType = getUserType(uid);
		logger.info("registerType==================>"+registerType);
		customerInfoMap.put("registerType", registerType);
		customerInfoMap.put("vipGrade", 0);
		customerInfoMap.put("phone",userinfo.getMobile() );
		customerInfoMap.put("integral",getBonusSum(uid));
		customerInfoMap.put("callCount", 0);
		customerInfoMap.put("rebateCount", 0);
		customerInfoMap.put("rebateMoney", 0);
		CustomerInfo query = new CustomerInfo();
		query.setUid(uid);		
		CustomerInfo customerinfo = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		if(customerinfo == null){//如果没有收集过相关记录
			customerInfoMap.put("username", userinfo.getTruename());
			customerInfoMap.put("sex", userinfobase.getSex());
			customerInfoMap.put("age", "");
			customerInfoMap.put("birthday", userinfobase.getBirthday());
			customerInfoMap.put("degree","");
			customerInfoMap.put("profession", "");
			customerInfoMap.put("area", userinfobase.getCity());
			customerInfoMap.put("qq",userinfo.getQq());
			customerInfoMap.put("email", userinfo.getMail());
			customerInfoMap.put("telphone", userinfo.getTelphone());				
		}else{
			customerInfoMap.put("username", (StringTools.isEmpty(customerinfo.getUsername())?userinfo.getTruename():customerinfo.getUsername()));
			customerInfoMap.put("sex", (StringTools.isEmpty(customerinfo.getSex())?userinfobase.getSex():customerinfo.getSex()));
			customerInfoMap.put("age", customerinfo.getAge());
			customerInfoMap.put("birthday", (StringTools.isEmpty(customerinfo.getBirthday())?userinfobase.getBirthday():customerinfo.getBirthday()));
			customerInfoMap.put("degree",customerinfo.getDegree());
			customerInfoMap.put("profession", customerinfo.getProfession());
			customerInfoMap.put("area", (StringTools.isEmpty(customerinfo.getArea())?userinfobase.getCity():customerinfo.getArea()));
			customerInfoMap.put("qq",(StringTools.isEmpty(customerinfo.getQq())?userinfo.getQq():customerinfo.getQq()));
			customerInfoMap.put("email", (StringTools.isEmpty(customerinfo.getEmail())?userinfo.getMail():customerinfo.getEmail()));
			customerInfoMap.put("telphone", (StringTools.isEmpty(customerinfo.getPhone())?userinfo.getTelphone():customerinfo.getPhone()));				
		}						        	
    }
    
   
    public void getAveralVipGradeTime(Map<String,Object> map,List<CustomerGrade> gradeList,String uid){
    	if(StringTools.isEmpty(uid))return ;
    	String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(payhistoryurl+"?uid="+uid);
    	if(StringTools.isEmpty(jsonStr)){
    		return ;
    	}
    	try {
			JSONObject returnObject = new JSONObject(jsonStr);
			String result = returnObject.getString("list");
			JSONArray jsonArray = new JSONArray(result);
			int size = jsonArray.length();
			double viptotal = 0;			
			int lastVipGrade = 0;
			for (int i = 0; i < size; i++) {
				JSONObject jsonObj = jsonArray.getJSONObject(i);
				viptotal += (Integer)jsonObj.get("payTotal");
		    	int vipGrade = isInGrade(gradeList,viptotal);		
		    	if(lastVipGrade == vipGrade)continue;
		    	lastVipGrade = vipGrade;
		    	map.put("vip"+vipGrade,  (String)jsonObj.get("payTime"));//取得满足金额档时最近的时间
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
    }
    
    /**
     * 查询达到VIP各等级所需的时间
     * @param map
     * @param uid
     */
    public  void queryAveralVipGradeTime(Map<String,Object> map,List<CustomerGrade> gradeList,String uid){
        if(StringTools.isEmpty(uid))return ;
		String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(getPayRecord+"uid="+uid);
		logger.info("jsonStr============================>"+jsonStr);
		if(jsonStr == null||"".equals(jsonStr)){
			return;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonPayRecord record = mapper.readValue(jsonStr, JsonPayRecord.class);
			//绑定游戏详情数据
			List<PayRecord> recordList = record.getList();
			double viptotal = 0;				
		    for(int i=recordList.size()-1;i>=0;i--){
		    	PayRecord pr = recordList.get(i);
		    	viptotal += pr.getPayTotal();
		    	int vipGrade = isInGrade(gradeList,viptotal);			    		
		    	map.put("vip"+vipGrade, pr.getPayTime());//取得满足金额档时最近的时间
	    		for(int j=1;j<vipGrade;j++){
	    			String value = (String)map.get("vip"+j);
	    			if("-".equals(value)){
	    				map.put("vip"+j, pr.getPayTime());
	    			}
	    		}
		    }			
		} catch (Exception e) {
			logger.error("queryAveralVipGradeTime,jsonStr:"+jsonStr,e);
		}
    }
    
    /**
	 * 调用远程接口查询用户信息
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_sec getUserInfo(UserInfoProxy userInfoProxy,String uid){	
		Resp_getuserinfo_sec userinfosec = userInfoProxy.getuserinfo_sec(uid, (byte)2);
		return userinfosec;
	}
      
	
	/**
	 * 格式化日期 （将yyyy-MM-dd格式的日期，转换为yyyyMMdd格式的日期）
	 * @param time
	 * @return
	 */
	public String formatDay(String time){
		if(time != null){
			if(time.length() <= 8)return time;
			String stimes[] = time.split("-");
			time = stimes[0]+stimes[1]+stimes[2];
		}	
		return time;
	}
	
	/**
	 * 判断某金额是否达到某VIP等级
	 * @param gradeList
	 * @param viptotal
	 * @param base
	 * @return
	 */
	private int isInGrade(List<CustomerGrade> gradeList,double viptotal){
		for(CustomerGrade grade:gradeList){			
			if(viptotal >= grade.getAmountFrom() && viptotal <= grade.getAmountTo()){
				return grade.getVipGrade();
			}
		}
		return 0;
	}

    
    /**
     * 编辑客户信息
     * @return
     */
    public String update(){
    	logger.info("开始修改客户信息");
    	String uid = findParameter("uid");  	
    	String username = findParameter("username");
    	String sex = findParameter("sex");
    	String age = findParameter("age");
    	String birthday = findParameter("birthday");
    	String degree = findParameter("degree");
    	String profession = findParameter("profession");
    	String area = findParameter("area");
    	String qq = findParameter("qq");
    	String email = findParameter("email");
    	String telphone = findParameter("telphone");
    	CustomerInfo customerInfo = new CustomerInfo();
    	customerInfo.setUid(uid);
    	if(!StringTools.isEmpty(telphone)){
    		if("0".equals(telphone))telphone="";
    	}
     	if(!StringTools.isEmpty(qq)){
    		if("0".equals(qq))qq="";
    	}
    	if(!StringTools.isEmpty(telphone)||!StringTools.isEmpty(qq)||!StringTools.isEmpty(birthday)){    		
        	CustomerDetailQuery cdq = new CustomerDetailQuery();
        	cdq.setUid(uid);
        	List<CustomerDetailQuery> cdqlist =  customerDetailQueryBo.find(cdq,defaultPage);
        	if(cdqlist == null || cdqlist.size()==0){
        		return "";
        	}
        	CustomerDetailQuery customer = cdqlist.get(0);
        	if(!StringTools.isEmpty(telphone))
        	   customer.setContactNumber(telphone);//联系方式
        	if(!StringTools.isEmpty(qq))
        		customer.setQq(qq);
        	if(!StringTools.isEmpty(birthday))
        		customer.setBirthday(birthday);
        	customerDetailQueryBo.update(customer);
    	}
    	List<CustomerInfo> customerinfolist = customerInfoBo.find(customerInfo, defaultPage);
    	if(customerinfolist == null || customerinfolist.size()==0){//如果数据库中没有这条记录，则需要新增一条
    		customerInfo.setUid(uid);
    		customerInfo.setUsername(username);
    		customerInfo.setSex(sex);
    		customerInfo.setAge(age == null||"".equals(age)?null:Integer.parseInt(age));
    		customerInfo.setBirthday(birthday);
    		customerInfo.setDegree(degree);
    		customerInfo.setProfession(profession);
    		customerInfo.setArea(area);
    		customerInfo.setQq(qq);
    		customerInfo.setEmail(email);
    		customerInfo.setPhone(telphone);
    		customerInfo.setCheckFlag(true);
    		customerInfo.setCheckPhone(false);
    		customerInfoBo.insert(customerInfo);
    	}else{//如果数据库中有这个条记录，则需要修改
    		CustomerInfo info = customerinfolist.get(0);
    		info.setUid(uid);
    		info.setUsername(username);
    		info.setSex(sex);
    		info.setAge((age == null||"".equals(age))?null:Integer.parseInt(age));
    		info.setBirthday(birthday);
    		info.setDegree(degree);
    		info.setProfession(profession);
    		info.setArea(area);
    		info.setQq(qq);
    		info.setEmail(email);
    		info.setPhone(telphone);
    		customerInfoBo.update(info);
    	}
    	//从session当中去结果集
		HttpServletRequest request = getHttpServletRequest();
		HttpSession session = request.getSession();
		customerInfoMap = (Map<String,Object>)session.getAttribute("customerinfomap");		
		if(customerInfoMap != null){
			customerInfoMap.put("username", username);
			customerInfoMap.put("sex", sex);
			customerInfoMap.put("age", age);
			customerInfoMap.put("birthday", birthday);
			customerInfoMap.put("degree",degree);
			customerInfoMap.put("profession", profession);
			customerInfoMap.put("area", area);
			customerInfoMap.put("qq", qq);
			customerInfoMap.put("email", email);
			customerInfoMap.put("telphone", telphone);
		}
    	return "";
    }
    
    /**
	 * 比较两个时间相隔多少天
	 *  
	 * @param fromtime 格式 yyyy-MM-dd
	 * @param totime   格式 yyyy-MM-dd
	 * @return
	 */
	public long compareTime(String fromtime,String totime){
		if(StringTools.isEmpty(totime))return 1000;
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
        try{
        	one = df.parse(fromtime);  
        	two = df.parse(totime); 
        	long time1 = one.getTime();  
        	long time2 = two.getTime();  
        	long diff = time1 - time2;
        	days = diff / (1000 * 60 * 60 * 24);  
        }catch(ParseException  e){
        	e.printStackTrace();  
        }
		return days;
	}
	
	private String beforeDay(){
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		return sdf.format(cal.getTime());
	}
	private String getResult(String uid,String beforeTime){
		if(StringTools.isNotEmpty(uid)){
			uid = uid.trim();
		}
		//获得当前时间前一天的日期
			String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+beforeTime);
			return jsonStr;
	}
	
	/**
	 * 获得平台的登录和充值记录
	 */
	public void getPlatform(Map<String,Object> map,String myuid){
        String uid = findParameter("uid");
        String suid = findParameter("suid");
        suid = suid == null?"":suid.trim();
        uid = uid == null?"":uid.trim();
        if(!StringTools.isEmpty(suid)){
        	uid = suid;
        }
        if(!StringTools.isEmpty(myuid)){
        	uid = myuid;
        }
        if(StringTools.isEmpty(uid))return;
        uid = uid.trim();
    	String beforetime = beforeDay();
    	String jsonStr = getResult(uid,beforetime);
		if(StringTools.isEmpty(jsonStr)){
			return ;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();								
			if(recordList == null||recordList.size()==0)return ;
			String firstLoginTime = null;//游戏的首次登录时间
			String lastLoginTime = null;//游戏的最后登录时间
			String firstPayTime = null;//游戏的首次充值时间
			String lastPayTime = null;//游戏的最后充值时间
			double payTotal = 0L;//充值金额
			long payCount = 0L;//充值次数
			long gameCount = 0L;//激活游戏数
			long serverCount= 0L;//激活区服数
			long payGameCount = 0L;//充值游戏数
			long payServerCount = 0L;//充值区服数
			Set<String> game = new HashSet<String>();
			Set<String> pay = new HashSet<String>();
			for(int i=0;i<recordList.size();i++){
				Record rd = recordList.get(i);
                payTotal += rd.getPayAmt();
                payCount += rd.getPayTimes();
                if(firstLoginTime==null){
                	firstLoginTime = rd.getFirstLoginTime();
                }else{
                	firstLoginTime = rd.getFirstLoginTime()==null||"".equals(rd.getFirstLoginTime())?firstLoginTime:(firstLoginTime==null||"".equals(firstLoginTime)?rd.getFirstLoginTime():(compareTime(firstLoginTime,rd.getFirstLoginTime())>0?rd.getFirstLoginTime():firstLoginTime));
                }
                if(lastLoginTime==null){
                	lastLoginTime = rd.getFirstLoginTime();
                }else{
                	lastLoginTime = rd.getLastLoginTime()==null||"".equals(rd.getLastLoginTime())?lastLoginTime:(lastLoginTime==null||"".equals(lastLoginTime)?rd.getLastLoginTime():(compareTime(lastLoginTime,rd.getLastLoginTime())<0?rd.getLastLoginTime():lastLoginTime));
                }
                if(firstPayTime==null){
                	firstPayTime = rd.getFirstPayTime();
                }else{
                	firstPayTime = rd.getFirstPayTime()==null||"".equals(rd.getFirstPayTime())?firstPayTime:(firstPayTime==null||"".equals(firstPayTime)?rd.getFirstPayTime():(compareTime(firstPayTime,rd.getFirstPayTime())>0?rd.getFirstPayTime():firstPayTime));
                }
                if(lastPayTime==null){
                	lastPayTime = rd.getLastPayTime();
                }else{
                	lastPayTime = rd.getLastPayTime()==null||"".equals(rd.getLastPayTime())?lastPayTime:(lastPayTime==null||"".equals(lastPayTime)?rd.getLastPayTime():(compareTime(lastPayTime,rd.getLastPayTime())<0?rd.getLastPayTime():lastPayTime));
                }
                
                if(rd.getFirstLoginTime() != null&& !"".equals(rd.getFirstLoginTime())){
                	serverCount++;
                	game.add(rd.getGameId());
                }
                if(rd.getFirstPayTime() != null && !"".equals(rd.getFirstPayTime())){
                	payServerCount ++;
                	pay.add(rd.getGameId());
                }
			}		
			gameCount = game.size();
			payGameCount = pay.size();
			map.put("gameCount", gameCount);
			map.put("serverCount", serverCount);
			map.put("payServerCount", payServerCount);
			map.put("payGameCount", payGameCount);
			map.put("payTotalAmt", payTotal==0?"0.0":myformat.format(new Double(payTotal)));
			map.put("payCount", payCount);
			map.put("averagePayAmt", payTotal==0?"0.0":myformat.format(new Double(payTotal/payCount)));
			map.put("firstLoginTime", firstLoginTime);
			map.put("lastLoginTime", lastLoginTime);
			long notLoginDays = lastLoginTime==null||"".equals(lastLoginTime)?0:(compareTime(beforetime,lastLoginTime)<0?0:compareTime(beforetime,lastLoginTime));
			map.put("notLoginDays", notLoginDays<0?0:notLoginDays);
			map.put("firstPayTime", firstPayTime);
			map.put("lastPayTime", lastPayTime);
			long notPayDays =  lastPayTime==null||"".equals(lastPayTime)?0:(compareTime(beforetime,lastPayTime)<0?0:compareTime(beforetime,lastPayTime));
			map.put("notPayDays",notPayDays<0?0:notPayDays);
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 获得游戏的充值记录
	 * @return
	 */
	public void getQueryGameList(){
		logger.info("开始游戏充值和登录记录查询");
        String uid = findParameter("uid");
        String suid = findParameter("suid");
        String account = findParameter("account");        
        suid = suid == null?"":suid.trim();
        uid = uid == null?"":uid.trim();
        if("".equals(uid)){
        	uid = suid;
        }
        if(account != null && !"".equals(account)){
        	CustomerDetailQuery customer = new CustomerDetailQuery();
            customer.setAccount(account);
            List<CustomerDetailQuery> customerdetaillist =  customerDetailQueryBo.find(customer, defaultPage);
            if(customerdetaillist != null && customerdetaillist.size()>0){
            	CustomerDetailQuery cdq = customerdetaillist.get(0);
            	uid = cdq.getUid();
            }
        }                
        if("".equals(uid))return;
    	String beforetime = beforeDay();
    	String jsonStr = getResult(uid,beforetime);
		if(StringTools.isEmpty(jsonStr)){
			return ;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);			
			//绑定游戏详情数据
			List<Record> recordList = record.getList();					
			
			if(recordList == null||recordList.size()==0)return ;
			String baseGameId = recordList.get(0).getGameId();//基础游戏编号
			GameServerVo gsvs = new GameServerVo();
			String firstLoginTime = null;//游戏的首次登录时间
			String lastLoginTime = null;//游戏的最后登录时间
			String firstPayTime = null;//游戏的首次充值时间
			String lastPayTime = null;//游戏的最后充值时间
			double payTotal = 0L;//充值金额
			long payCount = 0L;//充值次数
			long gameCount = 0L;//激活区服数
			String gameName = null;//游戏名称
			for(int i=0;i<recordList.size();i++){
				Record rd = recordList.get(i);
				if(baseGameId.trim().equals(rd.getGameId().trim())){
					gameName = URLDecoder.decode(rd.getGameName(),"utf8");
					if(firstLoginTime == null)
						firstLoginTime = rd.getFirstLoginTime()==null?null:rd.getFirstLoginTime();
					else
						firstLoginTime  = firstLoginTime==null||"".equals(firstLoginTime)?rd.getFirstLoginTime():(rd.getFirstLoginTime()==null||"".equals(rd.getFirstLoginTime()))?firstLoginTime:(compareTime(firstLoginTime,rd.getFirstLoginTime()) < 0? firstLoginTime:rd.getFirstLoginTime());
					if(firstPayTime == null||"".equals(firstPayTime))
						firstPayTime = rd.getFirstPayTime()==null?"":rd.getFirstPayTime();
					else
						firstPayTime  = (rd.getFirstPayTime()==null||"".equals(rd.getFirstPayTime()))||"".equals(rd.getFirstPayTime())?firstPayTime:(compareTime(firstPayTime,rd.getFirstPayTime()) < 0? firstPayTime:rd.getFirstPayTime());					
					if(lastLoginTime == null||"".equals(lastLoginTime))
						lastLoginTime = rd.getLastLoginTime()==null?null:rd.getLastLoginTime();
					else
						lastLoginTime  = (rd.getLastLoginTime()==null||"".equals(rd.getLastLoginTime()))?lastLoginTime:(compareTime(lastLoginTime,rd.getLastLoginTime()) > 0? lastLoginTime:rd.getLastLoginTime());
					if(lastPayTime == null||"".equals(lastPayTime))
						lastPayTime = rd.getLastPayTime()==null?null:rd.getLastPayTime();
					else
						lastPayTime  = (rd.getLastPayTime()==null||"".equals(rd.getLastPayTime()))?lastPayTime:(compareTime(lastPayTime,rd.getLastPayTime()) > 0? lastPayTime:rd.getLastPayTime());
						
					payTotal += rd.getPayAmt();	//充值总金额
					payCount += rd.getPayTimes();//充值总次数
					gameCount ++;//激活区服数
					
				}else{
					gsvs.setGameName(gameName);
					gsvs.setGameCount(gameCount);
					gsvs.setPayTotalAmt(payTotal==0?"0.0":myformat.format(new Double(payTotal)));
					gsvs.setPayCount(payCount);
					gsvs.setAverageAmt(payTotal==0?"0.0":myformat.format(new Double(payTotal/payCount)));
					gsvs.setFirstPayTime(firstPayTime);
					gsvs.setLastPayTime(lastPayTime);
					gsvs.setNotPayDays(lastPayTime == null || "".equals(lastPayTime)?0:compareTime(beforetime,lastPayTime));
					gsvs.setGameTime(firstLoginTime);
					gsvs.setLastLoginTime(lastLoginTime);
					gsvs.setNotLoginDays(lastLoginTime == null || "".equals(lastLoginTime)?0:compareTime(beforetime,lastLoginTime));
					gameLists.add(gsvs);
					
					//还原变量
					gsvs = new GameServerVo();
					baseGameId = rd.getGameId().trim();
					payTotal = 0L;//充值金额
					payCount = 0L;//充值次数
					gameCount = 0L;//激活区服数
					gameName = URLDecoder.decode(rd.getGameName(),"utf8");
					firstLoginTime = rd.getFirstLoginTime()==null?null:rd.getFirstLoginTime();
					firstPayTime = rd.getFirstPayTime()==null?null:rd.getFirstPayTime();				
					lastLoginTime = rd.getLastLoginTime()==null?null:rd.getLastLoginTime();
					lastPayTime = rd.getLastPayTime()==null?null:rd.getLastPayTime();					
					payTotal += rd.getPayAmt();	//充值总金额
					payCount += rd.getPayTimes();//充值总次数
					gameCount ++;//激活区服数
				}
				
				if(i == recordList.size()-1){//如果是最后一条记录
					gsvs.setGameName(gameName);
					gsvs.setGameCount(gameCount);
					gsvs.setPayTotalAmt(payTotal==0?"0.0":myformat.format(new Double(payTotal)));
					gsvs.setPayCount(payCount);
					gsvs.setAverageAmt(payTotal==0?"0.0":myformat.format(new Double(payTotal/payCount)));
					gsvs.setFirstPayTime(firstPayTime);
					gsvs.setLastPayTime(lastPayTime);
					gsvs.setNotPayDays((rd.getLastPayTime()==null||"".equals(rd.getLastPayTime()))?0:compareTime(beforetime,lastPayTime));
					if(gsvs.getNotPayDays()<0){
						gsvs.setNotPayDays(0L);
					}
					gsvs.setGameTime(rd.getFirstLoginTime());
					gsvs.setLastLoginTime(lastLoginTime);
					gsvs.setNotLoginDays((rd.getLastLoginTime()==null||"".equals(rd.getLastLoginTime()))?0:compareTime(beforetime,lastLoginTime));
					if(gsvs.getNotLoginDays()<0){
						gsvs.setNotLoginDays(0L);
					}
			
					gameLists.add(gsvs);
				}
			}			
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 获得游戏和区服的充值记录
	 */
	public String getQueryGameDetailList(){
		logger.info("开始游戏区服的充值和登录记录查询");
		detailLists.clear();
		gameLists.clear();		
		getQueryGameList();
		bindDatas();		
		PagedFliper pagedFliper = this.getFliper();
		int pageNo = pagedFliper.getPageNo();
        int pageSize = pagedFliper.getPageSize();
        if(pageNo<=0)pageNo = 1;
        int count = detailLists.size();
        pagedFliper.setRecordCount(count);     
        List<GameServerVo> result = new ArrayList<GameServerVo>();
        int pageTotal = count%pageSize==0?count/pageSize:count/pageSize+1;   
        rownum = 1;
        rownum2 = 1;
        if(pageTotal <= 1){
        	for(int i=0;i<count;i++){
        		result.add(detailLists.get(i));
        	}
        }else{
        	int addcount = count%pageSize==0?pageSize:count%pageSize;
        	if(pageNo <= pageTotal-1)addcount = pageSize;       	
        	for(int i = (pageNo-1)*pageSize;i<((pageNo-1)*pageSize+addcount);i++){
            	result.add(detailLists.get(i));
            }
        }
        Sheet<GameServerVo> sheet = new Sheet<GameServerVo>(count, result);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 此方法调用接口，解析数据，并且封装到集合中
	 * @return
	 */
	public void bindDatas(){		
        String uid = findParameter("uid");
        String suid = findParameter("suid");
        String account = findParameter("account");
        suid = suid == null?"":suid.trim();
        uid = uid == null?"":uid.trim();
        if("".equals(uid)){
        	uid = suid;
        }
        if(account != null && !"".equals(account)){
        	CustomerDetailQuery customer = new CustomerDetailQuery();
            customer.setAccount(account);
            List<CustomerDetailQuery> customerdetaillist =  customerDetailQueryBo.find(customer, defaultPage);
            if(customerdetaillist != null && customerdetaillist.size()>0){
            	CustomerDetailQuery cdq = customerdetaillist.get(0);
            	uid = cdq.getUid();
            }
        }
        if(StringTools.isEmpty(uid))return ;
        uid = uid.trim();
    	//获得当前时间前一天的日期
		Calendar cal = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		cal.add(Calendar.DAY_OF_MONTH, -1);	
		String beforetime = sdf.format(cal.getTime());
		String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(customerInterface+"uid="+uid+"&date="+beforetime);
		if(jsonStr == null){
			return;
		}
		ObjectMapper mapper = new ObjectMapper();
		try {
			JsonRecord record = mapper.readValue(jsonStr, JsonRecord.class);
			//绑定游戏详情数据
			List<Record> recordList = record.getList();
			for(Record detail:recordList){
				GameServerVo gsv = new GameServerVo();
				gsv.setGameName(URLDecoder.decode(detail.getGameName(),"utf8"));
				gsv.setGameServerId(detail.getServerId());
				gsv.setPayTotalAmt(detail.getPayAmt()==0?"0.0":myformat.format(new Double(detail.getPayAmt())));
				gsv.setPayCount(detail.getPayTimes());
				gsv.setAverageAmt(detail.getPayAmt()==0?"0.0":myformat.format(new Double(detail.getPayTimes()==0?0:detail.getPayAmt()/detail.getPayTimes())));
				gsv.setFirstPayTime(detail.getFirstPayTime());
				gsv.setLastPayTime(detail.getLastPayTime());
				long paydays = compareTime(beforetime,gsv.getLastPayTime());
				gsv.setNotPayDays((gsv.getLastPayTime()==null||"".equals(gsv.getLastPayTime()))?0:(paydays<0?0:paydays));
				gsv.setGameTime(detail.getFirstLoginTime());
				gsv.setLastLoginTime(detail.getLastLoginTime());
				long logindays = compareTime(beforetime,gsv.getLastLoginTime());
				gsv.setNotLoginDays((gsv.getLastLoginTime()==null||"".equals(gsv.getLastLoginTime()))?0:(logindays<0?0:logindays));
				detailLists.add(gsv);
			}
		} catch (JsonParseException e) {
			e.printStackTrace();
		} catch (JsonMappingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 判断玩家是否流失
	 * @param time
	 * @param lastLoginTime
	 * @param vipGrade
	 * @return
	 * @throws Exception
	 */
	public  boolean checkCustomerIsLost(String time,String lastLoginTime,int vipGrade){
		if(StringTools.isEmpty(lastLoginTime))return true;
		if(vipGrade>=1 && vipGrade <= 7){
			if(compareTime(time,lastLoginTime) >= 5)return true;
		}else if(vipGrade >= 8 && vipGrade <= 10){
			if(compareTime(time,lastLoginTime) >= 2)return true;
		}
		return false;
	}
	
	//查询用户的会员类型：0表示不是会员 2普通会员 3白金会员 4钻石会员
	public String getUserType(String uid){
		try {
			String responseStr = HttpClientUtil.getInfoForHttpGetMothed(userTypeUrl+"userid="+uid+"&protocol_version=110&secure=true");
			if(responseStr != null){
				String strs[] = responseStr.split("&");
				responseStr = strs[strs.length-1];
				if(responseStr != null){
					responseStr = responseStr.split("=")[1];
					if(responseStr != null && !"".equals(responseStr)){
						responseStr = responseStr.trim();
						logger.info("responseStr========================>"+responseStr);
						long ii = Long.parseLong(responseStr);
						if(ii == 2){
							return "普通会员";
						}else if(ii == 3){
							return "白金会员";
						}else if(ii == 4){
							return "钻石会员";
						}else{
							return "非会员";
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "非会员";
	}
	
	
	
	/**
	 * 格式化日期
	 * @param day
	 * @return
	 */
	public String formatTime(String lastlogin){
		if(lastlogin==null||"".equals(lastlogin.trim()))return "";	
		if(lastlogin.length()<8&&lastlogin.length()>3){			
			return "";
		}
		String year = lastlogin.substring(0, 4);		
  		String tmp = lastlogin.substring(4, 8);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2);
        return year+"-"+month+"-"+day;
	}
	
	/**
	 * 格式化年份
	 * @param time
	 * @return
	 */
	public String timeHandle(String time){
		String year = time.substring(0, 1);		
  		String tmp = time.substring(1, 5);		
        String month = tmp.substring(0,2);
        String day = tmp.substring(2); 
    	if("1".equals(year)){
    		year = "2011";
    	}else if("2".equals(year)){
    		year = "2012";
    	}else if("3".equals(year)){
    		year = "2013";
    	}else if("4".equals(year)){
    		year = "2014";
    	}else if("5".equals(year)){
    		year = "2015";
    	}else if("6".equals(year)){
    		year = "2016";
    	}else if("7".equals(year)){
    		year = "2017";
    	}else if("8".equals(year)){
    		year = "2018";
    	}else if("9".equals(year)){
    		year = "2019";
    	}   	
    	time = year+"-"+month+"-"+day;
		return time;
	}
	


	public int getRownum2() {
		return rownum2++;
	}

	public void setRownum2(int rownum2) {
		this.rownum2 = rownum2;
	}

	public List<GameServerVo> getGameLists() {
		return gameLists;
	}

	public void setGameLists(List<GameServerVo> gameLists) {
		this.gameLists = gameLists;
	}	
	
	static class JsonPayRecord{
		private List<PayRecord> list = null;

		public List<PayRecord> getList() {
			return list;
		}

		public void setList(List<PayRecord> list) {
			this.list = list;
		}
		
	}

	public Map<String, Object> getCustomerInfoMap() {
		return customerInfoMap;
	}

	public void setCustomerInfoMap(Map<String, Object> customerInfoMap) {
		this.customerInfoMap = customerInfoMap;
	}
}
