package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CustomerInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;

/**
 * 客户信息业务处理类
 * @author lisu
 * 2013-02-22
 */
public class CustomerInfoManagedBean extends BaseManagedBean {
    private CustomerInfoBo customerInfoBo;
    private static final Logger logger = Logger.getLogger(CustomerInfoManagedBean.class.getName());
 
	public CustomerInfoManagedBean(){
		customerInfoBo =  FacadeFactory.INSTANCE.getCustomerInfoBo();
	}

	
	/**
	 * 查询客户信息
	 * @return
	 */
	public String getQueryCustomerInfoList(){
		logger.info("开始客户信息查询");
        this.authenticateRun();//验证运行权限
        CustomerInfo info = findBean(CustomerInfo.class, "customerinfo");
        PagedFliper pagedFliper = this.getFliper();
        int count = customerInfoBo.count(info);
        pagedFliper.setRecordCount(count);
        List<CustomerInfo> list = new ArrayList<CustomerInfo>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("vipGrade", OrderType.ESC);
            list = customerInfoBo.find(info,page);
        }
        Sheet<CustomerInfo> sheet = new Sheet<CustomerInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	/**
	 * 新增客户信息
	 * @return
	 */
	public void add(){
		logger.info("开始客户信息添加");
		//this.authenticateAdd();//添加权限	
		try{
			CustomerInfo info = findBean(CustomerInfo.class, "customerinfo");	
			
			if(info==null){
				logger.info("客户信息为空");
				throw new XLRuntimeException("客户信息为空");
			}

			info.setInputby(currentUserLogo());
			info.setInputtime(now());
			customerInfoBo.insert(info);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
	}
	
	/**
	 * 修改客户信息
	 * @return
	 */
	public String edit(){
		logger.info("开始客户信息修改");
		//this.authenticateEdit();//编辑权限
		CustomerInfo info = findBean(CustomerInfo.class, "customerinfo");
		try{
			if(info==null){
				logger.info("客户信息为空");
				throw new XLRuntimeException("客户信息为空");
			}	
			if(info.getAge() == null || info.getAge().intValue()==0){
				info.setAge(0);
			}
			info.setEditby(this.currentUserLogo());
			info.setEdittime(now());
			customerInfoBo.update(info);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
