package com.xunlei.niux.manager.web.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;

import com.xunlei.niux.data.vipgame.vo.*;
import com.xunlei.niux.easyutils.commonutils.*;
import com.xunlei.niux.gameoffical.template.v2.builder.DataUtil;
import com.xunlei.niux.manager.web.util.*;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.codehaus.jackson.map.ObjectMapper;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.CustomerDetailQueryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.vo.JsonResult;
import com.xunlei.niux.manager.web.model.vo.PayRecordVo;
import com.xunlei.niux.manager.web.proxy.CustomerUserProxy;


/**
 * 客户详情查询业务处理类
 * @author lisu
 * 2013-02-21
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CUSTOMERQUERY)
public class CustomerDetailQueryManagedBean extends BaseManagedBean {
	private static final int MAXCOUNT = 10000;
    private CustomerDetailQueryBo customerDetailQueryBo;
	private static Map<Long,String> personMap = null;
	private static InterfaceManManagedBean man = new InterfaceManManagedBean();
    private BaseSo baseSo;
    private static final Logger logger = Logger.getLogger(CustomerDetailQueryManagedBean.class.getName());
    private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//文件上传路径
    private static String PAYRECORDURL = "http://paysvr.niu.xunlei.com:8090/gamepaycenter/recharge?action=querygiftorderdetail";
    private int rownum = 0;
	private UploadedFile upfile;
	private UploadedFile importupfile;
	private String text = "";	
	private static final Page page = new Page();
	private static final int COLUMNSIZE = 5;//玩家个人信息导入列数
    private static final int MAXROWCount = 500;//玩家个人信息一次最多导入行数
	private List<SelectItem> customServiceSel = new ArrayList<SelectItem>();

    public List<SelectItem> getCustomServiceSel() {
        return customServiceSel;
    }

    public void setCustomServiceSel(List<SelectItem> customServiceSel) {
        this.customServiceSel = customServiceSel;
    }

    public UploadedFile getImportupfile() {
		return importupfile;
	}
	public void setImportupfile(UploadedFile importupfile) {
		this.importupfile = importupfile;
	}

	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
    
	
	public CustomerDetailQueryManagedBean(){
		baseSo =  FacadeFactory.INSTANCE.getBaseSo();
		customerDetailQueryBo =  FacadeFactory.INSTANCE.getCustomerDetailQueryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;	
	}


	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 修改玩家手机号
	 * @return
	 */
	public String editCustomerInfo(){
		logger.info("开始玩家手机号修改");
		//this.authenticateEdit();//编辑权限
		CustomerInfo info = findBean(CustomerInfo.class, "customerinfo");
		try{
			if(info==null){
				logger.info("玩家信息为空");
				throw new XLRuntimeException("玩家信息为空为空");
			}				
			info.setEditby(this.currentUserLogo());
			info.setEdittime(now());
			baseSo.updateObjectById(info);
			
			//更新到大客户系统
			CustomerDetailQuery cdquery = new CustomerDetailQuery();
			cdquery.setUid(info.getUid());
			CustomerDetailQuery cdq = baseSo.findObject(cdquery);
			if(cdq != null){
				if(StringTools.isEmpty(cdq.getPhone())){
					cdq.setPhone(info.getPhone());
				}else{
					cdq.setContactNumber(info.getPhone());
				}				
				baseSo.updateObjectById(cdq);
			}
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 玩家手机号查询
	 * @return
	 */
	public String getQueryCustomerInfoList(){
		logger.info("开始 玩家手机号查询");
        this.authenticateRun();//验证运行权限
        CustomerInfo info = findBean(CustomerInfo.class, "customerinfo");
        if(StringTools.isEmpty(info.getUid())){
        	info.setUid("-1");
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(info);
        pagedFliper.setRecordCount(count);
        List<CustomerInfo> list = new ArrayList<CustomerInfo>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = baseSo.findObjects(info, page);
        }
       
        Sheet<CustomerInfo> sheet = new Sheet<CustomerInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

	/**
	 * 导出筛选后的结果到excel中
	 * @return
	 */
	public void getResult(){
		logger.info("开始筛选UID导出到excel文件");
		String showuids = findParameter("showuids");
		int payamt = findParamInt("payamt");
		int isuid = findParamInt("isuid");
		String beginday = findParameter("beginday");
		String endday = findParameter("endday");
		String beginpaystr = findParameter("beginpay");
		String endpaystr = findParameter("endpay");
		long beginpay = 0L;
		long endpay = 0L;
		if(beginpaystr!=null&&!"".equals(beginpaystr)){
			beginpay = Long.parseLong(beginpaystr);
		}
		if(endpaystr!=null&&!"".equals(endpaystr)){
			endpay = Long.parseLong(endpaystr);
		}
      
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String nowtime = sdf.format(new Date());
		List datas = new ArrayList();
		boolean flag = false;
		String ids[] = showuids.split("\n");
		CustomerDetailQuery query = new CustomerDetailQuery();
		Page page = new Page();
		for(String id:ids){			
			if(id == null || "".equals(id))continue;//过滤空UID
			//调用接口						
			try {			
				if(isuid ==1){	//如果需要导出额外的信息	
					id = id.trim();
					query.setUid(id);
					List<CustomerDetailQuery> cdqlist = customerDetailQueryBo.find(query, page);
					System.out.println("cdqlist==>"+cdqlist.size());
					if(cdqlist != null&&cdqlist.size()>0){
						CustomerDetailQuery cdq = cdqlist.get(0);
						List list = new ArrayList();
						list.add(id);
						list.add(cdq.getAccount());
						list.add(cdq.getPhone()==null||"".equals(cdq.getPhone())?cdq.getContactNumber():cdq.getPhone());
						datas.add(list);
					}
				}else{
					if(checkUID(id.trim(),payamt,beginday,endday,beginpay,endpay,nowtime)){//如果满足条件则，加到新的集合中
						List list = new ArrayList();
						list.add(id);				
						datas.add(list);
					}					
				}
			} catch (Exception e) {
				e.printStackTrace();
			}				
		}
		FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
        
        //更新标题
 	    String title = "";	    
    
 	    //生成数据到excel中
 	   String[] columnName = null;
 	    if(isuid == 0){//如果只导uid
 	    	columnName = new String[] {"UID"};
 	    }else{//如果还需要导出额外的信息
 	    	columnName = new String[] {"UID","账号","联系方式"};
 	    }
		
		String filePath = "/tmp/filtercustomer.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("筛选后的UID",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_filtercustomerdata.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   			
		text = "";
		FacesContext.getCurrentInstance().responseComplete();	   
	}
	
	
	/**
	 * 检查uid是否满足条件
	 * @param uid
	 * @return
	 */
	private boolean checkUID(String uid,int payamt,String beginday,String endday,long beginpay,long endpay,String nowtime) throws Exception {
		String time = "2012-01-01";
		if(beginday==null||"".equals(beginday)){
			beginday = time;
		}
		if(endday==null||"".equals(endday)){
			endday = nowtime;
		}
        logger.info("uid======>"+uid);	
        String url = PAYRECORDURL+"&pagesize=99999&giftflag=0&begintime="+beginday+"&endtime="+endday+"&uid="+uid+"&";
    	System.out.println("url:"+url);
		String jsonStr = HttpClientUtil.getInfoForHttpGetMothed(url);	
		System.out.println("jsonstr:"+jsonStr);
		ObjectMapper mapper = new ObjectMapper();
		jsonStr = jsonStr.replace("var defaultRtnName = ", "");		
		JsonResult record = mapper.readValue(jsonStr, JsonResult.class);	
		if(Integer.parseInt(record.getCode()) != 0)return false;
		List<PayRecordVo> recordList = record.getValue();
		boolean flag = false;
		if(endpay == 0){
			endpay = 999999999;
		}
		if(payamt == 0){//单笔充值
			for(PayRecordVo prv:recordList){
				double money = Double.parseDouble(prv.getMoney());
				if(money <= endpay){
					if(beginpay == 0){
						if(money > 0){
							flag = true;
							break;
						}
					}else{
						if(money >= beginpay){
							flag = true;
							break;
						}
					}
				}
			}
		}else{//累计充值
			double total = 0D;
			for(PayRecordVo prv:recordList){
				double money = Double.parseDouble(prv.getMoney());
				total += money;
			}
			if(total <= endpay){
				if(beginpay == 0){
					if(total > 0){
						flag = true;
					}
				}else{
					if(total >= beginpay){
						flag = true;
					}
				}
			}
		}
		return flag;
		
	}
	
	
	/**
	 * 玩家信息导入时文件上传
	 * @return
	 */
	public String importUploadFile(){     
		String filename=null;
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		if(importupfile!=null){
			try {
				filename=FileUploadUtil.upLoadFile(importupfile);
				filename = FILEPATH+filename;
                fis = new FileInputStream(new File(filename));
                wb = WorkbookFactory.create(fis);
                sheet = wb.getSheetAt(0);
            	row = sheet.getRow(0);// 得到标题的内容对象。
    			int colNum = row.getPhysicalNumberOfCells(); // 得到标题总列数
    			int rowNum = sheet.getLastRowNum(); // 得到总行数
    			if(colNum!=COLUMNSIZE){
    				alertJS("excel格式不正确");
    				return "";
    			}
    			if(rowNum >MAXROWCount){
    				alertJS("一次最多只能导入"+MAXROWCount+"条记录");
    				return "";
    			}
    			DecimalFormat df = new DecimalFormat("0");  
    			for (int i = 0; i <= rowNum; i++) { // 正文内容应该从第二行开始,第一行为表头的标题
    			
                	 row = sheet.getRow(i);        
                	 Cell cell0  = row.getCell(0);
                	 if(cell0 == null)continue;
                	 String uid = (cell0.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell0.getNumericCellValue())+"":cell0.getStringCellValue();
                	 if(StringTools.isEmpty(uid))continue;
                	 uid = uid.trim();
	               	 String userName =row.getCell(1)==null?"":row.getCell(1).getStringCellValue()+"";
	                 if(!StringTools.isEmpty(userName)){
	                	 userName = userName.trim();
	                 }
                	 Cell cell2  = row.getCell(2);
                	 String phone = cell2==null?"":((cell2.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell2.getNumericCellValue())+"":cell2.getStringCellValue());
                     if(!StringTools.isEmpty(phone)){
                    	 phone = phone.trim();
                     }
                     Cell cell3  = row.getCell(3);
                	 String qq =cell3==null?"": ((cell3.getCellType() == HSSFCell.CELL_TYPE_NUMERIC)?df.format(cell3.getNumericCellValue())+"":cell3.getStringCellValue());
                     if(!StringTools.isEmpty(qq)){
                    	 qq = qq.trim();
                     }
                  	 String address =row.getCell(4)==null?"":row.getCell(4).getStringCellValue()+"";
                     if(!StringTools.isEmpty(address)){
                    	 address = address.trim();
                     }
                	 System.out.println("i="+i+",phone:"+phone+",qq:"+qq);
                     addCustomerInfo(uid,userName,phone,qq,address);
    			}         
			} catch (Exception e) {
				e.printStackTrace();
			}finally{
				try{
					if(fis != null){
						fis.close();
						fis = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		return text;
	}
	
	
	private void addCustomerInfo(String userid,String userName,String phone,String qq,String address){
		CustomerDetailQuery query = new CustomerDetailQuery();
		query.setUid(userid);
		CustomerDetailQuery cdq = baseSo.findObject(query);
		if(cdq == null)return;
		CustomerInfo infoquery = new CustomerInfo();
		infoquery.setUid(userid);
		CustomerInfo info = baseSo.findObject(infoquery);
		if(info == null){//如果之前不存在记录，则需要新增
			CustomerInfo data = new CustomerInfo();
			data.setUid(userid);
			data.setUsername(userName);
			data.setPhone(phone);
			data.setQq(qq);
			data.setAddress(address);
			data.setCheckFlag(false);
			data.setCheckPhone(false);
			data.setInputby(this.currentUserLogo());
			data.setInputtime(now());
			baseSo.addObject(data);
		}else{//如果之前已存在记录，则需要修改
			info.setUsername(userName);
			if(checkPhone(phone)){
				info.setOldphone(info.getPhone());
				info.setPhone(phone);
			}
			info.setQq(qq);
			info.setAddress(address);
			info.setEditby(this.currentUserLogo());
			info.setEdittime(now());
			baseSo.updateObjectById(info);
		}
		if(checkPhone(phone)){
			cdq.setContactNumber(cdq.getPhone());
			cdq.setPhone(phone);
		}
		cdq.setQq(qq);
		baseSo.updateObjectById(cdq);
	}
	
	private boolean checkPhone(String phone){
		if(StringTools.isEmpty(phone)) return false;
		if(phone.length()!=11)return false;
		return true;
	}
	
	/**
	 * 文件上传
	 * @return
	 */
	public String uploadFile(){     
		String filename=null;
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		if(upfile!=null){
			try {
				filename=FileUploadUtil.upLoadFile(upfile);
				filename = FILEPATH+filename;
                fis = new FileInputStream(new File(filename));
                wb = WorkbookFactory.create(fis);
                sheet = wb.getSheetAt(0);
            	row = sheet.getRow(0);// 得到标题的内容对象。
    			int colNum = row.getPhysicalNumberOfCells(); // 得到标题总列数
    			int rowNum = sheet.getLastRowNum(); // 得到总行数
    			for (int i = 0; i <= rowNum; i++) { // 正文内容应该从第二行开始,第一行为表头的标题
    				row = sheet.getRow(i);
    				int j = 0;
    				while (j < colNum) {    
    					text += ((long)(row.getCell(j).getNumericCellValue())+"\n");
    					j++;
    				}
    			}         
			} catch (Exception e) {
				e.printStackTrace();
			}finally{
				try{
					if(fis != null){
						fis.close();
						fis = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		return text;
	}
	
	/**
	 * 查询客户
	 * @return
	 */
	public String getQueryCustomerDetailQueryList() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
		logger.info("开始所有客户详情查询");
		this.authenticateRun();//验证运行权限
        CustomerDetailQuery customer = findBean(CustomerDetailQuery.class, "customerdetailquery");    
        String uid = findParameter("uid");
        String account = findParameter("account");
        String vipGrade = findParameter("vipGrade");
        String birthday = findParameter("birthday");
        String vipGradea = findParameter("vipGradea");
        String phone = findParameter("phone");
        String qq = findParameter("qq");
        String lastPayTime = findParameter("lastPayTime");
        String contactNumber = findParameter("contactNumber");
        String loginGameId = findParameter("loginGameId");
        String payGameId = findParameter("payGameId");
        String beginday = findParameter("beginday");
        String endday = findParameter("endday");
        String beginpaytime= findParameter("beginpaytime");
        String endpaytime= findParameter("endpaytime");
        String logingameids = findParameter("logingameids");  
        if(vipGradea != null && !"".equals(vipGradea)){
        	customer.setVipGrade(Integer.parseInt(vipGradea));
        }
        String persons = findParameter("persons");
        
        String username = this.currentUserLogo();
        int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
        PagedFliper pagedFliper = this.getFliper();
        StringBuffer sb = new StringBuffer();
        sb.append("  and vipGrade <=").append(customerVipGrade);        
        if(uid != null && !"".equals(uid)){
        	sb.append(" and uid='"+uid+"'");
        }
        if(!StringTools.isEmpty(persons)&&!"0,".equals(persons)){
    		personMap = man.getPersonMap();
    		System.out.println("personMap:"+personMap);
        	String usernames[] = persons.split(",");
        	if(usernames != null){
        		 sb.append(" and  customerService in (");
        		for(String name:usernames){
        			 if(!StringTools.isEmpty(name)){
        				 if("-1".equals(name)||"-1,".equals(name)){
        					 sb.append("'',");
        				 }else{
        					 sb.append("'").append(personMap.get(Long.parseLong(name.replaceAll(",", "").trim()))).append("',");
        				 }        				
        			 }
        		}
        		sb.append("'a')");
        	}
        }       
        
        if(beginday != null&& !"".equals(beginday)){
        	sb.append(" and lastUpdateTime>='"+beginday+"'");
        }
        if(endday !=null&&!"".equals(endday)){
        	sb.append("  and lastUpdateTime < '"+endday+"'");
        }
        if(beginpaytime != null&& !"".equals(beginpaytime)){
        	sb.append(" and lastPayTime>='"+beginpaytime+"'");
        }
        if(endpaytime !=null&&!"".equals(endpaytime)){
        	sb.append("  and lastPayTime < '"+endpaytime+"'");
        }
        if(loginGameId != null && !"".equals(loginGameId)){
        	sb.append(" and loginGameId='"+loginGameId+"'");
        }
        if(payGameId != null && !"".equals(payGameId)){
        	sb.append(" and payGameId='"+payGameId+"'");
        }
        if(account != null && !"".equals(account)){
        	sb.append(" and account='"+account+"'");
        }      
        if(lastPayTime != null&& !"".equals(lastPayTime)){
        	sb.append("  and lastPayTime='"+lastPayTime+"'");
        }
        if(vipGradea != null && !"".equals(vipGradea)){
    		vipGrade = vipGradea;
    	}
        if(vipGrade !=null && !"".equals(vipGrade)){
        	sb.append(" and vipGrade="+vipGrade);
        }        
        if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
            if("1".equals(phone.trim())){//如果选择的是有安全手机的
            	sb.append(" and phone <> ''");
            }else{
            	sb.append(" and phone = ''");
            }
        }        
        if(qq != null && !"".equals(qq) && !"-1".equals(qq.trim())){
            if("1".equals(qq.trim())){//如果选择的是有QQ的
            	sb.append(" and qq <> ''");
            }else{
            	sb.append(" and qq = ''");
            }
        }        
        if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
            if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
            	sb.append(" and contactNumber <> ''");
            }else{
            	sb.append(" and contactNumber = ''");
            }
        }        
        if(!StringTools.isEmpty(logingameids)){
        	String gameids[] = logingameids.split(",");
        	if(gameids != null){
        		for(String gameid:gameids){
        			 if(!StringTools.isEmpty(gameid)){
        				 sb.append(" and logingameids LIKE '%").append(gameid).append("%' ");
        			 }
        		}
        	}
        }        
        Object[] objs = new Object[]{};
        String countsql = sb.toString();
        if(birthday != null&&!"".equals(birthday)){
        	String str[] = birthday.split("-");
        	String mybirthday = str[1]+"-"+str[2];
        	countsql = countsql+ " and birthday like '_____"+mybirthday+"%'";
        }
        int count = customerDetailQueryBo.count("select count(*) from customerdetailquery where 1=1 "+ countsql, objs);
        pagedFliper.setRecordCount(count);
        List<CustomerDetailQuery> list = new ArrayList<CustomerDetailQuery>();
        List<Map<String,Object>> list2 = new ArrayList<Map<String,Object>>();
        CustomerDetailQuery cdq = new CustomerDetailQuery();
        cdq.setBirthday(birthday);
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	if(pagedFliper.isNotEmptySortColumn()){      		
        		String str[] = pagedFliper.getSortColumn().split(" ");
        		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
        	}else{
        		page.addOrder("vipGrade", OrderType.DESC);
        	}
            list = customerDetailQueryBo.find(cdq,"select * from customerdetailquery where 1=1 "+ sb.toString(),page);
            for(CustomerDetailQuery ccc :list){
                Map<String,Object> mm = BeanUtils.describe(ccc);
                int loginStatus = diffNow(ccc.getLastLoginTime())<-3?2:1;
                int payStatus = diffNow(ccc.getLastPayTime())<-7?2:1;
                int vipStatus2 = 1;
                if(loginStatus==2&&payStatus==2){
                    vipStatus2=2;
                }
                mm.put("loginStatus",loginStatus);
                mm.put("payStatus",payStatus);
                mm.put("vipStatus2",vipStatus2);
                list2.add(mm);
            }
        }
        Sheet<Map<String,Object>> sheet = new Sheet<Map<String,Object>>(count, list2);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

    private Long diffNow(String srcDate){
        if(StringUtils.isEmpty(srcDate))return -999L;
        String now = DateUtil.formatNowByDefault();
        return DateUtil.compareTime(srcDate,now);
    }
	
	 /**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始客户查询导出到excel文件");   	
    	//获得页面查询的数据
    	 CustomerDetailQuery customer = findBean(CustomerDetailQuery.class, "customerdetailquery");	
    	 String uid = findParameter("uid");
         String account = findParameter("account");
         String vipGrade = findParameter("vipGrade");
         String birthday = findParameter("birthday");
         String vipGradea = findParameter("vipGradea");
         String lastPayTime = findParameter("lastPayTime");
         String phone = findParameter("phone");
         String qq = findParameter("qq");
         String contactNumber = findParameter("contactNumber");
         String loginGameId = findParameter("loginGameId");
         String payGameId = findParameter("payGameId");
         String beginday = findParameter("beginday");
         String endday = findParameter("endday");
         String beginpaytime= findParameter("beginpaytime");
         String endpaytime= findParameter("endpaytime");
         String logingameids = findParameter("logingameids");
         String persons = findParameter("persons");
         String username = this.currentUserLogo();
         int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
         if(vipGradea != null && !"".equals(vipGradea)){
         	customer.setVipGrade(Integer.parseInt(vipGradea));
         }
        StringBuffer ssb = new StringBuffer();
        ssb.append("  and vipGrade <=").append(customerVipGrade);      
        if(uid != null && !"".equals(uid)){
        	ssb.append(" and uid='"+uid+"'");
        }
        if(!StringTools.isEmpty(persons)&&!"0,".equals(persons)){
    		personMap = man.getPersonMap();
    		System.out.println("personMap:"+personMap);
        	String usernames[] = persons.split(",");
        	if(usernames != null){
        		ssb.append(" and  customerService in (");
        		for(String name:usernames){
        			 if(!StringTools.isEmpty(name)){
        				 if("-1".equals(name)||"-1,".equals(name)){
        					 ssb.append("'',");
        				 }else{
        					 ssb.append("'").append(personMap.get(Long.parseLong(name.replaceAll(",", "").trim()))).append("',");
        				 }        
        			 }
        		}
        		ssb.append("'a')");
        	}
        }        
        if(beginday != null&& !"".equals(beginday)){
        	ssb.append(" and lastUpdateTime>='"+beginday+"'");
        }
        if(endday !=null&&!"".equals(endday)){
        	ssb.append("  and lastUpdateTime < '"+endday+"'");
        }
        if(beginpaytime != null&& !"".equals(beginpaytime)){
        	ssb.append(" and lastPayTime>='"+beginpaytime+"'");
        }
        if(endpaytime !=null&&!"".equals(endpaytime)){
        	ssb.append("  and lastPayTime < '"+endpaytime+"'");
        }
        if(loginGameId != null && !"".equals(loginGameId)){
        	ssb.append(" and loginGameId='"+loginGameId+"'");
        }
        if(payGameId != null && !"".equals(payGameId)){
        	ssb.append(" and payGameId='"+payGameId+"'");
        }
        if(account != null && !"".equals(account)){
        	ssb.append(" and account='"+account+"'");
        }       
        if(lastPayTime != null&& !"".equals(lastPayTime)){
        	ssb.append("  and lastPayTime='"+lastPayTime+"'");
        }
        if(vipGradea != null && !"".equals(vipGradea)){
    		vipGrade = vipGradea;
    	}
        if(vipGrade !=null && !"".equals(vipGrade)){
        	ssb.append(" and vipGrade="+vipGrade);
        }
        if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
            if("1".equals(phone.trim())){//如果选择的是有安全手机的
            	ssb.append(" and phone <> ''");
            }else{
            	ssb.append(" and phone = ''");
            }
        }       
        if(qq != null && !"".equals(qq) && !"-1".equals(qq.trim())){
            if("1".equals(qq.trim())){//如果选择的是有QQ的
            	ssb.append(" and qq <> ''");
            }else{
            	ssb.append(" and qq = ''");
            }
        }        
        if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
            if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
            	ssb.append(" and contactNumber <> ''");
            }else{
            	ssb.append(" and contactNumber = ''");
            }
        }   
        if(!StringTools.isEmpty(logingameids)){
        	String gameids[] = logingameids.split(",");
        	if(gameids != null){
        		for(String gameid:gameids){
        			 if(!StringTools.isEmpty(gameid)){
        				ssb.append(" and logingameids LIKE '%").append(gameid).append("%' ");
        			 }
        		}
        	}
        }     
        String countsql = ssb.toString();
        if(birthday != null&&!"".equals(birthday)){
        	String str[] = birthday.split("-");
        	String mybirthday = str[1]+"-"+str[2];
        	countsql = countsql+ " and birthday like '%"+mybirthday+"%'";
        }
        CustomerDetailQuery cdq = new CustomerDetailQuery();
        cdq.setBirthday(birthday);
        PagedFliper pagedFliper = this.getFliper();
        Page page = new Page();
        if(pagedFliper.isNotEmptySortColumn()){      		
    		String str[] = pagedFliper.getSortColumn().split(" ");
    		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
    	}else{
    		page.addOrder("vipGrade", OrderType.DESC);
    	}
    	List<CustomerDetailQuery> crlist = customerDetailQueryBo.find(cdq,"select * from customerdetailquery where 1=1 "+ ssb.toString(),page);
    	if(crlist != null&&crlist.size()>MAXCOUNT){
    		if(crlist!= null){
    			crlist.clear();
    			crlist = null;
    		}  		
    		alertJS("您导出的数据超过"+MAXCOUNT+"条，为了避免对服务器造成很大的压力，我们屏蔽了导出的功能。要想获得这些数据，请发邮件给李苏，谢谢！");
    		return ;
    	}
    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
	    if(customer.getVipGrade() != null && customer.getVipGrade() != 0){
	    	sb.append("等级为"+customer.getVipGrade()+"的");
	    }else{
	    	sb.append("所有");
	    }
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = sb+"客户";	    
 	    List datas = new ArrayList();
 	   
 	    for(CustomerDetailQuery cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getUid());
 	    	list.add(cr.getAccount());
 	    	list.add(cr.getVipGrade());
// 	    	list.add(cr.getVipStatus()==1?"保有":"流失");

            int loginStatus = diffNow(cr.getLastLoginTime())<-3?2:1;
            int payStatus = diffNow(cr.getLastPayTime())<-7?2:1;
            int vipStatus2 = 1;
            if(loginStatus==2&&payStatus==2){
                vipStatus2=2;
            }
            list.add(vipStatus2==1?"保有":"流失");
            list.add(loginStatus==1?"保有":"流失");
            list.add(payStatus==1?"保有":"流失");


 	    	list.add(cr.getGameCount());
 	    	list.add(cr.getPayCount());
 	    	list.add(cr.getPayTotalAmt());
 	    	list.add(cr.getLastPayTime());
 	    	Games paygames = GameCache.getInstance().getGameByGameId(cr.getPayGameId());
 	    	list.add(paygames==null?"":paygames .getGameName());
 	    	list.add(cr.getLastLoginTime());
 	    	Games logingames = GameCache.getInstance().getGameByGameId(cr.getLoginGameId());
 	    	list.add(logingames==null?"":logingames.getGameName());
 	    	list.add(cr.getCallCount());
 	    	list.add(cr.getLastCaller());
 	    	list.add(cr.getCustomerService());
 	    	list.add(cr.getLastCallTime());
 	    	list.add(cr.getIntegral());
 	    	list.add(cr.getRebateCount());
 	    	list.add(cr.getRebateMoney());
 	    	list.add(cr.getPhone());
 	    	list.add(cr.getContactNumber());
 	    	list.add(cr.getQq());
 	    	list.add(cr.getEmail());
 	    	list.add(cr.getBirthday());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"UID", "迅雷账号", "VIP等级", "VIP状态","登录状态","充值状态","激活游戏数","充值游戏数","付费总金额","最后充值时间","最后充值游戏","最后登录时间","最后登录游戏","外呼次数","跟进销售","专属客服","最后外呼时间","平台总积分","返利笔数","返利总金额","安全手机号","联系电话","QQ","邮箱","生日"};
		String filePath = "/tmp/customerdetailquery.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("客户查询",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_customerdetaildata.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
			if(crlist!= null){
    			crlist.clear();
    			crlist = null;
    		}  		
			if(datas!= null){
				datas.clear();
				datas = null;
			}
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }

    public void export2() throws Exception{
        this.authenticateRun();//验证运行权限
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String now = sdf.format(new Date());
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
        String title = "客户excel";
        //生成数据到excel中
        String[] columnName = {"UID", "账号", "实时付费总金额", "VIP等级","VIP状态","登录状态","充值状态","最后充值时间","最后充值游戏","最后登录时间","最后登录游戏","最后外呼人","外呼次数","专属经理","最后外呼时间","联系电话","QQ"};
        String filePath = "/tmp/customerdetailquery.xls";

        CustomerDetailQuery customer = findBean(CustomerDetailQuery.class, "customerdetailquery");
        String contactNumber = findParameter("contactNumber");
        String vip_status = findParameter("vip_status");
        String login_status = findParameter("login_status");
        String pay_status = findParameter("pay_status");
        String vipGradeGe = findParameter("vipGradeGe");
        StringBuilder sqlWhere = new StringBuilder();

        if(StringUtils.isNotEmpty(customer.getUid())){
            sqlWhere.append(" and uid='"+customer.getUid()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getAccount())){
            sqlWhere.append(" and account='"+customer.getAccount()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getLoginGameId())){
            sqlWhere.append(" and LoginGameId='"+customer.getLoginGameId()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastLoginTime())){
            sqlWhere.append(" and lastLoginTime>='"+customer.getFromLastLoginTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastLoginTime())){
            sqlWhere.append(" and lastLoginTime<='"+customer.getToLastLoginTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getPayGameId())){
            sqlWhere.append(" and PayGameId='"+customer.getPayGameId() + "' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastPayTime())){
            sqlWhere.append(" and lastPayTime>='"+customer.getFromLastPayTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastPayTime())){
            sqlWhere.append(" and lastPayTime<='"+customer.getToLastPayTime() + "' ");
        }

        if(StringUtils.isNotEmpty(customer.getCustomerService())){
            if("0".equals(customer.getCustomerService())){
                sqlWhere.append(" and (customerService is null or customerService='') ");
            }else if("1".equals(customer.getCustomerService())){
                sqlWhere.append(" and customerService not in (select interfaceName from  interfaceman where type=4) and (customerService is not null and customerService<>'')  ");
            }else{
                sqlWhere.append(" and customerService='"+customer.getCustomerService()+"' ");
            }
        }

        if("0".equals(contactNumber)){
            sqlWhere.append("  and (contactNumber = '' or contactNumber is null) ");
        }else if("1".equals(contactNumber)){
            sqlWhere.append("  and contactNumber <> '' and contactNumber is not null ");
        }
        if(customer.getVipGrade()!=null && customer.getVipGrade()!=0){
            sqlWhere.append(" and VipGrade="+customer.getVipGrade());
        }else{
            sqlWhere.append(" and VipGrade>=3");
        }
        if(StringUtils.isNotEmpty(vipGradeGe)){
            sqlWhere.append(" and VipGrade>"+vipGradeGe);
        }

        String singlepayfrom = findParameter("singlepayfrom");
        String singlepayto = findParameter("singlepayto");
        String totalpayfrom = findParameter("totalpayfrom");
        String totalpayto = findParameter("totalpayto");

        if(StringUtils.isNotEmpty(totalpayfrom)){
            sqlWhere.append(" and payTotalAmt>='"+totalpayfrom+"' ");
        }
        if(StringUtils.isNotEmpty(totalpayto)){
            sqlWhere.append(" and payTotalAmt<='"+totalpayto+"' ");
        }


        System.out.println("################  "+sqlWhere.toString());
        int count = customerDetailQueryBo.count("select count(*) from customerdetailquery where 1=1 "+ sqlWhere.toString(), new Object[]{});
        List<Map<String,Object>> list2 = new ArrayList<Map<String,Object>>();
        CustomerDetailQuery cdq1 = new CustomerDetailQuery();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(0);
            page.setPageSize(count>10000?10000:count);
            page.addOrder("vipGrade", OrderType.DESC);
            List<CustomerDetailQuery> orclist = customerDetailQueryBo.find(cdq1,"select * from customerdetailquery where 1=1 "+ sqlWhere.toString(),page);
            for(CustomerDetailQuery ccc :orclist){
                Map<String,Object> mm = BeanUtils.describe(ccc);
                int loginStatus = diffNow(ccc.getLastLoginTime())<-3?2:1;
                int payStatus = diffNow(ccc.getLastPayTime())<-7?2:1;
                int vipStatus2 = 1;
                if(loginStatus==2&&payStatus==2){
                    vipStatus2=2;
                }
                mm.put("loginStatus",loginStatus);
                mm.put("payStatus",payStatus);
                mm.put("vipStatus2",vipStatus2);
                if(StringUtils.isNotEmpty(vip_status)){
                    if(vipStatus2 != Integer.valueOf(vip_status)){
                        continue;
                    }
                }else{
                    if(StringUtils.isNotEmpty(login_status) && loginStatus!=Integer.valueOf(login_status))continue;
                    if(StringUtils.isNotEmpty(pay_status) && payStatus!=Integer.valueOf(pay_status))continue;
                }
                list2.add(mm);
            }
        }

        List datas = new ArrayList();
        for(Map<String,Object> map :list2){
            CustomerDetailQuery cdq = new CustomerDetailQuery();
            BeanUtils.populate(cdq,map);
            List row = new ArrayList();
            row.add(cdq.getUid());
            row.add(cdq.getAccount());
            row.add(cdq.getLivePayTotalAmt());
            row.add(cdq.getVipGrade());
            row.add("1".equals(map.get("vipStatus2").toString())?"忠实":"睡眠");
            row.add("1".equals(map.get("payStatus").toString())?"保持":"流失");
            row.add("1".equals(map.get("loginStatus").toString())?"还在玩":"不玩了");
            row.add(cdq.getLastPayTime());
            row.add(GameCache.getInstance().getGameIdNameMap().get(cdq.getPayGameId()));
            row.add(cdq.getLastLoginTime());
            row.add(GameCache.getInstance().getGameIdNameMap().get(cdq.getLoginGameId()));
            row.add(cdq.getLastCaller());
            row.add(cdq.getCallCount());
            row.add(cdq.getCustomerService());
            row.add(cdq.getLastCallTime());
            row.add(cdq.getContactNumber());
            row.add(cdq.getQq());
            datas.add(row);
        }


        long beginTime = System.currentTimeMillis();
        Workbook wb = ExcelUtil.create("客户查询",title,columnName,filePath,datas);
        long endTime = System.currentTimeMillis();
        logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");

        //弹出下载窗口
        response.setHeader("Content-disposition", "attachment;filename="+now+"_customerdetaildata.xls");
        response.setContentType("application/x-download");
        OutputStream ouputStream = null;
        try {
            ouputStream = response.getOutputStream();
            wb.write(ouputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        FacesContext.getCurrentInstance().responseComplete();
    }

	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	
	/**
	 * 录入专属客服
	 * @return
	 */
	public String updateCustomerService(){
		try{
			String one_seqid = this.findParameter("one_seqId");
			String one_customerService = this.findParameter("one_customerService");			
			if(StringTools.isEmpty(one_seqid)){
				throw new XLRuntimeException("one_seqid不能为空");
			}

            if(StringTools.isEmpty(one_customerService)){
                one_customerService = "";
            }

		    CustomerDetailQuery cdq = customerDetailQueryBo.findById(Long.parseLong(one_seqid));
		    if(cdq == null){
		    	throw new XLRuntimeException("该玩家不存在");
		    }
		    boolean isDel = super.isEnableDel();
		    if(!StringTools.isEmpty(cdq.getCustomerService())){//如果已经录入过专属客服
		    	String trueName = this.currentUserInfo().getTrueName().trim();
		    	if(!trueName.trim().equals(cdq.getCustomerService().trim())){
		    		if(!isDel){//只有管理值有权限录入
			    		throw new XLRuntimeException("您没有该客户的操作权限");
			    	}
		    	}
		    }else{//如果没有录入过专属客服
//		    	if(!isDel){//只有管理值有权限录入
//		    		throw new XLRuntimeException("您没有该客户的操作权限");
//		    	}
		    }		    
		    
		    //更新专属客服到大额充值中
		    CustomerBigPayQuery cbpq = new CustomerBigPayQuery();
		    cbpq.setUid(cdq.getUid());
		    page.addOrder("daytime", OrderType.DESC);
		    List<CustomerBigPayQuery> cbpqlist = baseSo.findObjects(cbpq, page);
		    int index = 0;
		    for(CustomerBigPayQuery cb:cbpqlist){
		    	if(index>5)break;
		    	cb.setCustomerService(one_customerService);
		    	baseSo.updateObjectById(cb);
		    	index++;
		    }
		    cdq.setCustomerService(one_customerService);
		    customerDetailQueryBo.update(cdq);
		}catch(Exception e){
			logger.error("更新失败", e);
			mergeJsmessage("更新失败，原因：" + e.getMessage());
		}	
		return "";
	}


    /**
     * 新查询客户
     * @return
     */
    public String getQueryCustomerDetailQueryList2() throws Exception {
        logger.info("开始所有客户详情查询");
        this.authenticateRun();//验证运行权限
        PagedFliper pagedFliper = this.getFliper();


        updateCustomerServiceSel();
        CustomerDetailQuery customer = findBean(CustomerDetailQuery.class, "customerdetailquery");
        String contactNumber = findParameter("contactNumber");
        String vip_status = findParameter("vip_status");
        String login_status = findParameter("login_status");
        String pay_status = findParameter("pay_status");
        String vipGradeGe = findParameter("vipGradeGe");
        StringBuilder sqlWhere = new StringBuilder();

        if(StringUtils.isNotEmpty(customer.getUid())){
            sqlWhere.append(" and uid='"+customer.getUid()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getAccount())){
            sqlWhere.append(" and account='"+customer.getAccount()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getLoginGameId())){
            sqlWhere.append(" and LoginGameId='"+customer.getLoginGameId()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastLoginTime())){
            sqlWhere.append(" and lastLoginTime>='"+customer.getFromLastLoginTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastLoginTime())){
            sqlWhere.append(" and lastLoginTime<='"+customer.getToLastLoginTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getPayGameId())){
            sqlWhere.append(" and PayGameId='"+customer.getPayGameId() + "' ");
        }
        if(StringUtils.isNotEmpty(customer.getFromLastPayTime())){
            sqlWhere.append(" and lastPayTime>='"+customer.getFromLastPayTime()+"' ");
        }
        if(StringUtils.isNotEmpty(customer.getToLastPayTime())){
            sqlWhere.append(" and lastPayTime<='"+customer.getToLastPayTime() + "' ");
        }

        if(StringUtils.isNotEmpty(customer.getCustomerService())){
            if("0".equals(customer.getCustomerService())){
                sqlWhere.append(" and (customerService is null or customerService='') ");
            }else if("1".equals(customer.getCustomerService())){
                sqlWhere.append(" and customerService not in (select interfaceName from  interfaceman where type=4) and (customerService is not null and customerService<>'')  ");
            }else{
                sqlWhere.append(" and customerService='"+customer.getCustomerService()+"' ");
            }
        }
        if("0".equals(contactNumber)){
            sqlWhere.append("  and (contactNumber = '' or contactNumber is null) ");
        }else if("1".equals(contactNumber)){
            sqlWhere.append("  and contactNumber <> '' and contactNumber is not null ");
        }
        if(customer.getVipGrade()!=null && customer.getVipGrade()!=0){
            sqlWhere.append(" and VipGrade="+customer.getVipGrade());
        }else{
            sqlWhere.append(" and VipGrade>=3");
        }
        if(StringUtils.isNotEmpty(vipGradeGe)){
            sqlWhere.append(" and VipGrade>"+vipGradeGe);
        }

        String singlepayfrom = findParameter("singlepayfrom");
        String singlepayto = findParameter("singlepayto");
        String totalpayfrom = findParameter("totalpayfrom");
        String totalpayto = findParameter("totalpayto");

        if(StringUtils.isNotEmpty(totalpayfrom)){
            sqlWhere.append(" and payTotalAmt>='"+totalpayfrom+"' ");
        }
        if(StringUtils.isNotEmpty(totalpayto)){
            sqlWhere.append(" and payTotalAmt<='"+totalpayto+"' ");
        }


        System.out.println("################  "+sqlWhere.toString());
        int count = customerDetailQueryBo.count("select count(*) from customerdetailquery where 1=1 " + sqlWhere.toString(), new Object[]{});
        pagedFliper.setRecordCount(count);
        List<Map<String,Object>> list2 = new ArrayList<Map<String,Object>>();
        CustomerDetailQuery cdq = new CustomerDetailQuery();
        if (count > 0) {
            rownum = 1;
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("vipGrade", OrderType.DESC);
            List<CustomerDetailQuery> orclist = customerDetailQueryBo.find(cdq,"select * from customerdetailquery where 1=1 "+ sqlWhere.toString(),page);
            for(CustomerDetailQuery ccc :orclist){
                Map<String,Object> mm = BeanUtils.describe(ccc);
                int loginStatus = diffNow(ccc.getLastLoginTime())<-3?2:1;
                int payStatus = diffNow(ccc.getLastPayTime())<-7?2:1;
                int vipStatus2 = 1;
                if(loginStatus==2&&payStatus==2){
                    vipStatus2=2;
                }
                mm.put("loginStatus",loginStatus);
                mm.put("payStatus",payStatus);
                mm.put("vipStatus2",vipStatus2);
                if(StringUtils.isNotEmpty(vip_status)){
                    if(vipStatus2 != Integer.valueOf(vip_status)){
                        continue;
                    }
                }else{
                    if(StringUtils.isNotEmpty(login_status) && loginStatus!=Integer.valueOf(login_status))continue;
                    if(StringUtils.isNotEmpty(pay_status) && payStatus!=Integer.valueOf(pay_status))continue;
                }
                list2.add(mm);
            }
        }

        Sheet<Map<String,Object>> sheet = new Sheet<Map<String,Object>>(count, list2);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


    private void updateCustomerServiceSel(){
        customServiceSel.clear();
        List<CustomerUser> cuList = baseSo.findObjects(new CustomerUser(),new Page());
        for(CustomerUser cu:cuList){
            SelectItem sel = new SelectItem(cu.getSeqid()+"",cu.getTrueName());
            customServiceSel.add(sel);
        }
    }
}
