package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.pay.bo.PayDetailOkBo;
import com.xunlei.niux.data.pay.vo.PayDetailOK;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.RebateOrder;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.dto.CustomerCallPayRecord;
import com.xunlei.niux.manager.web.dto.CustomerNotUsedOrder;
import com.xunlei.niux.manager.web.dto.MCallRecord;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.util.StringTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.util.CollectionUtils;

public class CustomerCallPayRecordManagedBean extends BaseManagedBean
{
    private BaseSo baseSo;
    private static final Logger logger = Logger.getLogger(CustomerCallPayRecordManagedBean.class.getName());
    private int rownum = 0;
    private static final List<Object> queryList = new ArrayList();
    private static final Page queryPage = new Page();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String fromDay;
    private String toDay;
    private static Map<String, String> orderTypeMap;
    private PayDetailOkBo payDetailOkBo;

    static
    {
        if (orderTypeMap == null) {
            orderTypeMap = new HashMap();
            orderTypeMap.put("0", "普通订单");
            orderTypeMap.put("1", "返利订单");
            orderTypeMap.put("2", "代金券订单");
        }
    }

    public String getFromDay()
    {
        Calendar cal = Calendar.getInstance();
        return sdf.format(cal.getTime());
    }

    public void setFromDay(String fromDay) {
        this.fromDay = fromDay;
    }

    public String getToDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        return sdf.format(cal.getTime());
    }

    public void setToDay(String toDay) {
        this.toDay = toDay;
    }

    public CustomerCallPayRecordManagedBean()
    {
        this.baseSo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo();
        this.payDetailOkBo = com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getPayDetailOkBo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum() {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public List<CustomerCallPayRecord> getQueryCustomerCallPayRecordList()
    {
        logger.info("开始外呼后充值查询");
        authenticateRun();
        String startCallTime = findParameter("startCallTime");
        String endCallTime = findParameter("endCallTime");
        String startOrderTime = findParameter("startOrderTime");
        String endOrderTime = findParameter("endOrderTime");
        String giftFlag = findParameter("giftFlag");
        Calendar cal = Calendar.getInstance();
        String nowtime = sdf.format(cal.getTime());
        cal.add(6, 1);
        String totime = sdf.format(cal.getTime());
        this.fromDay = nowtime;
        this.toDay = totime;
        if (StringTools.isEmpty(startOrderTime)) {
            startOrderTime = nowtime;
        }
        if (StringTools.isEmpty(endOrderTime)) {
            endOrderTime = totime;
        }
        if (StringTools.isEmpty(startCallTime)) {
            startCallTime = nowtime;
        }
        if (StringTools.isEmpty(endCallTime)) {
            endCallTime = totime;
        }
        String callsql = "select uid ,min(callTime) mcallTime  from callrecord where callTime >= '" + startCallTime + "' and callTime<'" + endCallTime + "'  group by uid";
        System.out.println("callsql:" + callsql);
        List<MCallRecord> crlist = this.baseSo.executeQuery(MCallRecord.class, callsql, new ArrayList());

        StringBuffer insql = new StringBuffer("  (");
        Map timeMap = new HashMap();
        for (MCallRecord cr : crlist) {
            insql.append("'").append(cr.getUid()).append("',");
            timeMap.put(cr.getUid(), cr.getMcallTime());
        }
        insql.append("'')");
        System.out.println("insql:" + insql);
        String cdqsql = "select * from customerdetailquery where uid in " + insql;
        System.out.println("cdqsql:" + cdqsql);
        List<CustomerDetailQuery> cdqlist = this.baseSo.executeQuery(CustomerDetailQuery.class, cdqsql, queryList);

        String ordersql = "select * from paydetailok where orderTime >= '" + startOrderTime + "' and orderTime<'" + endOrderTime + "'";
        if ((!StringTools.isEmpty(giftFlag)) && (!giftFlag.equals("-1"))) {
            ordersql = ordersql + "  and  giftFlag =" + giftFlag;
        }
        ordersql = ordersql + " and ToInnerUserid in " + insql;
        ordersql = ordersql + " order by orderTime desc";
        List<PayDetailOK> pdolist = this.payDetailOkBo.executeQuery(PayDetailOK.class, ordersql);
        List ccprlist = new ArrayList();
        if ((pdolist == null) || (pdolist.size() == 0)) return ccprlist;
        for (PayDetailOK pdo : pdolist) {
            String uid = pdo.getToinneruserid();
            String callTime = (String)timeMap.get(uid);
            if (compareTime(callTime, pdo.getOrdertime()) <= 0L) {
                CustomerCallPayRecord record = new CustomerCallPayRecord();
                record.setUserId(pdo.getToinneruserid());
                record.setOrderId(pdo.getOrderid());
                record.setOrderTime(pdo.getOrdertime());
                record.setServerId(pdo.getServerid());
                record.setPayMoney(String.valueOf(pdo.getPayMondey()));
                record.setOrderMoney(pdo.getTotalmoney());
                record.setGiftFlag(pdo.getGiftFlag());
                String gameId = pdo.getGameid();
                if (gameId.length() == 5) {
                    gameId = "0" + gameId;
                }
                Games games = GameCache.getInstance().getGameByGameId(gameId);
                record.setGameName(games == null ? "" : games.getGameName());
                for (MCallRecord cr : crlist) {
                    if (cr.getUid().equals(record.getUserId())) {
                        record.setCallTime(cr.getMcallTime());
                        break;
                    }
                }
                for (CustomerDetailQuery cdq : cdqlist) {
                    if (cdq.getUid().equals(pdo.getToinneruserid())) {
                        record.setCustomerService(cdq.getCustomerService());
                        record.setLastCaller(cdq.getLastCaller());
                    }
                }
                ccprlist.add(record);
            }
        }
        return ccprlist;
    }

    private List<PayDetailOK> findResult(List<PayDetailOK> pdoList, List<RebateOrder> roList)
    {
        List result = new ArrayList();
        for (PayDetailOK pdo : pdoList) {
            boolean flag = false;
            for (RebateOrder ro : roList) {
                if (pdo.getOrderid().equals(ro.getOrderid())) {
                    flag = true;
                }
            }
            if (!flag) {
                result.add(pdo);
            }
        }
        return result;
    }

    public List<CustomerNotUsedOrder> getQueryCustomerNotUsedOrderList()
    {
        logger.info("开始指定日期内在返利申请中未使用的订单查询");
        authenticateRun();
        String startTime = findParameter("startTime");
        String endTime = findParameter("endTime");
        String caller = findParameter("caller");
        String queryGameidGameId = findParameter("query_gameid");
        String queryMinMoneyMinMoney = findParameter("query_min_money");
        if(StringUtils.isNotEmpty(queryMinMoneyMinMoney)){
            try{
                Integer.valueOf(queryMinMoneyMinMoney);
            }catch (NumberFormatException e){
                throw new XLRuntimeException("最小金额必须为数字");
            }
        }
        String queryUidid = findParameter("query_uid");
        Calendar cal = Calendar.getInstance();
        String nowtime = sdf.format(cal.getTime());
        cal.add(6, 1);
        String totime = sdf.format(cal.getTime());
        cal.add(2, -1);
        String toOrderTime = sdf.format(cal.getTime());
        if (StringTools.isEmpty(startTime)) {
            startTime = nowtime;
        }
        else if (DateUtil.compareTime(startTime, toOrderTime) < 0L) {
            startTime = toOrderTime;
        }

        if (StringTools.isEmpty(endTime)) {
            endTime = totime;
        }
        if (StringTools.isEmpty(caller))
            caller = "-1";
        else {
            caller = caller.trim();
        }
        List ccprlist = new ArrayList();
        String callsql = "select * from customerdetailquery where lastCaller = '" + caller + "'";
        List<CustomerDetailQuery> list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(CustomerDetailQuery.class, callsql, queryList);
        if (CollectionUtils.isEmpty(list)) return ccprlist;
        StringBuilder sb = new StringBuilder("(");
        for (CustomerDetailQuery cdq : list) {
            sb.append("'").append(cdq.getUid()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        String rebateOrderSql = "select * from rebateorder where isvalid = 1 and orderTime>='" + toOrderTime + "'";
        System.out.println("rebateOrderSql:" + rebateOrderSql);
        List roList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(RebateOrder.class, rebateOrderSql, new ArrayList());
        String ordersql = "select * from paydetailok   where  ToInnerUserid in " + sb + " and GiftFlag!='1' and  SuccessTime >= '" + startTime + "' and SuccessTime<'" + endTime + "'";
        if(StringUtils.isNotEmpty(queryMinMoneyMinMoney)){
            ordersql = ordersql + " and PayMondey >="+queryMinMoneyMinMoney;
        }
        if(StringUtils.isNotEmpty(queryGameidGameId)){
            ordersql = ordersql + " and gameid='"+queryGameidGameId.substring(1)+"' ";
        }
        if(StringUtils.isNotEmpty(queryUidid)){
            ordersql = ordersql + " and Toinneruserid = '"+queryUidid+"' ";
        }
        ordersql = ordersql + " order by SuccessTime desc";
        System.out.println("ordersql:" + ordersql);
        List<PayDetailOK> pdolist = this.payDetailOkBo.executeQuery(PayDetailOK.class, ordersql);
        pdolist = findResult(pdolist, roList);
        if (CollectionUtils.isEmpty(pdolist)) return ccprlist;
        Map vipGradeMap = getVipGradeMap(pdolist);
        for (PayDetailOK pdo : pdolist) {
            CustomerNotUsedOrder record = new CustomerNotUsedOrder();
            record.setUserId(pdo.getToinneruserid());
            record.setActno(pdo.getNiuxactno()==null?"":pdo.getNiuxactno());
            Object vipGrade = vipGradeMap.get(record.getUserId());
            record.setVipGrade(vipGrade == null ? "0" : String.valueOf(vipGrade));
            record.setOrderId(pdo.getOrderid());
            record.setOrderTime(pdo.getSuccesstime());
            record.setServerId(pdo.getServerid());
            record.setPayMoney(String.valueOf(pdo.getPayMondey()));
            record.setOrderMoney(pdo.getTotalmoney());
            String gameId = pdo.getGameid();
            if (gameId.length() == 5) {
                gameId = "0" + gameId;
            }
            Games games = GameCache.getInstance().getGameByGameId(gameId);
            record.setGameName(games == null ? "" : games.getGameName());
            ccprlist.add(record);
        }
        if (roList != null) {
            roList.clear();
        }
        if (list != null) {
            list.clear();
        }
        if (pdolist != null) {
            pdolist.clear();
        }
        int count = ccprlist.size();
        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);
        Sheet<CustomerNotUsedOrder> sheet = new Sheet<CustomerNotUsedOrder>(count, ccprlist);
        this.mergePagedDataModel(sheet, pagedFliper);
        return ccprlist;
    }

    private Map<String, String> getVipGradeMap(List<PayDetailOK> pdolist) {
        Set<String> uidSet = new HashSet<String>();
        for (PayDetailOK pdo : pdolist) {
            uidSet.add(pdo.getToinneruserid());
        }
        StringBuilder sb = new StringBuilder(" (");
        for (String uid : uidSet) {
            sb.append("'").append(uid).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        String sql = "select * from customerdetailquery where uid in " + sb;
        List<CustomerDetailQuery> cdqList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(CustomerDetailQuery.class, sql, queryList);
        Map result = new HashMap();
        if (CollectionUtils.isEmpty(cdqList)) return result;
        for (CustomerDetailQuery cdq : cdqList) {
            result.put(cdq.getUid(), cdq.getLiveVipGrade());
        }
        uidSet.clear();
        uidSet = null;
        cdqList.clear();
        cdqList = null;
        return result;
    }

    public long compareTime(String fromtime, String totime)
    {
        if (StringTools.isEmpty(totime)) return 1000L;
        if (StringTools.isEmpty(fromtime)) return -1L;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date one = null;
        Date two = null;
        long diff = 0L;
        try {
            one = df.parse(fromtime);
            two = df.parse(totime);
            long time1 = one.getTime();
            long time2 = two.getTime();
            diff = time1 - time2;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return diff;
    }

    public void export() {
        logger.info("开始外呼后充值导出");
        authenticateRun();
        String startCallTime = findParameter("startCallTime");
        String endCallTime = findParameter("endCallTime");
        String startOrderTime = findParameter("startOrderTime");
        String endOrderTime = findParameter("endOrderTime");
        String giftFlag = findParameter("giftFlag");
        Calendar cal = Calendar.getInstance();
        String nowtime = sdf.format(cal.getTime());
        cal.add(6, 1);
        String totime = sdf.format(cal.getTime());
        this.fromDay = nowtime;
        this.toDay = totime;
        if (StringTools.isEmpty(startOrderTime)) {
            startOrderTime = nowtime;
        }
        if (StringTools.isEmpty(endOrderTime)) {
            endOrderTime = totime;
        }
        if (StringTools.isEmpty(startCallTime)) {
            startCallTime = nowtime;
        }
        if (StringTools.isEmpty(endCallTime)) {
            endCallTime = totime;
        }
        String callsql = "select uid ,min(callTime) mcallTime  from callrecord where callTime >= '" + startCallTime + "' and callTime<'" + endCallTime + "'  group by uid";
        System.out.println("callsql:" + callsql);
        List<MCallRecord> crlist = this.baseSo.executeQuery(MCallRecord.class, callsql, new ArrayList());
        StringBuffer insql = new StringBuffer("  (");
        Map timeMap = new HashMap();
        for (MCallRecord cr : crlist) {
            insql.append("'").append(cr.getUid()).append("',");
            timeMap.put(cr.getUid(), cr.getMcallTime());
        }
        insql.append("'')");
        System.out.println("insql:" + insql);
        String cdqsql = "select * from customerdetailquery where uid in " + insql;
        System.out.println("cdqsql:" + cdqsql);
        List<CustomerDetailQuery> cdqlist = this.baseSo.executeQuery(CustomerDetailQuery.class, cdqsql, queryList);

        String ordersql = "select * from paydetailok where orderTime >= '" + startOrderTime + "' and orderTime<'" + endOrderTime + "'";
        if ((!StringTools.isEmpty(giftFlag)) && (!giftFlag.equals("-1"))) {
            ordersql = ordersql + "  and  giftFlag =" + giftFlag;
        }
        ordersql = ordersql + " and ToInnerUserid in " + insql;
        ordersql = ordersql + " order by orderTime desc";
        System.out.println("ordersql:" + ordersql);
        List<PayDetailOK> pdolist = this.payDetailOkBo.executeQuery(PayDetailOK.class, ordersql);
        List<CustomerCallPayRecord> ccprlist = new ArrayList();
        if ((pdolist != null) && (pdolist.size() == 0));
        System.out.println("pdolist.size:" + pdolist.size());
        String gameId;
        for (PayDetailOK pdo : pdolist) {
            String uid = pdo.getToinneruserid();
            String callTime = (String)timeMap.get(uid);
            if (compareTime(callTime, pdo.getOrdertime()) <= 0L) {
                CustomerCallPayRecord record = new CustomerCallPayRecord();
                record.setUserId(pdo.getToinneruserid());
                record.setOrderId(pdo.getOrderid());
                record.setOrderTime(pdo.getOrdertime());
                record.setServerId(pdo.getServerid());
                record.setPayMoney(String.valueOf(pdo.getPayMondey()));
                record.setOrderMoney(pdo.getTotalmoney());
                record.setGiftFlag(pdo.getGiftFlag());
                gameId = pdo.getGameid();
                if (gameId.length() == 5) {
                    gameId = "0" + gameId;
                }
                Games games = GameCache.getInstance().getGameByGameId(gameId);
                record.setGameName(games == null ? "" : games.getGameName());
                for (MCallRecord cr : crlist) {
                    if (cr.getUid().equals(record.getUserId())) {
                        record.setCallTime(cr.getMcallTime());
                        break;
                    }
                }

                for (CustomerDetailQuery cdq : cdqlist) {
                    if (cdq.getUid().equals(pdo.getToinneruserid())) {
                        record.setCustomerService(cdq.getCustomerService());
                        record.setLastCaller(cdq.getLastCaller());
                    }
                }

                ccprlist.add(record);
            }
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();

        String title = "外呼后充值记录";
        List datas = new ArrayList();
        for (CustomerCallPayRecord cr : ccprlist) {
            List list = new ArrayList();
            list.add(cr.getOrderId());
            list.add(orderTypeMap.get(cr.getGiftFlag()));
            list.add(cr.getUserId());
            list.add(cr.getGameName());
            list.add(cr.getServerId());
            list.add(cr.getOrderTime());
            list.add(cr.getOrderMoney());
            list.add(cr.getPayMoney());
            list.add(cr.getCallTime());
            list.add(cr.getLastCaller());
            list.add(cr.getCustomerService());
            datas.add(list);
        }

        String[] columnName = { "订单号", "订单类型", "迅雷uid", "充值游戏", "区服", "充值时间", "订单金额", "充值金额", "最后外呼时间", "最后外呼人", "专属客服" };
        String filePath = "/tmp/customercallpayrecord.xls";
        long beginTime = System.currentTimeMillis();
        Workbook wb = ExcelUtil.create("外呼后充值记录", title, columnName, filePath, datas);
        long endTime = System.currentTimeMillis();
        logger.info("生成excel文件花费：" + (endTime - beginTime) + "ms");

        response.setHeader("Content-disposition", "attachment;filename=" + now() + "_customercallpayrecord.xls");
        response.setContentType("application/x-download");
        OutputStream ouputStream = null;
        try {
            ouputStream = response.getOutputStream();
            wb.write(ouputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        FacesContext.getCurrentInstance().responseComplete();
    }
}