package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.businesss.CorporationInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.CorporationInfo;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CORPORATIONINFO)
public class CorporationInfoManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(CorporationInfoManagedBean.class);


    public String getQueryList() {
        this.authenticateRun();//验证运行权限

        CorporationInfo corporationInfo = findBean(CorporationInfo.class, "corporationinfo");
        String ctype = this.findParameter("ctype");
        corporationInfo.setCtype(Integer.parseInt(ctype));
        final CorporationInfoBo corporationInfoBo = FacadeFactory.INSTANCE.getCorporationInfoBo();
        int count = corporationInfoBo.count(corporationInfo);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<CorporationInfo> list = new ArrayList<CorporationInfo>();
        if (count > 0) {
            list = corporationInfoBo.find(corporationInfo, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<CorporationInfo> sheet = new Sheet<CorporationInfo>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add() {
        this.authenticateAdd();//添加权限

        CorporationInfo corporationInfo = findBean(CorporationInfo.class, "corporationinfo");
       
        if (corporationInfo == null) {
            logger.debug("添加内容为空");
            mergeJsmessage("添加失败，原因：编辑内容为空");
            return "";
        }
        String ctype = this.findParameter("ctype");
        System.out.println("ctype:"+ctype);
        corporationInfo.setCtype(Integer.parseInt(ctype));
        try {
            final CorporationInfoBo corporationInfoBo = FacadeFactory.INSTANCE.getCorporationInfoBo();

            if(corporationInfoBo.findById(corporationInfo.getProductno()) != null) {
                mergeJsmessage("添加失败，原因：重复的产品编号");
                return "";
            }

            CorporationInfo temp = new CorporationInfo();
            temp.setGameid(corporationInfo.getGameid());
            if(corporationInfoBo.find(temp, 1, 1).size() > 0) {
                mergeJsmessage("添加失败，原因：重复的游戏");
                return "";
            }


            UserInfo user=this.currentUserInfo();
            corporationInfo.setInputby(user.getTrueName());
            corporationInfo.setInputtime(DateUtil.formatNowByDefault());


            corporationInfoBo.insert(corporationInfo);
        } catch (Exception e) {
            logger.debug("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }

        return "";
    }

    public String edit() {
        this.authenticateEdit();//编辑权限

        CorporationInfo corporationInfo = findBean(CorporationInfo.class, "corporationinfo");
        if (corporationInfo == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }
        String ctype = this.findParameter("ctype");
        corporationInfo.setCtype(Integer.parseInt(ctype));
        try {
            final CorporationInfoBo corporationInfoBo = FacadeFactory.INSTANCE.getCorporationInfoBo();
            CorporationInfo temp = corporationInfoBo.findById(corporationInfo.getProductno());
            if(temp == null) {
                mergeJsmessage("添加失败，原因：重复的产品编号");
                return "";
            }

            temp.setSalecompany(corporationInfo.getSalecompany());
            temp.setTestaccount(corporationInfo.getTestaccount());
            temp.setSignupdate(corporationInfo.getSignupdate());
            temp.setGamestartdate(corporationInfo.getGamestartdate());
            temp.setFirstprincipal(corporationInfo.getFirstprincipal());
            temp.setFirstprincipalmobile(corporationInfo.getFirstprincipalmobile());
            temp.setSecondprincipal(corporationInfo.getSecondprincipal());
            temp.setSecondprincipalmobile(corporationInfo.getSecondprincipalmobile());

            UserInfo user=this.currentUserInfo();
            temp.setEditby(user.getTrueName());
            temp.setEdittime(DateUtil.formatNowByDefault());

            corporationInfoBo.update(temp);

        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }

        return "";
    }
}
