package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.activity.CompanyQqOpenRecord;
import com.xunlei.niux.manager.web.model.vo.CompanyQqCustomerInfo;
import com.xunlei.niux.manager.web.util.PageUtil;

public class CompanyQqOpenRecordManagedBean extends BaseManagedBean {
	public String getCompanyQqOpenRecord(){
		CompanyQqOpenRecord query=findBean(CompanyQqOpenRecord.class, "companyqq");
		if(query!=null&&query.getToReportTime()!=null&&!"".equals(query.getToReportTime())){
			query.setToReportTime(query.getToReportTime()+" 23:59:59");
		}
		PagedFliper pagedFliper = this.getFliper();
		Page page=PageUtil.formatPage(pagedFliper, "reportTime","desc");
		int count=FacadeFactory.INSTANCE.getCompanyQqOpenRecordBo().count(query);
		List<CompanyQqCustomerInfo> cqclist=new ArrayList<CompanyQqCustomerInfo>();
		List<CompanyQqOpenRecord> list=FacadeFactory.INSTANCE.getCompanyQqOpenRecordBo().finds(query, page);
		for(CompanyQqOpenRecord record:list){
			CompanyQqCustomerInfo cqci=new CompanyQqCustomerInfo();
			cqci.setSeqId(record.getSeqId());
			cqci.setReportTime(record.getReportTime());
			cqci.setUserId(record.getUserId());
			CustomerDetailQuery customer=findOneCustomerDetailQuery(record.getUserId());
			if(customer!=null){
				cqci.setAccount(customer.getAccount());
				cqci.setVipGrade(customer.getVipGrade());
				cqci.setBvipGrade(customer.getBvipGrade());
				cqci.setBirthday(customer.getBirthday());
				cqci.setCallCount(customer.getCallCount());
				cqci.setContactNumber(customer.getContactNumber());
				cqci.setEmail(customer.getEmail());
				cqci.setGameCount(customer.getGameCount());
				cqci.setIntegral(customer.getIntegral());
				cqci.setIsBack(customer.getIsBack());
				cqci.setIsNew(customer.getIsNew());
				cqci.setIsPromote(customer.getIsPromote());
				cqci.setLastLoginTime(customer.getLastLoginTime());
				cqci.setLastModifyAmt(customer.getLastModifyAmt());
				cqci.setLastPayTime(customer.getLastPayTime());
				cqci.setQq(customer.getQq());
				cqci.setPhone(customer.getPhone());
				cqci.setPayTotalAmt(customer.getPayTotalAmt());
				cqci.setPayCount(customer.getPayCount());
				cqci.setLiveVipGrade(customer.getLiveVipGrade());
				cqci.setLivePayTotalAmt(customer.getLivePayTotalAmt());
			}
			cqclist.add(cqci);
		}
		 Sheet<CompanyQqCustomerInfo> sheet = new Sheet<CompanyQqCustomerInfo>(count, cqclist);
	     this.mergePagedDataModel(sheet, pagedFliper);
		 return "";
	}
	private CustomerDetailQuery findOneCustomerDetailQuery(String userId){
		CustomerDetailQuery query=new CustomerDetailQuery();
		query.setUid(userId);
		Page page=new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		List<CustomerDetailQuery> list=FacadeFactory.INSTANCE.getCustomerDetailQueryBo().find(query, page);
		return (list==null||list.size()==0)?null:list.get(0);
	}
}
