package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.CommonSpreadInfo;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameApk;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameChannelApk;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.QRCodeUtil;
import com.xunlei.niux.manager.web.util.ShortUrlCreater;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CommonSpreadInfoManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(CommonSpreadInfoManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;

    public CommonSpreadInfoManagedBean()
    {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum()
    {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public void initJumpSpreadInfo()
    {
        String sql = "SELECT s2.* FROM mobileGameApk s1 INNER JOIN  mobileGameChannelApk s2 ON s1.apkid = s2.apkid GROUP BY s1.gameid ORDER BY packageTime DESC;";
        List<MobileGameChannelApk> mgcaList = FacadeFactory.INSTANCE.getBaseSo().executeQuery(MobileGameChannelApk.class, sql, new ArrayList());
        for (MobileGameChannelApk apk : mgcaList) {
            String version = getVersion(apk);
            addSpreadJump(apk, getGameId(apk.getApkId().longValue()), version);
        }
    }

    private String getGameId(long apkId)
    {
        MobileGameApk query = new MobileGameApk();
        query.setApkId(Long.valueOf(apkId));
        MobileGameApk game = (MobileGameApk)FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if (game == null) return null;
        return game.getGameId();
    }

    private String getVersion(MobileGameChannelApk apk) {
        String apkName = apk.getChannelApkName();
        System.out.println("========apkName=======" + apkName);
        apkName = apkName.replace(".apk", "");
        apkName = apkName.substring(apkName.indexOf("_") + 1);
        if (apkName.indexOf("_") != -1) {
            apkName = apkName.split("_")[0];
        }
        return apkName;
    }

    private String getJumpAdvNo() throws Exception
    {
        return ShortUrlCreater.createAdvNo();
    }

    private CommonSpreadInfo addSpreadJump(MobileGameChannelApk apk, String gameId, String version)
    {
        CommonSpreadInfo csi = null;
        try {
            csi = new CommonSpreadInfo();
            csi.setAdvNo(apk.getChannelId());
            csi.setJumpType(Integer.valueOf(1));
            csi.setGameId(gameId);
            String jumpAdvNo = getJumpAdvNo();
            csi.setJumpAdvNo(jumpAdvNo);
//            csi.setShortUrl("http://jump2.niu.xunlei.com:8080/" + ShortUrlCreater.createShortUrl(jumpAdvNo));
			csi.setShortUrl("http://jump2.niu.xunlei.com:8080/" + gameId + "/" + apk.getChannelId());
            csi.setJumpUrl(apk.getDownLoadLink());
            String muliPhotoUrl = getMuliPhotoUrl(csi.getAdvNo(), version, gameId, apk.getDownLoadLink());
            csi.setMuliPhotoUrl(muliPhotoUrl);
            csi.setVersion(version);
            csi.setIsValid(Boolean.valueOf(true));
            csi.setRecordTime(DateUtil.formatNowByDefault());
            FacadeFactory.INSTANCE.getBaseSo().addObject(csi);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return csi;
    }

    private String getMuliPhotoUrl(String advNo, String version, String gameId, String content)
    {
        Games games = GameCache.getInstance().getGameByGameId(gameId);
        String gameNo = games.getGameNo() == null ? "" : games.getGameNo();
        return QRCodeUtil.makeJumpApkMultiFile(advNo, version, gameId, gameNo, content);
    }

    public String getQueryCommonSpreadInfoList()
    {
        logger.info("开始跳转链接查询");
        authenticateRun();
        CommonSpreadInfo wl = (CommonSpreadInfo)findBean(CommonSpreadInfo.class, "commonspreadinfo");
        PagedFliper pagedFliper = getFliper();
        int count = this.baseSo.countObject(wl);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(0);
            page.setPageSize(0);
            page.addOrder("recordTime", OrderType.DESC);
            list = this.baseSo.findObjects(wl, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }
}