package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CommonAskBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CommonAsk;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 常用语业务处理类
 * @author lisu
 *  2013-03-06
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_COMMONASK)
public class CommonAskManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CommonAskManagedBean.class.getName());
	private CommonAskBo commonAskBo;
	private int rownum = 0;
	
	
	public CommonAskManagedBean(){
		commonAskBo = FacadeFactory.INSTANCE.getCommonAskBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询常用语
	 * @return
	 */
	public String getQueryCommonAskList(){
		logger.info("开始常用语查询");
        this.authenticateRun();//验证运行权限
        CommonAsk wl = findBean(CommonAsk.class, "commonask");
        PagedFliper pagedFliper = this.getFliper();
        int count = commonAskBo.count(wl);
        pagedFliper.setRecordCount(count);
        List<CommonAsk> list = new ArrayList<CommonAsk>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(0);
        	page.setPageSize(0);
        	page.addOrder("displayorder", OrderType.ESC);
        	page.addOrder("inputTime", OrderType.DESC);
            list = commonAskBo.findCommonAsk(wl,page);
        }
        Sheet<CommonAsk> sheet = new Sheet<CommonAsk>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增常用语
	 * @return
	 */
	public String add(){
		logger.info("开始常用语添加");		
		CommonAsk wl = this.findBean(CommonAsk.class,"commonask");	
		try{
			if(wl==null){
				logger.info("常用语为空");
				throw new XLRuntimeException("常用语为空");
			}		
			if(wl.getContent() != null)
				 wl.setContent(wl.getContent().trim());
			wl.setInputBy(this.currentUserLogo());
			wl.setInputTime(now());
			commonAskBo.insert(wl);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改常用语
	 * @return
	 */
	public String edit(){
		logger.info("开始常用语修改");
		this.authenticateEdit();//编辑权限
		CommonAsk wl =this.findBean(CommonAsk.class,"commonask");
		try{
			if(wl==null){
				logger.info("常用语为空");
				throw new XLRuntimeException("常用语为空");
			}
			if(wl.getContent() != null)
				 wl.setContent(wl.getContent().trim());
			wl.setEditBy(this.currentUserLogo());
			wl.setEditTime(now());
			commonAskBo.update(wl);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除常用语
	 * @return
	 */
	public String delete(){	
		logger.info("开始常用语删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				commonAskBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	 /**
	 * 设置显示顺序
	 * @return
	 */
	public String setDisplayorder() {		
		try {
			String seqid_priority = findParameter("seqid_displayorder");
			if (isEmpty(seqid_priority)) {
				return "";
			}
			String[] value = seqid_priority.split("_");
			long seqid = Long.parseLong(value[0]);
			long priority = Long.parseLong(value[1]);
			if (seqid <= 0 || priority < 0) {
				alertJS("优先级设置失败！");
				return "";
			}
			if(priority > Constant.RECOMMEND_IS_TOP){
				priority = Constant.RECOMMEND_IS_TOP;
			}
			String sql = "update commonask set displayorder=" + priority + " where seqid=" + seqid;		
			commonAskBo.execute(sql, new ArrayList());			
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
}
