package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.CardUseRecordBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CardUseRecord;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.vo.CardBiziVo;

/**
 * 代金券使用记录处理类
 * @author lisu
 *  2013-03-13
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CARDUSERECORD)
public class CardUseRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CardUseRecordManagedBean.class.getName());
	private CardUseRecordBo cardUseRecordBo;
	private int rownum = 0;
	
	public CardUseRecordManagedBean(){
		cardUseRecordBo = FacadeFactory.INSTANCE.getCardUseRecordBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询代金券使用记录
	 * @return
	 */
	public String getQueryCardUseRecordList(){
		logger.info("开始代金券使用记录查询");
        this.authenticateRun();//验证运行权限
        CardUseRecord cardUseRecord = findBean(CardUseRecord.class, "carduserecord");
        PagedFliper pagedFliper = this.getFliper();
        int count = 0;
        List<CardUseRecord> list = new ArrayList<CardUseRecord>();
    	rownum = 1;
    	Page page=new Page();
    	page.setPageNo(pagedFliper.getPageNo());
    	page.setPageSize(pagedFliper.getPageSize());
    	page.addOrder("daytime", OrderType.DESC);
    	page.addOrder("cardType", OrderType.ESC);    	
        list = cardUseRecordBo.find(cardUseRecord, page);
        
        List<CardBiziVo> vlist = new ArrayList<CardBiziVo>();
        if(list == null || list.size()==0)return "";
        String daytime = list.get(0).getDaytime();
        CardBiziVo card = new CardBiziVo();
        int i = 0;
        long allCount = 0L;
        for(CardUseRecord cur:list){//进行行列转换
        	if(!daytime.equals(cur.getDaytime())){
        		daytime = cur.getDaytime();
        		vlist.add(card);
        		card = new CardBiziVo();
        		allCount = 0L;
        	}       	
        	card.setActFromTime(cur.getDaytime());
        	allCount += cur.getLiveUsedCount();
        	card.setAllCount(allCount);
        	if(cur.getCardType().intValue() == 1){
        		card.setLeaveone(cur.getLiveUsedCount());
        	}else if(cur.getCardType().intValue() == 2){
        		card.setLeavetwo(cur.getLiveUsedCount());
        	}else if(cur.getCardType().intValue() == 3){
        		card.setLeavethree(cur.getLiveUsedCount());
        	}else if(cur.getCardType().intValue() == 5){
        		card.setLeavefive(cur.getLiveUsedCount());
        	}else if(cur.getCardType().intValue() == 10){
        		card.setLeaveten(cur.getLiveUsedCount());
        	}else if(cur.getCardType().intValue() == 99){
        		card.setLeaveninenine(cur.getLiveUsedCount());
        	}else if(cur.getCardType().intValue() == 149){
        		card.setLeavefourteennine(cur.getLiveUsedCount());
        	} 
        	
        	if(i==list.size()-1){
        		vlist.add(card);
        	}
        	i++;
        }
        if(vlist == null) count=0;
        else count = vlist.size();
        int pageNo = pagedFliper.getPageNo();
        int pageSize = pagedFliper.getPageSize();
        if(pageNo<=0)pageNo = 1;
        
        pagedFliper.setRecordCount(count);
        
        List<CardBiziVo> result = new ArrayList<CardBiziVo>();
        int pageTotal = count%pageSize==0?count/pageSize:count/pageSize+1;      
        if(pageTotal <= 1){
        	for(int ii=0;ii<count;ii++){
        		result.add(vlist.get(ii));
        	}
        }else{
        	int addcount = count%pageSize==0?pageSize:count%pageSize;
        	if(pageNo <= pageTotal-1)addcount = pageSize;       	
        	for(int ii = (pageNo-1)*pageSize;ii<((pageNo-1)*pageSize+addcount);ii++){
            	result.add(vlist.get(ii));
            }
        }
        Sheet<CardBiziVo> sheet = new Sheet<CardBiziVo>(count, result);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始代金券使用记录导出到excel文件");    	
    	//获得页面查询的数据
        CardUseRecord cardUseRecord = findBean(CardUseRecord.class, "carduserecord");
        Page page=new Page();
    	page.addOrder("daytime", OrderType.DESC);
    	page.addOrder("cardType", OrderType.ESC);
        List<CardUseRecord> list = cardUseRecordBo.find(cardUseRecord, page);
        
        List<CardBiziVo> result = new ArrayList<CardBiziVo>();
        if(list != null && list.size()>0){
        	String daytime = list.get(0).getDaytime();
            CardBiziVo card = new CardBiziVo();
            long allCount = 0L;
            int i = 0;
            for(CardUseRecord cur:list){//进行行列转换
            	if(!daytime.equals(cur.getDaytime())){
            		daytime = cur.getDaytime();
            		result.add(card);
            		card = new CardBiziVo();
            		allCount = 0L;
            	}       	
            	card.setActFromTime(cur.getDaytime());
            	allCount += cur.getLiveUsedCount();
            	card.setAllCount(allCount);
            	if(cur.getCardType().intValue() == 1){
            		card.setLeaveone(cur.getLiveUsedCount());
            	}else if(cur.getCardType().intValue() == 2){
            		card.setLeavetwo(cur.getLiveUsedCount());
            	}else if(cur.getCardType().intValue() == 3){
            		card.setLeavethree(cur.getLiveUsedCount());
            	}else if(cur.getCardType().intValue() == 5){
            		card.setLeavefive(cur.getLiveUsedCount());
            	}else if(cur.getCardType().intValue() == 10){
            		card.setLeaveten(cur.getLiveUsedCount());
            	}else if(cur.getCardType().intValue() == 99){
            		card.setLeaveninenine(cur.getLiveUsedCount());
            	}else if(cur.getCardType().intValue() == 149){
            		card.setLeavefourteennine(cur.getLiveUsedCount());
            	} 
            	
            	if(i==list.size()-1){
            		result.add(card);
            	}
            	i++;
            }
        }
        

    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "代金券使用记录";	    
 	    
 	    List datas = new ArrayList();
 	    String[] columnName = {"日期", "1元使用", "2元使用", "3元使用", "5元使用", "10元使用",  "9.9元使用", "14.9元使用","共计"};
 	    for(CardBiziVo cur:result){
 	    	List lista = new ArrayList();
 	    	lista.add(cur.getActFromTime());
 	    	lista.add(cur.getLeaveone());
 	    	lista.add(cur.getLeavetwo());
 	    	lista.add(cur.getLeavethree());
 	    	lista.add(cur.getLeavefive());
 	    	lista.add(cur.getLeaveten());
 	    	lista.add(cur.getLeaveninenine());
 	    	lista.add(cur.getLeavefourteennine());
 	    	lista.add(cur.getAllCount());
 	    	datas.add(lista);
 	    }
 	    
		String filePath = "/tmp/carduserecord.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("代金券使用记录",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_carduserecord.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
		
		
}
