package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CardDistributionBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CardDistribution;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 代金券分配处理类
 * @author lisu
 *  2013-03-12
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CARDDISTRIBUTION)
public class CardDistributionManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CardDistributionManagedBean.class.getName());
	private static final String url = "http://dynamic.vip.xunlei.com/xljinku/checkcash/?act=4001";//查询代金券剩余数量
	private CardDistributionBo cardDistributionBo;
	private int rownum = 0;
	
	public CardDistributionManagedBean(){
		cardDistributionBo = FacadeFactory.INSTANCE.getCardDistributionBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询代金券分配
	 * @return
	 */
	public String getQueryCardDistributionList(){
		logger.info("开始代金券分配查询");
        this.authenticateRun();//验证运行权限
        CardDistribution cardDistribution = findBean(CardDistribution.class, "carddistribution");
        PagedFliper pagedFliper = this.getFliper();
        int count = cardDistributionBo.count(cardDistribution);
        pagedFliper.setRecordCount(count);
        List<CardDistribution> list = new ArrayList<CardDistribution>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("month", OrderType.DESC);
            list = cardDistributionBo.find(cardDistribution, page);
        }
        Sheet<CardDistribution> sheet = new Sheet<CardDistribution>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 初始化/追加代金券
	 * @return
	 */
	public String add(){
		logger.info("开始代金券初始化/追加");		
		this.authenticateAdd();//添加权限
		String one_month = findParameter("one_month");
		String addcountstr = findParameter("addcount");//追加数量
		String remark = findParameter("remark");	
        try{
			if(one_month==null||"".equals(one_month)){
				logger.info("月份为空");
				throw new XLRuntimeException("月份为空");
			}		
            if(addcountstr == null || "".contentEquals(addcountstr)){
            	logger.info("追加数量为0");
				throw new XLRuntimeException("追加数量为0");
            }
            long addcount = Long.parseLong(addcountstr);
			CardDistribution cd = new CardDistribution();
			cd.setMonth(one_month);
			List<CardDistribution> cdlist = cardDistributionBo.find(cd, new Page());
			if(cdlist == null || cdlist.size()==0){//如果不存在历史记录，则表示是初始化操作
				cd.setAddCount(new Long(0));
				cd.setTotalCount(addcount);
				cd.setLeaveCount(addcount);
				cd.setUsedCount(new Long(0));
				if(remark != null&& !"".equals(remark))cd.setRemark(remark);
				cardDistributionBo.insert(cd);
			}else{//如果存在，表示是追加操作
				int  monthlimit = 0; // 1：按月发放 0：按天发放
				long count = 0L; //当月总数量
				String reponseText = HttpClientUtil.getHtml(url);
				logger.info("reponseText===============>"+reponseText);
				logger.info("代金券数量获得成功!");
				String datas[] = reponseText.split("&");
				for(String data:datas){
					if(data.indexOf("ret") != -1){
						String ret = data.split("=")[1];
						if(Integer.parseInt(ret) != 0){
							throw new Exception("代金券数量初始化失败，调用会员接口查询失败");
						}
					}
					if(data.indexOf("monthlimit") != -1){
						String m = data.split("=")[1];
						monthlimit = Integer.parseInt(m);
						if(monthlimit != 1){//如果不是按月发放代金券
							throw new Exception("代金券数量初始化失败，检查到代金券不是按月发放");
						}
					}
					if(data.indexOf("count") != -1){
						String m = data.split("=")[1];
						count = Long.parseLong(m);
					}
				}				
				
				CardDistribution card = cdlist.get(0);
				if(count < card.getTotalCount()+addcount){//如果追加的数量比会员实际数据多，则需要向会员那边申请，增加数量
					throw new Exception("当月会员发放总数量为："+count+"，追加后页游平台总数量为："+(card.getTotalCount()+addcount)+"，会员数量不足，请及时联系会员那边相关人员");
				}
				card.setAddCount(card.getAddCount()+addcount);
				card.setTotalCount(card.getTotalCount() + addcount);
				card.setLeaveCount(card.getLeaveCount() + addcount);
				card.setRemark(cd.getRemark()==null?remark:(cd.getRemark()+";"+remark));
				cardDistributionBo.update(card);
				//追加代金券的历史记录
			}			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
		
}
