package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CardBiziBo;
import com.xunlei.niux.data.vipgame.bo.CardCountBo;
import com.xunlei.niux.data.vipgame.bo.CardDistributionBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CardBizi;
import com.xunlei.niux.data.vipgame.vo.CardCount;
import com.xunlei.niux.data.vipgame.vo.CardDistribution;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.vo.CardBiziVo;


/**
 * 代金券相关的业务活动处理类
 * @author lisu
 *  2013-03-13
 */
public class CardBiziManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CardBiziManagedBean.class.getName());
	private CardBiziBo cardBiziBo;
	private CardDistributionBo cardDistributionBo;
	private CardCountBo cardCountBo;
	private int rownum = 0;
	
	public CardBiziManagedBean(){
		cardBiziBo = FacadeFactory.INSTANCE.getCardBiziBo();
		cardDistributionBo = FacadeFactory.INSTANCE.getCardDistributionBo();
		cardCountBo = FacadeFactory.INSTANCE.getCardCountBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询代金券相关的业务活动
	 * @return
	 */
	public String getQueryCardBiziList(){
		logger.info("开始代金券相关的业务活动查询");
        this.authenticateRun();//验证运行权限
        CardBizi cardBizi = findBean(CardBizi.class, "cardbizi");
        String month = findParameter("mymonth");    
        PagedFliper pagedFliper = this.getFliper();
        List<CardBizi> list = new ArrayList<CardBizi>();
        int count = 0;
        if(cardBizi.getMonth() == null || "".equals(cardBizi.getMonth())){
            if(cardBizi.getMonth() == null || "".equals(cardBizi.getMonth())){
            	cardBizi.setMonth(month);
            }        	
        }else{
        	month = cardBizi.getMonth();
        }
        String sql = "select count(*) from cardbizi where acttotime>='"+month+"' and actfromtime <= '"+(month+"-31 23:59:59")+"'";
    	count = cardBiziBo.count(sql, new Object[]{});
    	pagedFliper.setRecordCount(count); 
    	if(count > 0){
    		rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("actFromTime", OrderType.DESC);
        	sql = " and acttotime>='"+month+"' and actfromtime <= '"+(month+"-31 23:59:59")+"'";
            list = cardBiziBo.find(cardBizi, sql, page);
    	}
             
        List<CardCount>  cclist = cardCountBo.find(new CardCount(), new Page());
        List<CardBiziVo> result = new ArrayList<CardBiziVo>();
        for(CardBizi bizi:list){
        	CardBiziVo cbv = new CardBiziVo();
        	cbv.setSeqid(bizi.getSeqid());
        	cbv.setActFromTime(bizi.getActFromTime());
        	cbv.setActToTime(bizi.getActToTime());
        	cbv.setActName(bizi.getActName());
        	cbv.setActNo(bizi.getActNo());
        	cbv.setEditBy(bizi.getEditBy());
        	cbv.setEditTime(bizi.getEditTime());
        	cbv.setInputBy(bizi.getInputBy());
        	cbv.setInputTime(bizi.getInputTime());
        	cbv.setMonth(bizi.getMonth());
        	cbv.setPrivateKey(bizi.getPrivateKey());
        	cbv.setManager(bizi.getManager());
        	for(CardCount cc:cclist){
        		if(cc.getActNo().trim().equals(cbv.getActNo().trim())){//如果找到对应的业务编号
        			switch(cc.getCardtype().intValue()){
        			   case 1:
        				   cbv.setOne(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeaveone(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;
        			   case 2:
        				   cbv.setTwo(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeavetwo(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;
        			   case 3:
        				   cbv.setThree(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeavethree(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;
        			   case 5:
        				   cbv.setFive(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeavefive(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;
        			   case 10:
        				   cbv.setTen(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeaveten(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;
        			   case 99:
        				   cbv.setNinenine(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeaveninenine(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;
        			   case 149:
        				   cbv.setFourteennine(cc.getAllCount()==null?0:cc.getAllCount());
        				   cbv.setLeavefourteennine(cc.getLeaveCount()==null?0:cc.getLeaveCount());
        				   break;        				   
        			}
        		}
        	}
        	result.add(cbv);
        }
        Sheet<CardBiziVo> sheet = new Sheet<CardBiziVo>(count, result);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	
	/**
	 * 新增代金券相关的业务活动
	 * @return
	 */
	public String add(){
		logger.info("开始代金券相关的业务活动添加");		
		this.authenticateAdd();//添加权限
		CardBizi cardBizi = findBean(CardBizi.class, "cardbizi");
		String month = findParameter("one_month");
        String nowtime = now();
        String nowmonth = nowtime.substring(0, 7);       
		try{
			if(DateUtil.compareTime(nowmonth+"-01", month+"-01")>0){
	        	logger.info("无法新增以前月份的业务活动");
	        	throw new XLRuntimeException("无法新增以前月份的业务活动");
	        }
			if(cardBizi==null){
				logger.info("代金券相关的业务活动为空");
				throw new XLRuntimeException("代金券相关的业务活动为空");
			}
			CardBizi cb = new CardBizi();
			cb.setActNo(cardBizi.getActNo());
			List<CardBizi> cblist = cardBiziBo.find(cb, new Page());
			if(cblist != null && cblist.size()>0){
				throw new XLRuntimeException("该业务编号已存在，不能重复添加");
			}
			
			CardDistribution cd = new CardDistribution();
			cd.setMonth(month);
			List<CardDistribution> cdlist = cardDistributionBo.find(cd,new Page());
			if(cdlist == null || cdlist.size()==0){
				throw new XLRuntimeException("不存在年月为："+month+"的记录");
			}
			CardDistribution cdb = cdlist.get(0);
			
			String one_one = findParameter("one_one");
			String one_two = findParameter("one_two");
			String one_three = findParameter("one_three");
			String one_five = findParameter("one_five");
			String one_ten = findParameter("one_ten");
			String one_ninenine = findParameter("one_ninenine");
			String one_fourteennine = findParameter("one_fourteennine");
			
			long one = 0;
			long two = 0;
			long three = 0;
			long five = 0;
			long ten = 0;
			long ninenine = 0;
			long fourteennine = 0;
			
            if(one_one != null && !"".equals(one_one)){
            	one = Long.parseLong(one_one);
            }
            if(one_two != null && !"".equals(one_two)){
            	two = Long.parseLong(one_two);
            }
            if(one_three != null && !"".equals(one_three)){
            	three = Long.parseLong(one_three);
            }
            if(one_five != null && !"".equals(one_five)){
            	five = Long.parseLong(one_five);
            }
            if(one_ten != null && !"".equals(one_ten)){
            	ten = Long.parseLong(one_ten);
            }
            if(one_ninenine != null && !"".equals(one_ninenine)){
            	ninenine = Long.parseLong(one_ninenine);
            }
            if(one_fourteennine != null && !"".equals(one_fourteennine)){
            	fourteennine = Long.parseLong(one_fourteennine);
            }			
            long bizicount = one+two+three+five+ten+ninenine+fourteennine;
			if(cdb.getLeaveCount()-bizicount < 0){//如果业务申请的代金券的数量大于该年月剩余数量
				throw new XLRuntimeException("对不起,该年月代金券剩余数量不足。业务申请总数量为："+(bizicount)+",该年月剩余数量为："+cdb.getLeaveCount()+",相差："+(cdb.getLeaveCount()-bizicount));
			}	
			
			/**
			 * 添加业务申请
			 */
			cardBizi.setInputBy(currentUserLogo());
			cardBizi.setInputTime(now());
			cardBizi.setMonth(month);
			//生成密钥
			UUID uuid = UUID.randomUUID();
			cardBizi.setPrivateKey(uuid.toString());
			cardBiziBo.insert(cardBizi);
			
			Long luc = 0L;
			/**
			 * 添加申请数量
			 */
			if(one > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(1);
				cc.setAllCount(one);
				cc.setUsedCount(luc);
				cc.setLeaveCount(one);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}

			if(two > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(2);
				cc.setAllCount(two);
				cc.setUsedCount(luc);
				cc.setLeaveCount(two);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}
			
			if(three > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(3);
				cc.setAllCount(three);
				cc.setUsedCount(luc);
				cc.setLeaveCount(three);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}
			
			if(five > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(5);
				cc.setAllCount(five);
				cc.setUsedCount(luc);
				cc.setLeaveCount(five);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}
			
			if(ten > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(10);
				cc.setAllCount(ten);
				cc.setUsedCount(luc);
				cc.setLeaveCount(ten);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}
			if(ninenine > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(99);
				cc.setAllCount(ninenine);
				cc.setUsedCount(luc);
				cc.setLeaveCount(ninenine);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}
			if(fourteennine > 0){
				CardCount cc = new CardCount();
				cc.setActNo(cardBizi.getActNo());
				cc.setCardtype(149);
				cc.setAllCount(fourteennine);
				cc.setUsedCount(luc);
				cc.setLeaveCount(fourteennine);
				cc.setLiveUsedCount(luc);
                cardCountBo.insert(cc);
			}
			/**
			 * 更新代金券分配数量
			 */
			cdb.setLeaveCount(cdb.getLeaveCount()-bizicount);
			cdb.setUsedCount(cdb.getUsedCount()+bizicount);									
			cardDistributionBo.update(cdb);
						
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	

	
	/**
	 * 回收代金券
	 * 注意：不能回收本月之前的代金券
	 * @return
	 */
	public String recover(){
		String leaveone = findParameter("leaveone");
		String leavetwo = findParameter("leavetwo");
		String leavethree = findParameter("leavethree");
		String leavefive = findParameter("leavefive");
		String leaveten = findParameter("leaveten");
		String leaveninenine = findParameter("leaveninenine");
		String leavefourteennine = findParameter("leavefourteennine");
		String mybiziNo = findParameter("mybiziNo");
		String mymonth = findParameter("month");		
		String one = findParameter("one");
		String two = findParameter("two");
		String three = findParameter("three");	
		String five = findParameter("five");
		String ten = findParameter("ten");
		String ninenine = findParameter("ninenine");
		String fourteennine = findParameter("fourteennine");
	    String nowtime = now();
	    String nowmonth = nowtime.substring(0, 7); //当前年月
	    
		if(mymonth == null || "".equals(mymonth)){
			alertJS("回收失败，年月不能为空");
			return "";
		}
		if(DateUtil.compareTime(mymonth+"-01", nowmonth+"-0")>0){
	    	nowmonth = mymonth;
	    }else if(DateUtil.compareTime(mymonth+"-01", nowmonth+"-0")<0){
	    	alertJS("回收失败，不能回收以前年月的代金券");
			return "";
	    }
		CardDistribution cd = new CardDistribution();
		cd.setMonth(nowmonth);
		List<CardDistribution> cdlist = cardDistributionBo.find(cd,new Page());
		if(cdlist == null || cdlist.size()==0){
			alertJS("回收失败，年月在系统中不存在");
			return "";
		}
		CardDistribution cdb = cdlist.get(0);
        CardCount cc = new CardCount();
        cc.setActNo(mybiziNo);
		List<CardCount> cclist = cardCountBo.find(cc, new Page());
		
		if(cclist == null || cclist.size()==0){
			alertJS("回收失败，该业务没有被分配任何代金券");
			return "";
		}
		long ucount = 0L;
		long allcount = 0L;
		if(one != null && "on".equals(one)){
			allcount += Long.parseLong(leaveone);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 1){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}		
		if(two != null && "on".equals(two)){
			allcount += Long.parseLong(leavetwo);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 2){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}
		if(three != null && "on".equals(three)){
			allcount += Long.parseLong(leavethree);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 3){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}
		if(five != null && "on".equals(five)){
			allcount += Long.parseLong(leavefive);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 5){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}
		if(ten != null && "on".equals(ten)){
			allcount += Long.parseLong(leaveten);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 10){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}
		if(ninenine != null && "on".equals(ninenine)){
			allcount += Long.parseLong(leaveninenine);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 99){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}
		if(fourteennine != null && "on".equals(fourteennine)){
			allcount += Long.parseLong(leavefourteennine);
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 149){
					c.setAllCount(c.getUsedCount());
					c.setLeaveCount(ucount);
					cardCountBo.update(c);
				}
			}
		}
		
		//更新每月代金券总数
		cdb.setLeaveCount(cdb.getLeaveCount() + allcount);
		cdb.setUsedCount(cdb.getUsedCount() - allcount);
		cardDistributionBo.update(cdb);

		alertJS("回收成功");
		return "";
	}
	
	
	/**
	 * 修改代金券相关的业务活动
	 * 注意：不能修改本月之前的代金券
	 * @return
	 */
	public String edit(){
		logger.info("开始代金券相关的业务活动修改");
		this.authenticateEdit();//编辑权限
		CardBizi cardBizi = findBean(CardBizi.class, "cardbizi");
		String month = findParameter("one_month");	
		String one_overMonth = findParameter("one_overMonth");//编辑时手动输入的年月
        cardBizi.setMonth(month);
        String nowtime = now();
        String nowmonth = nowtime.substring(0, 7); //当前年月
		try{
			if(cardBizi==null){
				logger.info("代金券相关的业务活动为空");
				throw new XLRuntimeException("代金券相关的业务活动为空");
			}
			CardBizi cb = new CardBizi();
			cb.setSeqid(cardBizi.getSeqid());
			List<CardBizi> cblist = cardBiziBo.find(cb, new Page());
			if(cblist == null || cblist.size()==0){
				throw new XLRuntimeException("该业务申请不存在");
			}
			System.out.println("month===================>"+month);
			System.out.println("nowmonth================>"+nowmonth);
			if(DateUtil.compareTime(month+"-01", nowmonth+"-0")>0){
		    	nowmonth = month;
		    }
//            else if(DateUtil.compareTime(month+"-01", nowmonth+"-0")<0){
//		    	logger.info("不能修改以前年月的记录");
//				throw new XLRuntimeException("不能修改以前年月的记录");
//		    }
			CardDistribution cd = new CardDistribution();
			cd.setMonth(nowmonth);//只能修改当前年月中的代金券的数量
			List<CardDistribution> cdlist = cardDistributionBo.find(cd,new Page());
			if(cdlist == null || cdlist.size()==0){
				logger.info("系统中不存在该年月的相关记录");
				throw new XLRuntimeException("系统中不存在该年月的相关记录");
			}
			cd = cdlist.get(0);
			String one_one = findParameter("one_one");
			String one_two = findParameter("one_two");
			String one_three = findParameter("one_three");
			String one_five = findParameter("one_five");
			String one_ten = findParameter("one_ten");
			String one_ninenine = findParameter("one_ninenine");
			String one_fourteennine = findParameter("one_fourteennine");
			
			long one = 0;
			long two = 0;
			long three = 0;
			long five = 0;
			long ten = 0;
			long ninenine = 0;
			long fourteennine = 0;
			
			if(one_one != null && !"".equals(one_one)){
	            one = Long.parseLong(one_one);
            }
            if(one_two != null && !"".equals(one_two)){
            	two = Long.parseLong(one_two);
            }
            if(one_three != null && !"".equals(one_three)){
            	three = Long.parseLong(one_three);
            }
            if(one_five != null && !"".equals(one_five)){
            	five = Long.parseLong(one_five);
            }
            if(one_ten != null && !"".equals(one_ten)){
            	ten = Long.parseLong(one_ten);
            }
            if(one_ninenine != null && !"".equals(one_ninenine)){
            	ninenine = Long.parseLong(one_ninenine);
            }
            if(one_fourteennine != null && !"".equals(one_fourteennine)){
            	fourteennine = Long.parseLong(one_fourteennine);
            }		
            long bizicount = one+two+three+five+ten+ninenine+fourteennine;
			CardCount cc = new CardCount();
	
			cc.setActNo(cardBizi.getActNo());
			List<CardCount> cclist = cardCountBo.find(cc, new Page());
			long beforeallcount = 0L;
			for(CardCount c:cclist){
				beforeallcount += c.getAllCount();
			}
			
			long leavecount = bizicount - beforeallcount;

			if(leavecount > cd.getLeaveCount()){
				throw new XLRuntimeException("该年月代金券剩余数量不足");
			}
			
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 1){
				   if(one < c.getUsedCount()){
					   throw new XLRuntimeException("该业务1元券的数量不能小于已经使用的数量，1元券修改后的数量为："+one+"，已经使用的数量为："+c.getUsedCount());
				   }
				}else if(c.getCardtype().intValue() == 2){
				   if(two < c.getUsedCount()){
					   throw new XLRuntimeException("该业务2元券的数量不能小于已经使用的数量，2元券修改后的数量为："+two+"，已经使用的数量为："+c.getUsedCount());
				   }
				}else if(c.getCardtype().intValue() == 3){
					   if(three < c.getUsedCount()){
						   throw new XLRuntimeException("该业务3元券的数量不能小于已经使用的数量，3元券修改后的数量为："+three+"，已经使用的数量为："+c.getUsedCount());
					   }
				}else if(c.getCardtype().intValue() == 5){
					   if(five < c.getUsedCount()){
						   throw new XLRuntimeException("该业务5元券的数量不能小于已经使用的数量，5元券修改后的数量为："+five+"，已经使用的数量为："+c.getUsedCount());
					   }
				}else if(c.getCardtype().intValue() == 10){
					   if(ten < c.getUsedCount()){
						   throw new XLRuntimeException("该业务10元券的数量不能小于已经使用的数量，10元券修改后的数量为："+ten+"，已经使用的数量为："+c.getUsedCount());
					   }
				}else if(c.getCardtype().intValue() == 99){
					   if(ninenine < c.getUsedCount()){
						   throw new XLRuntimeException("该业务9.9元券的数量不能小于已经使用的数量，9.9元券修改后的数量为："+ninenine+"，已经使用的数量为："+c.getUsedCount());
					   }
				}else if(c.getCardtype().intValue() == 149){
					   if(fourteennine < c.getUsedCount()){
						   throw new XLRuntimeException("该业务14.9元券的数量不能小于已经使用的数量，14.9元券修改后的数量为："+fourteennine+"，已经使用的数量为："+c.getUsedCount());
					   }
				}				
			}
			
			for(CardCount c:cclist){
				if(c.getCardtype().intValue() == 1){
					  c.setAllCount(one);
					  c.setLeaveCount(one - c.getUsedCount());
					  cardCountBo.update(c);
				}else if(c.getCardtype().intValue() == 2){
					  c.setAllCount(two);
					  c.setLeaveCount(two - c.getUsedCount());
					  cardCountBo.update(c);
				}else if(c.getCardtype().intValue() == 3){
					  c.setAllCount(three);
					  c.setLeaveCount(three - c.getUsedCount());
					  cardCountBo.update(c);
				}else if(c.getCardtype().intValue() == 5){
					  c.setAllCount(five);
					  c.setLeaveCount(five - c.getUsedCount());
					  cardCountBo.update(c);
				}else if(c.getCardtype().intValue() == 10){
					  c.setAllCount(ten);
					  c.setLeaveCount(ten - c.getUsedCount());
					  cardCountBo.update(c);
				}else if(c.getCardtype().intValue() == 99){
					  c.setAllCount(ninenine);
					  c.setLeaveCount(ninenine - c.getUsedCount());
					  cardCountBo.update(c);
				}else if(c.getCardtype().intValue() == 149){
					  c.setAllCount(fourteennine);
					  c.setLeaveCount(fourteennine - c.getUsedCount());
					  cardCountBo.update(c);
				}				
			}
			Long luc = 0L;
			if(one > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 1){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(one);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(1);
					ccount.setLeaveCount(one);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			if(two > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 2){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(two);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(2);
					ccount.setLeaveCount(two);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			if(three > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 3){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(three);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(3);
					ccount.setLeaveCount(three);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			if(five > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 5){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(five);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(5);
					ccount.setLeaveCount(five);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			if(ten > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 10){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(ten);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(10);
					ccount.setLeaveCount(ten);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			if(ninenine > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 99){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(ninenine);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(99);
					ccount.setLeaveCount(ninenine);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			if(fourteennine > 0){
				boolean flag = false;
				for(CardCount c:cclist){
					if(c.getCardtype().intValue() == 149){
						flag = true;
					}
				}
				if(!flag){
					CardCount ccount = new CardCount();
					ccount.setAllCount(fourteennine);
					ccount.setActNo(cardBizi.getActNo());
					ccount.setCardtype(149);
					ccount.setLeaveCount(fourteennine);
					ccount.setLiveUsedCount(luc);
					ccount.setUsedCount(luc);
					cardCountBo.insert(ccount);
				}
			}
			//更新业务资料
			cardBizi.setEditBy(currentUserLogo());
			cardBizi.setEditTime(now());
			cardBiziBo.update(cardBizi);
			//更新该年月代金券的数量
			
			cd.setLeaveCount(cd.getLeaveCount()- leavecount);
			cd.setUsedCount(cd.getTotalCount() - cd.getLeaveCount());
			cardDistributionBo.update(cd);
			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
}
