package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.bonus.facade.FacadeFactory;
import com.xunlei.niux.data.bonus.vo.BonusTrans;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_BONUSTRANS)
public class BonusTransManagedBean extends BaseManagedBean{
	public String getQueryBonusTransList(){
		this.authenticateRun();//验证运行权限
		BonusTrans query=findBean(BonusTrans.class,"bonustrans");
		PagedFliper pagedFliper = this.getFliper();
		Page page=new Page();
		page.setPageNo(pagedFliper.getPageNo());
		page.setPageSize(pagedFliper.getPageSize());
		page.addOrder("transTime", OrderType.DESC);
		int count=FacadeFactory.INSTANCE.getBonusTransBo().count(query);
		List<BonusTrans> list=null;
		if(count>0){
			list=FacadeFactory.INSTANCE.getBonusTransBo().find(query, page);
		}
		if(list==null){
			list=new ArrayList<BonusTrans>();
		}
		Sheet<BonusTrans> sheet = new Sheet<BonusTrans>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
}
