package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 产品处理类
 * @author lisu
 *  2013-1-16
 */
public class BonusProductManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(BonusProductManagedBean.class.getName());
	private BonusProductBo bonusProductBo;
	private int rownum = 0;  
	//产品
    private Map<String,String> bonusProduct;   
    
	public BonusProductManagedBean(){
		bonusProductBo = FacadeFactory.INSTANCE.getBonusProductBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	 public List getBonusProductTypeList() {
		 List list = (List)getRequestAttribute("bonusproducttype");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("bonusproducttype");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("bonusproducttype", list);
	        }
	        return list;

	    }
	
	 
	 /**
	  * 查询会员专区没有过期的产品
	  * @return
	  */
	public List<SelectItem> getMbonusProductList(){
		BonusProduct query=new BonusProduct();
		query.setPlatForm("4");//金卡专区
		query.setProductStatus("1");//有效
		List<BonusProduct> bplist=FacadeFactory.INSTANCE.getBonusProductBo().find(query, 0, 0);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(BonusProduct product:bplist){
			siList.add(new SelectItem(product.getSeqId()+"", product.getProductName())); 	
		}
		return siList;
	}
	 
	 /**
	  * 查询所有没有过期的产品
	  * @return
	  */
	public List getBonusProductList(){
		List list = (List)getRequestAttribute("bonusproductlist");
		if(list == null){
			String sql = "select * from bonusproduct where validPeriod > ?";
			List paramList = new ArrayList();
			paramList.add(0, "'"+now()+"'");
			List<BonusProduct> productList = bonusProductBo.executeQuery(BonusProduct.class, sql, paramList);
			if(productList == null)return new ArrayList();
			 list = new ArrayList(productList.size());
			for(BonusProduct product:productList){
				list.add(new SelectItem(product.getSeqId()+"", product.getProductName())); 	
			}
			setRequestAttribute("bonusproductlist", list);
		}
		return list;
	}
	public List<SelectItem> getJinKaAllProductList(){
		BonusProduct query=new BonusProduct();
		query.setPlatForm("2");//金卡专区
		query.setProductStatus("1");//有效
		List<BonusProduct> bplist=FacadeFactory.INSTANCE.getBonusProductBo().find(query, 0, 0);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(BonusProduct product:bplist){
			siList.add(new SelectItem(product.getSeqId()+"", product.getProductName())); 	
		}
		return siList;
	}
	public List<SelectItem> getMyAreaAllProductList(){
		BonusProduct query=new BonusProduct();
		query.setPlatForm("1");//金卡专区
		query.setProductStatus("1");//有效
		List<BonusProduct> bplist=FacadeFactory.INSTANCE.getBonusProductBo().find(query, 0, 0);
		List<SelectItem> siList=new ArrayList<SelectItem>();
		if(bplist==null){
			return siList;
		}
		for(BonusProduct product:bplist){
			siList.add(new SelectItem(product.getSeqId()+"", product.getProductName())); 	
		}
		return siList;
	}
	public List getBonusProductNoList(){
		List list = (List)getRequestAttribute("bonusproductnolist");
		if(list == null){
			String sql = "select * from bonusproduct where validPeriod > ?";
			List paramList = new ArrayList();
			paramList.add(0, "'"+now()+"'");
			List<BonusProduct> productList = bonusProductBo.executeQuery(BonusProduct.class, sql, paramList);
			if(productList == null)return new ArrayList();
			 list = new ArrayList(productList.size());
			for(BonusProduct product:productList){
				list.add(new SelectItem(product.getProductNo(), product.getProductName())); 	
			}
			setRequestAttribute("bonusproductnolist", list);
		}
		return list;
	}
	public Map<String, String> getBonusProduct() {
        Map<String,String> tempMap=new HashMap<String,String>();
        String sql = "select * from bonusproduct";
		List paramList = new ArrayList();
//		paramList.add(0, "'"+now()+"'");
		List<BonusProduct> productList = bonusProductBo.executeQuery(BonusProduct.class, sql, paramList);
        if(productList!=null){
        	for(BonusProduct product:productList){
        		tempMap.put(product.getSeqId()+"", product.getProductName()); 	
			}
        }
        bonusProduct=tempMap;
		return bonusProduct;
	}

	 
	/**
	 * 查询产品信息
	 * @return
	 */
	public String getQueryBonusProductList(){
		logger.info("开始产品信息查询");
        this.authenticateRun();//验证运行权限
		BonusProduct bizInfo = findBean(BonusProduct.class, "bonusproduct");
        PagedFliper pagedFliper = this.getFliper();
        int count = bonusProductBo.count(bizInfo);
        pagedFliper.setRecordCount(count);
        List<BonusProduct> list = new ArrayList<BonusProduct>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = bonusProductBo.find(bizInfo, page.getPageNo(),page.getPageSize());
        }
        Sheet<BonusProduct> sheet = new Sheet<BonusProduct>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增产品信息
	 * @return
	 */
	public String add(){
		logger.info("开始产品信息添加");		
		this.authenticateAdd();//添加权限
		BonusProduct product = this.findBean(BonusProduct.class,"bonusproduct");	
        try{
			if(product==null){
				logger.info("产品信息为空");
				throw new XLRuntimeException("产品信息为空");
			}
			BonusProduct query=new BonusProduct();
			query.setProductNo(product.getProductNo());
			List<BonusProduct> listtbp=FacadeFactory.INSTANCE.getBonusProductBo().find(query, 1, 1);
			if(listtbp!=null&&listtbp.size()>0){
				throw new Exception("产品编码"+product.getProductNo()+"重复");
			}
			product.setInputBy(currentUserLogo());
			product.setInputTime(now());
			product.setProductNum(0L);
			product.setProductSum(0L);
			product.setUsedSum(0L);
			bonusProductBo.insert(product);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改产品信息
	 * @return
	 */
	public String edit(){
		logger.info("开始产品信息修改");
		this.authenticateEdit();//编辑权限
		BonusProduct product=this.findBean(BonusProduct.class,"bonusproduct");
		try{
			if(product==null){
				logger.info("产品为空");
				throw new XLRuntimeException("产品为空");
			}
			product.setEditBy(this.currentUserLogo());
			product.setEditTime(now());
			bonusProductBo.update(product);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}

	/**
	 * 修改产品信息
	 * @return
	 */
	public String editsomedata(){
		logger.info("开始产品信息修改");
		this.authenticateEdit();//编辑权限
		BonusProduct product=this.findBean(BonusProduct.class,"bonusproduct");
		try{
			if(product==null){
				logger.info("产品为空");
				throw new XLRuntimeException("产品为空");
			}
			product.setEditBy(this.currentUserLogo());
			product.setEditTime(now());
			bonusProductBo.updateSomeData(product);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	/**
	 * 修改产品信息
	 * @return
	 */
	public String editproductnum(){
		this.authenticateEdit();//编辑权限
		BonusProduct product=this.findBean(BonusProduct.class,"bonusproduct");
		try{
			if(product==null){
				logger.info("产品为空");
				throw new XLRuntimeException("产品为空");
			}
			product.setEditBy(this.currentUserLogo());
			product.setEditTime(now());
			logger.info("用户["+product.getEditBy()+"]充值产品["+product.getProductNo()+"]数量["+product.getProductNum()+"]");
			bonusProductBo.update_recharge(product);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	public void setBonusProduct(Map<String, String> bonusProduct) {
		this.bonusProduct = bonusProduct;
	}
	
		
		
}
