package com.xunlei.niux.manager.web.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.lang.StringUtils;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.manager.web.model.BaseManagedBean;
import com.xunlei.niux.manager.web.model.vo.AccountChange;
import com.xunlei.niux.manager.web.model.vo.BlackWhiteInfo;
import com.xunlei.niux.manager.web.proxy.JRedisProxy;
import com.xunlei.niux.manager.web.util.HttpClientUtil;


/**
 * @author Administrator
 */
public class BlackWhiteInfoManagedBean extends BaseManagedBean {
	private static String databasepassword = "t14284";
	private static String databaseusername = "yeyouser";
	private static String databaseurl = "10.1.2.84:3306";
	private static String databasepassword_manager = "t14283";
	private static String databaseusername_manager = "yeyouser";
	private static String databaseurl_manager = "10.1.2.83:3306";
//	private static String databasepassword = "sd-9898w";
//	private static String databaseusername = "root";
//	private static String databaseurl = "10.10.10.203:3306";
//	private static String databasepassword_manager = "sd-9898w";
//	private static String databaseusername_manager = "root";
//	private static String databaseurl_manager = "10.10.10.203:3306";

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String accountChangeUrl="http://websvr.niu.xunlei.com/queryUserInfo.gameUserInfo?";//gameid=000069&type=200&accounts=lijunfuangguang,wfgfcmwfg"
    
    //黑/白名单
    private int type = 0;
    //游戏ID
    private String gameId = "";
    
    public String add() {
        this.authenticateAdd();
        logger.info("[add blackwhiteinfo]gameid:"+gameId+",type:"+type);
        BlackWhiteInfo blackwhiteinfo = this.findBean(BlackWhiteInfo.class, "blackwhiteinfo");
        logger.info("[add blackwhiteinfo]gameid:"+gameId+",type:"+type+",blackwhiteinfo:"+blackwhiteinfo);
        
        if(blackwhiteinfo == null){
        	return "";
        }
        
        //永不过期
        if(blackwhiteinfo.getOverduedate() == null){
        	blackwhiteinfo.setOverduedate("");
        }
        
        UserInfo user=this.currentUserInfo();
        blackwhiteinfo.setEditor(user.getTrueName());
        //修改时间
        blackwhiteinfo.setEdittime(String.valueOf(System.currentTimeMillis() / 1000L));
        
        //以回车换行分开
        String info = blackwhiteinfo.getLogininfo();
        
        List<BlackWhiteInfo> configList = new ArrayList<BlackWhiteInfo>();
        
        
        if(!StringUtils.isEmpty(info)){
        	
        	List<String> infos = null;

            /**
             * 加密账号
             */
            if("1".equals(blackwhiteinfo.getType())){
            	
            	if(StringUtils.isEmpty(gameId)){
            		logger.warn("add blackwhiteinfo exception:not select a certain game.blackwhiteinfo:"+blackwhiteinfo);
            		throw new RuntimeException("[信息]输入的是加密账号，请选择某一款游戏。");
            	}
            	
            	blackwhiteinfo.setType("0");
            	info = info.trim().replaceAll("\\s", ",");
            	infos = getQueryAccountChangeList(gameId, info);
            	logger.info("add blackwhiteinfo exception: select a certain game.infos:"+infos);
            }else{
        		infos = Arrays.asList(info.trim().split("\\s"));
        	}
        	
        	for(String inf : infos){
        		if(StringUtils.isEmpty(inf)){
        			continue;
        		}
        		
        		BlackWhiteInfo entity = new BlackWhiteInfo();
        		entity.setEditor(blackwhiteinfo.getEditor());
        		entity.setEdittime(blackwhiteinfo.getEdittime());
        		entity.setLogininfo(inf.trim());
        		entity.setOverduedate(blackwhiteinfo.getOverduedate());
        		entity.setReason(blackwhiteinfo.getReason());
        		entity.setType(blackwhiteinfo.getType());
        		configList.add(entity);
        		
        	}
        }
        
        
        //如果选择的是全部游戏
        if(StringUtils.isEmpty(gameId)){
        	List<String> dbnames = getDBNames();
        	for(String dbname : dbnames){
        		try {
                    addBlackWhiteInfo(configList, dbname, type);
                } catch (Exception e) {
                    logger.error("add blackwhiteinfo exception.dbname:"+dbname+",configList:"+configList, e);
                }
        	}
        	
        }else{
        	
        	try {

                String dbname = getDBName(gameId);
        		addBlackWhiteInfo(configList, dbname, type);
        		
        	} catch (Exception e) {
        		logger.error("add blackwhiteinfo exception.gameId:"+gameId, e);
        	}
        	
        }
        

		//刷新缓存
        logger.info(" add blackwhiteinfo.refresh cache begin"+ ",gameId:" + gameId + ",type:"+type);
		if(!CollectionUtils.isEmpty(configList)){
			List<String> gameids = null;
			if(!StringUtils.isEmpty(gameId)){
				gameids = new ArrayList<String>();
				gameids.add(gameId);
			}else{
				gameids = getGameIds();
			}
			
			logger.info(" add blackwhiteinfo.refresh cache.插入结果存数缓存"+ ",gameId:" + gameId + ",gameids:"+gameids + ",type:"+type);
			
			for(BlackWhiteInfo blackWhite : configList){
				for(String gameid : gameids){
					String typeString = "_white";
					if(0 != type){
						typeString = "_black";
					}
					String gameBlackkey = gameid + "_" + blackWhite.getLogininfo() + "_" + blackWhite.getType() + typeString;
					Calendar calendar = Calendar.getInstance();
					int minute = calendar.get(Calendar.MINUTE); 
					boolean catchresult = JRedisProxy.getInstance().set(gameBlackkey, blackWhite.getOverduedate(), (60-minute)*60);
					logger.info(" add blackwhiteinfo.refresh cache.插入成功结果存数缓存"+ ",gameid:" + gameid + ",gameBlackkey:"+gameBlackkey+ ",catchresult:"+catchresult+",balckwhite:"+blackWhite);
					
				}
				
			}
			
		}
        
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        logger.info("[update blackwhiteinfo]gameid:"+gameId+",type:"+type);
        BlackWhiteInfo blackwhiteinfo = this.findBean(BlackWhiteInfo.class, "blackwhiteinfo");
        logger.info("[update blackwhiteinfo]gameid:"+gameId+",type:"+type+",blackwhiteinfo:"+blackwhiteinfo);
        
        if(blackwhiteinfo == null){
        	return "";
        }

        //永不过期
        if(blackwhiteinfo.getOverduedate() == null){
        	blackwhiteinfo.setOverduedate("");
        }
        
        UserInfo user=this.currentUserInfo();
        blackwhiteinfo.setEditor(user.getTrueName());
        //修改时间
        blackwhiteinfo.setEdittime(String.valueOf(System.currentTimeMillis() / 1000L));
        
        //以回车换行分开
        String info = blackwhiteinfo.getLogininfo();
        if(StringUtils.isEmpty(info) || info.trim().split("\\s").length > 1){
        	throw new RuntimeException("[信息]有误，不能为空或包含空格、回车换行符等");
        }
        

        /**
         * 加密账号
         */
        if("1".equals(blackwhiteinfo.getType())){
        	
        	if(StringUtils.isEmpty(gameId)){
        		logger.warn("update blackwhiteinfo exception:not select a certain game.blackwhiteinfo:"+blackwhiteinfo);
        		throw new RuntimeException("[信息]输入的是加密账号，请选择某一款游戏。");
        	}
        	
        	List<String> infos = null;
        	blackwhiteinfo.setType("0");
        	infos = getQueryAccountChangeList(gameId, info);
        	info = infos.get(0);
        	blackwhiteinfo.setLogininfo(info);
        	logger.info("update blackwhiteinfo exception: select a certain game.infos:"+infos);
    	}
    	
        
        //如果选择的是全部游戏
        if(StringUtils.isEmpty(gameId)){
        	List<String> dbnames = getDBNames();
        	for(String dbname : dbnames){
        		try {
    	            updateBlackWhiteInfo(blackwhiteinfo, dbname, type);
    	        } catch (Exception e) {
    	            logger.error("update blackwhiteinfo exception.gameid:"+dbname, e);
    	        }
        	}
        	
        }else{
	        try {
                String dbname = getDBName(gameId);
	            updateBlackWhiteInfo(blackwhiteinfo, dbname, type);
	        } catch (Exception e) {
	            logger.error("update blackwhiteinfo exception.gameId:"+gameId, e);
	        }
        }
        

		//刷新缓存
        logger.info(" update blackwhiteinfo.refresh cache begin"+ ",gameId:" + gameId + ",type:"+type);
		if(blackwhiteinfo != null && !StringUtils.isEmpty(gameId)){
				String typeString = "_white";
				if(0 != type){
					typeString = "_black";
				}
				String gameBlackkey = gameId + "_" + blackwhiteinfo.getLogininfo() + "_" + blackwhiteinfo.getType() + typeString;
				Calendar calendar = Calendar.getInstance();
				int minute = calendar.get(Calendar.MINUTE); 
				boolean catchresult = JRedisProxy.getInstance().set(gameBlackkey, blackwhiteinfo.getOverduedate(), (60-minute)*60);
				logger.info("update blackwhiteinfo.插入成功结果存数缓存"+ ",gameid:" + gameId + ",gameBlackkey:"+gameBlackkey+",catchresult:"+catchresult+",balckwhite:"+blackwhiteinfo);
			
		}
        
		
        return "";
    }
    
    public String getQueryBlackWhiteList() {
        this.authenticateRun();
        logger.info("[getQueryBlackWhiteList blackwhiteinfo]gameid:"+gameId+",type:"+type);
        PagedFliper fliper = this.getFliper();
        BlackWhiteInfo blackwhiteinfo = this.findBean(BlackWhiteInfo.class, "blackwhiteinfo");
        logger.info("[getQueryBlackWhiteList blackwhiteinfo]gameid:"+gameId+",type:"+type+",blackwhiteinfo:"+blackwhiteinfo);

        if(blackwhiteinfo == null){
        	return "";
        }
        
        
        try {
        	String dbname = getDBName(gameId);
        	int count = getCountBlackWhiteInfos(blackwhiteinfo, dbname, type);
        	fliper.setRecordCount(count);
        	
            List<BlackWhiteInfo> list = getBlackWhiteInfos(blackwhiteinfo, dbname, type, fliper.getPageSize(), fliper.getPageNo());
            list = list == null ? new ArrayList<BlackWhiteInfo>() : list;
            Sheet<BlackWhiteInfo> sheet = new Sheet<BlackWhiteInfo>(count, list);
            this.mergePagedDataModel(sheet, fliper);
        } catch (Exception e) {
            logger.error("getQueryBlackWhiteList blackwhiteinfo exception", e);
        }
        return "";
    }

    public static List<BlackWhiteInfo> getBlackWhiteInfos(BlackWhiteInfo blackwhiteinfo, String dbname, int type, int pageSize, int pageNo) throws Exception {
		int index = (pageNo - 1) * pageSize;
        List<Object> paramList = new ArrayList<Object>();
        String tablename = "whiteinfo";
    	if(type != 0){
    		tablename = "blackinfo";
    	}
    	
        StringBuilder sb = new StringBuilder("select * from "+tablename+" where 1=1 ");
        if(!StringUtils.isEmpty(blackwhiteinfo.getType())){
        	sb.append("and type=? ");
        	paramList.add(blackwhiteinfo.getType());
        }
        
        if(!StringUtils.isEmpty(blackwhiteinfo.getLogininfo())){
        	sb.append(" and logininfo=?");
        	paramList.add(blackwhiteinfo.getLogininfo());
        }
        
        sb.append(" order by edittime desc  limit " + index + "," + pageSize);
        
        logger.info("[getBlackWhiteInfos blackwhiteinfo]sql:"+sb+",paramList:"+paramList+",pageSize:"+pageSize+",pageNo:"+pageNo);
        Connection conn = getConnection(dbname);
        ResultSet rs = query(sb.toString(), paramList, conn);
        return formatBlackWhiteInfo(rs, type);
    }
    
    private static int getCountBlackWhiteInfos(BlackWhiteInfo blackwhiteinfo, String dbname, int type) throws Exception {
    	int count = 0;
    	List<Object> paramList = new ArrayList<Object>();
    	String tablename = "whiteinfo";
    	if(type != 0){
    		tablename = "blackinfo";
    	}
    	
    	StringBuilder sb = new StringBuilder("select count(*)  as count from "+tablename+" where 1=1 ");
    	if(!StringUtils.isEmpty(blackwhiteinfo.getType())){
    		sb.append("and type=? ");
    		paramList.add(blackwhiteinfo.getType());
    	}
    	
    	if(!StringUtils.isEmpty(blackwhiteinfo.getLogininfo())){
    		sb.append(" and logininfo=?");
    		paramList.add(blackwhiteinfo.getLogininfo());
    	}
    	
    	logger.info("[getCountBlackWhiteInfos blackwhiteinfo]sql:"+sb+",paramList:"+paramList);

        Connection conn = getConnection(dbname);
    	ResultSet rs = query(sb.toString(), paramList, conn);
    	
    	while (rs.next()) {
    		count = rs.getInt("count");
    	}
    	
    	logger.info("[getCountBlackWhiteInfos blackwhiteinfo]sql:"+sb+",paramList:"+paramList+",count:"+count);
    	return count;
    }

    private static ResultSet query(String prepareSql, List<Object> paramList, Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(prepareSql);
        paramList = paramList == null ? new ArrayList<Object>() : paramList;
        for (int i = 0; i < paramList.size(); i++) {
            ps.setObject(i + 1, paramList.get(i));
        }
        return ps.executeQuery();
    }

    public static void updateBlackWhiteInfo(BlackWhiteInfo config, String dbname, int type) throws Exception {
        String tablename = "whiteinfo";
        String overduedateName = "overduedate";
    	if(type != 0){
    		tablename = "blackinfo";
    		overduedateName = "freedate";
    	}
    	
        StringBuilder sb = new StringBuilder("update ");
        sb.append(tablename).append(" set type=?,logininfo=?,").append(overduedateName).append("=?,edittime=?,editor=?,reason=? where seqId=?");

        Connection conn = null;
        try {
        	conn = getConnection(dbname);
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            ps.setObject(1, config.getType());
            ps.setObject(2, config.getLogininfo());
            ps.setObject(3, config.getOverduedate());
            ps.setObject(4, config.getEdittime());
            ps.setObject(5, config.getEditor());
            ps.setObject(6, config.getReason());
            ps.setObject(7, config.getSeqid());
            ps.execute();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}finally{
			if(null != conn){
				conn.close();
			}
		}
    }
    
    /**
     * 删除对应的信息（同时会从redis中删除）
     * @param config
     * @param dbname
     * @param type
     * @throws Exception
     */
    public static void deleteBlackWhiteInfoForOneGame(BlackWhiteInfo config, String gameId, String dbname, int type) throws Exception {
    	String tablename = "whiteinfo";
    	if(type != 0){
    		tablename = "blackinfo";
    	}
    	
        StringBuilder sb = new StringBuilder("delete from ");
        sb.append(tablename).append(" where logininfo=? and type=?");
        
        Connection conn = null;
        try {
        	conn = getConnection(dbname);
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            ps.setObject(1, config.getLogininfo());
            ps.setObject(2, config.getType());
            ps.execute();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}finally{
			if(null != conn){
				conn.close();
			}
		}
        
        
        //从redis删除对应的信息
        String typeString = "_white";
		if(0 != type){
			typeString = "_black";
		}
		String gameBlackkey = gameId + "_" + config.getLogininfo() + "_" + config.getType() + typeString;
		Calendar calendar = Calendar.getInstance();
		int minute = calendar.get(Calendar.MINUTE); 
		boolean catchresult = JRedisProxy.getInstance().set(gameBlackkey, config.getOverduedate(), (60-minute)*60);
		logger.info("update blackwhiteinfo.插入成功结果存数缓存"+ ",gameid:" + gameId + ",gameBlackkey:"+gameBlackkey+",catchresult:"+catchresult+",balckwhite:"+config);
    }

    private static List<BlackWhiteInfo> formatBlackWhiteInfo(ResultSet rs, int type) throws Exception {
        List<BlackWhiteInfo> list = new ArrayList<BlackWhiteInfo>();
        while (rs.next()) {
            BlackWhiteInfo config = new BlackWhiteInfo();
            config.setSeqid(rs.getLong("SeqId"));
            config.setType(rs.getString("type"));
            config.setLogininfo(rs.getString("logininfo"));
            if(type == 0){
            	config.setOverduedate(rs.getString("overduedate"));
            }else{
            	config.setOverduedate(rs.getString("freedate"));
            }
            config.setEdittime(sdf.format(new Date(Long.parseLong(rs.getString("edittime") + "000"))));
            config.setEditor(rs.getString("editor"));
            config.setReason(rs.getString("reason"));
            list.add(config);
        }
        return list;
    }

    /**
     * 增加黑白名单
     * @param configList
     * @param dbname
     * @param type
     * @throws Exception
     */
    public static void addBlackWhiteInfo(List<BlackWhiteInfo> configList, String dbname, int type) throws Exception {
        if(CollectionUtils.isEmpty(configList) || StringUtils.isEmpty(dbname)){
            return;
        }
        
        String tablename = "whiteinfo";
        String overduedateName = "overduedate";
    	if(type != 0){
    		tablename = "blackinfo";
    		overduedateName = "freedate";
    	}
    	
    	Connection conn = null;
        StringBuilder sb = new StringBuilder(
                "insert into "+tablename+"(type,logininfo,"+overduedateName+",edittime,editor,reason) values(?,?,?,?,?,?)");
        
        try {
        	conn = getConnection(dbname);
            conn.setAutoCommit(false);
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            for(BlackWhiteInfo config : configList){
                ps.setObject(1, config.getType());
                ps.setObject(2, config.getLogininfo());
                ps.setObject(3, config.getOverduedate());
                ps.setObject(4, config.getEdittime());
                ps.setObject(5, config.getEditor());
                ps.setObject(6, config.getReason());
                ps.addBatch();
            }

            ps.executeBatch();
            conn.commit();
            
		} catch (Exception e) {
			throw e;
		}finally{
			if(null != conn){
				conn.close();
			}
		}
        
    }
    
    /**
     * 增加黑白名单
     * @param configList
     * @param dbname
     * @param type
     * @throws Exception
     */
    public static void addBlackWhiteInfoForOneGame(BlackWhiteInfo config, String gameId, String dbname, int type) throws Exception {
        if(StringUtils.isEmpty(dbname)){
            return;
        }
        
        String tablename = "whiteinfo";
        String overduedateName = "overduedate";
    	if(type != 0){
    		tablename = "blackinfo";
    		overduedateName = "freedate";
    	}
    	
    	Connection conn = null;
        StringBuilder sb = new StringBuilder(
                "insert into "+tablename+"(type,logininfo,"+overduedateName+",edittime,editor,reason) values(?,?,?,?,?,?)");
        
        try {
        	conn = getConnection(dbname);
            conn.setAutoCommit(false);
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            ps.setObject(1, config.getType());
            ps.setObject(2, config.getLogininfo());
            ps.setObject(3, config.getOverduedate());
            ps.setObject(4, config.getEdittime());
            ps.setObject(5, config.getEditor());
            ps.setObject(6, config.getReason());

            ps.execute();
            conn.commit();
            
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}finally{
			if(null != conn){
				conn.close();
			}
		}
        
        String typeString = "_white";
		if(0 != type){
			typeString = "_black";
		}
		String gameBlackkey = gameId + "_" + config.getLogininfo() + "_" + config.getType() + typeString;
		Calendar calendar = Calendar.getInstance();
		int minute = calendar.get(Calendar.MINUTE); 
		boolean catchresult = JRedisProxy.getInstance().set(gameBlackkey, config.getOverduedate(), (60-minute)*60);
		logger.info(" add blackwhiteinfo.refresh cache.插入成功结果存数缓存"+ ",gameid:" + gameId + ",gameBlackkey:"+gameBlackkey+ ",catchresult:"+catchresult+",balckwhite:"+config);
        
    }
    

    /**
     * 获取的数据库链接
     *
     * @param gameId
     * @return
     * @throws Exception
     */
    
    private static Connection getManagerConnection() throws Exception {
    	logger.info("[getManagerConnection blackwhiteinfo]");
    	String url = "jdbc:mysql://" + databaseurl_manager + "/niux_manager"
                + "?useUnicode=true&amp;characterEncoding=utf8";
        BasicDataSource dataSource = createManagerDatasource(url);
        logger.info("[getManagerConnection blackwhiteinfo]dataSource:"+dataSource);
        Connection conn = dataSource.getConnection();
        logger.info("[getManagerConnection blackwhiteinfo]conn:"+conn);
    	return conn;
    }
    
    
    public static String getDBName(String gameId) {
    	logger.info("[getDBName blackwhiteinfo]gameId:"+gameId);
    	String dbname = null;
    	
    	if(gameId == null || gameId.startsWith("05")){
    		throw new RuntimeException("游戏[" + gameId + "]数据不在或属于手机游戏，不能使用黑白名单功能。");
    	}
    	
    	//变成五位
    	gameId = gameId.substring(1);
    	
    	Connection conn = null;
		try {
			conn = getManagerConnection();
			conn.setAutoCommit(false);
	        PreparedStatement ps = conn.prepareStatement("select dbname from dbconfig where gameid=?");
	        ps.setObject(1, gameId);
	        ResultSet rs = ps.executeQuery();
	        
	        while (rs.next()) {
	        	dbname = rs.getString("dbname");
	        	if(!StringUtils.isEmpty(dbname)){
	        		break;
	        	}else{
	        		logger.warn("[getDBNames blackwhiteinfo]dbname empty,sql:"+ps+"gameid:"+gameId+",dbname:"+dbname);
	        	}
	    	}
	    	
	        conn.commit();
		} catch (Exception e) {
			logger.error("[getDBName blackwhiteinfo]error!gameId："+gameId,e);
		}finally{
			if(conn != null){
				try {
					conn.close();
				} catch (SQLException e) {
					logger.error("[getDBName blackwhiteinfo]conn.close()gameId："+gameId,e);
				}
				
			}
			
		}
		logger.info("[getDBName blackwhiteinfo]gameId:"+gameId+",dbname:"+dbname);
        return dbname;
    }
    
    private static List<String> getDBNames() {
    	List<String> dbnames = new ArrayList<String>();
        Connection conn = null;;
		try {
			conn = getManagerConnection();
			conn.setAutoCommit(false);
	        PreparedStatement ps = conn.prepareStatement("select gameid,dbname from dbconfig ");
	        ResultSet rs = ps.executeQuery();
	        
	        while (rs.next()) {
	        	String gameid = rs.getString("gameid");
	        	
	        	if(gameid == null || gameid.startsWith("5")){
	        		logger.info("[getDBNames blackwhiteinfo]eliminate telephone game,gameid:"+gameid);
	        		continue;
	        	}
	        	
	        	String dbname = rs.getString("dbname");
	        	if(!StringUtils.isEmpty(dbname)){
	        		dbnames.add(dbname);
	        	}else{
	        		logger.info("[getDBNames blackwhiteinfo]dbname empty,gameid:"+gameid+",dbname:"+dbname);
	        	}
	    	}

			conn.commit();
		} catch (Exception e) {
			logger.error("[getDBNames blackwhiteinfo]",e);
		}finally{
			if(conn != null){
				try {
					conn.close();
				} catch (SQLException e) {
					logger.error("[getDBNames blackwhiteinfo]conn.close()",e);
				}
				
			}
			
		}
        
        return dbnames;
    }
    
    /**
     * 获取页游所有gameid
     * @return
     */
    private static List<String> getGameIds() {
    	List<String> gameids = new ArrayList<String>();
    	Connection conn = null;;
    	try {
    		conn = getManagerConnection();
    		conn.setAutoCommit(false);
    		PreparedStatement ps = conn.prepareStatement("select gameid,dbname from dbconfig ");
    		ResultSet rs = ps.executeQuery();
    		
    		while (rs.next()) {
    			String gameid = rs.getString("gameid");
    			
    			if(gameid == null || gameid.startsWith("5")){
    				logger.info("[getGameIds blackwhiteinfo]eliminate telephone game,gameid:"+gameid);
    				continue;
    			}else{
    				gameids.add(gameid);
    			}
    		}
    		
    		conn.commit();
    	} catch (Exception e) {
    		logger.error("[getGameIds blackwhiteinfo]",e);
    	}finally{
    		if(conn != null){
    			try {
    				conn.close();
    			} catch (SQLException e) {
    				logger.error("[getGameIds blackwhiteinfo]conn.close()",e);
    			}
    			
    		}
    		
    	}
    	
    	return gameids;
    }
    
	  private static Connection getConnection(String dbName) throws Exception {
		  logger.info("[getConnection blackwhiteinfo]dbName:"+dbName);
		  
		  if(StringUtils.isEmpty(dbName)){
			  return null;
		  }
		  
	    String url = "jdbc:mysql://" + databaseurl + "/" + dbName
	            + "?useUnicode=true&amp;characterEncoding=utf8";
	    BasicDataSource dataSource = createDatasource(url);
	    return dataSource.getConnection();
	}


    /**
     * 创建数据链接
     *
     * @param url
     * @return
     * @throws Exception
     */
    private static BasicDataSource createDatasource(String url) throws Exception {
        Properties p = new Properties();
        p.setProperty("driverClassName", "com.mysql.jdbc.Driver");
        p.setProperty("url", url);
        p.setProperty("password", databasepassword);
        p.setProperty("username", databaseusername);
        return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
    }

    /**
     * 创建数据链接
     *
     * @param url
     * @return
     * @throws Exception
     */
    private static BasicDataSource createManagerDatasource(String url) throws Exception {
    	Properties p = new Properties();
    	p.setProperty("driverClassName", "com.mysql.jdbc.Driver");
    	p.setProperty("url", url);
    	p.setProperty("password", databasepassword_manager);
    	p.setProperty("username", databaseusername_manager);
    	return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
    }

    /**
     * 账号转加密账号
     * @param gameid
     * @param accounts
     * @return
     */
	public static List<String> getQueryAccountChangeList(String gameid, String accounts){
		String params="gameid="+gameid+"&type="+200+"&accounts="+accounts.replace(" ", ",");
		logger.info("[getQueryAccountChangeList blackwhiteinfo]url:"+accountChangeUrl+params);
		String resp=HttpClientUtil.get(accountChangeUrl+params);
		logger.info("[getQueryAccountChangeList blackwhiteinfo]result:"+resp);
		List<String> list=new ArrayList<String>();
		if(resp.contains("\"statues\":\"0\"")){
			resp=resp.replaceAll("\\{\"result\":\"", "");
			resp=resp.replaceAll("\",\"statues\":\"0\"\\}", "");
			resp=resp.replaceAll("\",\"statues\":\"1\"\\}", "");
			String[] a1=resp.split("&");
			for(String s:a1){
				if(a1==null||"".equals(a1)){
					continue;
				}
				String[] a2=s.split("=");
				if(a2.length>1 && !StringUtils.isEmpty(a2[1])){
					list.add(a2[1]);
				}
			}
		}
		return list;
	}
    
    public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public String getGameId() {
		return gameId;
	}

	public void setGameId(String gameId) {
		this.gameId = gameId;
	}

}
